/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.controller;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.internal.GeneratedSubclasses;
import org.gradle.caching.BuildCacheService;
import org.gradle.caching.BuildCacheServiceFactory;
import org.gradle.caching.configuration.BuildCache;
import org.gradle.caching.configuration.internal.BuildCacheConfigurationInternal;
import org.gradle.caching.internal.FinalizeBuildCacheConfigurationBuildOperationType;
import org.gradle.caching.internal.controller.BuildCacheController;
import org.gradle.caching.internal.controller.DefaultBuildCacheController;
import org.gradle.caching.internal.controller.NoOpBuildCacheController;
import org.gradle.caching.internal.controller.service.BuildCacheServiceRole;
import org.gradle.caching.internal.controller.service.BuildCacheServicesConfiguration;
import org.gradle.internal.Cast;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BuildCacheControllerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildCacheControllerFactory.class);

    public static BuildCacheController create(final BuildOperationExecutor buildOperationExecutor, final Path buildIdentityPath, final File gradleUserHomeDir, final BuildCacheConfigurationInternal buildCacheConfiguration, final BuildCacheMode buildCacheState, final RemoteAccessMode remoteAccessMode, final boolean logStackTraces, final boolean emitDebugLogging, final Instantiator instantiator) {
        return (BuildCacheController)buildOperationExecutor.call((CallableBuildOperation)new CallableBuildOperation<BuildCacheController>(){

            public BuildCacheController call(BuildOperationContext context) {
                boolean remoteEnabled;
                if (buildCacheState == BuildCacheMode.DISABLED) {
                    context.setResult((Object)ResultImpl.disabled());
                    return NoOpBuildCacheController.INSTANCE;
                }
                BuildCache local = buildCacheConfiguration.getLocal();
                BuildCache remote = buildCacheConfiguration.getRemote();
                boolean localEnabled = local != null && local.isEnabled();
                boolean bl = remoteEnabled = remote != null && remote.isEnabled();
                if (remoteEnabled && remoteAccessMode == RemoteAccessMode.OFFLINE) {
                    remoteEnabled = false;
                    LOGGER.warn("Remote build cache is disabled when running with --offline.");
                }
                DescribedBuildCacheService localDescribedService = localEnabled ? BuildCacheControllerFactory.createBuildCacheService(local, BuildCacheServiceRole.LOCAL, buildIdentityPath, buildCacheConfiguration, instantiator) : null;
                DescribedBuildCacheService remoteDescribedService = remoteEnabled ? BuildCacheControllerFactory.createBuildCacheService(remote, BuildCacheServiceRole.REMOTE, buildIdentityPath, buildCacheConfiguration, instantiator) : null;
                context.setResult((Object)new ResultImpl(true, local != null && local.isEnabled(), remote != null && remote.isEnabled() && remoteAccessMode == RemoteAccessMode.ONLINE, localDescribedService == null ? null : localDescribedService.description, remoteDescribedService == null ? null : remoteDescribedService.description));
                if (!localEnabled && !remoteEnabled) {
                    LOGGER.warn("Task output caching is enabled, but no build caches are configured or enabled.");
                    return NoOpBuildCacheController.INSTANCE;
                }
                BuildCacheServicesConfiguration config = BuildCacheControllerFactory.toConfiguration(local, localDescribedService == null ? null : localDescribedService.service, remote, remoteDescribedService == null ? null : remoteDescribedService.service);
                return new DefaultBuildCacheController(config, buildOperationExecutor, gradleUserHomeDir, logStackTraces, emitDebugLogging);
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)"Finalize build cache configuration").details((Object)new DetailsImpl(buildIdentityPath.getPath()));
            }
        });
    }

    private static BuildCacheServicesConfiguration toConfiguration(BuildCache local, BuildCacheService localService, BuildCache remote, BuildCacheService remoteService) {
        boolean remotePush = remote != null && remote.isPush();
        boolean localPush = local != null && local.isPush();
        return new BuildCacheServicesConfiguration(localService, localPush, remoteService, remotePush);
    }

    private static <T extends BuildCache> DescribedBuildCacheService createBuildCacheService(T configuration, BuildCacheServiceRole role, Path buildIdentityPath, BuildCacheConfigurationInternal buildCacheConfiguration, Instantiator instantiator) {
        Class castFactoryType = (Class)Cast.uncheckedCast(buildCacheConfiguration.getBuildCacheServiceFactoryType(configuration.getClass()));
        BuildCacheServiceFactory factory = (BuildCacheServiceFactory)instantiator.newInstance(castFactoryType, new Object[0]);
        Describer describer = new Describer();
        BuildCacheService service = factory.createBuildCacheService(configuration, (BuildCacheServiceFactory.Describer)describer);
        ImmutableSortedMap config = ImmutableSortedMap.copyOf((Map)describer.configParams);
        BuildCacheDescription description = new BuildCacheDescription(configuration, describer.type, config);
        BuildCacheControllerFactory.logConfig(buildIdentityPath, role, description);
        return new DescribedBuildCacheService(service, description);
    }

    private static void logConfig(Path buildIdentityPath, BuildCacheServiceRole role, BuildCacheDescription description) {
        if (LOGGER.isInfoEnabled()) {
            boolean pullOnly;
            StringBuilder config = new StringBuilder();
            boolean bl = pullOnly = !description.isPush();
            if (!description.config.isEmpty() || pullOnly) {
                Object configMap;
                if (pullOnly) {
                    configMap = new LinkedHashMap();
                    configMap.put("pull-only", null);
                    configMap.putAll(description.config);
                } else {
                    configMap = description.config;
                }
                config.append(" (");
                Joiner.on((String)", ").appendTo(config, Iterables.transform(configMap.entrySet(), (Function)new Function<Map.Entry<String, String>, String>(){

                    public String apply(Map.Entry<String, String> input) {
                        if (input.getValue() == null) {
                            return input.getKey();
                        }
                        return input.getKey() + " = " + input.getValue();
                    }
                }));
                config.append(")");
            }
            String buildDescription = buildIdentityPath.equals((Object)Path.ROOT) ? "the root build" : "build '" + buildIdentityPath + "'";
            LOGGER.info("Using {} {} build cache for {}{}.", new Object[]{role.getDisplayName(), description.type == null ? description.className : description.type, buildDescription, config});
        }
    }

    private static class ResultImpl
    implements FinalizeBuildCacheConfigurationBuildOperationType.Result {
        private final boolean enabled;
        private final boolean localEnabled;
        private final FinalizeBuildCacheConfigurationBuildOperationType.Result.BuildCacheDescription local;
        private final boolean remoteEnabled;
        private final FinalizeBuildCacheConfigurationBuildOperationType.Result.BuildCacheDescription remote;

        ResultImpl(boolean enabled, boolean localEnabled, boolean remoteEnabled, @Nullable FinalizeBuildCacheConfigurationBuildOperationType.Result.BuildCacheDescription local, @Nullable FinalizeBuildCacheConfigurationBuildOperationType.Result.BuildCacheDescription remote) {
            this.enabled = enabled;
            this.localEnabled = localEnabled;
            this.remoteEnabled = remoteEnabled;
            this.local = local;
            this.remote = remote;
        }

        static FinalizeBuildCacheConfigurationBuildOperationType.Result disabled() {
            return new ResultImpl(false, false, false, null, null);
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public boolean isLocalEnabled() {
            return this.localEnabled;
        }

        @Override
        public boolean isRemoteEnabled() {
            return this.remoteEnabled;
        }

        @Override
        @Nullable
        public FinalizeBuildCacheConfigurationBuildOperationType.Result.BuildCacheDescription getLocal() {
            return this.local;
        }

        @Override
        @Nullable
        public FinalizeBuildCacheConfigurationBuildOperationType.Result.BuildCacheDescription getRemote() {
            return this.remote;
        }
    }

    private static class DetailsImpl
    implements FinalizeBuildCacheConfigurationBuildOperationType.Details {
        private final String buildPath;

        private DetailsImpl(String buildPath) {
            this.buildPath = buildPath;
        }

        @Override
        public String getBuildPath() {
            return this.buildPath;
        }
    }

    private static class DescribedBuildCacheService {
        private final BuildCacheService service;
        private final BuildCacheDescription description;

        private DescribedBuildCacheService(BuildCacheService service, BuildCacheDescription description) {
            this.service = service;
            this.description = description;
        }
    }

    private static class Describer
    implements BuildCacheServiceFactory.Describer {
        private String type;
        private Map<String, String> configParams = new HashMap<String, String>();

        private Describer() {
        }

        public BuildCacheServiceFactory.Describer type(String type) {
            if (type == null) {
                throw new IllegalArgumentException("'type' argument cannot be null");
            }
            this.type = type;
            return this;
        }

        public BuildCacheServiceFactory.Describer config(String name, String value) {
            if (name == null) {
                throw new IllegalArgumentException("'name' argument cannot be null");
            }
            if (value == null) {
                throw new IllegalArgumentException("'value' argument cannot be null");
            }
            this.configParams.put(name, value);
            return this;
        }
    }

    private static final class BuildCacheDescription
    implements FinalizeBuildCacheConfigurationBuildOperationType.Result.BuildCacheDescription {
        private final String className;
        private final boolean push;
        private final String type;
        private final ImmutableSortedMap<String, String> config;

        private BuildCacheDescription(BuildCache buildCache, String type, ImmutableSortedMap<String, String> config) {
            this.className = GeneratedSubclasses.unpackType((Object)buildCache).getName();
            this.push = buildCache.isPush();
            this.type = type;
            this.config = config;
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        @Override
        public boolean isPush() {
            return this.push;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public Map<String, String> getConfig() {
            return this.config;
        }
    }

    public static enum RemoteAccessMode {
        ONLINE,
        OFFLINE;

    }

    public static enum BuildCacheMode {
        ENABLED,
        DISABLED;

    }
}

