/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallWithIndexedArgumentsBase;
import org.jetbrains.kotlin.ir.expressions.impl.IrVarargImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImpl;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0016J\"\u0010\r\u001a\u00020\b*\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/VarargTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitVararg", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "toArrayLiteral", "", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "varargElementType", "backend.js"})
final class VarargTransformer
extends IrElementTransformerVoid {
    @NotNull
    private final JsIrBackendContext context;

    private final IrExpression toArrayLiteral(@NotNull List<? extends IrExpression> $receiver, IrType type2, IrType varargElementType) {
        IrCallImpl irCallImpl;
        Object object;
        block5: {
            block4: {
                IrClassifierSymbol irClassifierSymbol;
                Object object2 = this.context.getIntrinsics().getPrimitiveArrays();
                object = object2.get(irClassifierSymbol = IrTypesKt.getClassifierOrNull(type2));
                if (object == null) break block4;
                Object primitiveType = object2 = object;
                object = this.context.getIntrinsics().getPrimitiveToLiteralConstructor().get(primitiveType);
                if (object != null) break block5;
            }
            object = this.context.getIntrinsics().getArrayLiteral();
        }
        PrimitiveType intrinsic = object;
        IrExpression irExpression = (IrExpression)CollectionsKt.firstOrNull($receiver);
        int startOffset = irExpression != null ? irExpression.getStartOffset() : -1;
        IrExpression irExpression2 = (IrExpression)CollectionsKt.lastOrNull($receiver);
        int endOffset = irExpression2 != null ? irExpression2.getEndOffset() : -1;
        IrVarargImpl irVararg = new IrVarargImpl(startOffset, endOffset, type2, varargElementType, $receiver);
        IrCallImpl $receiver2 = irCallImpl = new IrCallImpl(startOffset, endOffset, type2, (IrFunctionSymbol)((Object)intrinsic));
        Collection collection = ((IrSimpleFunction)intrinsic.getOwner()).getTypeParameters();
        if (!collection.isEmpty()) {
            $receiver2.putTypeArgument(0, varargElementType);
        }
        $receiver2.putValueArgument(0, irVararg);
        return irCallImpl;
    }

    @Override
    @NotNull
    public IrExpression visitVararg(@NotNull IrVararg expression2) {
        IrCallImpl irCallImpl;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
        List currentList = new ArrayList();
        List segments = new ArrayList();
        for (IrVarargElement e : expression2.getElements()) {
            if (e instanceof IrSpreadElement) {
                if (!currentList.isEmpty()) {
                    segments.add(this.toArrayLiteral(currentList, expression2.getType(), expression2.getVarargElementType()));
                    currentList.clear();
                }
                segments.add(((IrSpreadElement)e).getExpression());
                continue;
            }
            IrVarargElement irVarargElement = e;
            if (irVarargElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
            }
            currentList.add((IrExpression)irVarargElement);
        }
        if (!currentList.isEmpty()) {
            segments.add(this.toArrayLiteral(currentList, expression2.getType(), expression2.getVarargElementType()));
            currentList.clear();
        }
        if (segments.isEmpty()) {
            return this.toArrayLiteral(CollectionsKt.emptyList(), expression2.getType(), expression2.getVarargElementType());
        }
        if (segments.size() == 1) {
            IrExpression irExpression;
            boolean bl;
            Object $receiver$iv;
            block12: {
                $receiver$iv = expression2.getElements();
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    Iterator<IrVarargElement> iterator2 = $receiver$iv.iterator();
                    while (iterator2.hasNext()) {
                        IrVarargElement element$iv = iterator2.next();
                        IrVarargElement it = element$iv;
                        if (!(it instanceof IrSpreadElement)) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
            }
            if (bl) {
                Object $receiver = $receiver$iv = new IrCallImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), this.context.getIntrinsics().getJsArraySlice().getSymbol());
                ((IrCallWithIndexedArgumentsBase)$receiver).putValueArgument(0, (IrExpression)CollectionsKt.first((List)segments));
                irExpression = (IrExpression)$receiver$iv;
            } else {
                irExpression = (IrExpression)CollectionsKt.first((List)segments);
            }
            return irExpression;
        }
        IrExpression arrayLiteral = this.toArrayLiteral(segments, new IrSimpleTypeImpl(this.context.getIntrinsics().getArray(), false, CollectionsKt.emptyList(), CollectionsKt.emptyList()), this.context.getIrBuiltIns().getAnyType());
        IrSimpleFunctionSymbol concatFun = CollectionsKt.contains((Iterable)this.context.getIntrinsics().getPrimitiveArrays().keySet(), (Object)IrTypesKt.getClassifierOrNull(expression2.getType())) ? this.context.getIntrinsics().getPrimitiveArrayConcat() : this.context.getIntrinsics().getArrayConcat();
        IrCallImpl $receiver = irCallImpl = new IrCallImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), concatFun);
        $receiver.putValueArgument(0, arrayLiteral);
        return irCallImpl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        this.transformChildrenVoid(expression2);
        int size = expression2.getValueArgumentsCount();
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void i;
            IrExpression argument = expression2.getValueArgument((int)i);
            IrValueParameter parameter = expression2.getSymbol().getOwner().getValueParameters().get((int)i);
            if (argument == null && parameter.getVarargElementType() != null) {
                List list2 = CollectionsKt.emptyList();
                IrType irType = parameter.getType();
                IrType irType2 = parameter.getVarargElementType();
                if (irType2 == null) {
                    Intrinsics.throwNpe();
                }
                expression2.putValueArgument((int)i, this.toArrayLiteral(list2, irType, irType2));
            }
            ++i;
        }
        return expression2;
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    public VarargTransformer(@NotNull JsIrBackendContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }
}

