/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import java.util.ArrayList;
import org.gradle.api.ProjectConfigurationException;
import org.gradle.api.ProjectState;
import org.gradle.util.CollectionUtils;

public class ProjectStateInternal
implements ProjectState {
    private State state = State.UNCONFIGURED;
    private ProjectConfigurationException failure;

    public boolean getExecuted() {
        return this.state.ordinal() > State.IN_EVALUATE.ordinal();
    }

    public boolean isConfiguring() {
        return this.state == State.IN_BEFORE_EVALUATE || this.state == State.IN_EVALUATE || this.state == State.IN_AFTER_EVALUATE;
    }

    public boolean isUnconfigured() {
        return this.state == State.UNCONFIGURED;
    }

    public void toBeforeEvaluate() {
        assert (this.state == State.UNCONFIGURED);
        this.state = State.IN_BEFORE_EVALUATE;
    }

    public void toEvaluate() {
        assert (this.state == State.IN_BEFORE_EVALUATE);
        this.state = State.IN_EVALUATE;
    }

    public void toAfterEvaluate() {
        assert (this.state == State.IN_EVALUATE);
        this.state = State.IN_AFTER_EVALUATE;
    }

    public void configured() {
        assert (this.state != State.CONFIGURED);
        this.state = State.CONFIGURED;
    }

    public void failed(ProjectConfigurationException failure) {
        if (this.failure == null) {
            this.failure = failure;
        } else {
            ArrayList causes = new ArrayList(this.failure.getCauses());
            CollectionUtils.addAll(causes, (Iterable)failure.getCauses());
            this.failure.initCauses(causes);
        }
    }

    public boolean hasFailure() {
        return this.failure != null;
    }

    public Throwable getFailure() {
        return this.failure;
    }

    public void rethrowFailure() {
        if (this.failure != null) {
            throw this.failure;
        }
    }

    public String toString() {
        String state = this.isConfiguring() ? "EXECUTING" : (this.getExecuted() ? (this.failure == null ? "EXECUTED" : String.format("FAILED (%s)", this.failure.getMessage())) : "NOT EXECUTED");
        return String.format("project state '%s'", state);
    }

    static enum State {
        UNCONFIGURED,
        IN_BEFORE_EVALUATE,
        IN_EVALUATE,
        IN_AFTER_EVALUATE,
        CONFIGURED;

    }
}

