/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.plugins;

import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.NamedDomainObjectList;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.FeaturePreviews;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyPublicationResolver;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.IvyPublication;
import org.gradle.api.publish.ivy.internal.artifact.IvyArtifactNotationParserFactory;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyPublication;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyPublicationIdentity;
import org.gradle.api.publish.ivy.internal.publication.IvyPublicationInternal;
import org.gradle.api.publish.ivy.tasks.GenerateIvyDescriptor;
import org.gradle.api.publish.ivy.tasks.PublishToIvyRepository;
import org.gradle.api.publish.plugins.PublishingPlugin;
import org.gradle.api.publish.tasks.GenerateModuleMetadata;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.model.Path;

public class IvyPublishPlugin
implements Plugin<Project> {
    private final Instantiator instantiator;
    private final ObjectFactory objectFactory;
    private final DependencyMetaDataProvider dependencyMetaDataProvider;
    private final FileResolver fileResolver;
    private final ProjectDependencyPublicationResolver projectDependencyResolver;
    private final FileCollectionFactory fileCollectionFactory;
    private final ImmutableAttributesFactory immutableAttributesFactory;
    private final FeaturePreviews featurePreviews;
    private CollectionCallbackActionDecorator collectionCallbackActionDecorator;

    @Inject
    public IvyPublishPlugin(Instantiator instantiator, ObjectFactory objectFactory, DependencyMetaDataProvider dependencyMetaDataProvider, FileResolver fileResolver, ProjectDependencyPublicationResolver projectDependencyResolver, FileCollectionFactory fileCollectionFactory, ImmutableAttributesFactory immutableAttributesFactory, FeaturePreviews featurePreviews, CollectionCallbackActionDecorator collectionCallbackActionDecorator) {
        this.instantiator = instantiator;
        this.objectFactory = objectFactory;
        this.dependencyMetaDataProvider = dependencyMetaDataProvider;
        this.fileResolver = fileResolver;
        this.projectDependencyResolver = projectDependencyResolver;
        this.fileCollectionFactory = fileCollectionFactory;
        this.immutableAttributesFactory = immutableAttributesFactory;
        this.featurePreviews = featurePreviews;
        this.collectionCallbackActionDecorator = collectionCallbackActionDecorator;
    }

    public void apply(final Project project) {
        project.getPluginManager().apply(PublishingPlugin.class);
        project.getExtensions().configure(PublishingExtension.class, (Action)new Action<PublishingExtension>(){

            public void execute(PublishingExtension extension) {
                extension.getPublications().registerFactory(IvyPublication.class, (NamedDomainObjectFactory)new IvyPublicationFactory(IvyPublishPlugin.this.dependencyMetaDataProvider, IvyPublishPlugin.this.instantiator, IvyPublishPlugin.this.objectFactory, IvyPublishPlugin.this.fileResolver, IvyPublishPlugin.this.collectionCallbackActionDecorator));
                IvyPublishPlugin.this.createTasksLater(project, extension, project.getLayout().getBuildDirectory());
            }
        });
    }

    private void createTasksLater(final Project project, final PublishingExtension publishingExtension, final DirectoryProperty buildDir) {
        final TaskContainer tasks = project.getTasks();
        final NamedDomainObjectSet publications = publishingExtension.getPublications().withType(IvyPublicationInternal.class);
        publications.all((Action)new Action<IvyPublicationInternal>(){

            public void execute(IvyPublicationInternal publication) {
                String publicationName = publication.getName();
                IvyPublishPlugin.this.createGenerateIvyDescriptorTask(tasks, publicationName, publication, buildDir);
                IvyPublishPlugin.this.createGenerateMetadataTask(project, tasks, publication, (Set)publications, buildDir);
                IvyPublishPlugin.this.createPublishTaskForEachRepository(tasks, publishingExtension, publication, publicationName);
            }
        });
    }

    private void createPublishTaskForEachRepository(final TaskContainer tasks, PublishingExtension publishingExtension, final IvyPublicationInternal publication, final String publicationName) {
        NamedDomainObjectList repositories = publishingExtension.getRepositories().withType(IvyArtifactRepository.class);
        repositories.all((Action)new Action<IvyArtifactRepository>(){

            public void execute(IvyArtifactRepository repository) {
                String repositoryName = repository.getName();
                String publishTaskName = "publish" + StringUtils.capitalize((String)publicationName) + "PublicationTo" + StringUtils.capitalize((String)repositoryName) + "Repository";
                IvyPublishPlugin.this.createPublishToRepositoryTask(tasks, publication, publicationName, repository, repositoryName, publishTaskName);
            }
        });
    }

    private void createPublishToRepositoryTask(TaskContainer tasks, final IvyPublicationInternal publication, final String publicationName, final IvyArtifactRepository repository, final String repositoryName, final String publishTaskName) {
        tasks.register(publishTaskName, PublishToIvyRepository.class, (Action)new Action<PublishToIvyRepository>(){

            public void execute(PublishToIvyRepository publishTask) {
                publishTask.setPublication(publication);
                publishTask.setRepository(repository);
                publishTask.setGroup("publishing");
                publishTask.setDescription("Publishes Ivy publication '" + publicationName + "' to Ivy repository '" + repositoryName + "'.");
            }
        });
        tasks.named("publish", (Action)new Action<Task>(){

            public void execute(Task task) {
                task.dependsOn(new Object[]{publishTaskName});
            }
        });
    }

    private void createGenerateIvyDescriptorTask(TaskContainer tasks, final String publicationName, final IvyPublicationInternal publication, final @Path(value="buildDir") DirectoryProperty buildDir) {
        String descriptorTaskName = "generateDescriptorFileFor" + StringUtils.capitalize((String)publicationName) + "Publication";
        TaskProvider generatorTask = tasks.register(descriptorTaskName, GenerateIvyDescriptor.class, (Action)new Action<GenerateIvyDescriptor>(){

            public void execute(GenerateIvyDescriptor descriptorTask) {
                descriptorTask.setDescription("Generates the Ivy Module Descriptor XML file for publication '" + publicationName + "'.");
                descriptorTask.setGroup("publishing");
                descriptorTask.setDescriptor(publication.getDescriptor());
                if (descriptorTask.getDestination() == null) {
                    descriptorTask.setDestination(buildDir.file("publications/" + publicationName + "/ivy.xml"));
                }
            }
        });
        publication.setIvyDescriptorGenerator((Task)generatorTask.get());
    }

    private void createGenerateMetadataTask(Project project, TaskContainer tasks, final IvyPublicationInternal publication, final Set<IvyPublicationInternal> publications, final DirectoryProperty buildDir) {
        final String publicationName = publication.getName();
        String descriptorTaskName = "generateMetadataFileFor" + StringUtils.capitalize((String)publicationName) + "Publication";
        TaskProvider generatorTask = tasks.register(descriptorTaskName, GenerateModuleMetadata.class, (Action)new Action<GenerateModuleMetadata>(){

            public void execute(GenerateModuleMetadata generateTask) {
                generateTask.setDescription("Generates the Gradle metadata file for publication '" + publicationName + "'.");
                generateTask.setGroup("publishing");
                generateTask.getPublication().set((Object)publication);
                generateTask.getPublications().set((Iterable)publications);
                generateTask.getOutputFile().convention(buildDir.file("publications/" + publicationName + "/module.json"));
            }
        });
        publication.setModuleDescriptorGenerator((Task)generatorTask.get());
    }

    private class IvyPublicationFactory
    implements NamedDomainObjectFactory<IvyPublication> {
        private final Instantiator instantiator;
        private final DependencyMetaDataProvider dependencyMetaDataProvider;
        private final ObjectFactory objectFactory;
        private final FileResolver fileResolver;
        private final CollectionCallbackActionDecorator collectionCallbackActionDecorator;

        private IvyPublicationFactory(DependencyMetaDataProvider dependencyMetaDataProvider, Instantiator instantiator, ObjectFactory objectFactory, FileResolver fileResolver, CollectionCallbackActionDecorator collectionCallbackActionDecorator) {
            this.dependencyMetaDataProvider = dependencyMetaDataProvider;
            this.instantiator = instantiator;
            this.objectFactory = objectFactory;
            this.fileResolver = fileResolver;
            this.collectionCallbackActionDecorator = collectionCallbackActionDecorator;
        }

        public IvyPublication create(String name) {
            Module module = this.dependencyMetaDataProvider.getModule();
            DefaultIvyPublicationIdentity publicationIdentity = new DefaultIvyPublicationIdentity(module);
            NotationParser<Object, IvyArtifact> notationParser = new IvyArtifactNotationParserFactory(this.instantiator, this.fileResolver, publicationIdentity).create();
            return (IvyPublication)this.instantiator.newInstance(DefaultIvyPublication.class, new Object[]{name, this.instantiator, this.objectFactory, publicationIdentity, notationParser, IvyPublishPlugin.this.projectDependencyResolver, IvyPublishPlugin.this.fileCollectionFactory, IvyPublishPlugin.this.immutableAttributesFactory, IvyPublishPlugin.this.featurePreviews, this.collectionCallbackActionDecorator});
        }
    }
}

