/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.org.objectweb.asm.tree;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationNode
extends AnnotationVisitor {
    public String desc;
    public List<Object> values;

    public AnnotationNode(String desc) {
        this(393216, desc);
        if (this.getClass() != AnnotationNode.class) {
            throw new IllegalStateException();
        }
    }

    public AnnotationNode(int api, String desc) {
        super(api);
        this.desc = desc;
    }

    AnnotationNode(List<Object> values) {
        super(393216);
        this.values = values;
    }

    @Override
    public void visit(String name, Object value) {
        if (this.values == null) {
            this.values = new ArrayList<Object>(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(name);
        }
        if (value instanceof byte[]) {
            byte[] v2 = (byte[])value;
            ArrayList<Byte> l = new ArrayList<Byte>(v2.length);
            for (byte b : v2) {
                l.add(b);
            }
            this.values.add(l);
        } else if (value instanceof boolean[]) {
            boolean[] v3 = (boolean[])value;
            ArrayList<Boolean> l = new ArrayList<Boolean>(v3.length);
            for (boolean b : v3) {
                l.add(b);
            }
            this.values.add(l);
        } else if (value instanceof short[]) {
            short[] v4 = (short[])value;
            ArrayList<Short> l = new ArrayList<Short>(v4.length);
            for (short s : v4) {
                l.add(s);
            }
            this.values.add(l);
        } else if (value instanceof char[]) {
            char[] v5 = (char[])value;
            ArrayList<Character> l = new ArrayList<Character>(v5.length);
            for (char c : v5) {
                l.add(Character.valueOf(c));
            }
            this.values.add(l);
        } else if (value instanceof int[]) {
            int[] v6 = (int[])value;
            ArrayList<Integer> l = new ArrayList<Integer>(v6.length);
            for (int i : v6) {
                l.add(i);
            }
            this.values.add(l);
        } else if (value instanceof long[]) {
            long[] v7 = (long[])value;
            ArrayList<Long> l = new ArrayList<Long>(v7.length);
            for (long lng : v7) {
                l.add(lng);
            }
            this.values.add(l);
        } else if (value instanceof float[]) {
            float[] v8 = (float[])value;
            ArrayList<Float> l = new ArrayList<Float>(v8.length);
            for (float f : v8) {
                l.add(Float.valueOf(f));
            }
            this.values.add(l);
        } else if (value instanceof double[]) {
            double[] v9 = (double[])value;
            ArrayList<Double> l = new ArrayList<Double>(v9.length);
            for (double d : v9) {
                l.add(d);
            }
            this.values.add(l);
        } else {
            this.values.add(value);
        }
    }

    @Override
    public void visitEnum(String name, String desc, String value) {
        if (this.values == null) {
            this.values = new ArrayList<Object>(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(name);
        }
        this.values.add(new String[]{desc, value});
    }

    @Override
    public AnnotationVisitor visitAnnotation(String name, String desc) {
        if (this.values == null) {
            this.values = new ArrayList<Object>(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(name);
        }
        AnnotationNode annotation2 = new AnnotationNode(desc);
        this.values.add(annotation2);
        return annotation2;
    }

    @Override
    public AnnotationVisitor visitArray(String name) {
        if (this.values == null) {
            this.values = new ArrayList<Object>(this.desc != null ? 2 : 1);
        }
        if (this.desc != null) {
            this.values.add(name);
        }
        ArrayList<Object> array = new ArrayList<Object>();
        this.values.add(array);
        return new AnnotationNode(array);
    }

    @Override
    public void visitEnd() {
    }

    public void check(int api) {
    }

    public void accept(AnnotationVisitor av) {
        if (av != null) {
            if (this.values != null) {
                for (int i = 0; i < this.values.size(); i += 2) {
                    String name = (String)this.values.get(i);
                    Object value = this.values.get(i + 1);
                    AnnotationNode.accept(av, name, value);
                }
            }
            av.visitEnd();
        }
    }

    static void accept(AnnotationVisitor av, String name, Object value) {
        if (av != null) {
            if (value instanceof String[]) {
                String[] typeconst = (String[])value;
                av.visitEnum(name, typeconst[0], typeconst[1]);
            } else if (value instanceof AnnotationNode) {
                AnnotationNode an = (AnnotationNode)value;
                an.accept(av.visitAnnotation(name, an.desc));
            } else if (value instanceof List) {
                AnnotationVisitor v2 = av.visitArray(name);
                if (v2 != null) {
                    List array = (List)value;
                    for (int j = 0; j < array.size(); ++j) {
                        AnnotationNode.accept(v2, null, array.get(j));
                    }
                    v2.visitEnd();
                }
            } else {
                av.visit(name, value);
            }
        }
    }
}

