/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.lang;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtilRt;
import org.jetbrains.kotlin.com.intellij.util.lang.MemoryResource;
import org.jetbrains.kotlin.com.intellij.util.lang.Resource;

public class JarMemoryLoader {
    private final Map<String, Resource> myResources = Collections.synchronizedMap(new HashMap());

    private JarMemoryLoader() {
    }

    public Resource getResource(String entryName) {
        return this.myResources.remove(entryName);
    }

    @Nullable
    public static JarMemoryLoader load(ZipFile zipFile2, URL baseUrl, Map<Resource.Attribute, String> attributes) throws IOException {
        Enumeration<? extends ZipEntry> entries2 = zipFile2.entries();
        if (!entries2.hasMoreElements()) {
            return null;
        }
        ZipEntry sizeEntry = entries2.nextElement();
        if (sizeEntry == null || !sizeEntry.getName().equals("META-INF/jb/$$size$$")) {
            return null;
        }
        byte[] bytes = FileUtilRt.loadBytes(zipFile2.getInputStream(sizeEntry), 2);
        int size = ((bytes[1] & 0xFF) << 8) + (bytes[0] & 0xFF);
        JarMemoryLoader loader = new JarMemoryLoader();
        for (int i = 0; i < size && entries2.hasMoreElements(); ++i) {
            ZipEntry entry = entries2.nextElement();
            MemoryResource resource = MemoryResource.load(baseUrl, zipFile2, entry, attributes);
            loader.myResources.put(entry.getName(), resource);
        }
        return loader;
    }
}

