/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.cache;

import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.LighterAST;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameHelper;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiAnnotationStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiClassStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LightTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubBase;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubInputStream;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubOutputStream;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.BitUtil;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.gnu.trove.TObjectIntHashMap;

public class TypeInfo {
    private static final String[] ourIndexFrequentType = new String[]{"", "boolean", "byte", "char", "double", "float", "int", "long", "null", "short", "void", "Object", "java.lang.Object", "String", "java.lang.String"};
    private static final TObjectIntHashMap<String> ourFrequentTypeIndex = new TObjectIntHashMap();
    private static final TypeInfo NULL;
    public final String text;
    public final byte arrayCount;
    public final boolean isEllipsis;
    private final PsiAnnotationStub[] myAnnotationStubs;

    public TypeInfo(String text2, byte arrayCount, boolean ellipsis, @NotNull PsiAnnotationStub[] annotationStubs) {
        if (annotationStubs == null) {
            TypeInfo.$$$reportNull$$$0(0);
        }
        this.text = text2 == null ? null : TypeInfo.internFrequentType(text2);
        this.arrayCount = arrayCount;
        this.isEllipsis = ellipsis;
        this.myAnnotationStubs = annotationStubs;
    }

    @NotNull
    public TypeInfo applyAnnotations(@NotNull StubBase<?> owner) {
        PsiModifierListStub modifierList;
        if (owner == null) {
            TypeInfo.$$$reportNull$$$0(1);
        }
        if ((modifierList = owner.findChildStubByType(JavaStubElementTypes.MODIFIER_LIST)) == null) {
            TypeInfo typeInfo = this;
            if (typeInfo == null) {
                TypeInfo.$$$reportNull$$$0(2);
            }
            return typeInfo;
        }
        SmartList<PsiAnnotationStub> annotationStubs = null;
        for (StubElement child : modifierList.getChildrenStubs()) {
            PsiAnnotationStub annotationStub;
            if (!(child instanceof PsiAnnotationStub) || !PsiImplUtil.isTypeAnnotation((annotationStub = (PsiAnnotationStub)child).getPsiElement())) continue;
            if (annotationStubs == null) {
                annotationStubs = new SmartList<PsiAnnotationStub>();
            }
            annotationStubs.add(annotationStub);
        }
        PsiAnnotationStub[] stubArray = PsiAnnotationStub.EMPTY_ARRAY;
        if (annotationStubs != null) {
            stubArray = annotationStubs.toArray(PsiAnnotationStub.EMPTY_ARRAY);
        }
        TypeInfo typeInfo = new TypeInfo(this.text, this.arrayCount, this.isEllipsis, stubArray);
        if (typeInfo == null) {
            TypeInfo.$$$reportNull$$$0(3);
        }
        return typeInfo;
    }

    @NotNull
    public String getShortTypeText() {
        if (this.text == null) {
            if ("" == null) {
                TypeInfo.$$$reportNull$$$0(4);
            }
            return "";
        }
        String name = PsiNameHelper.getShortClassName(this.text);
        if (this.arrayCount > 0) {
            name = name + StringUtil.repeat("[]", this.arrayCount);
        }
        String string = name;
        if (string == null) {
            TypeInfo.$$$reportNull$$$0(5);
        }
        return string;
    }

    public String toString() {
        String text2 = TypeInfo.createTypeText(this);
        return text2 != null ? text2 : "null";
    }

    @NotNull
    public static TypeInfo createConstructorType() {
        TypeInfo typeInfo = NULL;
        if (typeInfo == null) {
            TypeInfo.$$$reportNull$$$0(6);
        }
        return typeInfo;
    }

    @NotNull
    public static TypeInfo create(@NotNull LighterAST tree, @NotNull LighterASTNode element, StubElement parentStub) {
        String text2;
        if (tree == null) {
            TypeInfo.$$$reportNull$$$0(7);
        }
        if (element == null) {
            TypeInfo.$$$reportNull$$$0(8);
        }
        byte arrayCount = 0;
        boolean isEllipsis = false;
        if (element.getTokenType() == JavaElementType.ENUM_CONSTANT) {
            text2 = ((PsiClassStub)parentStub).getName();
        } else {
            LighterASTNode nested;
            LighterASTNode typeElement = null;
            for (LighterASTNode child : tree.getChildren(element)) {
                IElementType type2 = child.getTokenType();
                if (type2 == JavaElementType.TYPE) {
                    typeElement = child;
                    continue;
                }
                if (type2 != JavaTokenType.LBRACKET) continue;
                arrayCount = (byte)(arrayCount + 1);
            }
            if (typeElement == null && element.getTokenType() == JavaElementType.FIELD) {
                LighterASTNode parent2 = tree.getParent(element);
                assert (parent2 != null) : element;
                List<LighterASTNode> fields2 = LightTreeUtil.getChildrenOfType(tree, parent2, JavaElementType.FIELD);
                int idx = fields2.indexOf(element);
                for (int i = idx - 1; i >= 0 && typeElement == null; --i) {
                    typeElement = LightTreeUtil.firstChildOfType(tree, fields2.get(i), JavaElementType.TYPE);
                }
            }
            assert (typeElement != null) : element + " in " + parentStub;
            boolean bl = isEllipsis = LightTreeUtil.firstChildOfType(tree, typeElement, JavaTokenType.ELLIPSIS) != null;
            while ((nested = LightTreeUtil.firstChildOfType(tree, typeElement, JavaElementType.TYPE)) != null) {
                typeElement = nested;
                arrayCount = (byte)(arrayCount + 1);
            }
            text2 = LightTreeUtil.toFilteredString(tree, typeElement, null);
        }
        TypeInfo typeInfo = new TypeInfo(text2, arrayCount, isEllipsis, PsiAnnotationStub.EMPTY_ARRAY);
        if (typeInfo == null) {
            TypeInfo.$$$reportNull$$$0(9);
        }
        return typeInfo;
    }

    @NotNull
    public static TypeInfo fromString(@NotNull String typeText, boolean isEllipsis) {
        if (typeText == null) {
            TypeInfo.$$$reportNull$$$0(10);
        }
        assert (!typeText.endsWith("...")) : typeText;
        byte arrayCount = 0;
        while (typeText.endsWith("[]")) {
            arrayCount = (byte)(arrayCount + 1);
            typeText = typeText.substring(0, typeText.length() - 2);
        }
        TypeInfo typeInfo = new TypeInfo(typeText, arrayCount, isEllipsis, PsiAnnotationStub.EMPTY_ARRAY);
        if (typeInfo == null) {
            TypeInfo.$$$reportNull$$$0(11);
        }
        return typeInfo;
    }

    @NotNull
    public static TypeInfo fromString(@NotNull String typeText) {
        if (typeText == null) {
            TypeInfo.$$$reportNull$$$0(12);
        }
        boolean isEllipsis = false;
        if (typeText.endsWith("...")) {
            isEllipsis = true;
            typeText = typeText.substring(0, typeText.length() - 3);
        }
        TypeInfo typeInfo = TypeInfo.fromString(typeText, isEllipsis);
        if (typeInfo == null) {
            TypeInfo.$$$reportNull$$$0(13);
        }
        return typeInfo;
    }

    @NotNull
    public static TypeInfo readTYPE(@NotNull StubInputStream record2) throws IOException {
        int flags;
        if (record2 == null) {
            TypeInfo.$$$reportNull$$$0(14);
        }
        if ((flags = record2.readByte() & 0xFF) == 63) {
            TypeInfo typeInfo = NULL;
            if (typeInfo == null) {
                TypeInfo.$$$reportNull$$$0(15);
            }
            return typeInfo;
        }
        byte arrayCount = BitUtil.isSet(flags, 64) ? record2.readByte() : (byte)0;
        boolean hasEllipsis = BitUtil.isSet(flags, 128);
        int frequentIndex = 0x3F & flags;
        String text2 = frequentIndex == 0 ? record2.readNameString() : ourIndexFrequentType[frequentIndex];
        TypeInfo typeInfo = new TypeInfo(text2, arrayCount, hasEllipsis, PsiAnnotationStub.EMPTY_ARRAY);
        if (typeInfo == null) {
            TypeInfo.$$$reportNull$$$0(16);
        }
        return typeInfo;
    }

    public static void writeTYPE(@NotNull StubOutputStream dataStream, @NotNull TypeInfo typeInfo) throws IOException {
        if (dataStream == null) {
            TypeInfo.$$$reportNull$$$0(17);
        }
        if (typeInfo == null) {
            TypeInfo.$$$reportNull$$$0(18);
        }
        if (typeInfo == NULL) {
            dataStream.writeByte(63);
            return;
        }
        String text2 = typeInfo.text;
        byte arrayCount = typeInfo.arrayCount;
        int frequentIndex = ourFrequentTypeIndex.get(text2);
        int flags = (typeInfo.isEllipsis ? 128 : 0) | (arrayCount != 0 ? 64 : 0) | frequentIndex;
        dataStream.writeByte(flags);
        if (arrayCount != 0) {
            dataStream.writeByte(arrayCount);
        }
        if (frequentIndex == 0) {
            dataStream.writeName(text2);
        }
    }

    @Nullable
    public static String createTypeText(@NotNull TypeInfo typeInfo) {
        if (typeInfo == null) {
            TypeInfo.$$$reportNull$$$0(19);
        }
        if (typeInfo == NULL || typeInfo.text == null) {
            return null;
        }
        if (typeInfo.arrayCount == 0 && typeInfo.myAnnotationStubs.length == 0) {
            return typeInfo.text;
        }
        StringBuilder buf = new StringBuilder();
        for (PsiAnnotationStub stub : typeInfo.myAnnotationStubs) {
            buf.append(stub.getText()).append(' ');
        }
        buf.append(typeInfo.text);
        int arrayCount = typeInfo.isEllipsis ? typeInfo.arrayCount - 1 : typeInfo.arrayCount;
        for (int i = 0; i < arrayCount; ++i) {
            buf.append("[]");
        }
        if (typeInfo.isEllipsis) {
            buf.append("...");
        }
        return TypeInfo.internFrequentType(buf.toString());
    }

    @NotNull
    public static String internFrequentType(@NotNull String type2) {
        int frequentIndex;
        if (type2 == null) {
            TypeInfo.$$$reportNull$$$0(20);
        }
        String string = (frequentIndex = ourFrequentTypeIndex.get(type2)) == 0 ? type2 : ourIndexFrequentType[frequentIndex];
        if (string == null) {
            TypeInfo.$$$reportNull$$$0(21);
        }
        return string;
    }

    static {
        for (int i = 0; i < ourIndexFrequentType.length; ++i) {
            ourFrequentTypeIndex.put(ourIndexFrequentType[i], i);
        }
        NULL = new TypeInfo(null, 0, false, PsiAnnotationStub.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationStubs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/cache/TypeInfo";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeText";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "record";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeInfo";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/cache/TypeInfo";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "applyAnnotations";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortTypeText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstructorType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "fromString";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "readTYPE";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "internFrequentType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyAnnotations";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 21: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "readTYPE";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "writeTYPE";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createTypeText";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "internFrequentType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

