/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.util.NavigableSet;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.execution.plan.TaskDependencyResolver;

public abstract class Node
implements Comparable<Node> {
    private ExecutionState state;
    private boolean dependenciesProcessed;
    private Throwable executionFailure;
    private final NavigableSet<Node> dependencySuccessors = Sets.newTreeSet();
    private final NavigableSet<Node> dependencyPredecessors = Sets.newTreeSet();

    public Node() {
        this.state = ExecutionState.UNKNOWN;
    }

    @VisibleForTesting
    ExecutionState getState() {
        return this.state;
    }

    public boolean isRequired() {
        return this.state == ExecutionState.SHOULD_RUN;
    }

    public boolean isMustNotRun() {
        return this.state == ExecutionState.MUST_NOT_RUN;
    }

    public boolean isIncludeInGraph() {
        return this.state == ExecutionState.NOT_REQUIRED || this.state == ExecutionState.UNKNOWN;
    }

    public boolean isReady() {
        return this.state == ExecutionState.SHOULD_RUN || this.state == ExecutionState.MUST_RUN;
    }

    public boolean isInKnownState() {
        return this.state != ExecutionState.UNKNOWN;
    }

    public boolean isComplete() {
        return this.state == ExecutionState.EXECUTED || this.state == ExecutionState.SKIPPED || this.state == ExecutionState.UNKNOWN || this.state == ExecutionState.NOT_REQUIRED || this.state == ExecutionState.MUST_NOT_RUN;
    }

    public boolean isSuccessful() {
        return this.state == ExecutionState.EXECUTED && !this.isFailed() || this.state == ExecutionState.NOT_REQUIRED || this.state == ExecutionState.MUST_NOT_RUN;
    }

    public boolean isFailed() {
        return this.getNodeFailure() != null || this.getExecutionFailure() != null;
    }

    @Nullable
    public abstract Throwable getNodeFailure();

    public abstract void rethrowNodeFailure();

    public void startExecution() {
        assert (this.isReady());
        this.state = ExecutionState.EXECUTING;
    }

    public void finishExecution() {
        assert (this.state == ExecutionState.EXECUTING);
        this.state = ExecutionState.EXECUTED;
    }

    public void skipExecution() {
        assert (this.state == ExecutionState.SHOULD_RUN);
        this.state = ExecutionState.SKIPPED;
    }

    public void abortExecution() {
        assert (this.isReady());
        this.state = ExecutionState.SKIPPED;
    }

    public void require() {
        this.state = ExecutionState.SHOULD_RUN;
    }

    public void doNotRequire() {
        this.state = ExecutionState.NOT_REQUIRED;
    }

    public void mustNotRun() {
        this.state = ExecutionState.MUST_NOT_RUN;
    }

    public void enforceRun() {
        assert (this.state == ExecutionState.SHOULD_RUN || this.state == ExecutionState.MUST_NOT_RUN || this.state == ExecutionState.MUST_RUN);
        this.state = ExecutionState.MUST_RUN;
    }

    public void setExecutionFailure(Throwable failure) {
        assert (this.state == ExecutionState.EXECUTING);
        this.executionFailure = failure;
    }

    @Nullable
    public Throwable getExecutionFailure() {
        return this.executionFailure;
    }

    public Set<Node> getDependencyPredecessors() {
        return this.dependencyPredecessors;
    }

    public Set<Node> getDependencySuccessors() {
        return this.dependencySuccessors;
    }

    protected void addDependencySuccessor(Node toNode) {
        this.dependencySuccessors.add(toNode);
        toNode.dependencyPredecessors.add(this);
    }

    @OverridingMethodsMustInvokeSuper
    public boolean allDependenciesComplete() {
        for (Node dependency : this.dependencySuccessors) {
            if (dependency.isComplete()) continue;
            return false;
        }
        return true;
    }

    public boolean allDependenciesSuccessful() {
        for (Node dependency : this.dependencySuccessors) {
            if (dependency.isSuccessful()) continue;
            return false;
        }
        return true;
    }

    public abstract void prepareForExecution();

    public abstract void resolveDependencies(TaskDependencyResolver var1, Action<Node> var2);

    public boolean getDependenciesProcessed() {
        return this.dependenciesProcessed;
    }

    public void dependenciesProcessed() {
        this.dependenciesProcessed = true;
    }

    @OverridingMethodsMustInvokeSuper
    public Iterable<Node> getAllSuccessors() {
        return this.dependencySuccessors;
    }

    @OverridingMethodsMustInvokeSuper
    public Iterable<Node> getAllSuccessorsInReverseOrder() {
        return this.dependencySuccessors.descendingSet();
    }

    @OverridingMethodsMustInvokeSuper
    public boolean hasHardSuccessor(Node successor) {
        return this.dependencySuccessors.contains(successor);
    }

    public abstract Set<Node> getFinalizers();

    @Nullable
    public abstract Project getProject();

    public abstract String toString();

    @VisibleForTesting
    static enum ExecutionState {
        UNKNOWN,
        NOT_REQUIRED,
        SHOULD_RUN,
        MUST_RUN,
        MUST_NOT_RUN,
        EXECUTING,
        EXECUTED,
        SKIPPED;

    }
}

