/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.file.FilePropertyFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.provider.AbstractCombiningProvider;
import org.gradle.api.internal.provider.AbstractMappingProvider;
import org.gradle.api.internal.provider.DefaultPropertyState;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.provider.Provider;
import org.gradle.internal.file.PathToFileResolver;

public class DefaultFilePropertyFactory
implements FilePropertyFactory {
    private final FileResolver fileResolver;

    public DefaultFilePropertyFactory(FileResolver resolver) {
        this.fileResolver = resolver;
    }

    @Override
    public DirectoryProperty newDirectoryProperty() {
        return new DefaultDirectoryVar(this.fileResolver);
    }

    @Override
    public RegularFileProperty newFileProperty() {
        return new DefaultRegularFileVar((PathToFileResolver)this.fileResolver);
    }

    static class ToFileProvider
    extends AbstractMappingProvider<File, FileSystemLocation> {
        ToFileProvider(ProviderInternal<? extends FileSystemLocation> provider) {
            super(File.class, provider);
        }

        protected File map(FileSystemLocation provider) {
            return provider.getAsFile();
        }
    }

    static class DefaultDirectoryVar
    extends AbstractFileVar<Directory>
    implements DirectoryProperty {
        private final FileResolver resolver;

        DefaultDirectoryVar(FileResolver resolver) {
            super(Directory.class);
            this.resolver = resolver;
        }

        DefaultDirectoryVar(FileResolver resolver, Object value) {
            super(Directory.class);
            this.resolver = resolver;
            this.resolveAndSet(value);
        }

        public FileTree getAsFileTree() {
            return this.resolver.resolveFilesAsTree(new Object[]{this});
        }

        public Provider<File> getAsFile() {
            return new ToFileProvider((ProviderInternal<? extends FileSystemLocation>)this);
        }

        void resolveAndSet(Object value) {
            File resolved = this.resolver.resolve(value);
            this.set(new FixedDirectory(resolved, this.resolver.newResolver(resolved)));
        }

        @Override
        public void set(File dir) {
            File resolved = this.resolver.resolve((Object)dir);
            this.set(new FixedDirectory(resolved, this.resolver.newResolver(resolved)));
        }

        public DirectoryProperty value(Directory value) {
            super.value((Object)value);
            return this;
        }

        public DirectoryProperty convention(Directory value) {
            super.convention((Object)value);
            return this;
        }

        public DirectoryProperty convention(Provider<? extends Directory> valueProvider) {
            super.convention(valueProvider);
            return this;
        }

        public Provider<Directory> dir(final String path) {
            return new AbstractMappingProvider<Directory, Directory>(Directory.class, (ProviderInternal)this){

                protected Directory map(Directory dir) {
                    return dir.dir(path);
                }
            };
        }

        public Provider<Directory> dir(Provider<? extends CharSequence> path) {
            return new AbstractCombiningProvider<Directory, Directory, CharSequence>(Directory.class, (Provider)this, path){

                protected Directory map(Directory b, CharSequence v) {
                    return b.dir(v.toString());
                }
            };
        }

        public Provider<RegularFile> file(final String path) {
            return new AbstractMappingProvider<RegularFile, Directory>(RegularFile.class, (ProviderInternal)this){

                protected RegularFile map(Directory dir) {
                    return dir.file(path);
                }
            };
        }

        public Provider<RegularFile> file(Provider<? extends CharSequence> path) {
            return new AbstractCombiningProvider<RegularFile, Directory, CharSequence>(RegularFile.class, (Provider)this, path){

                protected RegularFile map(Directory b, CharSequence v) {
                    return b.file(v.toString());
                }
            };
        }
    }

    static class ResolvingDirectory
    extends AbstractResolvingProvider<Directory> {
        private final FileResolver resolver;

        ResolvingDirectory(FileResolver resolver, ProviderInternal<? extends CharSequence> valueProvider) {
            super(Directory.class, valueProvider);
            this.resolver = resolver;
        }

        protected Directory map(CharSequence path) {
            File dir = this.resolver.resolve((Object)path);
            return new FixedDirectory(dir, this.resolver.newResolver(dir));
        }
    }

    static class DefaultRegularFileVar
    extends AbstractFileVar<RegularFile>
    implements RegularFileProperty {
        private final PathToFileResolver fileResolver;

        DefaultRegularFileVar(PathToFileResolver fileResolver) {
            super(RegularFile.class);
            this.fileResolver = fileResolver;
        }

        public Provider<File> getAsFile() {
            return new ToFileProvider((ProviderInternal<? extends FileSystemLocation>)this);
        }

        @Override
        public void set(File file) {
            this.set(new FixedFile(this.fileResolver.resolve((Object)file)));
        }

        public RegularFileProperty value(RegularFile value) {
            super.value((Object)value);
            return this;
        }

        public RegularFileProperty convention(RegularFile value) {
            super.convention((Object)value);
            return this;
        }

        public RegularFileProperty convention(Provider<? extends RegularFile> valueProvider) {
            super.convention(valueProvider);
            return this;
        }
    }

    static abstract class AbstractFileVar<T>
    extends DefaultPropertyState<T> {
        public AbstractFileVar(Class<T> type) {
            super(type);
        }

        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            if (!super.maybeVisitBuildDependencies(context)) {
                this.getProvider().maybeVisitBuildDependencies(context);
            }
            return true;
        }

        public void setFromAnyValue(Object object) {
            if (object instanceof File) {
                this.set((File)object);
            } else {
                super.setFromAnyValue(object);
            }
        }

        public abstract void set(File var1);
    }

    static class ResolvingRegularFileProvider
    extends AbstractResolvingProvider<RegularFile> {
        private final PathToFileResolver resolver;

        ResolvingRegularFileProvider(PathToFileResolver resolver, ProviderInternal<? extends CharSequence> path) {
            super(RegularFile.class, path);
            this.resolver = resolver;
        }

        protected RegularFile map(CharSequence path) {
            return new FixedFile(this.resolver.resolve((Object)path));
        }
    }

    static abstract class AbstractResolvingProvider<T>
    extends AbstractMappingProvider<T, CharSequence> {
        public AbstractResolvingProvider(Class<T> type, ProviderInternal<? extends CharSequence> provider) {
            super(type, provider);
        }

        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            return true;
        }
    }

    static class FixedFile
    implements RegularFile {
        private final File file;

        FixedFile(File file) {
            this.file = file;
        }

        public String toString() {
            return this.file.toString();
        }

        public File getAsFile() {
            return this.file;
        }
    }

    static class FixedDirectory
    implements Directory {
        private final File value;
        final FileResolver fileResolver;

        FixedDirectory(File value, FileResolver fileResolver) {
            this.value = value;
            this.fileResolver = fileResolver;
        }

        public String toString() {
            return this.value.toString();
        }

        public File getAsFile() {
            return this.value;
        }

        public Directory dir(String path) {
            File newDir = this.fileResolver.resolve((Object)path);
            return new FixedDirectory(newDir, this.fileResolver.newResolver(newDir));
        }

        public FileTree getAsFileTree() {
            return this.fileResolver.resolveFilesAsTree(new Object[]{this});
        }

        public Provider<Directory> dir(Provider<? extends CharSequence> path) {
            return new ResolvingDirectory(this.fileResolver, (ProviderInternal<? extends CharSequence>)Providers.internal(path));
        }

        public RegularFile file(String path) {
            return new FixedFile(this.fileResolver.resolve((Object)path));
        }

        public Provider<RegularFile> file(Provider<? extends CharSequence> path) {
            return new ResolvingRegularFileProvider((PathToFileResolver)this.fileResolver, (ProviderInternal<? extends CharSequence>)Providers.internal(path));
        }
    }
}

