/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.sink;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.events.ProgressCompleteEvent;
import org.gradle.internal.logging.events.ProgressEvent;
import org.gradle.internal.logging.events.ProgressStartEvent;
import org.gradle.internal.logging.events.RenderableOutputEvent;
import org.gradle.internal.operations.BuildOperationCategory;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.util.GUtil;

public class OutputEventTransformer
implements OutputEventListener {
    private final Map<OperationIdentifier, OperationIdentifier> effectiveProgressOperation = new HashMap<OperationIdentifier, OperationIdentifier>();
    private final Set<OperationIdentifier> forwarded = new HashSet<OperationIdentifier>();
    private final OutputEventListener listener;

    public OutputEventTransformer(OutputEventListener listener) {
        this.listener = listener;
    }

    @Override
    public void onOutput(OutputEvent event) {
        if (event instanceof ProgressStartEvent) {
            ProgressStartEvent startEvent = (ProgressStartEvent)event;
            if (!startEvent.isBuildOperationStart()) {
                OperationIdentifier mappedId;
                this.forwarded.add(startEvent.getProgressOperationId());
                OperationIdentifier parentProgressOperationId = startEvent.getParentProgressOperationId();
                if (parentProgressOperationId != null && (mappedId = this.effectiveProgressOperation.get(parentProgressOperationId)) != null) {
                    startEvent = startEvent.withParentProgressOperation(mappedId);
                }
                this.listener.onOutput(startEvent);
                return;
            }
            if (startEvent.getParentProgressOperationId() == null || GUtil.isTrue((Object)startEvent.getLoggingHeader()) || GUtil.isTrue((Object)startEvent.getStatus()) || startEvent.getBuildOperationCategory() != BuildOperationCategory.UNCATEGORIZED) {
                OperationIdentifier mappedId;
                this.forwarded.add(startEvent.getProgressOperationId());
                OperationIdentifier parentProgressOperationId = startEvent.getParentProgressOperationId();
                if (parentProgressOperationId != null && (mappedId = this.effectiveProgressOperation.get(parentProgressOperationId)) != null) {
                    startEvent = startEvent.withParentProgressOperation(mappedId);
                }
                this.listener.onOutput(startEvent);
            } else {
                OperationIdentifier mappedParent = this.effectiveProgressOperation.get(startEvent.getParentProgressOperationId());
                if (mappedParent == null) {
                    mappedParent = startEvent.getParentProgressOperationId();
                }
                this.effectiveProgressOperation.put(startEvent.getProgressOperationId(), mappedParent);
            }
        } else if (event instanceof ProgressCompleteEvent) {
            ProgressCompleteEvent completeEvent = (ProgressCompleteEvent)event;
            this.effectiveProgressOperation.remove(completeEvent.getProgressOperationId());
            if (this.forwarded.remove(completeEvent.getProgressOperationId())) {
                this.listener.onOutput(event);
            }
        } else if (event instanceof ProgressEvent) {
            ProgressEvent progressEvent = (ProgressEvent)event;
            if (this.forwarded.contains(progressEvent.getProgressOperationId())) {
                this.listener.onOutput(event);
            }
        } else if (event instanceof RenderableOutputEvent) {
            OperationIdentifier mappedId;
            RenderableOutputEvent outputEvent = (RenderableOutputEvent)event;
            OperationIdentifier operationId = outputEvent.getBuildOperationId();
            if (operationId != null && (mappedId = this.effectiveProgressOperation.get(operationId)) != null) {
                outputEvent = outputEvent.withBuildOperationId(mappedId);
            }
            this.listener.onOutput(outputEvent);
        } else {
            this.listener.onOutput(event);
        }
    }
}

