/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import com.google.common.collect.ImmutableCollection;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.TaskDependencyResolver;
import org.gradle.execution.plan.TaskNode;
import org.gradle.internal.ImmutableActionSet;

public class LocalTaskNode
extends TaskNode {
    private final TaskInternal task;
    private ImmutableActionSet<Task> postAction = ImmutableActionSet.empty();

    public LocalTaskNode(TaskInternal task) {
        this.task = task;
    }

    public TaskInternal getTask() {
        return this.task;
    }

    @Override
    public Action<? super Task> getPostAction() {
        return this.postAction;
    }

    @Override
    public void appendPostAction(Action<? super Task> action) {
        this.postAction = this.postAction.add(action);
    }

    @Override
    public void collectTaskInto(ImmutableCollection.Builder<Task> builder) {
        builder.add((Object)this.task);
    }

    @Override
    public Throwable getNodeFailure() {
        return this.task.getState().getFailure();
    }

    @Override
    public void rethrowNodeFailure() {
        this.task.getState().rethrowFailure();
    }

    @Override
    public void prepareForExecution() {
        ((TaskContainerInternal)this.task.getProject().getTasks()).prepareForExecution(this.task);
    }

    @Override
    public void resolveDependencies(TaskDependencyResolver dependencyResolver, Action<Node> processHardSuccessor) {
        for (Node targetNode : this.getDependencies(dependencyResolver)) {
            this.addDependencySuccessor(targetNode);
            processHardSuccessor.execute((Object)targetNode);
        }
        for (Node targetNode : this.getFinalizedBy(dependencyResolver)) {
            if (!(targetNode instanceof TaskNode)) {
                throw new IllegalStateException("Only tasks can be finalizers: " + targetNode);
            }
            this.addFinalizerNode((TaskNode)targetNode);
            processHardSuccessor.execute((Object)targetNode);
        }
        for (Node targetNode : this.getMustRunAfter(dependencyResolver)) {
            this.addMustSuccessor(targetNode);
        }
        for (Node targetNode : this.getShouldRunAfter(dependencyResolver)) {
            this.addShouldSuccessor(targetNode);
        }
    }

    private void addFinalizerNode(TaskNode finalizerNode) {
        this.addFinalizer(finalizerNode);
        if (!finalizerNode.isInKnownState()) {
            finalizerNode.mustNotRun();
        }
    }

    private Set<Node> getDependencies(TaskDependencyResolver dependencyResolver) {
        return dependencyResolver.resolveDependenciesFor(this.task, this.task.getTaskDependencies());
    }

    private Set<Node> getFinalizedBy(TaskDependencyResolver dependencyResolver) {
        return dependencyResolver.resolveDependenciesFor(this.task, this.task.getFinalizedBy());
    }

    private Set<Node> getMustRunAfter(TaskDependencyResolver dependencyResolver) {
        return dependencyResolver.resolveDependenciesFor(this.task, this.task.getMustRunAfter());
    }

    private Set<Node> getShouldRunAfter(TaskDependencyResolver dependencyResolver) {
        return dependencyResolver.resolveDependenciesFor(this.task, this.task.getShouldRunAfter());
    }

    @Override
    public int compareTo(Node other) {
        if (this.getClass() != other.getClass()) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        LocalTaskNode localTask = (LocalTaskNode)other;
        return this.task.compareTo(localTask.task);
    }

    @Override
    public String toString() {
        return this.task.getIdentityPath().toString();
    }
}

