/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.resources;

import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.internal.file.archive.compression.Bzip2Archiver;
import org.gradle.api.internal.file.archive.compression.GzipArchiver;
import org.gradle.api.internal.resources.DefaultTextResourceFactory;
import org.gradle.api.internal.resources.ResourceResolver;
import org.gradle.api.resources.ResourceHandler;
import org.gradle.api.resources.TextResourceFactory;
import org.gradle.api.resources.internal.ReadableResourceInternal;
import org.gradle.internal.resource.TextResourceLoader;

public class DefaultResourceHandler
implements ResourceHandler {
    private final ResourceResolver resourceResolver;
    private final TextResourceFactory textResourceFactory;

    public DefaultResourceHandler(FileOperations fileOperations, ResourceResolver resourceResolver, TemporaryFileProvider tempFileProvider, TextResourceLoader textResourceLoader) {
        this.resourceResolver = resourceResolver;
        this.textResourceFactory = new DefaultTextResourceFactory(fileOperations, tempFileProvider, textResourceLoader);
    }

    public ReadableResourceInternal gzip(Object path) {
        return new GzipArchiver(this.resourceResolver.resolveResource(path));
    }

    public ReadableResourceInternal bzip2(Object path) {
        return new Bzip2Archiver(this.resourceResolver.resolveResource(path));
    }

    public TextResourceFactory getText() {
        return this.textResourceFactory;
    }
}

