/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.changes;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSortedMap;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.OverlappingOutputs;
import org.gradle.api.internal.TaskExecutionHistory;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.TaskArtifactState;
import org.gradle.api.internal.changedetection.TaskArtifactStateRepository;
import org.gradle.api.internal.changedetection.changes.ChangesOnlyIncrementalTaskInputs;
import org.gradle.api.internal.changedetection.changes.RebuildIncrementalTaskInputs;
import org.gradle.api.internal.changedetection.rules.DefaultTaskUpToDateState;
import org.gradle.api.internal.changedetection.rules.MaximumNumberTaskStateChangeVisitor;
import org.gradle.api.internal.changedetection.rules.NoHistoryTaskUpToDateState;
import org.gradle.api.internal.changedetection.rules.TaskUpToDateState;
import org.gradle.api.internal.changedetection.state.CurrentTaskExecution;
import org.gradle.api.internal.changedetection.state.HistoricalTaskExecution;
import org.gradle.api.internal.changedetection.state.TaskHistoryRepository;
import org.gradle.api.internal.changedetection.state.TaskOutputFilesRepository;
import org.gradle.api.internal.tasks.OriginTaskExecutionMetadata;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.execution.TaskProperties;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.caching.internal.tasks.TaskCacheKeyCalculator;
import org.gradle.caching.internal.tasks.TaskOutputCachingBuildCacheKey;
import org.gradle.internal.changes.TaskStateChange;
import org.gradle.internal.changes.TaskStateChangeVisitor;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.id.UniqueId;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.snapshot.FileSystemSnapshot;

@NonNullApi
public class DefaultTaskArtifactStateRepository
implements TaskArtifactStateRepository {
    private final TaskHistoryRepository taskHistoryRepository;
    private final Instantiator instantiator;
    private final TaskOutputFilesRepository taskOutputFilesRepository;
    private final TaskCacheKeyCalculator taskCacheKeyCalculator;

    public DefaultTaskArtifactStateRepository(TaskHistoryRepository taskHistoryRepository, Instantiator instantiator, TaskOutputFilesRepository taskOutputFilesRepository, TaskCacheKeyCalculator taskCacheKeyCalculator) {
        this.taskHistoryRepository = taskHistoryRepository;
        this.instantiator = instantiator;
        this.taskOutputFilesRepository = taskOutputFilesRepository;
        this.taskCacheKeyCalculator = taskCacheKeyCalculator;
    }

    @Override
    public TaskArtifactState getStateFor(TaskInternal task, TaskProperties taskProperties) {
        return new TaskArtifactStateImpl(task, this.taskHistoryRepository.getHistory(task, taskProperties));
    }

    private static class MessageCollectingChangeVisitor
    implements TaskStateChangeVisitor {
        private final Collection<String> messages;
        private boolean anyChanges;

        public MessageCollectingChangeVisitor(Collection<String> messages) {
            this.messages = messages;
        }

        public boolean visitChange(TaskStateChange change) {
            this.messages.add(change.getMessage());
            this.anyChanges = true;
            return true;
        }

        public boolean hasAnyChanges() {
            return this.anyChanges;
        }
    }

    private class TaskArtifactStateImpl
    implements TaskArtifactState,
    TaskExecutionHistory {
        private final TaskInternal task;
        private final TaskHistoryRepository.History history;
        private boolean upToDate;
        private boolean outputsRemoved;
        private TaskUpToDateState states;

        public TaskArtifactStateImpl(TaskInternal task, TaskHistoryRepository.History history) {
            this.task = task;
            this.history = history;
        }

        @Override
        public boolean isUpToDate(Collection<String> messages) {
            MessageCollectingChangeVisitor visitor = new MessageCollectingChangeVisitor(messages);
            this.getStates().visitAllTaskChanges(new MaximumNumberTaskStateChangeVisitor(3, visitor));
            this.upToDate = !visitor.hasAnyChanges();
            return this.upToDate;
        }

        @Override
        public IncrementalTaskInputs getInputChanges() {
            assert (!this.upToDate) : "Should not be here if the task is up-to-date";
            IncrementalTaskInputs taskInputs = this.outputsRemoved || this.getStates().isRebuildRequired() ? (IncrementalTaskInputs)DefaultTaskArtifactStateRepository.this.instantiator.newInstance(RebuildIncrementalTaskInputs.class, new Object[]{this.task, this.getCurrentInputFileFingerprints()}) : (IncrementalTaskInputs)DefaultTaskArtifactStateRepository.this.instantiator.newInstance(ChangesOnlyIncrementalTaskInputs.class, new Object[]{this.getStates().getInputFilesChanges()});
            return taskInputs;
        }

        @Override
        public Iterable<? extends FileCollectionFingerprint> getCurrentInputFileFingerprints() {
            return this.history.getCurrentExecution().getInputFingerprints().values();
        }

        @Override
        public boolean isAllowedToUseCachedResults() {
            return true;
        }

        @Override
        @Nullable
        public OverlappingOutputs getOverlappingOutputs() {
            return this.history.getCurrentExecution().getDetectedOverlappingOutputs();
        }

        @Override
        public TaskOutputCachingBuildCacheKey calculateCacheKey() {
            return DefaultTaskArtifactStateRepository.this.taskCacheKeyCalculator.calculate(this.task, this.history.getCurrentExecution());
        }

        @Override
        public Set<File> getOutputFiles() {
            HistoricalTaskExecution previousExecution = this.history.getPreviousExecution();
            if (previousExecution == null) {
                return Collections.emptySet();
            }
            ImmutableCollection outputFingerprints = previousExecution.getOutputFingerprints().values();
            HashSet<File> outputs = new HashSet<File>();
            for (FileCollectionFingerprint fileCollectionFingerprint : outputFingerprints) {
                for (String absolutePath : fileCollectionFingerprint.getFingerprints().keySet()) {
                    outputs.add(new File(absolutePath));
                }
            }
            return outputs;
        }

        @Override
        public Map<String, CurrentFileCollectionFingerprint> getOutputFingerprints() {
            return this.history.getCurrentExecution().getOutputFingerprints();
        }

        @Override
        public TaskExecutionHistory getExecutionHistory() {
            return this;
        }

        @Override
        public OriginTaskExecutionMetadata getOriginExecutionMetadata() {
            HistoricalTaskExecution previousExecution = this.history.getPreviousExecution();
            return previousExecution == null ? null : previousExecution.getOriginExecutionMetadata();
        }

        @Override
        public void ensureSnapshotBeforeTask() {
            this.history.getCurrentExecution();
        }

        @Override
        public void afterOutputsRemovedBeforeTask() {
            this.outputsRemoved = true;
        }

        @Override
        public void snapshotAfterTaskExecution(Throwable failure, UniqueId buildInvocationId, TaskExecutionContext taskExecutionContext) {
            this.history.updateCurrentExecution();
            this.snapshotAfterOutputsWereGenerated(this.history, failure, new OriginTaskExecutionMetadata(buildInvocationId, taskExecutionContext.markExecutionTime()));
        }

        @Override
        public void snapshotAfterLoadedFromCache(ImmutableSortedMap<String, CurrentFileCollectionFingerprint> newOutputFingerprints, OriginTaskExecutionMetadata originMetadata) {
            this.history.updateCurrentExecutionWithOutputs(newOutputFingerprints);
            this.snapshotAfterOutputsWereGenerated(this.history, null, originMetadata);
        }

        private void snapshotAfterOutputsWereGenerated(TaskHistoryRepository.History history, @Nullable Throwable failure, OriginTaskExecutionMetadata originMetadata) {
            if (failure == null || this.getStates().hasAnyOutputFileChanges()) {
                history.getCurrentExecution().setOriginExecutionMetadata(originMetadata);
                history.persist();
                DefaultTaskArtifactStateRepository.this.taskOutputFilesRepository.recordOutputs((Iterable<? extends FileSystemSnapshot>)history.getCurrentExecution().getOutputFingerprints().values());
            }
        }

        private TaskUpToDateState getStates() {
            if (this.states == null) {
                HistoricalTaskExecution previousExecution = this.history.getPreviousExecution();
                CurrentTaskExecution currentExecution = this.history.getCurrentExecution();
                this.states = previousExecution == null ? NoHistoryTaskUpToDateState.INSTANCE : new DefaultTaskUpToDateState(previousExecution, currentExecution, this.task);
            }
            return this.states;
        }
    }
}

