/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.internal.consumer.ConnectionParameters;
import org.gradle.tooling.internal.consumer.DefaultProjectConnection;
import org.gradle.tooling.internal.consumer.Distribution;
import org.gradle.tooling.internal.consumer.LoggingProvider;
import org.gradle.tooling.internal.consumer.async.DefaultAsyncConsumerActionExecutor;
import org.gradle.tooling.internal.consumer.connection.CancellableConsumerActionExecutor;
import org.gradle.tooling.internal.consumer.connection.LazyConsumerActionExecutor;
import org.gradle.tooling.internal.consumer.connection.ProgressLoggingConsumerActionExecutor;
import org.gradle.tooling.internal.consumer.connection.RethrowingErrorsConsumerActionExecutor;
import org.gradle.tooling.internal.consumer.loader.ToolingImplementationLoader;

public class ConnectionFactory {
    private final ToolingImplementationLoader toolingImplementationLoader;
    private final ExecutorFactory executorFactory;
    private final LoggingProvider loggingProvider;

    public ConnectionFactory(ToolingImplementationLoader toolingImplementationLoader, ExecutorFactory executorFactory, LoggingProvider loggingProvider) {
        this.toolingImplementationLoader = toolingImplementationLoader;
        this.executorFactory = executorFactory;
        this.loggingProvider = loggingProvider;
    }

    public ProjectConnection create(Distribution distribution, ConnectionParameters parameters) {
        LazyConsumerActionExecutor lazyConnection = new LazyConsumerActionExecutor(distribution, this.toolingImplementationLoader, this.loggingProvider, parameters);
        CancellableConsumerActionExecutor cancellableConnection = new CancellableConsumerActionExecutor(lazyConnection);
        ProgressLoggingConsumerActionExecutor progressLoggingConnection = new ProgressLoggingConsumerActionExecutor(cancellableConnection, this.loggingProvider);
        RethrowingErrorsConsumerActionExecutor rethrowingErrorsConnection = new RethrowingErrorsConsumerActionExecutor(progressLoggingConnection);
        DefaultAsyncConsumerActionExecutor asyncConnection = new DefaultAsyncConsumerActionExecutor(rethrowingErrorsConnection, this.executorFactory);
        return new DefaultProjectConnection(asyncConnection, parameters);
    }

    ToolingImplementationLoader getToolingImplementationLoader() {
        return this.toolingImplementationLoader;
    }
}

