/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.Closeable;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheOpenException;
import org.gradle.cache.CacheValidator;
import org.gradle.cache.CleanupAction;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.cache.internal.CacheFactory;
import org.gradle.cache.internal.DefaultPersistentDirectoryCache;
import org.gradle.cache.internal.DefaultPersistentDirectoryStore;
import org.gradle.cache.internal.ReferencablePersistentCache;
import org.gradle.internal.Factory;
import org.gradle.internal.FileUtils;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.serialize.Serializer;

public class DefaultCacheFactory
implements CacheFactory,
Closeable {
    private final Map<File, DirCacheReference> dirCaches = new HashMap<File, DirCacheReference>();
    private final FileLockManager lockManager;
    private final ExecutorFactory executorFactory;
    private final Lock lock = new ReentrantLock();

    public DefaultCacheFactory(FileLockManager fileLockManager, ExecutorFactory executorFactory) {
        this.lockManager = fileLockManager;
        this.executorFactory = executorFactory;
    }

    void onOpen(Object cache) {
    }

    void onClose(Object cache) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PersistentCache open(File cacheDir, String displayName, @Nullable CacheValidator cacheValidator, Map<String, ?> properties, CacheBuilder.LockTarget lockTarget, LockOptions lockOptions, Action<? super PersistentCache> initializer, CleanupAction cleanup) throws CacheOpenException {
        this.lock.lock();
        try {
            PersistentCache persistentCache = this.doOpen(cacheDir, displayName, cacheValidator, properties, lockTarget, lockOptions, initializer, cleanup);
            return persistentCache;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.lock.lock();
        try {
            CompositeStoppable.stoppable(this.dirCaches.values()).stop();
        }
        finally {
            this.dirCaches.clear();
            this.lock.unlock();
        }
    }

    private PersistentCache doOpen(File cacheDir, String displayName, @Nullable CacheValidator validator, Map<String, ?> properties, CacheBuilder.LockTarget lockTarget, LockOptions lockOptions, @Nullable Action<? super PersistentCache> initializer, @Nullable CleanupAction cleanup) {
        File canonicalDir = FileUtils.canonicalize((File)cacheDir);
        DirCacheReference dirCacheReference = this.dirCaches.get(canonicalDir);
        if (dirCacheReference == null) {
            DefaultPersistentDirectoryStore cache = !properties.isEmpty() || validator != null || initializer != null || cleanup != null ? new DefaultPersistentDirectoryCache(canonicalDir, displayName, validator, properties, lockTarget, lockOptions, initializer, cleanup, this.lockManager, this.executorFactory) : new DefaultPersistentDirectoryStore(canonicalDir, displayName, lockTarget, lockOptions, this.lockManager, this.executorFactory);
            cache.open();
            dirCacheReference = new DirCacheReference(cache, properties, lockTarget, lockOptions);
            this.dirCaches.put(canonicalDir, dirCacheReference);
        } else {
            if (!lockOptions.equals(dirCacheReference.lockOptions)) {
                throw new IllegalStateException(String.format("Cache '%s' is already open with different lock options.", cacheDir));
            }
            if (lockTarget != dirCacheReference.lockTarget) {
                throw new IllegalStateException(String.format("Cache '%s' is already open with different lock target.", cacheDir));
            }
            if (!properties.equals(dirCacheReference.properties)) {
                throw new IllegalStateException(String.format("Cache '%s' is already open with different properties.", cacheDir));
            }
        }
        return new ReferenceTrackingCache(dirCacheReference);
    }

    private static class ReferenceTrackingCache
    implements PersistentCache {
        private final DirCacheReference reference;

        private ReferenceTrackingCache(DirCacheReference reference) {
            this.reference = reference;
            reference.addReference(this);
        }

        public String toString() {
            return this.reference.cache.toString();
        }

        @Override
        public void close() {
            this.reference.release(this);
        }

        @Override
        public File getBaseDir() {
            return this.reference.cache.getBaseDir();
        }

        @Override
        public Collection<File> getReservedCacheFiles() {
            return this.reference.cache.getReservedCacheFiles();
        }

        @Override
        public <K, V> PersistentIndexedCache<K, V> createCache(PersistentIndexedCacheParameters<K, V> parameters) {
            return this.reference.cache.createCache(parameters);
        }

        @Override
        public <K, V> PersistentIndexedCache<K, V> createCache(String name, Class<K> keyType, Serializer<V> valueSerializer) {
            return this.reference.cache.createCache(name, keyType, valueSerializer);
        }

        @Override
        public <T> T withFileLock(Factory<? extends T> action) {
            return this.reference.cache.withFileLock(action);
        }

        @Override
        public void withFileLock(Runnable action) {
            this.reference.cache.withFileLock(action);
        }

        @Override
        public <T> T useCache(Factory<? extends T> action) {
            return this.reference.cache.useCache(action);
        }

        @Override
        public void useCache(Runnable action) {
            this.reference.cache.useCache(action);
        }
    }

    private class DirCacheReference
    implements Closeable {
        private final Map<String, ?> properties;
        private final CacheBuilder.LockTarget lockTarget;
        private final LockOptions lockOptions;
        private final ReferencablePersistentCache cache;
        private final Set<ReferenceTrackingCache> references = new HashSet<ReferenceTrackingCache>();

        DirCacheReference(ReferencablePersistentCache cache, Map<String, ?> properties, CacheBuilder.LockTarget lockTarget, LockOptions lockOptions) {
            this.cache = cache;
            this.properties = properties;
            this.lockTarget = lockTarget;
            this.lockOptions = lockOptions;
            DefaultCacheFactory.this.onOpen(cache);
        }

        public void addReference(ReferenceTrackingCache cache) {
            this.references.add(cache);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release(ReferenceTrackingCache cache) {
            DefaultCacheFactory.this.lock.lock();
            try {
                if (this.references.remove(cache) && this.references.isEmpty()) {
                    this.close();
                }
            }
            finally {
                DefaultCacheFactory.this.lock.unlock();
            }
        }

        @Override
        public void close() {
            DefaultCacheFactory.this.onClose(this.cache);
            DefaultCacheFactory.this.dirCaches.values().remove(this);
            this.references.clear();
            this.cache.close();
        }
    }
}

