/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.EmptySchema;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.model.AbstractMutableModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ComponentVariant;
import org.gradle.internal.component.external.model.DefaultConfigurationMetadata;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.VariantBackedConfigurationMetadata;
import org.gradle.internal.component.external.model.VariantMetadataRules;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.hash.HashValue;

abstract class AbstractModuleComponentResolveMetadata
implements ModuleComponentResolveMetadata {
    private final ImmutableAttributesFactory attributesFactory;
    private final ModuleVersionIdentifier moduleVersionIdentifier;
    private final ModuleComponentIdentifier componentIdentifier;
    private final boolean changing;
    private final boolean missing;
    private final List<String> statusScheme;
    @Nullable
    private final ModuleSource moduleSource;
    private final ImmutableMap<String, Configuration> configurationDefinitions;
    private final VariantMetadataRules variantMetadataRules;
    private final ImmutableList<? extends ComponentVariant> variants;
    private final HashValue contentHash;
    private final ImmutableAttributes attributes;
    private final Map<String, DefaultConfigurationMetadata> configurations = Maps.newHashMap();
    private Optional<ImmutableList<? extends ConfigurationMetadata>> graphVariants;

    AbstractModuleComponentResolveMetadata(AbstractMutableModuleComponentResolveMetadata metadata) {
        this.componentIdentifier = metadata.getId();
        this.moduleVersionIdentifier = metadata.getModuleVersionId();
        this.changing = metadata.isChanging();
        this.missing = metadata.isMissing();
        this.statusScheme = metadata.getStatusScheme();
        this.moduleSource = metadata.getSource();
        this.configurationDefinitions = metadata.getConfigurationDefinitions();
        this.variantMetadataRules = metadata.getVariantMetadataRules();
        this.contentHash = metadata.getContentHash();
        this.attributesFactory = metadata.getAttributesFactory();
        this.attributes = AbstractModuleComponentResolveMetadata.extractAttributes(metadata);
        this.variants = metadata.getVariants();
    }

    private static ImmutableAttributes extractAttributes(AbstractMutableModuleComponentResolveMetadata metadata) {
        return ((AttributeContainerInternal)metadata.getAttributes()).asImmutable();
    }

    AbstractModuleComponentResolveMetadata(AbstractModuleComponentResolveMetadata metadata, @Nullable ModuleSource source) {
        this.componentIdentifier = metadata.getId();
        this.moduleVersionIdentifier = metadata.getModuleVersionId();
        this.changing = metadata.changing;
        this.missing = metadata.missing;
        this.statusScheme = metadata.statusScheme;
        this.moduleSource = source;
        this.configurationDefinitions = metadata.configurationDefinitions;
        this.variantMetadataRules = metadata.variantMetadataRules;
        this.contentHash = metadata.contentHash;
        this.attributesFactory = metadata.getAttributesFactory();
        this.attributes = metadata.attributes;
        this.variants = metadata.variants;
    }

    protected void copyCachedState(AbstractModuleComponentResolveMetadata metadata) {
        this.configurations.putAll(metadata.configurations);
        this.graphVariants = metadata.graphVariants;
    }

    private DefaultConfigurationMetadata populateConfigurationFromDescriptor(String name, Map<String, Configuration> configurationDefinitions, Map<String, DefaultConfigurationMetadata> configurations) {
        DefaultConfigurationMetadata populated = configurations.get(name);
        if (populated != null) {
            return populated;
        }
        Configuration descriptorConfiguration = configurationDefinitions.get(name);
        if (descriptorConfiguration == null) {
            return null;
        }
        ImmutableList<String> hierarchy = this.constructHierarchy(descriptorConfiguration);
        boolean transitive = descriptorConfiguration.isTransitive();
        boolean visible = descriptorConfiguration.isVisible();
        populated = this.createConfiguration(this.componentIdentifier, name, transitive, visible, hierarchy, this.variantMetadataRules);
        configurations.put(name, populated);
        return populated;
    }

    private ImmutableList<String> constructHierarchy(Configuration descriptorConfiguration) {
        if (descriptorConfiguration.getExtendsFrom().isEmpty()) {
            return ImmutableList.of((Object)descriptorConfiguration.getName());
        }
        LinkedHashSet<String> accumulator = new LinkedHashSet<String>();
        this.populateHierarchy(descriptorConfiguration, accumulator);
        return ImmutableList.copyOf(accumulator);
    }

    private void populateHierarchy(Configuration metadata, Set<String> accumulator) {
        accumulator.add(metadata.getName());
        for (String parentName : metadata.getExtendsFrom()) {
            Configuration parent = (Configuration)this.configurationDefinitions.get((Object)parentName);
            this.populateHierarchy(parent, accumulator);
        }
    }

    protected abstract DefaultConfigurationMetadata createConfiguration(ModuleComponentIdentifier var1, String var2, boolean var3, boolean var4, ImmutableList<String> var5, VariantMetadataRules var6);

    protected Optional<ImmutableList<? extends ConfigurationMetadata>> maybeDeriveVariants() {
        return Optional.absent();
    }

    private Optional<ImmutableList<? extends ConfigurationMetadata>> buildVariantsForGraphTraversal(List<? extends ComponentVariant> variants) {
        if (variants.isEmpty()) {
            return this.maybeDeriveVariants();
        }
        ImmutableList.Builder configurations = new ImmutableList.Builder();
        for (ComponentVariant componentVariant : variants) {
            configurations.add((Object)new VariantBackedConfigurationMetadata(this.getId(), componentVariant, this.attributes, this.attributesFactory, this.variantMetadataRules));
        }
        return Optional.of((Object)configurations.build());
    }

    @Override
    @Nullable
    public AttributesSchemaInternal getAttributesSchema() {
        return EmptySchema.INSTANCE;
    }

    @Override
    public ImmutableAttributesFactory getAttributesFactory() {
        return this.attributesFactory;
    }

    @Override
    public HashValue getContentHash() {
        return this.contentHash;
    }

    @Override
    public boolean isChanging() {
        return this.changing;
    }

    @Override
    public boolean isMissing() {
        return this.missing;
    }

    @Override
    public String getStatus() {
        return (String)this.attributes.getAttribute(ProjectInternal.STATUS_ATTRIBUTE);
    }

    @Override
    public List<String> getStatusScheme() {
        return this.statusScheme;
    }

    @Override
    public ModuleComponentIdentifier getId() {
        return this.componentIdentifier;
    }

    @Override
    public ModuleVersionIdentifier getModuleVersionId() {
        return this.moduleVersionIdentifier;
    }

    @Override
    public ModuleSource getSource() {
        return this.moduleSource;
    }

    @Override
    public ImmutableList<? extends ComponentVariant> getVariants() {
        return this.variants;
    }

    @Override
    public synchronized Optional<ImmutableList<? extends ConfigurationMetadata>> getVariantsForGraphTraversal() {
        if (this.graphVariants == null) {
            this.graphVariants = this.buildVariantsForGraphTraversal((List<? extends ComponentVariant>)this.variants);
        }
        return this.graphVariants;
    }

    public String toString() {
        return this.componentIdentifier.getDisplayName();
    }

    @Override
    public ModuleComponentArtifactMetadata artifact(String type, @Nullable String extension, @Nullable String classifier) {
        DefaultIvyArtifactName ivyArtifactName = new DefaultIvyArtifactName(this.getModuleVersionId().getName(), type, extension, classifier);
        return new DefaultModuleComponentArtifactMetadata(this.getId(), ivyArtifactName);
    }

    @Override
    public Set<String> getConfigurationNames() {
        return this.configurationDefinitions.keySet();
    }

    @Override
    public synchronized ConfigurationMetadata getConfiguration(String name) {
        return this.populateConfigurationFromDescriptor(name, (Map<String, Configuration>)this.configurationDefinitions, this.configurations);
    }

    public AttributeContainer getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractModuleComponentResolveMetadata that = (AbstractModuleComponentResolveMetadata)o;
        return this.changing == that.changing && this.missing == that.missing && Objects.equal((Object)this.moduleVersionIdentifier, (Object)that.moduleVersionIdentifier) && Objects.equal((Object)this.componentIdentifier, (Object)that.componentIdentifier) && Objects.equal(this.statusScheme, that.statusScheme) && Objects.equal((Object)this.moduleSource, (Object)that.moduleSource) && Objects.equal(this.configurationDefinitions, that.configurationDefinitions) && Objects.equal((Object)this.attributes, (Object)that.attributes) && Objects.equal(this.variants, that.variants) && Objects.equal((Object)this.contentHash, (Object)that.contentHash);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.moduleVersionIdentifier, this.componentIdentifier, this.changing, this.missing, this.statusScheme, this.moduleSource, this.configurationDefinitions, this.attributes, this.variants, this.contentHash});
    }
}

