/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import com.google.common.collect.Maps;
import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.internal.plugins.DefaultExtraPropertiesExtension;
import org.gradle.api.internal.plugins.ExtensionContainerInternal;
import org.gradle.api.internal.plugins.ExtensionsStorage;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtensionsSchema;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.reflect.HasPublicType;
import org.gradle.api.reflect.TypeOf;
import org.gradle.internal.Cast;
import org.gradle.internal.metaobject.AbstractDynamicObject;
import org.gradle.internal.metaobject.BeanDynamicObject;
import org.gradle.internal.metaobject.DynamicInvokeResult;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConvention
implements Convention,
ExtensionContainerInternal {
    private static final TypeOf<ExtraPropertiesExtension> EXTRA_PROPERTIES_EXTENSION_TYPE = TypeOf.typeOf(ExtraPropertiesExtension.class);
    private final ExtensionsDynamicObject extensionsDynamicObject = new ExtensionsDynamicObject();
    private final ExtensionsStorage extensionsStorage = new ExtensionsStorage();
    private final ExtraPropertiesExtension extraProperties = new DefaultExtraPropertiesExtension();
    private final Instantiator instantiator;
    private Map<String, Object> plugins;
    private Map<Object, BeanDynamicObject> dynamicObjects;

    public DefaultConvention() {
        this(null);
    }

    public DefaultConvention(Instantiator instantiator) {
        this.instantiator = instantiator;
        this.add(EXTRA_PROPERTIES_EXTENSION_TYPE, "ext", this.extraProperties);
    }

    public Map<String, Object> getPlugins() {
        if (this.plugins == null) {
            this.plugins = Maps.newLinkedHashMap();
        }
        return this.plugins;
    }

    public DynamicObject getExtensionsAsDynamicObject() {
        return this.extensionsDynamicObject;
    }

    private Instantiator getInstantiator() {
        if (this.instantiator == null) {
            throw new GradleException("request for DefaultConvention.instantiator when the object was constructed without a convention");
        }
        return this.instantiator;
    }

    public <T> T getPlugin(Class<T> type) {
        T value = this.findPlugin(type);
        if (value == null) {
            throw new IllegalStateException(String.format("Could not find any convention object of type %s.", type.getSimpleName()));
        }
        return value;
    }

    public <T> T findPlugin(Class<T> type) throws IllegalStateException {
        if (this.plugins == null) {
            return null;
        }
        ArrayList<T> values = new ArrayList<T>();
        for (Object object : this.plugins.values()) {
            if (!type.isInstance(object)) continue;
            values.add(type.cast(object));
        }
        if (values.isEmpty()) {
            return null;
        }
        if (values.size() > 1) {
            throw new IllegalStateException(String.format("Found multiple convention objects of type %s.", type.getSimpleName()));
        }
        return (T)values.get(0);
    }

    public void add(String name, Object extension) {
        if (extension instanceof Class) {
            this.create(name, (Class)extension, new Object[0]);
        } else {
            this.addWithDefaultPublicType(extension.getClass(), name, extension);
        }
    }

    public <T> void add(Class<T> publicType, String name, T extension) {
        this.add(TypeOf.typeOf(publicType), name, extension);
    }

    public <T> void add(TypeOf<T> publicType, String name, T extension) {
        this.extensionsStorage.add(publicType, name, extension);
    }

    public <T> T create(String name, Class<T> instanceType, Object ... constructionArguments) {
        T instance = this.instantiate(instanceType, constructionArguments);
        this.addWithDefaultPublicType(instanceType, name, instance);
        return instance;
    }

    public <T> T create(Class<T> publicType, String name, Class<? extends T> instanceType, Object ... constructionArguments) {
        return this.create(TypeOf.typeOf(publicType), name, instanceType, constructionArguments);
    }

    public <T> T create(TypeOf<T> publicType, String name, Class<? extends T> instanceType, Object ... constructionArguments) {
        T instance = this.instantiate(instanceType, constructionArguments);
        this.add(publicType, name, instance);
        return instance;
    }

    public ExtraPropertiesExtension getExtraProperties() {
        return this.extraProperties;
    }

    public Map<String, TypeOf<?>> getSchema() {
        HashMap map = new HashMap();
        for (ExtensionsSchema.ExtensionSchema schema : this.getExtensionsSchema()) {
            map.put(schema.getName(), schema.getPublicType());
        }
        return map;
    }

    public ExtensionsSchema getExtensionsSchema() {
        return this.extensionsStorage.getSchema();
    }

    public <T> T getByType(Class<T> type) {
        return this.getByType(TypeOf.typeOf(type));
    }

    public <T> T getByType(TypeOf<T> type) {
        return this.extensionsStorage.getByType(type);
    }

    public <T> T findByType(Class<T> type) {
        return this.findByType(TypeOf.typeOf(type));
    }

    public <T> T findByType(TypeOf<T> type) {
        return this.extensionsStorage.findByType(type);
    }

    public Object getByName(String name) {
        return this.extensionsStorage.getByName(name);
    }

    public Object findByName(String name) {
        return this.extensionsStorage.findByName(name);
    }

    public <T> void configure(Class<T> type, Action<? super T> action) {
        this.configure(TypeOf.typeOf(type), action);
    }

    public <T> void configure(TypeOf<T> type, Action<? super T> action) {
        this.extensionsStorage.configureExtension(type, action);
    }

    public <T> void configure(String name, Action<? super T> action) {
        this.extensionsStorage.configureExtension(name, action);
    }

    @Override
    public Map<String, Object> getAsMap() {
        return this.extensionsStorage.getAsMap();
    }

    public Object propertyMissing(String name) {
        return this.getByName(name);
    }

    public void propertyMissing(String name, Object value) {
        this.checkExtensionIsNotReassigned(name);
        this.add(name, value);
    }

    private void addWithDefaultPublicType(Class<?> defaultType, String name, Object extension) {
        this.add(this.preferredPublicTypeOf(extension, defaultType), name, extension);
    }

    private TypeOf<Object> preferredPublicTypeOf(Object extension, Class<?> defaultType) {
        if (extension instanceof HasPublicType) {
            return (TypeOf)Cast.uncheckedCast((Object)((HasPublicType)extension).getPublicType());
        }
        return TypeOf.typeOf(this.firstNonSyntheticClassOf(defaultType));
    }

    private Class<?> firstNonSyntheticClassOf(Class<?> clazz) {
        Class<?> next;
        if (!clazz.isSynthetic()) {
            return clazz;
        }
        while ((next = clazz.getSuperclass()) != null) {
            if (next.isSynthetic()) continue;
            return next;
        }
        return clazz;
    }

    private <T> T instantiate(Class<? extends T> instanceType, Object[] constructionArguments) {
        return (T)this.getInstantiator().newInstance(instanceType, constructionArguments);
    }

    private void checkExtensionIsNotReassigned(String name) {
        if (this.extensionsStorage.hasExtension(name)) {
            throw new IllegalArgumentException(String.format("There's an extension registered with name '%s'. You should not reassign it via a property setter.", name));
        }
    }

    private boolean isConfigureExtensionMethod(String name, Object[] args) {
        return args.length == 1 && args[0] instanceof Closure && this.extensionsStorage.hasExtension(name);
    }

    private Object configureExtension(String name, Object[] args) {
        Closure closure = (Closure)args[0];
        Action action = ConfigureUtil.configureUsing(closure);
        return this.extensionsStorage.configureExtension(name, action);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExtensionsDynamicObject
    extends AbstractDynamicObject {
        private ExtensionsDynamicObject() {
        }

        @Override
        public String getDisplayName() {
            return "extensions";
        }

        @Override
        public boolean hasProperty(String name) {
            if (DefaultConvention.this.extensionsStorage.hasExtension(name)) {
                return true;
            }
            if (DefaultConvention.this.plugins == null) {
                return false;
            }
            for (Object object : DefaultConvention.this.plugins.values()) {
                if (!this.asDynamicObject(object).hasProperty(name)) continue;
                return true;
            }
            return false;
        }

        public Map<String, Object> getProperties() {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            if (DefaultConvention.this.plugins != null) {
                ArrayList reverseOrder = new ArrayList(DefaultConvention.this.plugins.values());
                Collections.reverse(reverseOrder);
                for (Object object : reverseOrder) {
                    properties.putAll(this.asDynamicObject(object).getProperties());
                }
            }
            properties.putAll(DefaultConvention.this.extensionsStorage.getAsMap());
            return properties;
        }

        @Override
        public DynamicInvokeResult tryGetProperty(String name) {
            Object extension = DefaultConvention.this.extensionsStorage.findByName(name);
            if (extension != null) {
                return DynamicInvokeResult.found((Object)extension);
            }
            if (DefaultConvention.this.plugins == null) {
                return DynamicInvokeResult.notFound();
            }
            for (Object object : DefaultConvention.this.plugins.values()) {
                BeanDynamicObject dynamicObject = this.asDynamicObject(object).withNotImplementsMissing();
                DynamicInvokeResult result = dynamicObject.tryGetProperty(name);
                if (!result.isFound()) continue;
                return result;
            }
            return DynamicInvokeResult.notFound();
        }

        public Object propertyMissing(String name) {
            return this.getProperty(name);
        }

        @Override
        public DynamicInvokeResult trySetProperty(String name, Object value) {
            DefaultConvention.this.checkExtensionIsNotReassigned(name);
            if (DefaultConvention.this.plugins == null) {
                return DynamicInvokeResult.notFound();
            }
            for (Object object : DefaultConvention.this.plugins.values()) {
                BeanDynamicObject dynamicObject = this.asDynamicObject(object).withNotImplementsMissing();
                DynamicInvokeResult result = dynamicObject.trySetProperty(name, value);
                if (!result.isFound()) continue;
                return result;
            }
            return DynamicInvokeResult.notFound();
        }

        public void propertyMissing(String name, Object value) {
            this.setProperty(name, value);
        }

        @Override
        public DynamicInvokeResult tryInvokeMethod(String name, Object ... args) {
            if (DefaultConvention.this.isConfigureExtensionMethod(name, args)) {
                return DynamicInvokeResult.found((Object)DefaultConvention.this.configureExtension(name, args));
            }
            if (DefaultConvention.this.plugins == null) {
                return DynamicInvokeResult.notFound();
            }
            for (Object object : DefaultConvention.this.plugins.values()) {
                BeanDynamicObject dynamicObject = this.asDynamicObject(object).withNotImplementsMissing();
                DynamicInvokeResult result = dynamicObject.tryInvokeMethod(name, args);
                if (!result.isFound()) continue;
                return result;
            }
            return DynamicInvokeResult.notFound();
        }

        public Object methodMissing(String name, Object args) {
            return this.invokeMethod(name, (Object[])args);
        }

        @Override
        public boolean hasMethod(String name, Object ... args) {
            if (DefaultConvention.this.isConfigureExtensionMethod(name, args)) {
                return true;
            }
            if (DefaultConvention.this.plugins == null) {
                return false;
            }
            for (Object object : DefaultConvention.this.plugins.values()) {
                BeanDynamicObject dynamicObject = this.asDynamicObject(object);
                if (!dynamicObject.hasMethod(name, args)) continue;
                return true;
            }
            return false;
        }

        private BeanDynamicObject asDynamicObject(Object object) {
            BeanDynamicObject dynamicObject;
            if (DefaultConvention.this.dynamicObjects == null) {
                DefaultConvention.this.dynamicObjects = Maps.newIdentityHashMap();
            }
            if ((dynamicObject = (BeanDynamicObject)DefaultConvention.this.dynamicObjects.get(object)) == null) {
                dynamicObject = new BeanDynamicObject(object);
                DefaultConvention.this.dynamicObjects.put(object, dynamicObject);
            }
            return dynamicObject;
        }
    }
}

