/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemProperties {
    private static String ourTestUserName;

    private SystemProperties() {
    }

    @NotNull
    public static String getUserHome() {
        String string = System.getProperty("user.home");
        if (string == null) {
            SystemProperties.$$$reportNull$$$0(0);
        }
        return string;
    }

    public static String getUserName() {
        return ourTestUserName != null ? ourTestUserName : System.getProperty("user.name");
    }

    public static void setTestUserName(@Nullable String name) {
        ourTestUserName = name;
    }

    public static String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    public static String getOsName() {
        return System.getProperty("os.name");
    }

    public static String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public static String getJavaVmVendor() {
        return System.getProperty("java.vm.vendor");
    }

    public static String getJavaHome() {
        return System.getProperty("java.home");
    }

    public static int getIntProperty(@NotNull String key, int defaultValue) {
        String value;
        if (key == null) {
            SystemProperties.$$$reportNull$$$0(1);
        }
        if ((value = System.getProperty(key)) != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static boolean getBooleanProperty(@NotNull String key, boolean defaultValue) {
        String value;
        if (key == null) {
            SystemProperties.$$$reportNull$$$0(2);
        }
        if ((value = System.getProperty(key)) != null) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    public static String getJavaVendor() {
        return System.getProperty("java.vendor");
    }

    public static boolean is(String key) {
        return SystemProperties.getBooleanProperty(key, false);
    }

    public static boolean has(String key) {
        return System.getProperty(key) != null;
    }

    public static boolean isTrueSmoothScrollingEnabled() {
        return SystemProperties.getBooleanProperty("idea.true.smooth.scrolling", false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/SystemProperties";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserHome";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/SystemProperties";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getIntProperty";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBooleanProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

