/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.compile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Incubating;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.collections.SimpleFileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.compile.AbstractOptions;
import org.gradle.api.tasks.compile.DebugOptions;
import org.gradle.api.tasks.compile.ForkOptions;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.util.CollectionUtils;
import org.gradle.util.DeprecationLogger;

public class CompileOptions
extends AbstractOptions {
    private static final long serialVersionUID = 0L;
    private static final ImmutableSet<String> EXCLUDE_FROM_ANT_PROPERTIES = ImmutableSet.of((Object)"debugOptions", (Object)"forkOptions", (Object)"compilerArgs", (Object)"incremental", (Object)"allCompilerArgs", (Object)"compilerArgumentProviders", (Object[])new String[0]);
    private boolean failOnError = true;
    private boolean verbose;
    private boolean listFiles;
    private boolean deprecation;
    private boolean warnings = true;
    private String encoding;
    private boolean debug = true;
    private DebugOptions debugOptions = new DebugOptions();
    private boolean fork;
    private ForkOptions forkOptions = new ForkOptions();
    private FileCollection bootstrapClasspath;
    private String extensionDirs;
    private List<String> compilerArgs = Lists.newArrayList();
    private List<CommandLineArgumentProvider> compilerArgumentProviders = Lists.newArrayList();
    private boolean incremental;
    private FileCollection sourcepath;
    private FileCollection annotationProcessorPath;
    private final Property<File> annotationProcessorGeneratedSourcesDirectory;

    @Inject
    public CompileOptions(ObjectFactory objectFactory) {
        this.annotationProcessorGeneratedSourcesDirectory = objectFactory.property(File.class);
    }

    @Input
    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    @Console
    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Console
    public boolean isListFiles() {
        return this.listFiles;
    }

    public void setListFiles(boolean listFiles) {
        this.listFiles = listFiles;
    }

    @Console
    public boolean isDeprecation() {
        return this.deprecation;
    }

    public void setDeprecation(boolean deprecation) {
        this.deprecation = deprecation;
    }

    @Console
    public boolean isWarnings() {
        return this.warnings;
    }

    public void setWarnings(boolean warnings) {
        this.warnings = warnings;
    }

    @Nullable
    @Optional
    @Input
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(@Nullable String encoding) {
        this.encoding = encoding;
    }

    @Input
    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Nested
    public DebugOptions getDebugOptions() {
        return this.debugOptions;
    }

    public void setDebugOptions(DebugOptions debugOptions) {
        this.debugOptions = debugOptions;
    }

    @Input
    public boolean isFork() {
        return this.fork;
    }

    public void setFork(boolean fork) {
        this.fork = fork;
    }

    @Nested
    public ForkOptions getForkOptions() {
        return this.forkOptions;
    }

    public void setForkOptions(ForkOptions forkOptions) {
        this.forkOptions = forkOptions;
    }

    @Deprecated
    @Internal
    public String getBootClasspath() {
        DeprecationLogger.nagUserOfReplacedProperty((String)"CompileOptions.bootClasspath", (String)"CompileOptions.bootstrapClasspath");
        return this.bootstrapClasspath == null ? null : this.bootstrapClasspath.getAsPath();
    }

    @Deprecated
    public void setBootClasspath(String bootClasspath) {
        DeprecationLogger.nagUserOfReplacedProperty((String)"CompileOptions.bootClasspath", (String)"CompileOptions.bootstrapClasspath");
        if (bootClasspath == null) {
            this.bootstrapClasspath = null;
        } else {
            String[] paths = StringUtils.split((String)bootClasspath, (char)File.pathSeparatorChar);
            ArrayList files = Lists.newArrayListWithCapacity((int)paths.length);
            for (String path : paths) {
                files.add(new File(path));
            }
            this.bootstrapClasspath = new SimpleFileCollection((Collection)files);
        }
    }

    @Nullable
    @Optional
    @CompileClasspath
    public FileCollection getBootstrapClasspath() {
        return this.bootstrapClasspath;
    }

    public void setBootstrapClasspath(@Nullable FileCollection bootstrapClasspath) {
        this.bootstrapClasspath = bootstrapClasspath;
    }

    @Nullable
    @Optional
    @Input
    public String getExtensionDirs() {
        return this.extensionDirs;
    }

    public void setExtensionDirs(@Nullable String extensionDirs) {
        this.extensionDirs = extensionDirs;
    }

    @Input
    public List<String> getCompilerArgs() {
        return this.compilerArgs;
    }

    @Incubating
    @Internal
    public List<String> getAllCompilerArgs() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll((Iterable)CollectionUtils.stringize(this.getCompilerArgs()));
        for (CommandLineArgumentProvider compilerArgumentProvider : this.getCompilerArgumentProviders()) {
            builder.addAll(compilerArgumentProvider.asArguments());
        }
        return builder.build();
    }

    @Nested
    @Incubating
    public List<CommandLineArgumentProvider> getCompilerArgumentProviders() {
        return this.compilerArgumentProviders;
    }

    public void setCompilerArgs(List<String> compilerArgs) {
        this.compilerArgs = compilerArgs;
    }

    public CompileOptions fork(Map<String, Object> forkArgs) {
        this.fork = true;
        this.forkOptions.define(forkArgs);
        return this;
    }

    public CompileOptions debug(Map<String, Object> debugArgs) {
        this.debug = true;
        this.debugOptions.define(debugArgs);
        return this;
    }

    public CompileOptions setIncremental(boolean incremental) {
        this.incremental = incremental;
        return this;
    }

    public Map<String, Object> optionMap() {
        Map map = super.optionMap();
        map.putAll(this.debugOptions.optionMap());
        map.putAll(this.forkOptions.optionMap());
        return map;
    }

    protected boolean excludeFromAntProperties(String fieldName) {
        return EXCLUDE_FROM_ANT_PROPERTIES.contains((Object)fieldName);
    }

    protected String getAntPropertyName(String fieldName) {
        if (fieldName.equals("warnings")) {
            return "nowarn";
        }
        if (fieldName.equals("extensionDirs")) {
            return "extdirs";
        }
        return fieldName;
    }

    protected Object getAntPropertyValue(String fieldName, Object value) {
        if (fieldName.equals("warnings")) {
            return !this.warnings;
        }
        return value;
    }

    @Internal
    public boolean isIncremental() {
        return this.incremental;
    }

    @Incubating
    @Optional
    @Nullable
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    public FileCollection getSourcepath() {
        return this.sourcepath;
    }

    @Incubating
    public void setSourcepath(@Nullable FileCollection sourcepath) {
        this.sourcepath = sourcepath;
    }

    @Nullable
    @Internal
    public FileCollection getAnnotationProcessorPath() {
        return this.annotationProcessorPath;
    }

    public void setAnnotationProcessorPath(@Nullable FileCollection annotationProcessorPath) {
        this.annotationProcessorPath = annotationProcessorPath;
    }

    @Incubating
    @Nullable
    @Optional
    @OutputDirectory
    public File getAnnotationProcessorGeneratedSourcesDirectory() {
        return (File)this.annotationProcessorGeneratedSourcesDirectory.getOrNull();
    }

    @Incubating
    public void setAnnotationProcessorGeneratedSourcesDirectory(@Nullable File file) {
        this.annotationProcessorGeneratedSourcesDirectory.set((Object)file);
    }

    @Incubating
    public void setAnnotationProcessorGeneratedSourcesDirectory(Provider<File> file) {
        this.annotationProcessorGeneratedSourcesDirectory.set(file);
    }
}

