/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.support;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.kotlin.dsl.support.ZipKt;
import org.gradle.util.TextUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0000\u001a\u0016\u0010\n\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003\u001a$\u0010\n\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r\u001a(\u0010\n\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00032\u0018\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f0\r\u001a(\u0010\n\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00132\u0018\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f0\r\u001a\u0014\u0010\u0014\u001a\u00020\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0002\u00a8\u0006\u0018"}, d2={"unzipEntryTo", "", "outputDirectory", "Ljava/io/File;", "zip", "Ljava/util/zip/ZipFile;", "entry", "Ljava/util/zip/ZipEntry;", "unzipTo", "zipFile", "zipTo", "baseDir", "files", "Lkotlin/sequences/Sequence;", "entries", "Lkotlin/Pair;", "", "", "outputStream", "Ljava/io/OutputStream;", "copyTo", "", "Ljava/io/InputStream;", "file", "gradle-kotlin-dsl"})
public final class ZipKt {
    public static final void zipTo(@NotNull File zipFile, @NotNull File baseDir) {
        Intrinsics.checkParameterIsNotNull((Object)zipFile, (String)"zipFile");
        Intrinsics.checkParameterIsNotNull((Object)baseDir, (String)"baseDir");
        Sequence files2 = SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)baseDir)), (Function1)zipTo.files.1.INSTANCE);
        ZipKt.zipTo(zipFile, baseDir, (Sequence<? extends File>)files2);
    }

    public static final void zipTo(@NotNull File zipFile, @NotNull File baseDir, @NotNull Sequence<? extends File> files2) {
        Intrinsics.checkParameterIsNotNull((Object)zipFile, (String)"zipFile");
        Intrinsics.checkParameterIsNotNull((Object)baseDir, (String)"baseDir");
        Intrinsics.checkParameterIsNotNull(files2, (String)"files");
        Sequence entries2 = SequencesKt.map(files2, (Function1)((Function1)new Function1<File, Pair<? extends String, ? extends byte[]>>(baseDir){
            final /* synthetic */ File $baseDir;

            @NotNull
            public final Pair<String, byte[]> invoke(@NotNull File file) {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                String path = FilesKt.relativeTo((File)file, (File)this.$baseDir).getPath();
                byte[] bytes = FilesKt.readBytes((File)file);
                return TuplesKt.to((Object)TextUtil.normaliseFileSeparators((String)path), (Object)bytes);
            }
            {
                this.$baseDir = file;
                super(1);
            }
        }));
        ZipKt.zipTo(zipFile, (Sequence<Pair<String, byte[]>>)entries2);
    }

    public static final void zipTo(@NotNull File zipFile, @NotNull Sequence<Pair<String, byte[]>> entries2) {
        Intrinsics.checkParameterIsNotNull((Object)zipFile, (String)"zipFile");
        Intrinsics.checkParameterIsNotNull(entries2, (String)"entries");
        File file = zipFile;
        ZipKt.zipTo(new FileOutputStream(file), entries2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void zipTo(@NotNull OutputStream outputStream, @NotNull Sequence<Pair<String, byte[]>> entries2) {
        Intrinsics.checkParameterIsNotNull((Object)outputStream, (String)"outputStream");
        Intrinsics.checkParameterIsNotNull(entries2, (String)"entries");
        Closeable closeable = new ZipOutputStream(outputStream);
        Throwable throwable = null;
        try {
            ZipOutputStream zos = (ZipOutputStream)closeable;
            Sequence<Pair<String, byte[]>> $receiver$iv = entries2;
            for (Object element$iv : $receiver$iv) {
                void path;
                Pair entry = (Pair)element$iv;
                Object object = entry;
                String string = (String)object.component1();
                byte[] bytes = (byte[])object.component2();
                object = new ZipEntry((String)path);
                ZipOutputStream zipOutputStream = zos;
                Object $receiver = object;
                ((ZipEntry)$receiver).setSize(bytes.length);
                Object object2 = object;
                zipOutputStream.putNextEntry((ZipEntry)object2);
                zos.write(bytes);
                zos.closeEntry();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void unzipTo(@NotNull File outputDirectory, @NotNull File zipFile) {
        Intrinsics.checkParameterIsNotNull((Object)outputDirectory, (String)"outputDirectory");
        Intrinsics.checkParameterIsNotNull((Object)zipFile, (String)"zipFile");
        Closeable closeable = new ZipFile(zipFile);
        Throwable throwable = null;
        try {
            ZipFile zip = (ZipFile)closeable;
            Enumeration<? extends ZipEntry> enumeration = zip.entries();
            Intrinsics.checkExpressionValueIsNotNull(enumeration, (String)"zip.entries()");
            Iterator iterator = CollectionsKt.iterator(enumeration);
            while (iterator.hasNext()) {
                ZipEntry entry;
                ZipEntry zipEntry = entry = (ZipEntry)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)zipEntry, (String)"entry");
                ZipKt.unzipEntryTo(outputDirectory, zip, zipEntry);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void unzipEntryTo(File outputDirectory, ZipFile zip, ZipEntry entry) {
        File output = new File(outputDirectory, entry.getName());
        if (entry.isDirectory()) {
            output.mkdirs();
        } else {
            Closeable closeable = zip.getInputStream(entry);
            Throwable throwable = null;
            try {
                InputStream it;
                InputStream inputStream = it = (InputStream)closeable;
                Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"it");
                long l = ZipKt.copyTo(inputStream, output);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final long copyTo(@NotNull InputStream $receiver, File file) {
        long l;
        Object object = file;
        object = new FileOutputStream((File)object);
        Throwable throwable = null;
        try {
            FileOutputStream it = (FileOutputStream)object;
            l = ByteStreamsKt.copyTo$default((InputStream)$receiver, (OutputStream)it, (int)0, (int)2, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return l;
    }
}

