/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.resolver;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyPatternRepositoryLayout;
import org.gradle.api.artifacts.repositories.RepositoryLayout;
import org.gradle.api.artifacts.transform.VariantTransform;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.invocation.Gradle;
import org.gradle.kotlin.dsl.DependencyHandlerExtensionsKt;
import org.gradle.kotlin.dsl.resolver.SourceDistributionProvider;
import org.gradle.kotlin.dsl.resolver.SourceDistributionResolver;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 =2\u00020\u0001:\u0001=B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0017\u001a$\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00190\u0019 \u001a*\u0010\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00190\u00190\u001b0\u0018H\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010\r\u001a\u00020\u000eH\u0002J!\u0010'\u001a\u00020\u001d2\u0017\u0010(\u001a\u0013\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020*0)\u00a2\u0006\u0002\b+H\u0002J\u0010\u0010,\u001a\u00020*2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0002J!\u00100\u001a\u00020*2\u0017\u0010(\u001a\u0013\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020*0)\u00a2\u0006\u0002\b+H\u0002J\b\u00102\u001a\u00020*H\u0002J\u0010\u00103\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u00104\u001a\b\u0012\u0004\u0012\u00020\u001905H\u0016J\u0010\u00106\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u00107\u001a\u00020 H\u0002J!\u00108\u001a\u0002H9\"\u0004\b\u0000\u001092\f\u0010:\u001a\b\u0012\u0004\u0012\u0002H90;H\u0002\u00a2\u0006\u0002\u0010<R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006>"}, d2={"Lorg/gradle/kotlin/dsl/resolver/SourceDistributionResolver;", "Lorg/gradle/kotlin/dsl/resolver/SourceDistributionProvider;", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "configurations", "Lorg/gradle/api/artifacts/ConfigurationContainer;", "getConfigurations", "()Lorg/gradle/api/artifacts/ConfigurationContainer;", "dependencies", "Lorg/gradle/api/artifacts/dsl/DependencyHandler;", "getDependencies", "()Lorg/gradle/api/artifacts/dsl/DependencyHandler;", "gradleVersion", "", "getGradleVersion", "()Ljava/lang/String;", "getProject", "()Lorg/gradle/api/Project;", "repositories", "Lorg/gradle/api/artifacts/dsl/RepositoryHandler;", "getRepositories", "()Lorg/gradle/api/artifacts/dsl/RepositoryHandler;", "collectSourceDirs", "", "Ljava/io/File;", "kotlin.jvm.PlatformType", "", "createSourceRepository", "Lorg/gradle/api/artifacts/repositories/IvyArtifactRepository;", "dependencyVersion", "detachedConfigurationFor", "Lorg/gradle/api/artifacts/Configuration;", "dependency", "Lorg/gradle/api/artifacts/Dependency;", "gradleSourceDependency", "Lorg/gradle/api/artifacts/ExternalModuleDependency;", "isSnapshot", "", "ivy", "configure", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "makeItFirstInTheList", "repository", "Lorg/gradle/api/artifacts/repositories/ArtifactRepository;", "previousMinor", "registerTransform", "Lorg/gradle/api/artifacts/transform/VariantTransform;", "registerTransforms", "repositoryNameFor", "sourceDirs", "", "toVersionRange", "transientConfigurationForSourcesDownload", "withSourceRepository", "T", "produce", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Companion", "gradle-kotlin-dsl"})
public final class SourceDistributionResolver
implements SourceDistributionProvider {
    @NotNull
    private final Project project;
    @NotNull
    private static final Attribute<String> artifactType;
    @NotNull
    private static final String zipType = "zip";
    @NotNull
    private static final String sourceDirectory = "src-directory";
    public static final Companion Companion;

    @Override
    @NotNull
    public Collection<File> sourceDirs() {
        Collection collection;
        try {
            Set<File> set = this.collectSourceDirs();
            Intrinsics.checkExpressionValueIsNotNull(set, (String)"collectSourceDirs()");
            collection = set;
        }
        catch (Exception ex) {
            this.project.getLogger().warn("Unexpected exception while resolving Gradle distribution sources: " + ex.getMessage(), (Throwable)ex);
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    private final Set<File> collectSourceDirs() {
        return (Set)this.withSourceRepository((Function0)new Function0<Set<File>>(this){
            final /* synthetic */ SourceDistributionResolver this$0;

            @NotNull
            public final Set<File> invoke() {
                SourceDistributionResolver.access$registerTransforms(this.this$0);
                Configuration configuration = SourceDistributionResolver.access$transientConfigurationForSourcesDownload(this.this$0);
                Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"transientConfigurationForSourcesDownload()");
                return configuration.getFiles();
            }
            {
                this.this$0 = sourceDistributionResolver;
                super(0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T withSourceRepository(Function0<? extends T> produce) {
        Object object;
        IvyArtifactRepository ivyArtifactRepository;
        IvyArtifactRepository it = ivyArtifactRepository = this.createSourceRepository();
        try {
            object = produce.invoke();
        }
        finally {
            this.getRepositories().remove((Object)it);
        }
        return (T)object;
    }

    private final void registerTransforms() {
        this.registerTransform((Function1<? super VariantTransform, Unit>)((Function1)registerTransforms.1.INSTANCE));
    }

    private final Configuration transientConfigurationForSourcesDownload() {
        Configuration configuration;
        Configuration $receiver = configuration = this.detachedConfigurationFor((Dependency)this.gradleSourceDependency());
        $receiver.getAttributes().attribute(Companion.getArtifactType(), (Object)Companion.getSourceDirectory());
        return configuration;
    }

    private final Configuration detachedConfigurationFor(Dependency dependency) {
        return this.getConfigurations().detachedConfiguration(new Dependency[]{dependency});
    }

    private final ExternalModuleDependency gradleSourceDependency() {
        DependencyHandler dependencyHandler = this.getDependencies();
        Intrinsics.checkExpressionValueIsNotNull((Object)dependencyHandler, (String)"dependencies");
        String string = this.getGradleVersion();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"gradleVersion");
        return DependencyHandlerExtensionsKt.create(dependencyHandler, "gradle", "gradle", this.dependencyVersion(string), null, "src", zipType);
    }

    private final IvyArtifactRepository createSourceRepository() {
        IvyArtifactRepository ivyArtifactRepository;
        IvyArtifactRepository it;
        IvyArtifactRepository ivyArtifactRepository2 = it = (ivyArtifactRepository = this.ivy((Function1<? super IvyArtifactRepository, Unit>)((Function1)new Function1<IvyArtifactRepository, Unit>(this){
            final /* synthetic */ SourceDistributionResolver this$0;

            public final void invoke(@NotNull IvyArtifactRepository $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                String string = SourceDistributionResolver.access$getGradleVersion$p(this.this$0);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"gradleVersion");
                String repoName = SourceDistributionResolver.access$repositoryNameFor(this.this$0, string);
                $receiver.setName("Gradle " + repoName);
                $receiver.setUrl((Object)("https://services.gradle.org/" + repoName));
                $receiver.metadataSources((Action)createSourceRepository.1.INSTANCE);
                $receiver.layout("pattern", (Action)new Action<RepositoryLayout>(this){
                    final /* synthetic */ createSourceRepository.1 this$0;

                    public final void execute(@NotNull RepositoryLayout it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        IvyPatternRepositoryLayout layout = (IvyPatternRepositoryLayout)it;
                        SourceDistributionResolver sourceDistributionResolver = this.this$0.this$0;
                        String string = SourceDistributionResolver.access$getGradleVersion$p(this.this$0.this$0);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"gradleVersion");
                        if (SourceDistributionResolver.access$isSnapshot(sourceDistributionResolver, string)) {
                            layout.ivy("/dummy");
                        }
                        layout.artifact("[module]-[revision](-[classifier])(.[ext])");
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = sourceDistributionResolver;
                super(1);
            }
        })));
        Intrinsics.checkExpressionValueIsNotNull((Object)ivyArtifactRepository2, (String)"it");
        this.makeItFirstInTheList((ArtifactRepository)ivyArtifactRepository2);
        return ivyArtifactRepository;
    }

    private final String repositoryNameFor(String gradleVersion) {
        return this.isSnapshot(gradleVersion) ? "distributions-snapshots" : "distributions";
    }

    private final String dependencyVersion(String gradleVersion) {
        return this.isSnapshot(gradleVersion) ? this.toVersionRange(gradleVersion) : gradleVersion;
    }

    private final boolean isSnapshot(String gradleVersion) {
        return StringsKt.contains$default((CharSequence)gradleVersion, (char)'+', (boolean)false, (int)2, null);
    }

    private final String toVersionRange(String gradleVersion) {
        return '(' + this.previousMinor(gradleVersion) + ", " + gradleVersion + ']';
    }

    /*
     * WARNING - void declaration
     */
    private final String previousMinor(String gradleVersion) {
        Integer n;
        int index$iv;
        Collection collection;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv = CollectionsKt.take((Iterable)StringsKt.split$default((CharSequence)gradleVersion, (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null), (int)2);
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            String string;
            void $receiver$iv2;
            block4: {
                void it;
                String string2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                $receiver$iv2 = it;
                int n2 = 0;
                int n3 = $receiver$iv2.length();
                while (n2 < n3) {
                    char it22 = $receiver$iv2.charAt(index$iv);
                    if (!(it22 != '-')) {
                        void it22 = $receiver$iv2;
                        int $i$a$1$takeWhile = 0;
                        String string3 = it22.substring($i$a$1$takeWhile, index$iv);
                        string = string3;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        break block4;
                    }
                    ++index$iv;
                }
                string = $receiver$iv2;
            }
            $receiver$iv2 = string;
            n = Integer.parseInt((String)$receiver$iv2);
            collection.add(n);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        int index$iv$iv = 0;
        for (Object item$iv$iv : $receiver$iv$iv) {
            int v;
            void i2;
            int n4 = index$iv$iv++;
            int $receiver$iv2 = ((Number)item$iv$iv).intValue();
            index$iv = n4;
            collection = destination$iv$iv;
            n = i2 == false ? v : Integer.max((int)(v - true), 0);
            collection.add(n);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)".", null, null, (int)0, null, (Function1)previousMinor.3.INSTANCE, (int)30, null);
    }

    private final void makeItFirstInTheList(ArtifactRepository repository) {
        RepositoryHandler repositoryHandler;
        RepositoryHandler $receiver = repositoryHandler = this.getRepositories();
        $receiver.remove((Object)repository);
        $receiver.addFirst(repository);
    }

    private final void registerTransform(Function1<? super VariantTransform, Unit> configure) {
        this.getDependencies().registerTransform((Action)new Action<VariantTransform>(configure){
            final /* synthetic */ Function1 $configure;

            public final void execute(@NotNull VariantTransform it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.$configure.invoke((Object)it);
            }
            {
                this.$configure = function1;
            }
        });
    }

    private final IvyArtifactRepository ivy(Function1<? super IvyArtifactRepository, Unit> configure) {
        return this.getRepositories().ivy((Action)new Action<IvyArtifactRepository>(configure){
            final /* synthetic */ Function1 $configure;

            public final void execute(@NotNull IvyArtifactRepository it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.$configure.invoke((Object)it);
            }
            {
                this.$configure = function1;
            }
        });
    }

    private final RepositoryHandler getRepositories() {
        return this.project.getRepositories();
    }

    private final ConfigurationContainer getConfigurations() {
        return this.project.getConfigurations();
    }

    private final DependencyHandler getDependencies() {
        return this.project.getDependencies();
    }

    private final String getGradleVersion() {
        Gradle gradle = this.project.getGradle();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradle, (String)"project.gradle");
        return gradle.getGradleVersion();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public SourceDistributionResolver(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
    }

    static {
        Companion = new Companion(null);
        artifactType = Attribute.of((String)"artifactType", String.class);
        zipType = zipType;
        sourceDirectory = sourceDirectory;
    }

    public static final /* synthetic */ void access$registerTransforms(SourceDistributionResolver $this) {
        $this.registerTransforms();
    }

    @NotNull
    public static final /* synthetic */ Configuration access$transientConfigurationForSourcesDownload(SourceDistributionResolver $this) {
        return $this.transientConfigurationForSourcesDownload();
    }

    @NotNull
    public static final /* synthetic */ String access$repositoryNameFor(SourceDistributionResolver $this, @NotNull String gradleVersion) {
        return $this.repositoryNameFor(gradleVersion);
    }

    @NotNull
    public static final /* synthetic */ String access$getGradleVersion$p(SourceDistributionResolver $this) {
        return $this.getGradleVersion();
    }

    public static final /* synthetic */ boolean access$isSnapshot(SourceDistributionResolver $this, @NotNull String gradleVersion) {
        return $this.isSnapshot(gradleVersion);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001f\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/gradle/kotlin/dsl/resolver/SourceDistributionResolver$Companion;", "", "()V", "artifactType", "Lorg/gradle/api/attributes/Attribute;", "", "kotlin.jvm.PlatformType", "getArtifactType", "()Lorg/gradle/api/attributes/Attribute;", "sourceDirectory", "getSourceDirectory", "()Ljava/lang/String;", "zipType", "getZipType", "gradle-kotlin-dsl"})
    public static final class Companion {
        @NotNull
        public final Attribute<String> getArtifactType() {
            return artifactType;
        }

        @NotNull
        public final String getZipType() {
            return zipType;
        }

        @NotNull
        public final String getSourceDirectory() {
            return sourceDirectory;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

