/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.gradle.api.artifacts.result.ComponentSelectionCause;
import org.gradle.api.artifacts.result.ComponentSelectionDescriptor;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.DefaultComponentSelectionDescriptor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.VersionSelectionReasons;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

@NotThreadSafe
public class ComponentSelectionReasonSerializer
implements Serializer<ComponentSelectionReason> {
    private final BiMap<String, Integer> descriptions = HashBiMap.create();

    public ComponentSelectionReason read(Decoder decoder) throws IOException {
        List<ComponentSelectionDescriptor> descriptions = this.readDescriptions(decoder);
        return VersionSelectionReasons.of(descriptions);
    }

    private List<ComponentSelectionDescriptor> readDescriptions(Decoder decoder) throws IOException {
        int size = decoder.readSmallInt();
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (int i = 0; i < size; ++i) {
            ComponentSelectionCause cause = ComponentSelectionCause.values()[decoder.readByte()];
            String desc = this.readDescriptionText(decoder);
            builder.add((Object)new DefaultComponentSelectionDescriptor(cause, desc));
        }
        return builder.build();
    }

    private String readDescriptionText(Decoder decoder) throws IOException {
        boolean alreadyKnown = decoder.readBoolean();
        if (alreadyKnown) {
            return (String)this.descriptions.inverse().get((Object)decoder.readSmallInt());
        }
        String description = decoder.readString();
        this.descriptions.put((Object)description, (Object)this.descriptions.size());
        return description;
    }

    public void write(Encoder encoder, ComponentSelectionReason value) throws IOException {
        List descriptions = value.getDescriptions();
        encoder.writeSmallInt(descriptions.size());
        for (ComponentSelectionDescriptor description : descriptions) {
            this.writeDescription(encoder, description);
        }
    }

    private void writeDescription(Encoder encoder, ComponentSelectionDescriptor description) throws IOException {
        encoder.writeByte((byte)description.getCause().ordinal());
        this.writeDescriptionText(encoder, description.getDescription());
    }

    private void writeDescriptionText(Encoder encoder, String description) throws IOException {
        Integer index = (Integer)this.descriptions.get((Object)description);
        encoder.writeBoolean(index != null);
        if (index == null) {
            index = this.descriptions.size();
            this.descriptions.put((Object)description, (Object)index);
            encoder.writeString((CharSequence)description);
        } else {
            encoder.writeSmallInt(index.intValue());
        }
    }

    public void reset() {
        this.descriptions.clear();
    }
}

