/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import java.util.List;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicatorProvider;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;

public abstract class PsiRecursiveElementVisitor
extends PsiElementVisitor {
    private final boolean myVisitAllFileRoots;

    protected PsiRecursiveElementVisitor() {
        this(false);
    }

    protected PsiRecursiveElementVisitor(boolean visitAllFileRoots) {
        this.myVisitAllFileRoots = visitAllFileRoots;
    }

    @Override
    public void visitElement(PsiElement element) {
        ProgressIndicatorProvider.checkCanceled();
        element.acceptChildren(this);
    }

    @Override
    public void visitFile(PsiFile file2) {
        FileViewProvider viewProvider;
        List<PsiFile> allFiles;
        if (this.myVisitAllFileRoots && (allFiles = (viewProvider = file2.getViewProvider()).getAllFiles()).size() > 1 && file2 == viewProvider.getPsi(viewProvider.getBaseLanguage())) {
            for (PsiFile lFile : allFiles) {
                ProgressIndicatorProvider.checkCanceled();
                lFile.acceptChildren(this);
            }
            return;
        }
        super.visitFile(file2);
    }
}

