/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IrIntrinsicFunction;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/CompareTo;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "()V", "genInvoke", "", "type", "Lorg/jetbrains/org/objectweb/asm/Type;", "v", "Lorg/jetbrains/org/objectweb/asm/commons/InstructionAdapter;", "toCallable", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IrIntrinsicFunction;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "signature", "Lorg/jetbrains/kotlin/resolve/jvm/jvmSignature/JvmMethodSignature;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "backend"})
public final class CompareTo
extends IntrinsicMethod {
    private final void genInvoke(Type type2, InstructionAdapter v) {
        Type type3 = type2;
        if (Intrinsics.areEqual((Object)type3, (Object)Type.INT_TYPE)) {
            v.invokestatic("kotlin/jvm/internal/Intrinsics", "compare", "(II)I", false);
        } else if (Intrinsics.areEqual((Object)type3, (Object)Type.LONG_TYPE)) {
            v.invokestatic("kotlin/jvm/internal/Intrinsics", "compare", "(JJ)I", false);
        } else if (Intrinsics.areEqual((Object)type3, (Object)Type.FLOAT_TYPE)) {
            v.invokestatic("java/lang/Float", "compare", "(FF)I", false);
        } else if (Intrinsics.areEqual((Object)type3, (Object)Type.DOUBLE_TYPE)) {
            v.invokestatic("java/lang/Double", "compare", "(DD)I", false);
        } else {
            throw (Throwable)new UnsupportedOperationException();
        }
    }

    @Override
    @NotNull
    public IrIntrinsicFunction toCallable(@NotNull IrMemberAccessExpression expression2, @NotNull JvmMethodSignature signature, @NotNull JvmBackendContext context) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)signature, (String)"signature");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        IrExpression irExpression = expression2.getDispatchReceiver();
        if (irExpression == null && (irExpression = expression2.getExtensionReceiver()) == null) {
            Intrinsics.throwNpe();
        }
        Type type2 = IntrinsicMethod.Companion.expressionType(irExpression, context);
        List<JvmMethodParameterSignature> list2 = signature.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"signature.valueParameters");
        Object object = CollectionsKt.single(list2);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"signature.valueParameters.single()");
        Type parameterType = AsmUtil.comparisonOperandType(type2, ((JvmMethodParameterSignature)object).getAsmType());
        return IrIntrinsicFunction.Companion.create(expression2, signature, context, CollectionsKt.listOf((Object[])new Type[]{parameterType, parameterType}), (Function2<? super IrIntrinsicFunction, ? super InstructionAdapter, Unit>)((Function2)new Function2<IrIntrinsicFunction, InstructionAdapter, Unit>(this, parameterType){
            final /* synthetic */ CompareTo this$0;
            final /* synthetic */ Type $parameterType;

            public final void invoke(@NotNull IrIntrinsicFunction $receiver, @NotNull InstructionAdapter it) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                CompareTo.access$genInvoke(this.this$0, this.$parameterType, it);
            }
            {
                this.this$0 = compareTo;
                this.$parameterType = type2;
                super(2);
            }
        }));
    }

    public static final /* synthetic */ void access$genInvoke(CompareTo $this, @Nullable Type type2, @NotNull InstructionAdapter v) {
        $this.genInvoke(type2, v);
    }
}

