/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import java.util.List;
import org.gradle.api.internal.tasks.TaskInputFilePropertySpec;
import org.gradle.api.internal.tasks.TaskPropertyUtils;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetInputFilesVisitor
extends PropertyVisitor.Adapter {
    private final List<TaskInputFilePropertySpec> specs = Lists.newArrayList();
    private boolean hasSourceFiles;
    private ImmutableSortedSet<TaskInputFilePropertySpec> fileProperties;

    @Override
    public void visitInputFileProperty(TaskInputFilePropertySpec inputFileProperty) {
        this.specs.add(inputFileProperty);
        if (inputFileProperty.isSkipWhenEmpty()) {
            this.hasSourceFiles = true;
        }
    }

    public ImmutableSortedSet<TaskInputFilePropertySpec> getFileProperties() {
        if (this.fileProperties == null) {
            this.fileProperties = TaskPropertyUtils.collectFileProperties("input", this.specs.iterator());
        }
        return this.fileProperties;
    }

    public boolean hasSourceFiles() {
        return this.hasSourceFiles;
    }
}

