/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import groovy.lang.Closure;
import java.util.Collection;
import org.gradle.api.Action;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.AbstractFileTree;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.UnionFileTree;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.file.collections.ResolvableFileCollectionResolveContext;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.internal.Cast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompositeFileTree
extends CompositeFileCollection
implements FileTreeInternal {
    protected Collection<? extends FileTreeInternal> getSourceCollections() {
        return (Collection)Cast.uncheckedCast(super.getSourceCollections());
    }

    public FileTree plus(FileTree fileTree) {
        return new UnionFileTree(this, (FileTreeInternal)Cast.cast(FileTreeInternal.class, (Object)fileTree));
    }

    public FileTree matching(final Closure filterConfigClosure) {
        return new FilteredFileTree(){

            protected FileTree filter(FileTree set) {
                return set.matching(filterConfigClosure);
            }
        };
    }

    public FileTree matching(final Action<? super PatternFilterable> filterConfigAction) {
        return new FilteredFileTree(){

            protected FileTree filter(FileTree set) {
                return set.matching(filterConfigAction);
            }
        };
    }

    public FileTree matching(final PatternFilterable patterns) {
        return new FilteredFileTree(){

            protected FileTree filter(FileTree set) {
                return set.matching(patterns);
            }
        };
    }

    public FileTree visit(Closure visitor) {
        return this.visit(AbstractFileTree.fileVisitorFrom(visitor));
    }

    public FileTree visit(Action<? super FileVisitDetails> visitor) {
        for (FileTree fileTree : this.getSourceCollections()) {
            fileTree.visit(visitor);
        }
        return this;
    }

    public FileTree visit(FileVisitor visitor) {
        for (FileTree fileTree : this.getSourceCollections()) {
            fileTree.visit(visitor);
        }
        return this;
    }

    @Override
    public void visitTreeOrBackingFile(FileVisitor visitor) {
        this.visit(visitor);
    }

    @Override
    public FileTree getAsFileTree() {
        return this;
    }

    private abstract class FilteredFileTree
    extends CompositeFileTree {
        private FilteredFileTree() {
        }

        protected abstract FileTree filter(FileTree var1);

        public String getDisplayName() {
            return CompositeFileTree.this.getDisplayName();
        }

        public void visitContents(FileCollectionResolveContext context) {
            ResolvableFileCollectionResolveContext nestedContext = context.newContext();
            CompositeFileTree.this.visitContents(nestedContext);
            for (FileTree fileTree : nestedContext.resolveAsFileTrees()) {
                context.add(this.filter(fileTree));
            }
        }

        public void visitDependencies(TaskDependencyResolveContext context) {
            CompositeFileTree.this.visitDependencies(context);
        }
    }
}

