/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.taskfactory.PropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.TaskPropertyActionContext;
import org.gradle.api.internal.project.taskfactory.UpdateAction;
import org.gradle.api.internal.tasks.TaskPropertyValue;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskInputFilePropertyBuilder;

abstract class AbstractInputPropertyAnnotationHandler
implements PropertyAnnotationHandler {
    AbstractInputPropertyAnnotationHandler() {
    }

    public void attachActions(final TaskPropertyActionContext context) {
        PathSensitivity pathSensitivity;
        PathSensitive pathSensitive = context.getAnnotation(PathSensitive.class);
        if (pathSensitive == null) {
            if (context.isCacheable()) {
                context.validationMessage("is missing a @PathSensitive annotation, defaulting to PathSensitivity.ABSOLUTE");
            }
            pathSensitivity = PathSensitivity.ABSOLUTE;
        } else {
            pathSensitivity = pathSensitive.value();
        }
        context.setConfigureAction(new UpdateAction(){

            public void update(TaskInternal task, TaskPropertyValue futureValue) {
                TaskInputFilePropertyBuilder propertyBuilder = AbstractInputPropertyAnnotationHandler.this.createPropertyBuilder(context, task, futureValue);
                propertyBuilder.withPropertyName(context.getName()).withPathSensitivity(pathSensitivity).skipWhenEmpty(context.isAnnotationPresent(SkipWhenEmpty.class)).optional(context.isOptional());
            }
        });
    }

    protected abstract TaskInputFilePropertyBuilder createPropertyBuilder(TaskPropertyActionContext var1, TaskInternal var2, TaskPropertyValue var3);
}

