/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Factory;
import org.jetbrains.kotlin.com.intellij.openapi.util.NullableLazyValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionGuard;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionManager;

public abstract class AtomicNullableLazyValue<T>
extends NullableLazyValue<T> {
    private static final RecursionGuard ourGuard = RecursionManager.createGuard("AtomicNullableLazyValue");
    private volatile T myValue;
    private volatile boolean myComputed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T getValue() {
        boolean computed = this.myComputed;
        T value = this.myValue;
        if (computed) {
            return value;
        }
        AtomicNullableLazyValue atomicNullableLazyValue = this;
        synchronized (atomicNullableLazyValue) {
            computed = this.myComputed;
            value = this.myValue;
            if (!computed) {
                RecursionGuard.StackStamp stamp = ourGuard.markStack();
                value = this.compute();
                if (stamp.mayCacheNow()) {
                    this.myValue = value;
                    this.myComputed = true;
                }
            }
        }
        return value;
    }

    @NotNull
    public static <T> AtomicNullableLazyValue<T> createValue(final @NotNull Factory<T> value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/com/intellij/openapi/util/AtomicNullableLazyValue", "createValue"));
        }
        AtomicNullableLazyValue atomicNullableLazyValue = new AtomicNullableLazyValue<T>(){

            @Override
            @Nullable
            protected T compute() {
                return value.create();
            }
        };
        if (atomicNullableLazyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/AtomicNullableLazyValue", "createValue"));
        }
        return atomicNullableLazyValue;
    }
}

