/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.projectRoots;

import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;

public enum JavaSdkVersion {
    JDK_1_0(LanguageLevel.JDK_1_3, 0, new String[]{"1.0"}),
    JDK_1_1(LanguageLevel.JDK_1_3, 1, new String[]{"1.1"}),
    JDK_1_2(LanguageLevel.JDK_1_3, 2, new String[]{"1.2"}),
    JDK_1_3(LanguageLevel.JDK_1_3, 3, new String[]{"1.3"}),
    JDK_1_4(LanguageLevel.JDK_1_4, 4, new String[]{"1.4"}),
    JDK_1_5(LanguageLevel.JDK_1_5, 5, new String[]{"1.5", "5.0"}),
    JDK_1_6(LanguageLevel.JDK_1_6, 6, new String[]{"1.6", "6.0"}),
    JDK_1_7(LanguageLevel.JDK_1_7, 7, new String[]{"1.7", "7.0"}),
    JDK_1_8(LanguageLevel.JDK_1_8, 8, new String[]{"1.8", "8.0"}),
    JDK_1_9(LanguageLevel.JDK_1_9, 9, new String[]{"1.9", "9.0", "9-ea"}),
    JDK_10(LanguageLevel.JDK_1_9, 10, new String[]{"10.0", "10-ea"});

    private static final JavaSdkVersion MAX_JDK;
    private static final Pattern JAVA_VERSION;
    private final LanguageLevel myMaxLanguageLevel;
    private final int myRelease;
    private final String[] myVersionStrings;

    private JavaSdkVersion(@NotNull LanguageLevel maxLanguageLevel, int release, @NotNull String[] description) {
        if (maxLanguageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "maxLanguageLevel", "org/jetbrains/kotlin/com/intellij/openapi/projectRoots/JavaSdkVersion", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "org/jetbrains/kotlin/com/intellij/openapi/projectRoots/JavaSdkVersion", "<init>"));
        }
        this.myMaxLanguageLevel = maxLanguageLevel;
        this.myRelease = release;
        this.myVersionStrings = description;
    }

    @NotNull
    public LanguageLevel getMaxLanguageLevel() {
        LanguageLevel languageLevel = this.myMaxLanguageLevel;
        if (languageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/projectRoots/JavaSdkVersion", "getMaxLanguageLevel"));
        }
        return languageLevel;
    }

    @NotNull
    public String getDescription() {
        String string = this.myVersionStrings[0];
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/projectRoots/JavaSdkVersion", "getDescription"));
        }
        return string;
    }

    public String toString() {
        return super.toString() + ", description: " + this.getDescription();
    }

    static {
        MAX_JDK = JDK_1_9;
        JAVA_VERSION = Pattern.compile("java version \"(\\d.*)\"");
    }
}

