/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.codeInsight;

import java.util.ArrayList;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;

public class PsiEquivalenceUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInsight.PsiEquivalenceUtil");

    public static boolean areElementsEquivalent(@NotNull PsiElement element1, @NotNull PsiElement element2, @Nullable Comparator<PsiElement> resolvedElementsComparator, boolean areCommentsSignificant) {
        if (element1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element1", "org/jetbrains/kotlin/com/intellij/codeInsight/PsiEquivalenceUtil", "areElementsEquivalent"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element2", "org/jetbrains/kotlin/com/intellij/codeInsight/PsiEquivalenceUtil", "areElementsEquivalent"));
        }
        return PsiEquivalenceUtil.areElementsEquivalent(element1, element2, new ReferenceComparator(resolvedElementsComparator), null, null, areCommentsSignificant);
    }

    public static boolean areElementsEquivalent(@NotNull PsiElement element1, @NotNull PsiElement element2, @NotNull Comparator<PsiReference> referenceComparator, @Nullable Comparator<PsiElement> leafElementsComparator, @Nullable Condition<PsiElement> isElementSignificantCondition, boolean areCommentsSignificant) {
        PsiElement[] children2;
        if (element1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element1", "org/jetbrains/kotlin/com/intellij/codeInsight/PsiEquivalenceUtil", "areElementsEquivalent"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element2", "org/jetbrains/kotlin/com/intellij/codeInsight/PsiEquivalenceUtil", "areElementsEquivalent"));
        }
        if (referenceComparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceComparator", "org/jetbrains/kotlin/com/intellij/codeInsight/PsiEquivalenceUtil", "areElementsEquivalent"));
        }
        if (element1 == element2) {
            return true;
        }
        ASTNode node1 = element1.getNode();
        ASTNode node2 = element2.getNode();
        if (node1 == null || node2 == null) {
            return false;
        }
        if (node1.getElementType() != node2.getElementType()) {
            return false;
        }
        PsiElement[] children1 = PsiEquivalenceUtil.getFilteredChildren(element1, isElementSignificantCondition, areCommentsSignificant);
        if (children1.length != (children2 = PsiEquivalenceUtil.getFilteredChildren(element2, isElementSignificantCondition, areCommentsSignificant)).length) {
            return false;
        }
        for (int i = 0; i < children1.length; ++i) {
            PsiElement child1 = children1[i];
            PsiElement child2 = children2[i];
            if (PsiEquivalenceUtil.areElementsEquivalent(child1, child2, referenceComparator, leafElementsComparator, isElementSignificantCondition, areCommentsSignificant)) continue;
            return false;
        }
        if (children1.length == 0 && (leafElementsComparator != null ? leafElementsComparator.compare(element1, element2) != 0 : !element1.textMatches(element2))) {
            return false;
        }
        PsiReference ref1 = element1.getReference();
        if (ref1 != null) {
            PsiReference ref2 = element2.getReference();
            if (ref2 == null) {
                return false;
            }
            if (referenceComparator.compare(ref1, ref2) != 0) {
                return false;
            }
        }
        return true;
    }

    public static boolean areElementsEquivalent(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        if (element1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element1", "org/jetbrains/kotlin/com/intellij/codeInsight/PsiEquivalenceUtil", "areElementsEquivalent"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element2", "org/jetbrains/kotlin/com/intellij/codeInsight/PsiEquivalenceUtil", "areElementsEquivalent"));
        }
        return PsiEquivalenceUtil.areElementsEquivalent(element1, element2, null, false);
    }

    @NotNull
    public static PsiElement[] getFilteredChildren(@NotNull PsiElement element, @Nullable Condition<PsiElement> isElementSignificantCondition, boolean areCommentsSignificant) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/codeInsight/PsiEquivalenceUtil", "getFilteredChildren"));
        }
        ASTNode[] children1 = element.getNode().getChildren(null);
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        for (ASTNode node : children1) {
            PsiElement child = node.getPsi();
            if (child instanceof PsiWhiteSpace || !areCommentsSignificant && child instanceof PsiComment || isElementSignificantCondition != null && !isElementSignificantCondition.value(child)) continue;
            array.add(child);
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(array);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/codeInsight/PsiEquivalenceUtil", "getFilteredChildren"));
        }
        return psiElementArray;
    }

    private static class ReferenceComparator
    implements Comparator<PsiReference> {
        @Nullable
        private final Comparator<PsiElement> myResolvedElementsComparator;

        ReferenceComparator(@Nullable Comparator<PsiElement> resolvedElementsComparator) {
            this.myResolvedElementsComparator = resolvedElementsComparator;
        }

        @Override
        public int compare(PsiReference ref1, PsiReference ref2) {
            PsiElement resolved2;
            PsiElement resolved1 = ref1.resolve();
            return Comparing.equal(resolved1, resolved2 = ref2.resolve()) || this.myResolvedElementsComparator != null && this.myResolvedElementsComparator.compare(resolved1, resolved2) == 0 ? 0 : 1;
        }
    }
}

