/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import org.gradle.composite.internal.IncludedBuildFactory;
import org.gradle.initialization.DefaultSettingsLoader;
import org.gradle.initialization.ISettingsFinder;
import org.gradle.initialization.NotifyingSettingsLoader;
import org.gradle.initialization.SettingsLoader;
import org.gradle.initialization.SettingsLoaderFactory;
import org.gradle.initialization.SettingsProcessor;
import org.gradle.initialization.buildsrc.BuildSourceBuilder;
import org.gradle.internal.composite.CompositeBuildSettingsLoader;
import org.gradle.internal.composite.CompositeContextBuilder;

public class DefaultSettingsLoaderFactory
implements SettingsLoaderFactory {
    private final ISettingsFinder settingsFinder;
    private final SettingsProcessor settingsProcessor;
    private final BuildSourceBuilder buildSourceBuilder;
    private final CompositeContextBuilder compositeContextBuilder;
    private final IncludedBuildFactory includedBuildFactory;

    public DefaultSettingsLoaderFactory(ISettingsFinder settingsFinder, SettingsProcessor settingsProcessor, BuildSourceBuilder buildSourceBuilder, CompositeContextBuilder compositeContextBuilder, IncludedBuildFactory includedBuildFactory) {
        this.settingsFinder = settingsFinder;
        this.settingsProcessor = settingsProcessor;
        this.buildSourceBuilder = buildSourceBuilder;
        this.compositeContextBuilder = compositeContextBuilder;
        this.includedBuildFactory = includedBuildFactory;
    }

    public SettingsLoader forTopLevelBuild() {
        return this.notifyingSettingsLoader(this.compositeBuildSettingsLoader());
    }

    public SettingsLoader forNestedBuild() {
        return this.notifyingSettingsLoader(this.defaultSettingsLoader());
    }

    private SettingsLoader compositeBuildSettingsLoader() {
        return new CompositeBuildSettingsLoader(this.defaultSettingsLoader(), this.compositeContextBuilder, this.includedBuildFactory);
    }

    private SettingsLoader defaultSettingsLoader() {
        return new DefaultSettingsLoader(this.settingsFinder, this.settingsProcessor, this.buildSourceBuilder);
    }

    private SettingsLoader notifyingSettingsLoader(SettingsLoader settingsLoader) {
        return new NotifyingSettingsLoader(settingsLoader);
    }
}

