/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import java.util.Collection;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Describable;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.taskfactory.PropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.TaskPropertyActionContext;
import org.gradle.api.internal.project.taskfactory.UpdateAction;
import org.gradle.api.internal.project.taskfactory.ValidationAction;
import org.gradle.api.tasks.TaskOutputFilePropertyBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOutputPropertyAnnotationHandler
implements PropertyAnnotationHandler {
    @Override
    public void attachActions(final TaskPropertyActionContext context) {
        context.setValidationAction(new ValidationAction(){

            @Override
            public void validate(String propertyName, Object value, Collection<String> messages) {
                AbstractOutputPropertyAnnotationHandler.this.validate(propertyName, value, messages);
            }
        });
        context.setConfigureAction(new UpdateAction(){

            @Override
            public void update(TaskInternal task, Callable<Object> futureValue) {
                AbstractOutputPropertyAnnotationHandler.this.createPropertyBuilder(context, task, futureValue).withPropertyName(context.getName()).optional(context.isOptional());
                task.prependParallelSafeAction(new CreateOutputDirectoryTaskAction(context.getName(), futureValue));
            }
        });
    }

    protected abstract TaskOutputFilePropertyBuilder createPropertyBuilder(TaskPropertyActionContext var1, TaskInternal var2, Callable<Object> var3);

    protected abstract void beforeTask(Callable<Object> var1);

    protected abstract void validate(String var1, Object var2, Collection<String> var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CreateOutputDirectoryTaskAction
    implements Action<Task>,
    Describable {
        private final String propertyName;
        private final Callable<Object> futureValue;

        public CreateOutputDirectoryTaskAction(String propertyName, Callable<Object> futureValue) {
            this.propertyName = propertyName;
            this.futureValue = futureValue;
        }

        public void execute(Task task) {
            AbstractOutputPropertyAnnotationHandler.this.beforeTask(this.futureValue);
        }

        public String getDisplayName() {
            return "Create " + this.propertyName + " output directory";
        }
    }
}

