/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import org.gradle.api.internal.changedetection.state.CachingResourceHasher;
import org.gradle.api.internal.changedetection.state.RegularFileHasher;
import org.gradle.api.internal.changedetection.state.RegularFileSnapshot;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.caching.internal.DefaultBuildCacheHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hashing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceSnapshotterCacheService {
    private static final HashCode NO_HASH = Hashing.md5().hashString((CharSequence)(CachingResourceHasher.class.getName() + " : no hash"));
    private final PersistentIndexedCache<HashCode, HashCode> persistentCache;

    public ResourceSnapshotterCacheService(PersistentIndexedCache<HashCode, HashCode> persistentCache) {
        this.persistentCache = persistentCache;
    }

    public HashCode hashFile(RegularFileSnapshot fileSnapshot, RegularFileHasher hasher, byte[] configurationHash) {
        HashCode resourceHashCacheKey = this.resourceHashCacheKey(fileSnapshot, configurationHash);
        HashCode resourceHash = (HashCode)this.persistentCache.get((Object)resourceHashCacheKey);
        if (resourceHash != null) {
            if (resourceHash.equals((Object)NO_HASH)) {
                return null;
            }
            return resourceHash;
        }
        resourceHash = hasher.hash(fileSnapshot);
        if (resourceHash != null) {
            this.persistentCache.put((Object)resourceHashCacheKey, (Object)resourceHash);
        } else {
            this.persistentCache.put((Object)resourceHashCacheKey, (Object)NO_HASH);
        }
        return resourceHash;
    }

    private HashCode resourceHashCacheKey(RegularFileSnapshot fileSnapshot, byte[] configurationHash) {
        DefaultBuildCacheHasher hasher = new DefaultBuildCacheHasher();
        hasher.putBytes(configurationHash);
        hasher.putHash(fileSnapshot.getContent().getContentMd5());
        return hasher.hash();
    }
}

