/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import org.gradle.api.Task;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.OverlappingOutputs;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.changes.IncrementalTaskInputsInternal;
import org.gradle.api.internal.changedetection.state.DefaultFileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotterRegistry;
import org.gradle.api.internal.changedetection.state.FileSnapshotRepository;
import org.gradle.api.internal.changedetection.state.GenericFileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.ImplementationSnapshot;
import org.gradle.api.internal.changedetection.state.InputPathNormalizationStrategy;
import org.gradle.api.internal.changedetection.state.LazyTaskExecution;
import org.gradle.api.internal.changedetection.state.NormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.api.internal.changedetection.state.TaskExecutionSnapshot;
import org.gradle.api.internal.changedetection.state.TaskExecutionSnapshotSerializer;
import org.gradle.api.internal.changedetection.state.TaskFilePropertyCompareStrategy;
import org.gradle.api.internal.changedetection.state.TaskHistoryRepository;
import org.gradle.api.internal.changedetection.state.TaskHistoryStore;
import org.gradle.api.internal.changedetection.state.ValueSnapshot;
import org.gradle.api.internal.changedetection.state.ValueSnapshotter;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.tasks.CacheableTaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.ContextAwareTaskAction;
import org.gradle.api.internal.tasks.TaskFilePropertySpec;
import org.gradle.api.internal.tasks.TaskOutputFilePropertySpec;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.internal.classloader.ClassLoaderHierarchyHasher;
import org.gradle.internal.file.FileType;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.scopeids.id.BuildInvocationScopeId;
import org.gradle.normalization.internal.InputNormalizationHandlerInternal;
import org.gradle.normalization.internal.InputNormalizationStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheBackedTaskHistoryRepository
implements TaskHistoryRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheBackedTaskHistoryRepository.class);
    private final FileSnapshotRepository snapshotRepository;
    private final PersistentIndexedCache<String, TaskExecutionSnapshot> taskHistoryCache;
    private final StringInterner stringInterner;
    private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;
    private final ValueSnapshotter valueSnapshotter;
    private final FileCollectionSnapshotterRegistry snapshotterRegistry;
    private final FileCollectionFactory fileCollectionFactory;
    private final BuildInvocationScopeId buildInvocationScopeId;

    public CacheBackedTaskHistoryRepository(TaskHistoryStore cacheAccess, FileSnapshotRepository snapshotRepository, StringInterner stringInterner, ClassLoaderHierarchyHasher classLoaderHierarchyHasher, ValueSnapshotter valueSnapshotter, FileCollectionSnapshotterRegistry snapshotterRegistry, FileCollectionFactory fileCollectionFactory, BuildInvocationScopeId buildInvocationScopeId) {
        this.snapshotRepository = snapshotRepository;
        this.stringInterner = stringInterner;
        this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
        this.valueSnapshotter = valueSnapshotter;
        this.snapshotterRegistry = snapshotterRegistry;
        this.fileCollectionFactory = fileCollectionFactory;
        this.buildInvocationScopeId = buildInvocationScopeId;
        TaskExecutionSnapshotSerializer serializer = new TaskExecutionSnapshotSerializer(stringInterner);
        this.taskHistoryCache = cacheAccess.createCache("taskHistory", String.class, serializer, 10000, false);
    }

    @Override
    public TaskHistoryRepository.History getHistory(final TaskInternal task) {
        final InputNormalizationStrategy normalizationStrategy = ((InputNormalizationHandlerInternal)task.getProject().getNormalization()).buildFinalStrategy();
        return new TaskHistoryRepository.History(){
            private boolean previousExecutionLoadAttempted;
            private LazyTaskExecution previousExecution;
            private LazyTaskExecution currentExecution;

            @Override
            public LazyTaskExecution getPreviousExecution() {
                if (!this.previousExecutionLoadAttempted) {
                    this.previousExecutionLoadAttempted = true;
                    this.previousExecution = CacheBackedTaskHistoryRepository.this.loadPreviousExecution(task);
                }
                return this.previousExecution;
            }

            @Override
            public LazyTaskExecution getCurrentExecution() {
                if (this.currentExecution == null) {
                    this.currentExecution = CacheBackedTaskHistoryRepository.this.createExecution(task, this.getPreviousExecution(), normalizationStrategy);
                }
                return this.currentExecution;
            }

            @Override
            public void updateCurrentExecution(IncrementalTaskInputsInternal taskInputs) {
                CacheBackedTaskHistoryRepository.this.updateExecution(this.getPreviousExecution(), this.getCurrentExecution(), task, taskInputs, normalizationStrategy);
            }

            @Override
            public void updateCurrentExecutionWithOutputs(IncrementalTaskInputsInternal taskInputs, ImmutableSortedMap<String, FileCollectionSnapshot> newOutputSnapshot) {
                CacheBackedTaskHistoryRepository.this.updateExecution(this.getCurrentExecution(), task, taskInputs, (ImmutableSortedMap<String, FileCollectionSnapshot>)newOutputSnapshot, normalizationStrategy);
            }

            @Override
            public void persist() {
                this.persistCurrentExecution();
                this.cleanupPreviousExecution();
            }

            private void cleanupPreviousExecution() {
                LazyTaskExecution previousExecution = this.getPreviousExecution();
                if (previousExecution != null) {
                    previousExecution.removeUnnecessarySnapshots();
                }
            }

            private void persistCurrentExecution() {
                LazyTaskExecution currentExecution = this.getCurrentExecution();
                currentExecution.storeSnapshots();
                CacheBackedTaskHistoryRepository.this.taskHistoryCache.put((Object)task.getPath(), (Object)currentExecution.snapshot());
            }
        };
    }

    private LazyTaskExecution createExecution(TaskInternal task, TaskExecution previousExecution, InputNormalizationStrategy normalizationStrategy) {
        Class<?> taskClass = task.getClass();
        List<ContextAwareTaskAction> taskActions = task.getTaskActions();
        ImplementationSnapshot taskImplementation = new ImplementationSnapshot(taskClass.getName(), this.classLoaderHierarchyHasher.getClassLoaderHash(taskClass.getClassLoader()));
        ImmutableList<ImplementationSnapshot> taskActionImplementations = CacheBackedTaskHistoryRepository.collectActionImplementations(taskActions, this.classLoaderHierarchyHasher);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Implementation for {}: {}", (Object)task, (Object)taskImplementation);
            LOGGER.debug("Action implementations for {}: {}", (Object)task, taskActionImplementations);
        }
        ImmutableSortedMap<String, ValueSnapshot> previousInputProperties = previousExecution == null ? ImmutableSortedMap.of() : previousExecution.getInputProperties();
        ImmutableSortedMap<String, ValueSnapshot> inputProperties = CacheBackedTaskHistoryRepository.snapshotTaskInputProperties(task, previousInputProperties, this.valueSnapshotter);
        ImmutableSortedSet<String> outputPropertyNames = CacheBackedTaskHistoryRepository.getOutputPropertyNamesForCacheKey(task);
        ImmutableSet<String> declaredOutputFilePaths = CacheBackedTaskHistoryRepository.getDeclaredOutputFilePaths(task, this.stringInterner);
        ImmutableSortedMap<String, FileCollectionSnapshot> inputFiles = CacheBackedTaskHistoryRepository.snapshotTaskFiles(task, "Input", normalizationStrategy, task.getInputs().getFileProperties(), this.snapshotterRegistry);
        ImmutableSortedMap<String, FileCollectionSnapshot> outputFiles = CacheBackedTaskHistoryRepository.snapshotTaskFiles(task, "Output", normalizationStrategy, task.getOutputs().getFileProperties(), this.snapshotterRegistry);
        FileCollectionSnapshot previousDiscoveredInputs = previousExecution == null ? null : previousExecution.getDiscoveredInputFilesSnapshot();
        FileCollectionSnapshot discoveredInputs = previousDiscoveredInputs != null ? CacheBackedTaskHistoryRepository.snapshotDiscoveredInputs(task, normalizationStrategy, previousDiscoveredInputs.getElements(), this.snapshotterRegistry, this.fileCollectionFactory) : FileCollectionSnapshot.EMPTY;
        OverlappingOutputs overlappingOutputs = CacheBackedTaskHistoryRepository.detectOverlappingOutputs(outputFiles, previousExecution);
        return new LazyTaskExecution(this.snapshotRepository, this.buildInvocationScopeId.getId(), taskImplementation, taskActionImplementations, inputProperties, outputPropertyNames, declaredOutputFilePaths, inputFiles, discoveredInputs, outputFiles, overlappingOutputs);
    }

    private void updateExecution(final LazyTaskExecution previousExecution, LazyTaskExecution currentExecution, TaskInternal task, IncrementalTaskInputsInternal taskInputs, InputNormalizationStrategy normalizationStrategy) {
        final ImmutableSortedMap outputFilesAfter = CacheBackedTaskHistoryRepository.snapshotTaskFiles(task, "Output", normalizationStrategy, task.getOutputs().getFileProperties(), this.snapshotterRegistry);
        ImmutableSortedMap newOutputSnapshot = currentExecution.getDetectedOverlappingOutputs() == null ? outputFilesAfter : ImmutableSortedMap.copyOfSorted((SortedMap)Maps.transformEntries(currentExecution.getOutputFilesSnapshot(), (Maps.EntryTransformer)new Maps.EntryTransformer<String, FileCollectionSnapshot, FileCollectionSnapshot>(){

            public FileCollectionSnapshot transformEntry(String propertyName, FileCollectionSnapshot beforeExecution) {
                FileCollectionSnapshot afterExecution = (FileCollectionSnapshot)outputFilesAfter.get((Object)propertyName);
                FileCollectionSnapshot afterPreviousExecution = CacheBackedTaskHistoryRepository.getSnapshotAfterPreviousExecution(previousExecution, propertyName);
                return CacheBackedTaskHistoryRepository.filterOutputSnapshot(afterPreviousExecution, beforeExecution, afterExecution);
            }
        }));
        this.updateExecution(currentExecution, task, taskInputs, newOutputSnapshot, normalizationStrategy);
    }

    private void updateExecution(LazyTaskExecution currentExecution, TaskInternal task, IncrementalTaskInputsInternal taskInputs, ImmutableSortedMap<String, FileCollectionSnapshot> newOutputSnapshot, InputNormalizationStrategy normalizationStrategy) {
        currentExecution.setSuccessful(task.getState().getFailure() == null);
        currentExecution.setOutputFilesSnapshot(newOutputSnapshot);
        FileCollectionSnapshot discoveredFilesSnapshot = taskInputs != null ? CacheBackedTaskHistoryRepository.snapshotDiscoveredInputs(task, normalizationStrategy, taskInputs.getDiscoveredInputs(), this.snapshotterRegistry, this.fileCollectionFactory) : FileCollectionSnapshot.EMPTY;
        currentExecution.setDiscoveredInputFilesSnapshot(discoveredFilesSnapshot);
    }

    private static FileCollectionSnapshot snapshotDiscoveredInputs(Task task, InputNormalizationStrategy normalizationStrategy, Collection<File> discoveredInputs, FileCollectionSnapshotterRegistry snapshotterRegistry, FileCollectionFactory fileCollectionFactory) {
        GenericFileCollectionSnapshotter snapshotter = snapshotterRegistry.getSnapshotter(GenericFileCollectionSnapshotter.class);
        if (discoveredInputs.isEmpty()) {
            LOGGER.debug("No discovered inputs for {}", (Object)task);
            return FileCollectionSnapshot.EMPTY;
        }
        LOGGER.debug("Snapshotting discovered inputs for {}", (Object)task);
        try {
            return snapshotter.snapshot(fileCollectionFactory.fixed("Discovered input files", discoveredInputs), InputPathNormalizationStrategy.ABSOLUTE, normalizationStrategy);
        }
        catch (Exception e) {
            throw new UncheckedIOException(String.format("Failed to capture snapshot of discovered input files for %s during up-to-date check.", task), (Throwable)e);
        }
    }

    private static FileCollectionSnapshot filterOutputSnapshot(FileCollectionSnapshot afterPreviousExecution, FileCollectionSnapshot beforeExecution, FileCollectionSnapshot afterExecution) {
        FileCollectionSnapshot filesSnapshot;
        Map<String, NormalizedFileSnapshot> afterSnapshots = afterExecution.getSnapshots();
        if (!beforeExecution.getSnapshots().isEmpty() && !afterSnapshots.isEmpty()) {
            Map<String, NormalizedFileSnapshot> beforeSnapshots = beforeExecution.getSnapshots();
            HashMap<String, NormalizedFileSnapshot> afterPreviousSnapshots = afterPreviousExecution != null ? afterPreviousExecution.getSnapshots() : new HashMap<String, NormalizedFileSnapshot>();
            int newEntryCount = 0;
            ImmutableMap.Builder outputEntries = ImmutableMap.builder();
            for (Map.Entry<String, NormalizedFileSnapshot> entry : afterSnapshots.entrySet()) {
                NormalizedFileSnapshot fileSnapshot;
                String path = entry.getKey();
                if (!CacheBackedTaskHistoryRepository.isOutputEntry(path, fileSnapshot = entry.getValue(), beforeSnapshots, afterPreviousSnapshots)) continue;
                outputEntries.put((Object)entry.getKey(), (Object)fileSnapshot);
                ++newEntryCount;
            }
            filesSnapshot = newEntryCount == afterSnapshots.size() ? afterExecution : new DefaultFileCollectionSnapshot((Map<String, NormalizedFileSnapshot>)outputEntries.build(), TaskFilePropertyCompareStrategy.UNORDERED, true);
        } else {
            filesSnapshot = afterExecution;
        }
        return filesSnapshot;
    }

    private static boolean isOutputEntry(String path, NormalizedFileSnapshot fileSnapshot, Map<String, NormalizedFileSnapshot> beforeSnapshots, Map<String, NormalizedFileSnapshot> afterPreviousSnapshots) {
        if (fileSnapshot.getSnapshot().getType() == FileType.Missing) {
            return false;
        }
        NormalizedFileSnapshot beforeSnapshot = beforeSnapshots.get(path);
        if (beforeSnapshot == null) {
            return true;
        }
        if (!fileSnapshot.getSnapshot().isContentAndMetadataUpToDate(beforeSnapshot.getSnapshot())) {
            return true;
        }
        return afterPreviousSnapshots.containsKey(path);
    }

    private static ImmutableList<ImplementationSnapshot> collectActionImplementations(Collection<ContextAwareTaskAction> taskActions, ClassLoaderHierarchyHasher classLoaderHierarchyHasher) {
        if (taskActions.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder actionImplementations = ImmutableList.builder();
        for (ContextAwareTaskAction taskAction : taskActions) {
            String typeName = taskAction.getActionClassName();
            HashCode classLoaderHash = classLoaderHierarchyHasher.getClassLoaderHash(taskAction.getClassLoader());
            actionImplementations.add((Object)new ImplementationSnapshot(typeName, classLoaderHash));
        }
        return actionImplementations.build();
    }

    private static ImmutableSortedMap<String, ValueSnapshot> snapshotTaskInputProperties(TaskInternal task, ImmutableSortedMap<String, ValueSnapshot> previousInputProperties, ValueSnapshotter valueSnapshotter) {
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (Map.Entry entry : task.getInputs().getProperties().entrySet()) {
            String propertyName = (String)entry.getKey();
            Object value = entry.getValue();
            try {
                ValueSnapshot previousSnapshot = (ValueSnapshot)previousInputProperties.get((Object)propertyName);
                if (previousSnapshot == null) {
                    builder.put((Object)propertyName, (Object)valueSnapshotter.snapshot(value));
                    continue;
                }
                builder.put((Object)propertyName, (Object)valueSnapshotter.snapshot(value, previousSnapshot));
            }
            catch (Exception e) {
                throw new UncheckedIOException(String.format("Unable to store input properties for %s. Property '%s' with value '%s' cannot be serialized.", task, propertyName, value), (Throwable)e);
            }
        }
        return builder.build();
    }

    @VisibleForTesting
    static ImmutableSortedMap<String, FileCollectionSnapshot> snapshotTaskFiles(TaskInternal task, String title, InputNormalizationStrategy normalizationStrategy, SortedSet<? extends TaskFilePropertySpec> fileProperties, FileCollectionSnapshotterRegistry snapshotterRegistry) {
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (TaskFilePropertySpec taskFilePropertySpec : fileProperties) {
            FileCollectionSnapshot result;
            try {
                FileCollectionSnapshotter snapshotter = snapshotterRegistry.getSnapshotter(taskFilePropertySpec.getSnapshotter());
                LOGGER.debug("Snapshotting property {} for {}", (Object)taskFilePropertySpec, (Object)task);
                result = snapshotter.snapshot(taskFilePropertySpec.getPropertyFiles(), taskFilePropertySpec.getPathNormalizationStrategy(), normalizationStrategy);
            }
            catch (Exception e) {
                throw new UncheckedIOException(String.format("Failed to capture snapshot of %s files for %s property '%s' during up-to-date check.", title.toLowerCase(), task, taskFilePropertySpec.getPropertyName()), (Throwable)e);
            }
            builder.put((Object)taskFilePropertySpec.getPropertyName(), (Object)result);
        }
        return builder.build();
    }

    private static OverlappingOutputs detectOverlappingOutputs(ImmutableSortedMap<String, FileCollectionSnapshot> taskOutputs, TaskExecution previousExecution) {
        for (Map.Entry entry : taskOutputs.entrySet()) {
            String propertyName = (String)entry.getKey();
            FileCollectionSnapshot beforeExecution = (FileCollectionSnapshot)entry.getValue();
            FileCollectionSnapshot afterPreviousExecution = CacheBackedTaskHistoryRepository.getSnapshotAfterPreviousExecution(previousExecution, propertyName);
            OverlappingOutputs overlappingOutputs = OverlappingOutputs.detect(propertyName, afterPreviousExecution, beforeExecution);
            if (overlappingOutputs == null) continue;
            return overlappingOutputs;
        }
        return null;
    }

    private static FileCollectionSnapshot getSnapshotAfterPreviousExecution(TaskExecution previousExecution, String propertyName) {
        FileCollectionSnapshot afterPreviousExecution;
        ImmutableSortedMap<String, FileCollectionSnapshot> previousSnapshots;
        if (previousExecution != null && (previousSnapshots = previousExecution.getOutputFilesSnapshot()) != null && (afterPreviousExecution = (FileCollectionSnapshot)previousSnapshots.get(propertyName)) != null) {
            return afterPreviousExecution;
        }
        return FileCollectionSnapshot.EMPTY;
    }

    private LazyTaskExecution loadPreviousExecution(TaskInternal task) {
        TaskExecutionSnapshot taskExecutionSnapshot = (TaskExecutionSnapshot)this.taskHistoryCache.get((Object)task.getPath());
        if (taskExecutionSnapshot != null) {
            return new LazyTaskExecution(this.snapshotRepository, taskExecutionSnapshot);
        }
        return null;
    }

    private static ImmutableSortedSet<String> getOutputPropertyNamesForCacheKey(TaskInternal task) {
        ImmutableSortedSet<TaskOutputFilePropertySpec> fileProperties = task.getOutputs().getFileProperties();
        ArrayList outputPropertyNames = Lists.newArrayListWithCapacity((int)fileProperties.size());
        for (TaskOutputFilePropertySpec propertySpec : fileProperties) {
            CacheableTaskOutputFilePropertySpec cacheablePropertySpec;
            if (!(propertySpec instanceof CacheableTaskOutputFilePropertySpec) || (cacheablePropertySpec = (CacheableTaskOutputFilePropertySpec)propertySpec).getOutputFile() == null) continue;
            outputPropertyNames.add(propertySpec.getPropertyName());
        }
        return ImmutableSortedSet.copyOf((Collection)outputPropertyNames);
    }

    private static ImmutableSet<String> getDeclaredOutputFilePaths(TaskInternal task, StringInterner stringInterner) {
        ImmutableSortedSet.Builder declaredOutputFilePaths = ImmutableSortedSet.naturalOrder();
        for (File file : task.getOutputs().getFiles()) {
            declaredOutputFilePaths.add((Object)stringInterner.intern(file.getAbsolutePath()));
        }
        return declaredOutputFilePaths.build();
    }
}

