/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.rules.CachingTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.DiscoveredInputsTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.ErrorHandlingTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.InputFilesTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.InputPropertiesTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.NoHistoryTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.OutputFilesTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.PreviousSuccessTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.SummaryTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.TaskStateChanges;
import org.gradle.api.internal.changedetection.rules.TaskTypeTaskStateChanges;
import org.gradle.api.internal.changedetection.state.TaskExecution;

public class TaskUpToDateState {
    public static final int MAX_OUT_OF_DATE_MESSAGES = 3;
    private final TaskStateChanges inputFileChanges;
    private final OutputFilesTaskStateChanges outputFileChanges;
    private final TaskStateChanges allTaskChanges;
    private final TaskStateChanges rebuildChanges;

    public TaskUpToDateState(TaskExecution lastExecution, TaskExecution thisExecution, TaskInternal task) {
        NoHistoryTaskStateChanges noHistoryState = new NoHistoryTaskStateChanges(lastExecution);
        PreviousSuccessTaskStateChanges previousSuccessState = new PreviousSuccessTaskStateChanges(lastExecution, thisExecution, task);
        TaskTypeTaskStateChanges taskTypeState = new TaskTypeTaskStateChanges(lastExecution, thisExecution, task);
        InputPropertiesTaskStateChanges inputPropertiesState = new InputPropertiesTaskStateChanges(lastExecution, thisExecution, task);
        OutputFilesTaskStateChanges uncachedOutputChanges = new OutputFilesTaskStateChanges(lastExecution, thisExecution, task);
        TaskStateChanges outputFileChanges = TaskUpToDateState.caching(uncachedOutputChanges);
        this.outputFileChanges = uncachedOutputChanges;
        InputFilesTaskStateChanges directInputFileChanges = new InputFilesTaskStateChanges(lastExecution, thisExecution, task);
        TaskStateChanges inputFileChanges = TaskUpToDateState.caching(directInputFileChanges);
        this.inputFileChanges = new ErrorHandlingTaskStateChanges(task, inputFileChanges);
        DiscoveredInputsTaskStateChanges discoveredChanges = new DiscoveredInputsTaskStateChanges(lastExecution, thisExecution);
        TaskStateChanges discoveredInputFilesChanges = TaskUpToDateState.caching(discoveredChanges);
        this.allTaskChanges = new ErrorHandlingTaskStateChanges(task, new SummaryTaskStateChanges(3, previousSuccessState, noHistoryState, taskTypeState, inputPropertiesState, outputFileChanges, inputFileChanges, discoveredInputFilesChanges));
        this.rebuildChanges = new ErrorHandlingTaskStateChanges(task, new SummaryTaskStateChanges(1, previousSuccessState, noHistoryState, taskTypeState, inputPropertiesState, outputFileChanges));
    }

    private static TaskStateChanges caching(TaskStateChanges wrapped) {
        return new CachingTaskStateChanges(3, wrapped);
    }

    public TaskStateChanges getInputFilesChanges() {
        return this.inputFileChanges;
    }

    public boolean hasAnyOutputFileChanges() {
        return this.outputFileChanges.hasAnyChanges();
    }

    public TaskStateChanges getAllTaskChanges() {
        return this.allTaskChanges;
    }

    public TaskStateChanges getRebuildChanges() {
        return this.rebuildChanges;
    }
}

