/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.twirl;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gradle.language.twirl.TwirlImports;
import org.gradle.language.twirl.TwirlTemplateFormat;
import org.gradle.language.twirl.internal.DefaultTwirlTemplateFormat;
import org.gradle.play.internal.twirl.VersionedTwirlCompilerAdapter;
import org.gradle.scala.internal.reflect.ScalaCodecMapper;
import org.gradle.scala.internal.reflect.ScalaMethod;
import org.gradle.scala.internal.reflect.ScalaReflectionUtil;

class TwirlCompilerAdapterV10X
extends VersionedTwirlCompilerAdapter {
    private static final Iterable<String> SHARED_PACKAGES = Arrays.asList("play.twirl.compiler", "scala.io");
    private static final Collection<String> DEFAULT_JAVA_IMPORTS = Arrays.asList("models._", "controllers._", "play.api.templates.PlayMagic._", "java.lang._", "java.util._", "scala.collection.JavaConversions._", "scala.collection.JavaConverters._", "play.api.i18n._", "play.core.j.PlayMagicForJava._", "play.mvc._", "play.data._", "play.api.data.Field", "play.mvc.Http.Context.Implicit._");
    private static final Collection<String> DEFAULT_SCALA_IMPORTS = Arrays.asList("models._", "controllers._", "play.api.templates.PlayMagic._", "play.api.i18n._", "play.api.mvc._", "play.api.data._");
    private final String scalaVersion;
    private final String twirlVersion;

    public TwirlCompilerAdapterV10X(String twirlVersion, String scalaVersion) {
        this.scalaVersion = scalaVersion;
        this.twirlVersion = twirlVersion;
    }

    @Override
    public ScalaMethod getCompileMethod(ClassLoader cl) throws ClassNotFoundException {
        return ScalaReflectionUtil.scalaMethod(cl, "play.twirl.compiler.TwirlCompiler", "compile", File.class, File.class, File.class, String.class, String.class, cl.loadClass(ScalaCodecMapper.getClassName()), Boolean.TYPE, Boolean.TYPE);
    }

    @Override
    public Object[] createCompileParameters(ClassLoader cl, File file, File sourceDirectory, File destinationDirectory, TwirlImports defaultImports, TwirlTemplateFormat templateFormat, List<String> additionalImports) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Collection<String> defaultTwirlImports = defaultImports == TwirlImports.JAVA ? DEFAULT_JAVA_IMPORTS : DEFAULT_SCALA_IMPORTS;
        return new Object[]{file, sourceDirectory, destinationDirectory, templateFormat.getFormatType(), this.getImportsFor(templateFormat, defaultTwirlImports, additionalImports), ScalaCodecMapper.create(cl, "UTF-8"), this.isInclusiveDots(), this.isUseOldParser()};
    }

    private boolean isInclusiveDots() {
        return false;
    }

    private boolean isUseOldParser() {
        return false;
    }

    @Override
    public Iterable<String> getClassLoaderPackages() {
        return SHARED_PACKAGES;
    }

    @Override
    public String getDependencyNotation() {
        return "com.typesafe.play:twirl-compiler_" + this.scalaVersion + ":" + this.twirlVersion;
    }

    @Override
    public Collection<TwirlTemplateFormat> getDefaultTemplateFormats() {
        return Arrays.asList(new DefaultTwirlTemplateFormat("html", "play.twirl.api.HtmlFormat", Collections.singleton("views.html._")), new DefaultTwirlTemplateFormat("txt", "play.twirl.api.TxtFormat", Collections.singleton("views.txt._")), new DefaultTwirlTemplateFormat("xml", "play.twirl.api.XmlFormat", Collections.singleton("views.xml._")), new DefaultTwirlTemplateFormat("js", "play.twirl.api.JavaScriptFormat", Collections.singleton("views.js._")));
    }
}

