/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes;

import java.util.Collection;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.AbstractCompositeExclusion;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.AbstractModuleExclusion;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ArtifactExcludeSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ExcludeAllModulesSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.GroupNameExcludeSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ImmutableModuleExclusionSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleIdExcludeSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleNameExcludeSpec;
import org.gradle.internal.component.model.IvyArtifactName;

class IntersectionExclusion
extends AbstractCompositeExclusion {
    private final ImmutableModuleExclusionSet excludeSpecs;
    private final boolean mergeable;

    public IntersectionExclusion(ImmutableModuleExclusionSet specs) {
        this.excludeSpecs = specs;
        boolean canMerge = true;
        for (AbstractModuleExclusion spec : specs.elements) {
            if (IntersectionExclusion.canMerge(spec)) continue;
            canMerge = false;
            break;
        }
        this.mergeable = canMerge;
    }

    boolean canMerge() {
        return this.mergeable;
    }

    ImmutableModuleExclusionSet getFilters() {
        return this.excludeSpecs;
    }

    @Override
    protected boolean excludesNoModules() {
        for (AbstractModuleExclusion excludeSpec : this.excludeSpecs) {
            if (excludeSpec.excludesNoModules()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean excludeModule(ModuleIdentifier element) {
        for (AbstractModuleExclusion excludeSpec : this.excludeSpecs) {
            if (!excludeSpec.excludeModule(element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean excludeArtifact(ModuleIdentifier module, IvyArtifactName artifact) {
        for (AbstractModuleExclusion excludeSpec : this.excludeSpecs) {
            if (!excludeSpec.excludeArtifact(module, artifact)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean mayExcludeArtifacts() {
        for (AbstractModuleExclusion spec : this.excludeSpecs) {
            if (!spec.mayExcludeArtifacts()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void unpackIntersection(Collection<AbstractModuleExclusion> specs) {
        specs.addAll(this.excludeSpecs);
    }

    private static boolean canMerge(AbstractModuleExclusion excludeSpec) {
        return excludeSpec instanceof ExcludeAllModulesSpec || excludeSpec instanceof ArtifactExcludeSpec || excludeSpec instanceof GroupNameExcludeSpec || excludeSpec instanceof ModuleNameExcludeSpec || excludeSpec instanceof ModuleIdExcludeSpec;
    }
}

