/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Describable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultResolvedArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactBackedResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariantSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusion;
import org.gradle.api.internal.artifacts.transform.VariantSelector;
import org.gradle.api.internal.artifacts.type.ArtifactTypeRegistry;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.Factory;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.DefaultVariantMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.component.model.VariantMetadata;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.result.DefaultBuildableArtifactResolveResult;

public abstract class DefaultArtifactSet
implements ArtifactSet,
ResolvedVariantSet {
    private final ComponentIdentifier componentIdentifier;
    private final AttributesSchemaInternal schema;

    private DefaultArtifactSet(ComponentIdentifier componentIdentifier, AttributesSchemaInternal schema) {
        this.componentIdentifier = componentIdentifier;
        this.schema = schema;
    }

    public static ArtifactSet multipleVariants(ComponentIdentifier componentIdentifier, ModuleVersionIdentifier ownerId, ModuleSource moduleSource, ModuleExclusion exclusions, Set<? extends VariantMetadata> variants, AttributesSchemaInternal schema, ArtifactResolver artifactResolver, Map<ComponentArtifactIdentifier, ResolvableArtifact> allResolvedArtifacts, ArtifactTypeRegistry artifactTypeRegistry) {
        if (variants.size() == 1) {
            VariantMetadata variantMetadata = variants.iterator().next();
            ResolvedVariant resolvedVariant = DefaultArtifactSet.toResolvedVariant(variantMetadata, ownerId, moduleSource, exclusions, artifactResolver, allResolvedArtifacts, artifactTypeRegistry);
            return new SingleVariantAttributeSet(componentIdentifier, schema, resolvedVariant);
        }
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (VariantMetadata variantMetadata : variants) {
            ResolvedVariant resolvedVariant = DefaultArtifactSet.toResolvedVariant(variantMetadata, ownerId, moduleSource, exclusions, artifactResolver, allResolvedArtifacts, artifactTypeRegistry);
            result.add((Object)resolvedVariant);
        }
        return new MultipleVariantAttributeSet(componentIdentifier, schema, (Set<ResolvedVariant>)result.build());
    }

    public static ArtifactSet singleVariant(ComponentIdentifier componentIdentifier, ModuleVersionIdentifier ownerId, DisplayName displayName, Set<? extends ComponentArtifactMetadata> artifacts, ModuleSource moduleSource, ModuleExclusion exclusions, AttributesSchemaInternal schema, ArtifactResolver artifactResolver, Map<ComponentArtifactIdentifier, ResolvableArtifact> allResolvedArtifacts, ArtifactTypeRegistry artifactTypeRegistry) {
        DefaultVariantMetadata variantMetadata = new DefaultVariantMetadata(displayName, (AttributeContainerInternal)ImmutableAttributes.EMPTY, artifacts);
        ResolvedVariant resolvedVariant = DefaultArtifactSet.toResolvedVariant(variantMetadata, ownerId, moduleSource, exclusions, artifactResolver, allResolvedArtifacts, artifactTypeRegistry);
        return new SingleVariantAttributeSet(componentIdentifier, schema, resolvedVariant);
    }

    private static ResolvedVariant toResolvedVariant(VariantMetadata variant, ModuleVersionIdentifier ownerId, ModuleSource moduleSource, ModuleExclusion exclusions, ArtifactResolver artifactResolver, Map<ComponentArtifactIdentifier, ResolvableArtifact> allResolvedArtifacts, ArtifactTypeRegistry artifactTypeRegistry) {
        Set<? extends ComponentArtifactMetadata> artifacts = variant.getArtifacts();
        LinkedHashSet<ResolvableArtifact> resolvedArtifacts = new LinkedHashSet<ResolvableArtifact>(artifacts.size());
        ImmutableAttributes attributes = artifactTypeRegistry.mapAttributesFor(variant);
        for (ComponentArtifactMetadata componentArtifactMetadata : artifacts) {
            IvyArtifactName artifactName = componentArtifactMetadata.getName();
            if (exclusions.excludeArtifact(ownerId.getModule(), artifactName)) continue;
            ResolvableArtifact resolvedArtifact = allResolvedArtifacts.get(componentArtifactMetadata.getId());
            if (resolvedArtifact == null) {
                LazyArtifactSource artifactSource = new LazyArtifactSource(componentArtifactMetadata, moduleSource, artifactResolver);
                resolvedArtifact = new DefaultResolvedArtifact(ownerId, artifactName, componentArtifactMetadata.getId(), componentArtifactMetadata.getBuildDependencies(), artifactSource);
                allResolvedArtifacts.put(componentArtifactMetadata.getId(), resolvedArtifact);
            }
            resolvedArtifacts.add(resolvedArtifact);
        }
        return ArtifactBackedResolvedVariant.create(variant.asDescribable(), (AttributeContainerInternal)attributes, resolvedArtifacts);
    }

    public String toString() {
        return this.asDescribable().getDisplayName();
    }

    @Override
    public Describable asDescribable() {
        return Describables.of((Object)this.componentIdentifier);
    }

    @Override
    public AttributesSchemaInternal getSchema() {
        return this.schema;
    }

    @Override
    public ResolvedArtifactSet select(Spec<? super ComponentIdentifier> componentFilter, VariantSelector selector) {
        if (!componentFilter.isSatisfiedBy((Object)this.componentIdentifier)) {
            return ResolvedArtifactSet.EMPTY;
        }
        return selector.select(this);
    }

    private static class LazyArtifactSource
    implements Factory<File> {
        private final ArtifactResolver artifactResolver;
        private final ModuleSource moduleSource;
        private final ComponentArtifactMetadata artifact;

        private LazyArtifactSource(ComponentArtifactMetadata artifact, ModuleSource moduleSource, ArtifactResolver artifactResolver) {
            this.artifact = artifact;
            this.artifactResolver = artifactResolver;
            this.moduleSource = moduleSource;
        }

        public File create() {
            DefaultBuildableArtifactResolveResult result = new DefaultBuildableArtifactResolveResult();
            this.artifactResolver.resolveArtifact(this.artifact, this.moduleSource, result);
            return (File)result.getResult();
        }
    }

    private static class MultipleVariantAttributeSet
    extends DefaultArtifactSet {
        private final Set<ResolvedVariant> variants;

        public MultipleVariantAttributeSet(ComponentIdentifier componentIdentifier, AttributesSchemaInternal schema, Set<ResolvedVariant> variants) {
            super(componentIdentifier, schema);
            this.variants = variants;
        }

        @Override
        public Set<ResolvedVariant> getVariants() {
            return this.variants;
        }
    }

    private static class SingleVariantAttributeSet
    extends DefaultArtifactSet {
        private final ResolvedVariant variant;

        public SingleVariantAttributeSet(ComponentIdentifier componentIdentifier, AttributesSchemaInternal schema, ResolvedVariant variant) {
            super(componentIdentifier, schema);
            this.variant = variant;
        }

        @Override
        public Set<ResolvedVariant> getVariants() {
            return ImmutableSet.of((Object)this.variant);
        }
    }
}

