/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.FileASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationAdapter;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.ModalityState;
import org.jetbrains.kotlin.com.intellij.openapi.application.ReadAction;
import org.jetbrains.kotlin.com.intellij.openapi.application.TransactionGuard;
import org.jetbrains.kotlin.com.intellij.openapi.application.TransactionGuardImpl;
import org.jetbrains.kotlin.com.intellij.openapi.application.ex.ApplicationEx;
import org.jetbrains.kotlin.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.editor.ex.DocumentEx;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicator;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressManager;
import org.jetbrains.kotlin.com.intellij.openapi.progress.util.StandardProgressIndicatorBase;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolderEx;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.pom.PomManager;
import org.jetbrains.kotlin.com.intellij.pom.PomModel;
import org.jetbrains.kotlin.com.intellij.pom.event.PomModelEvent;
import org.jetbrains.kotlin.com.intellij.pom.impl.PomTransactionBase;
import org.jetbrains.kotlin.com.intellij.pom.tree.TreeAspect;
import org.jetbrains.kotlin.com.intellij.pom.tree.TreeAspectEvent;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiCompiledFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiDocumentManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiInvalidElementAccessException;
import org.jetbrains.kotlin.com.intellij.psi.PsiLock;
import org.jetbrains.kotlin.com.intellij.psi.SingleRootFileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.CodeStyleManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.DebugUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.DocumentCommitProcessor;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiDocumentManagerBase;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiToDocumentSynchronizer;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.text.DiffLog;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.FileElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.text.BlockSupport;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtil;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.concurrency.BoundedTaskExecutor;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.HashSetQueue;
import org.jetbrains.kotlin.com.intellij.util.ui.UIUtil;

public class DocumentCommitThread
implements Disposable,
DocumentCommitProcessor,
Runnable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.DocumentCommitThread");
    private final ExecutorService executor = new BoundedTaskExecutor("Document committing pool", PooledThreadExecutor.INSTANCE, 1, this);
    private final Object lock = new Object();
    private final HashSetQueue<CommitTask> documentsToCommit = new HashSetQueue();
    private final HashSetQueue<CommitTask> documentsToApplyInEDT = new HashSetQueue();
    private final ApplicationEx myApplication;
    private volatile boolean isDisposed;
    private CommitTask currentTask;
    private boolean myEnabled;
    private static final Key<Object> CANCEL_REASON = Key.create("CANCEL_REASON");
    private static final Key<Lock> DOCUMENT_LOCK = Key.create("DOCUMENT_LOCK");

    public static DocumentCommitThread getInstance() {
        return (DocumentCommitThread)ServiceManager.getService(DocumentCommitProcessor.class);
    }

    public DocumentCommitThread(ApplicationEx application) {
        this.myApplication = application;
        application.invokeLater(() -> {
            if (application.isDisposed()) {
                return;
            }
            assert (!application.isWriteAccessAllowed() || application.isUnitTestMode());
            application.addApplicationListener(new ApplicationAdapter(){

                @Override
                public void beforeWriteActionStart(@NotNull Object action) {
                    if (action == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread$1", "beforeWriteActionStart"));
                    }
                    DocumentCommitThread.this.disable("Write action started: " + action);
                }

                @Override
                public void afterWriteActionFinished(@NotNull Object action) {
                    if (action == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread$1", "afterWriteActionFinished"));
                    }
                    DocumentCommitThread.this.enable("Write action finished: " + action);
                }
            }, this);
            this.enable("Listener installed, started");
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        this.isDisposed = true;
        Object object = this.lock;
        synchronized (object) {
            this.documentsToCommit.clear();
        }
        this.cancel("Stop thread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disable(@NonNls @NotNull Object reason) {
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "disable"));
        }
        Object object = this.lock;
        synchronized (object) {
            this.cancel(reason);
            this.myEnabled = false;
        }
        this.log(null, "disabled", null, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enable(@NonNls @NotNull Object reason) {
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "enable"));
        }
        Object object = this.lock;
        synchronized (object) {
            this.myEnabled = true;
            this.wakeUpQueue();
        }
        this.log(null, "enabled", null, reason);
    }

    private void wakeUpQueue() {
        if (!this.isDisposed && !this.documentsToCommit.isEmpty()) {
            this.executor.execute(this);
        }
    }

    private void cancel(@NonNls @NotNull Object reason) {
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "cancel"));
        }
        this.startNewTask(null, reason);
    }

    @Override
    public void commitAsynchronously(@NotNull Project project, @NotNull Document document, @NonNls @NotNull Object reason, @NotNull ModalityState currentModalityState) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "commitAsynchronously"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "commitAsynchronously"));
        }
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "commitAsynchronously"));
        }
        if (currentModalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentModalityState", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "commitAsynchronously"));
        }
        assert (!this.isDisposed) : "already disposed";
        if (!project.isInitialized()) {
            return;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance(project).getCachedPsiFile(document);
        if (psiFile == null) {
            return;
        }
        this.doQueue(project, document, DocumentCommitThread.getAllFileNodes(psiFile), reason, currentModalityState, PsiDocumentManager.getInstance(project).getLastCommittedText(document));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doQueue(@NotNull Project project, @NotNull Document document, @NotNull List<Pair<PsiFileImpl, FileASTNode>> oldFileNodes, @NotNull Object reason, @NotNull ModalityState currentModalityState, @NotNull CharSequence lastCommittedText) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "doQueue"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "doQueue"));
        }
        if (oldFileNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldFileNodes", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "doQueue"));
        }
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "doQueue"));
        }
        if (currentModalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentModalityState", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "doQueue"));
        }
        if (lastCommittedText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lastCommittedText", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "doQueue"));
        }
        Object object = this.lock;
        synchronized (object) {
            if (!project.isInitialized()) {
                return;
            }
            CommitTask newTask = this.createNewTaskAndCancelSimilar(project, document, oldFileNodes, reason, currentModalityState, lastCommittedText);
            this.documentsToCommit.offer(newTask);
            this.log(project, "Queued", newTask, reason);
            this.wakeUpQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private CommitTask createNewTaskAndCancelSimilar(@NotNull Project project, @NotNull Document document, @NotNull List<Pair<PsiFileImpl, FileASTNode>> oldFileNodes, @NotNull Object reason, @NotNull ModalityState currentModalityState, @NotNull CharSequence lastCommittedText) {
        Pair<PsiFileImpl, FileASTNode> pair;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "createNewTaskAndCancelSimilar"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "createNewTaskAndCancelSimilar"));
        }
        if (oldFileNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldFileNodes", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "createNewTaskAndCancelSimilar"));
        }
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "createNewTaskAndCancelSimilar"));
        }
        if (currentModalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentModalityState", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "createNewTaskAndCancelSimilar"));
        }
        if (lastCommittedText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lastCommittedText", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "createNewTaskAndCancelSimilar"));
        }
        Object object = this.lock;
        // MONITORENTER : object
        Iterator<Pair<PsiFileImpl, FileASTNode>> iterator2 = oldFileNodes.iterator();
        while (true) {
            if (!iterator2.hasNext()) {
                CommitTask newTask = new CommitTask(project, document, oldFileNodes, this.createProgressIndicator(), reason, currentModalityState, lastCommittedText);
                this.cancelAndRemoveFromDocsToCommit(newTask, reason);
                this.cancelAndRemoveCurrentTask(newTask, reason);
                this.cancelAndRemoveFromDocsToApplyInEDT(newTask, reason);
                CommitTask commitTask = newTask;
                // MONITOREXIT : object
                if (commitTask != null) return commitTask;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "createNewTaskAndCancelSimilar"));
            }
            pair = iterator2.next();
            assert (((PsiFileImpl)pair.first).getProject() == project);
        }
    }

    public void log(Project project, @NonNls String msg, @Nullable CommitTask task, Object ... args) {
    }

    private void cancelAll() {
        String reason = "Cancel all in tests";
        this.cancel(reason);
        for (CommitTask commitTask : this.documentsToCommit) {
            commitTask.cancel(reason, this);
            this.log(commitTask.project, "Removed from background queue", commitTask, new Object[0]);
        }
        this.documentsToCommit.clear();
        for (CommitTask commitTask : this.documentsToApplyInEDT) {
            commitTask.cancel(reason, this);
            this.log(commitTask.project, "Removed from EDT apply queue (sync commit called)", commitTask, new Object[0]);
        }
        this.documentsToApplyInEDT.clear();
        CommitTask task = this.currentTask;
        if (task != null) {
            this.cancelAndRemoveFromDocsToCommit(task, reason);
        }
        this.cancel("Sync commit intervened");
        ((BoundedTaskExecutor)this.executor).clearAndCancelAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearQueue() {
        Object object = this.lock;
        synchronized (object) {
            this.cancelAll();
            this.wakeUpQueue();
        }
    }

    private void cancelAndRemoveCurrentTask(@NotNull CommitTask newTask, @NotNull Object reason) {
        if (newTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTask", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "cancelAndRemoveCurrentTask"));
        }
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "cancelAndRemoveCurrentTask"));
        }
        CommitTask currentTask = this.currentTask;
        if (currentTask != null && currentTask.equals(newTask)) {
            this.cancelAndRemoveFromDocsToCommit(currentTask, reason);
            this.cancel(reason);
        }
    }

    private void cancelAndRemoveFromDocsToApplyInEDT(@NotNull CommitTask newTask, @NotNull Object reason) {
        if (newTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTask", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "cancelAndRemoveFromDocsToApplyInEDT"));
        }
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "cancelAndRemoveFromDocsToApplyInEDT"));
        }
        boolean removed2 = this.cancelAndRemoveFromQueue(newTask, this.documentsToApplyInEDT, reason);
        if (removed2) {
            this.log(newTask.project, "Removed from EDT apply queue", newTask, new Object[0]);
        }
    }

    private void cancelAndRemoveFromDocsToCommit(@NotNull CommitTask newTask, @NotNull Object reason) {
        if (newTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTask", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "cancelAndRemoveFromDocsToCommit"));
        }
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "cancelAndRemoveFromDocsToCommit"));
        }
        boolean removed2 = this.cancelAndRemoveFromQueue(newTask, this.documentsToCommit, reason);
        if (removed2) {
            this.log(newTask.project, "Removed from background queue", newTask, new Object[0]);
        }
    }

    private boolean cancelAndRemoveFromQueue(@NotNull CommitTask newTask, @NotNull HashSetQueue<CommitTask> queue, @NotNull Object reason) {
        if (newTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTask", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "cancelAndRemoveFromQueue"));
        }
        if (queue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queue", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "cancelAndRemoveFromQueue"));
        }
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "cancelAndRemoveFromQueue"));
        }
        CommitTask queuedTask = queue.find(newTask);
        if (queuedTask != null) {
            assert (queuedTask != newTask);
            queuedTask.cancel(reason, this);
        }
        return queue.remove(newTask);
    }

    @Override
    public void run() {
        while (!this.isDisposed) {
            try {
                boolean polled = this.pollQueue();
                if (polled) continue;
                break;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pollQueue() {
        assert (!this.myApplication.isDispatchThread()) : Thread.currentThread();
        boolean success = false;
        Document document = null;
        Project project = null;
        CommitTask task = null;
        Object failureReason = null;
        try {
            ProgressIndicator indicator;
            Object object = this.lock;
            synchronized (object) {
                if (!this.myEnabled || (task = this.documentsToCommit.poll()) == null) {
                    return false;
                }
                document = task.getDocument();
                indicator = task.indicator;
                project = task.project;
                if (project.isDisposed() || !((PsiDocumentManagerBase)PsiDocumentManager.getInstance(project)).isInUncommittedSet(document)) {
                    this.log(project, "Abandon and proceed to next", task, new Object[0]);
                    return true;
                }
                if (indicator.isCanceled()) {
                    return true;
                }
                this.startNewTask(task, "Pulled new task");
                this.documentsToApplyInEDT.add(task);
            }
            if (indicator.isCanceled()) {
                success = false;
            } else {
                CommitTask commitTask = task;
                Ref result2 = new Ref();
                ProgressManager.getInstance().executeProcessUnderProgress(() -> result2.set(this.commitUnderProgress(commitTask, false)), indicator);
                Runnable finishRunnable = (Runnable)((Pair)result2.get()).first;
                success = finishRunnable != null;
                failureReason = ((Pair)result2.get()).second;
                if (success) {
                    assert (!this.myApplication.isDispatchThread());
                    TransactionGuardImpl guard = (TransactionGuardImpl)TransactionGuard.getInstance();
                    guard.submitTransaction(project, guard.getModalityTransaction(task.myCreationModalityState), finishRunnable);
                }
            }
        }
        catch (ProcessCanceledException e) {
            this.cancel(e + " (cancel reason: " + ((UserDataHolder)((Object)task.indicator)).getUserData(CANCEL_REASON) + ")");
            success = false;
            failureReason = e;
        }
        catch (Throwable e) {
            this.cancel(e);
            failureReason = ExceptionUtil.getThrowableText(e);
        }
        if (!success && task != null) {
            Project finalProject = project;
            Document finalDocument = document;
            String finalFailureReason = failureReason;
            CommitTask finalTask = task;
            ReadAction.run(() -> {
                List<Pair<PsiFileImpl, FileASTNode>> oldFileNodes;
                if (finalProject.isDisposed()) {
                    return;
                }
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance(finalProject);
                if (documentManager.isCommitted(finalDocument)) {
                    return;
                }
                CharSequence lastCommittedText = documentManager.getLastCommittedText(finalDocument);
                PsiFile file = documentManager.getPsiFile(finalDocument);
                List<Pair<PsiFileImpl, FileASTNode>> list2 = oldFileNodes = file == null ? null : DocumentCommitThread.getAllFileNodes(file);
                if (oldFileNodes != null) {
                    this.doQueue(finalProject, finalDocument, oldFileNodes, "re-added on failure: " + finalFailureReason, finalTask.myCreationModalityState, lastCommittedText);
                }
            });
        }
        Object object = this.lock;
        synchronized (object) {
            this.currentTask = null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitSynchronously(@NotNull Document document, @NotNull Project project, @NotNull PsiFile psiFile) {
        CommitTask task;
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "commitSynchronously"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "commitSynchronously"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "commitSynchronously"));
        }
        assert (!this.isDisposed);
        if (!project.isInitialized() && !project.isDefault()) {
            String s = project + "; Disposed: " + project.isDisposed() + "; Open: " + project.isOpen();
            try {
                Disposer.dispose(project);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new RuntimeException(s);
        }
        List<Pair<PsiFileImpl, FileASTNode>> allFileNodes = DocumentCommitThread.getAllFileNodes(psiFile);
        Lock documentLock = DocumentCommitThread.getDocumentLock(document);
        Object object = this.lock;
        synchronized (object) {
            task = this.createNewTaskAndCancelSimilar(project, document, allFileNodes, "Sync commit", ModalityState.current(), PsiDocumentManager.getInstance(project).getLastCommittedText(document));
            documentLock.lock();
        }
        try {
            assert (!task.indicator.isCanceled());
            Pair<Runnable, Object> result2 = this.commitUnderProgress(task, true);
            Runnable finish = (Runnable)result2.first;
            this.log(project, "Committed sync", task, finish, task.indicator);
            assert (finish != null);
            finish.run();
        }
        finally {
            documentLock.unlock();
        }
    }

    @NotNull
    private static List<Pair<PsiFileImpl, FileASTNode>> getAllFileNodes(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "getAllFileNodes"));
        }
        if (!file.isValid()) {
            throw new PsiInvalidElementAccessException((PsiElement)file, "File " + file + " is invalid, can't commit");
        }
        if (file instanceof PsiCompiledFile) {
            throw new IllegalArgumentException("Can't commit ClsFile: " + file);
        }
        List<Pair<PsiFileImpl, FileASTNode>> list2 = ContainerUtil.map(file.getViewProvider().getAllFiles(), root2 -> Pair.create((PsiFileImpl)root2, root2.getNode()));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "getAllFileNodes"));
        }
        return list2;
    }

    @NotNull
    protected ProgressIndicator createProgressIndicator() {
        StandardProgressIndicatorBase standardProgressIndicatorBase = new StandardProgressIndicatorBase();
        if (standardProgressIndicatorBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "createProgressIndicator"));
        }
        return standardProgressIndicatorBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startNewTask(@Nullable CommitTask task, @NotNull Object reason) {
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "startNewTask"));
        }
        Object object = this.lock;
        synchronized (object) {
            CommitTask cur = this.currentTask;
            if (cur != null) {
                cur.cancel(reason, this);
            }
            this.currentTask = task;
        }
    }

    @NotNull
    private Pair<Runnable, Object> commitUnderProgress(@NotNull CommitTask task, boolean synchronously) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "commitUnderProgress"));
        }
        if (synchronously) assert (!task.indicator.isCanceled());
        Document document = task.getDocument();
        Project project = task.project;
        PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(project);
        SmartList<Processor<Document>> finishProcessors = new SmartList<Processor<Document>>();
        Runnable runnable = () -> {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "lambda$commitUnderProgress$4"));
            }
            this.myApplication.assertReadAccessAllowed();
            if (project.isDisposed()) {
                return;
            }
            Lock lock = DocumentCommitThread.getDocumentLock(document);
            if (!lock.tryLock()) {
                task.cancel("Can't obtain document lock", this);
                return;
            }
            boolean canceled = false;
            try {
                if (documentManager.isCommitted(document)) {
                    return;
                }
                if (!task.isStillValid()) {
                    canceled = true;
                    return;
                }
                FileViewProvider viewProvider = documentManager.getCachedViewProvider(document);
                if (viewProvider == null) {
                    finishProcessors.add(this.handleCommitWithoutPsi(documentManager, task));
                    return;
                }
                for (Pair<PsiFileImpl, FileASTNode> pair : task.myOldFileNodes) {
                    PsiFileImpl file = (PsiFileImpl)pair.first;
                    if (file.isValid()) {
                        FileASTNode oldFileNode = (FileASTNode)pair.second;
                        Processor<Document> finishProcessor = this.doCommit(task, file, oldFileNode);
                        if (finishProcessor == null) continue;
                        finishProcessors.add(finishProcessor);
                        continue;
                    }
                    if (task.reason.equals("Sync commit")) {
                        throw new PsiInvalidElementAccessException((PsiElement)file, "File " + file + " invalidated during sync commit");
                    }
                    this.commitAsynchronously(project, document, "File " + file + " invalidated during background commit; task: " + task, task.myCreationModalityState);
                }
            }
            finally {
                lock.unlock();
                if (canceled) {
                    task.cancel("Task invalidated", this);
                }
            }
        };
        if (synchronously) {
            runnable.run();
        } else if (!this.myApplication.tryRunReadAction(runnable)) {
            this.log(project, "Could not start read action", task, this.myApplication.isReadAccessAllowed(), Thread.currentThread());
            Pair<Object, String> pair = new Pair<Object, String>(null, "Could not start read action");
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "commitUnderProgress"));
            }
            return pair;
        }
        boolean canceled = task.indicator.isCanceled();
        assert (!synchronously || !canceled);
        if (canceled) {
            Pair<Object, String> pair = new Pair<Object, String>(null, "Indicator was canceled");
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "commitUnderProgress"));
            }
            return pair;
        }
        Runnable result2 = this.createEdtRunnable(task, synchronously, finishProcessors);
        Pair<Runnable, Object> pair = Pair.create(result2, null);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "commitUnderProgress"));
        }
        return pair;
    }

    @NotNull
    private Runnable createEdtRunnable(@NotNull CommitTask task, boolean synchronously, @NotNull List<Processor<Document>> finishProcessors) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "createEdtRunnable"));
        }
        if (finishProcessors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finishProcessors", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "createEdtRunnable"));
        }
        Runnable runnable = () -> {
            boolean success;
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "lambda$createEdtRunnable$5"));
            }
            if (finishProcessors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finishProcessors", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "lambda$createEdtRunnable$5"));
            }
            this.myApplication.assertIsDispatchThread();
            Document document = task.getDocument();
            Project project = task.project;
            PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(project);
            boolean committed = project.isDisposed() || documentManager.isCommitted(document);
            Object object = this.lock;
            synchronized (object) {
                this.documentsToApplyInEDT.remove(task);
                if (committed) {
                    this.log(project, "Marked as already committed in EDT apply queue, return", task, new Object[0]);
                    return;
                }
            }
            boolean changeStillValid = task.isStillValid();
            boolean bl = success = changeStillValid && documentManager.finishCommit(document, finishProcessors, synchronously, task.reason);
            if (synchronously) assert (success);
            if (!changeStillValid) {
                this.log(project, "document changed; ignore", task, new Object[0]);
                return;
            }
            if (synchronously || success) assert (!documentManager.isInUncommittedSet(document));
            if (success) {
                this.log(project, "Commit finished", task, new Object[0]);
            } else {
                this.commitAsynchronously(project, document, "Re-added back", task.myCreationModalityState);
            }
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "createEdtRunnable"));
        }
        return runnable;
    }

    @NotNull
    private Processor<Document> handleCommitWithoutPsi(@NotNull PsiDocumentManagerBase documentManager, @NotNull CommitTask task) {
        if (documentManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentManager", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "handleCommitWithoutPsi"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "handleCommitWithoutPsi"));
        }
        Processor<Document> processor = document -> {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "lambda$handleCommitWithoutPsi$6"));
            }
            if (documentManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentManager", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "lambda$handleCommitWithoutPsi$6"));
            }
            this.log(task.project, "Finishing without PSI", task, new Object[0]);
            if (!task.isStillValid() || documentManager.getCachedViewProvider((Document)document) != null) {
                return false;
            }
            documentManager.handleCommitWithoutPsi((Document)document);
            return true;
        };
        if (processor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "handleCommitWithoutPsi"));
        }
        return processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isEnabled() {
        Object object = this.lock;
        synchronized (object) {
            return this.myEnabled;
        }
    }

    public String toString() {
        return "Document commit thread; application: " + this.myApplication + "; isDisposed: " + this.isDisposed + "; myEnabled: " + this.isEnabled();
    }

    public void waitForAllCommits() throws ExecutionException, InterruptedException, TimeoutException {
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (!ApplicationManager.getApplication().isWriteAccessAllowed());
        ((BoundedTaskExecutor)this.executor).waitAllTasksExecuted(100L, TimeUnit.SECONDS);
        UIUtil.dispatchAllInvocationEvents();
    }

    @Nullable(value="returns runnable to execute under write action in AWT to finish the commit")
    public Processor<Document> doCommit(@NotNull CommitTask task, @NotNull PsiFile file, @NotNull FileASTNode oldFileNode) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "doCommit"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "doCommit"));
        }
        if (oldFileNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldFileNode", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "doCommit"));
        }
        Document document = task.getDocument();
        CharSequence newDocumentText = document.getImmutableCharSequence();
        TextRange changedPsiRange = DocumentCommitThread.getChangedPsiRange(file, task.myLastCommittedText, newDocumentText);
        if (changedPsiRange == null) {
            return null;
        }
        Boolean data2 = document.getUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY);
        if (data2 != null) {
            document.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, null);
            file.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, data2);
        }
        BlockSupport blockSupport = BlockSupport.getInstance(file.getProject());
        DiffLog diffLog = blockSupport.reparseRange(file, oldFileNode, changedPsiRange, newDocumentText, task.indicator, task.myLastCommittedText);
        return document1 -> {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "lambda$doCommit$7"));
            }
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "lambda$doCommit$7"));
            }
            if (oldFileNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldFileNode", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "lambda$doCommit$7"));
            }
            FileViewProvider viewProvider = file.getViewProvider();
            if (!task.isStillValid() || ((PsiDocumentManagerBase)PsiDocumentManager.getInstance(file.getProject())).getCachedViewProvider((Document)document1) != viewProvider) {
                return false;
            }
            if (file.isPhysical() && !ApplicationManager.getApplication().isWriteAccessAllowed()) {
                VirtualFile vFile = viewProvider.getVirtualFile();
                LOG.error("Write action expected; document=" + document1 + "; file=" + file + " of " + file.getClass() + "; file.valid=" + file.isValid() + "; file.eventSystemEnabled=" + viewProvider.isEventSystemEnabled() + "; viewProvider=" + viewProvider + " of " + viewProvider.getClass() + "; language=" + file.getLanguage() + "; vFile=" + vFile + " of " + vFile.getClass() + "; free-threaded=" + SingleRootFileViewProvider.isFreeThreaded(viewProvider));
            }
            DocumentCommitThread.doActualPsiChange(file, diffLog);
            this.assertAfterCommit((Document)document1, file, (FileElement)oldFileNode);
            return true;
        };
    }

    private static int getLeafMatchingLength(CharSequence leafText, CharSequence pattern, int patternIndex, int finalPatternIndex, int direction) {
        int leafIndex = direction == 1 ? 0 : leafText.length() - 1;
        int finalLeafIndex = direction == 1 ? leafText.length() - 1 : 0;
        int result2 = 0;
        while (leafText.charAt(leafIndex) == pattern.charAt(patternIndex)) {
            ++result2;
            if (leafIndex == finalLeafIndex || patternIndex == finalPatternIndex) break;
            leafIndex += direction;
            patternIndex += direction;
        }
        return result2;
    }

    private static int getMatchingLength(@NotNull FileElement treeElement, @NotNull CharSequence text2, boolean fromStart) {
        if (treeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeElement", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "getMatchingLength"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "getMatchingLength"));
        }
        int patternIndex = fromStart ? 0 : text2.length() - 1;
        int finalPatternIndex = fromStart ? text2.length() - 1 : 0;
        int direction = fromStart ? 1 : -1;
        ASTNode leaf = fromStart ? TreeUtil.findFirstLeaf(treeElement, false) : TreeUtil.findLastLeaf(treeElement, false);
        int result2 = 0;
        while (leaf != null && (fromStart ? patternIndex <= finalPatternIndex : patternIndex >= finalPatternIndex)) {
            CharSequence chars;
            if (!(leaf instanceof ForeignLeafPsiElement) && (chars = leaf.getChars()).length() > 0) {
                int matchingLength = DocumentCommitThread.getLeafMatchingLength(chars, text2, patternIndex, finalPatternIndex, direction);
                result2 += matchingLength;
                if (matchingLength != chars.length()) break;
                patternIndex += fromStart ? matchingLength : -matchingLength;
            }
            leaf = fromStart ? TreeUtil.nextLeaf(leaf, false) : TreeUtil.prevLeaf(leaf, false);
        }
        return result2;
    }

    @Nullable
    public static TextRange getChangedPsiRange(@NotNull PsiFile file, @NotNull FileElement treeElement, @NotNull CharSequence newDocumentText) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "getChangedPsiRange"));
        }
        if (treeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeElement", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "getChangedPsiRange"));
        }
        if (newDocumentText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newDocumentText", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "getChangedPsiRange"));
        }
        int psiLength = treeElement.getTextLength();
        if (!file.getViewProvider().supportsIncrementalReparse(file.getLanguage())) {
            return new TextRange(0, psiLength);
        }
        int commonPrefixLength = DocumentCommitThread.getMatchingLength(treeElement, newDocumentText, true);
        if (commonPrefixLength == newDocumentText.length() && newDocumentText.length() == psiLength) {
            return null;
        }
        int commonSuffixLength = Math.min(DocumentCommitThread.getMatchingLength(treeElement, newDocumentText, false), psiLength - commonPrefixLength);
        return new TextRange(commonPrefixLength, psiLength - commonSuffixLength);
    }

    @Nullable
    private static TextRange getChangedPsiRange(@NotNull PsiFile file, @NotNull CharSequence oldDocumentText, @NotNull CharSequence newDocumentText) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "getChangedPsiRange"));
        }
        if (oldDocumentText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldDocumentText", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "getChangedPsiRange"));
        }
        if (newDocumentText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newDocumentText", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "getChangedPsiRange"));
        }
        int psiLength = oldDocumentText.length();
        if (!file.getViewProvider().supportsIncrementalReparse(file.getLanguage())) {
            return new TextRange(0, psiLength);
        }
        int commonPrefixLength = StringUtil.commonPrefixLength(oldDocumentText, newDocumentText);
        if (commonPrefixLength == newDocumentText.length() && newDocumentText.length() == psiLength) {
            return null;
        }
        int commonSuffixLength = Math.min(StringUtil.commonSuffixLength(oldDocumentText, newDocumentText), psiLength - commonPrefixLength);
        return new TextRange(commonPrefixLength, psiLength - commonSuffixLength);
    }

    public static void doActualPsiChange(final @NotNull PsiFile file, final @NotNull DiffLog diffLog) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "doActualPsiChange"));
        }
        if (diffLog == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffLog", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "doActualPsiChange"));
        }
        CodeStyleManager.getInstance(file.getProject()).performActionWithFormatterDisabled(() -> {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "lambda$doActualPsiChange$8"));
            }
            if (diffLog == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffLog", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "lambda$doActualPsiChange$8"));
            }
            Object object = PsiLock.LOCK;
            synchronized (object) {
                file.getViewProvider().beforeContentsSynchronized();
                Document document = file.getViewProvider().getDocument();
                PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(file.getProject());
                PsiToDocumentSynchronizer.DocumentChangeTransaction transaction = documentManager.getSynchronizer().getTransaction(document);
                PsiFileImpl fileImpl = (PsiFileImpl)file;
                if (transaction == null) {
                    final PomModel model = PomManager.getModel(fileImpl.getProject());
                    model.runTransaction(new PomTransactionBase(fileImpl, model.getModelAspect(TreeAspect.class)){

                        @Override
                        public PomModelEvent runInner() {
                            return new TreeAspectEvent(model, diffLog.performActualPsiChange(file));
                        }
                    });
                } else {
                    diffLog.performActualPsiChange(file);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertAfterCommit(@NotNull Document document, @NotNull PsiFile file, @NotNull FileElement oldFileNode) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "assertAfterCommit"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "assertAfterCommit"));
        }
        if (oldFileNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldFileNode", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread", "assertAfterCommit"));
        }
        if (oldFileNode.getTextLength() != document.getTextLength()) {
            String documentText = document.getText();
            String fileText = file.getText();
            boolean sameText = Comparing.equal(fileText, documentText);
            LOG.error("commitDocument() left PSI inconsistent: " + DebugUtil.diagnosePsiDocumentInconsistency(file, document) + "; node.length=" + oldFileNode.getTextLength() + "; doc.text" + (sameText ? "==" : "!=") + "file.text; file name:" + file.getName() + "; type:" + file.getFileType() + "; lang:" + file.getLanguage());
            file.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, Boolean.TRUE);
            try {
                BlockSupport blockSupport = BlockSupport.getInstance(file.getProject());
                DiffLog diffLog = blockSupport.reparseRange(file, file.getNode(), new TextRange(0, documentText.length()), documentText, this.createProgressIndicator(), oldFileNode.getText());
                DocumentCommitThread.doActualPsiChange(file, diffLog);
                if (oldFileNode.getTextLength() != document.getTextLength()) {
                    LOG.error("PSI is broken beyond repair in: " + file);
                }
            }
            finally {
                file.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, null);
            }
        }
    }

    private static Lock getDocumentLock(Document document) {
        Lock lock = document.getUserData(DOCUMENT_LOCK);
        return lock != null ? lock : (Lock)((UserDataHolderEx)((Object)document)).putUserDataIfAbsent(DOCUMENT_LOCK, new ReentrantLock());
    }

    private class CommitTask {
        @NotNull
        private final Document document;
        @NotNull
        final Project project;
        private final int modificationSequence;
        @NotNull
        final ProgressIndicator indicator;
        @NotNull
        final Object reason;
        @NotNull
        final ModalityState myCreationModalityState;
        private final CharSequence myLastCommittedText;
        @NotNull
        final List<Pair<PsiFileImpl, FileASTNode>> myOldFileNodes;

        CommitTask(@NotNull Project project, @NotNull Document document, @NotNull List<Pair<PsiFileImpl, FileASTNode>> oldFileNodes, @NotNull ProgressIndicator indicator, @NotNull Object reason, @NotNull ModalityState currentModalityState, @NotNull CharSequence lastCommittedText) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread$CommitTask", "<init>"));
            }
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread$CommitTask", "<init>"));
            }
            if (oldFileNodes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldFileNodes", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread$CommitTask", "<init>"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread$CommitTask", "<init>"));
            }
            if (reason == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread$CommitTask", "<init>"));
            }
            if (currentModalityState == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentModalityState", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread$CommitTask", "<init>"));
            }
            if (lastCommittedText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lastCommittedText", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread$CommitTask", "<init>"));
            }
            this.document = document;
            this.project = project;
            this.indicator = indicator;
            this.reason = reason;
            this.myCreationModalityState = currentModalityState;
            this.myLastCommittedText = lastCommittedText;
            this.myOldFileNodes = oldFileNodes;
            this.modificationSequence = ((DocumentEx)document).getModificationSequence();
        }

        @NonNls
        public String toString() {
            Document document = this.getDocument();
            String docInfo = document + " (\"" + StringUtil.first(document.getImmutableCharSequence(), 40, true).toString().replaceAll("\n", " ") + "\")";
            String indicatorInfo = this.indicator.isCanceled() ? " (Canceled: " + ((UserDataHolder)((Object)this.indicator)).getUserData(CANCEL_REASON) + ")" : "";
            String reasonInfo = " Reason: " + this.reason + (this.isStillValid() ? "" : "; changed: old seq=" + this.modificationSequence + ", new seq=" + ((DocumentEx)document).getModificationSequence());
            return "Doc: " + docInfo + indicatorInfo + reasonInfo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CommitTask)) {
                return false;
            }
            CommitTask task = (CommitTask)o;
            return Comparing.equal(this.getDocument(), task.getDocument()) && this.project.equals(task.project);
        }

        public int hashCode() {
            int result2 = this.getDocument().hashCode();
            result2 = 31 * result2 + this.project.hashCode();
            return result2;
        }

        boolean isStillValid() {
            Document document = this.getDocument();
            return ((DocumentEx)document).getModificationSequence() == this.modificationSequence;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancel(@NotNull Object reason, @NotNull DocumentCommitThread commitProcessor) {
            if (reason == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread$CommitTask", "cancel"));
            }
            if (commitProcessor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitProcessor", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread$CommitTask", "cancel"));
            }
            if (!this.indicator.isCanceled()) {
                commitProcessor.log(this.project, "indicator cancel", this, new Object[0]);
                this.indicator.cancel();
                ((UserDataHolder)((Object)this.indicator)).putUserData(CANCEL_REASON, reason);
                Object object = DocumentCommitThread.this.lock;
                synchronized (object) {
                    DocumentCommitThread.this.documentsToCommit.remove(this);
                    DocumentCommitThread.this.documentsToApplyInEDT.remove(this);
                }
            }
        }

        @NotNull
        Document getDocument() {
            Document document = this.document;
            if (document == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/DocumentCommitThread$CommitTask", "getDocument"));
            }
            return document;
        }
    }
}

