/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.protocol;

import org.gradle.api.logging.LogLevel;
import org.gradle.internal.logging.events.LogEvent;
import org.gradle.internal.logging.events.LogLevelChangeEvent;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.ProgressCompleteEvent;
import org.gradle.internal.logging.events.ProgressEvent;
import org.gradle.internal.logging.events.ProgressStartEvent;
import org.gradle.internal.logging.events.StyledTextOutputEvent;
import org.gradle.internal.logging.serializer.LogEventSerializer;
import org.gradle.internal.logging.serializer.LogLevelChangeEventSerializer;
import org.gradle.internal.logging.serializer.ProgressCompleteEventSerializer;
import org.gradle.internal.logging.serializer.ProgressEventSerializer;
import org.gradle.internal.logging.serializer.ProgressStartEventSerializer;
import org.gradle.internal.logging.serializer.SpanSerializer;
import org.gradle.internal.logging.serializer.StyledTextOutputEventSerializer;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.DefaultSerializer;
import org.gradle.internal.serialize.DefaultSerializerRegistry;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.ListSerializer;
import org.gradle.internal.serialize.Serializer;
import org.gradle.launcher.daemon.protocol.BuildEvent;
import org.gradle.launcher.daemon.protocol.CloseInput;
import org.gradle.launcher.daemon.protocol.Failure;
import org.gradle.launcher.daemon.protocol.ForwardInput;
import org.gradle.launcher.daemon.protocol.Message;
import org.gradle.launcher.daemon.protocol.OutputMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaemonMessageSerializer {
    public static Serializer<Message> create() {
        BaseSerializerFactory factory = new BaseSerializerFactory();
        Serializer logLevelSerializer = factory.getSerializerFor(LogLevel.class);
        Serializer throwableSerializer = factory.getSerializerFor(Throwable.class);
        DefaultSerializerRegistry registry = new DefaultSerializerRegistry();
        registry.register(BuildEvent.class, (Serializer)new BuildEventSerializer());
        registry.register(Failure.class, (Serializer)new FailureSerializer((Serializer<Throwable>)throwableSerializer));
        registry.register(ForwardInput.class, (Serializer)new ForwardInputSerializer());
        registry.register(CloseInput.class, (Serializer)new CloseInputSerializer());
        registry.register(LogEvent.class, (Serializer)new LogEventSerializer(logLevelSerializer, throwableSerializer));
        registry.register(StyledTextOutputEvent.class, (Serializer)new StyledTextOutputEventSerializer(logLevelSerializer, (Serializer)new ListSerializer((Serializer)new SpanSerializer(factory.getSerializerFor(StyledTextOutput.Style.class)))));
        registry.register(ProgressStartEvent.class, (Serializer)new ProgressStartEventSerializer());
        registry.register(ProgressCompleteEvent.class, (Serializer)new ProgressCompleteEventSerializer());
        registry.register(ProgressEvent.class, (Serializer)new ProgressEventSerializer());
        registry.register(LogLevelChangeEvent.class, (Serializer)new LogLevelChangeEventSerializer(logLevelSerializer));
        registry.register(OutputMessage.class, (Serializer)new OutputMessageSerializer((Serializer<OutputEvent>)registry.build(OutputEvent.class)));
        registry.useJavaSerialization(Message.class);
        return registry.build(Message.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OutputMessageSerializer
    implements Serializer<OutputMessage> {
        private final Serializer<OutputEvent> eventSerializer;

        public OutputMessageSerializer(Serializer<OutputEvent> eventSerializer) {
            this.eventSerializer = eventSerializer;
        }

        public void write(Encoder encoder, OutputMessage message) throws Exception {
            this.eventSerializer.write(encoder, (Object)message.getEvent());
        }

        public OutputMessage read(Decoder decoder) throws Exception {
            return new OutputMessage((OutputEvent)this.eventSerializer.read(decoder));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CloseInputSerializer
    implements Serializer<CloseInput> {
        private CloseInputSerializer() {
        }

        public void write(Encoder encoder, CloseInput value) {
        }

        public CloseInput read(Decoder decoder) {
            return new CloseInput();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ForwardInputSerializer
    implements Serializer<ForwardInput> {
        private ForwardInputSerializer() {
        }

        public void write(Encoder encoder, ForwardInput message) throws Exception {
            encoder.writeBinary(message.getBytes());
        }

        public ForwardInput read(Decoder decoder) throws Exception {
            return new ForwardInput(decoder.readBinary());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BuildEventSerializer
    implements Serializer<BuildEvent> {
        private final Serializer<Object> payloadSerializer = new DefaultSerializer();

        private BuildEventSerializer() {
        }

        public void write(Encoder encoder, BuildEvent buildEvent) throws Exception {
            this.payloadSerializer.write(encoder, buildEvent.getPayload());
        }

        public BuildEvent read(Decoder decoder) throws Exception {
            return new BuildEvent(this.payloadSerializer.read(decoder));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FailureSerializer
    implements Serializer<Failure> {
        private final Serializer<Throwable> throwableSerializer;

        public FailureSerializer(Serializer<Throwable> throwableSerializer) {
            this.throwableSerializer = throwableSerializer;
        }

        public void write(Encoder encoder, Failure failure) throws Exception {
            this.throwableSerializer.write(encoder, failure.getValue());
        }

        public Failure read(Decoder decoder) throws Exception {
            return new Failure((Throwable)this.throwableSerializer.read(decoder));
        }
    }
}

