/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer.internal;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.GetObjectRequest;
import java.io.File;
import java.util.concurrent.Callable;

public class DownloadPartCallable
implements Callable<File> {
    private final AmazonS3 s3;
    private final GetObjectRequest getPartRequest;
    private final String destinationFileName;
    private File tempFile;
    private static final String TEMP_FILE_MIDDLE_NAME = ".part.";

    public DownloadPartCallable(AmazonS3 s3, GetObjectRequest getPartRequest, String destinationFileName) {
        this.s3 = s3;
        this.getPartRequest = getPartRequest;
        this.destinationFileName = destinationFileName;
    }

    @Override
    public File call() throws Exception {
        this.tempFile = File.createTempFile(this.destinationFileName, TEMP_FILE_MIDDLE_NAME + this.getPartRequest.getPartNumber().toString());
        this.tempFile.deleteOnExit();
        if (this.s3.getObject(this.getPartRequest, this.tempFile) == null) {
            throw new AmazonClientException("There is no object in S3 satisfying this request. The getObject method returned null");
        }
        return this.tempFile;
    }
}

