/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.internal.artifact;

import com.google.common.base.Strings;
import javax.annotation.Nullable;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyInternal;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.tasks.TaskDependency;

public abstract class AbstractIvyArtifact
implements IvyArtifact {
    private final TaskDependency allBuildDependencies;
    private final DefaultTaskDependency additionalBuildDependencies = new DefaultTaskDependency();
    private String name;
    private String type;
    private String extension;
    private String classifier;
    private String conf;

    protected AbstractIvyArtifact() {
        this.allBuildDependencies = new CompositeTaskDependency();
    }

    @Override
    public String getName() {
        return this.name != null ? this.name : this.getDefaultName();
    }

    protected abstract String getDefaultName();

    @Override
    public void setName(String name) {
        this.name = Strings.nullToEmpty((String)name);
    }

    @Override
    public String getType() {
        return this.type != null ? this.type : this.getDefaultType();
    }

    protected abstract String getDefaultType();

    @Override
    public void setType(String type) {
        this.type = Strings.nullToEmpty((String)type);
    }

    @Override
    public String getExtension() {
        return this.extension != null ? this.extension : this.getDefaultExtension();
    }

    protected abstract String getDefaultExtension();

    @Override
    public void setExtension(String extension) {
        this.extension = Strings.nullToEmpty((String)extension);
    }

    @Override
    @Nullable
    public String getClassifier() {
        return Strings.emptyToNull((String)(this.classifier != null ? this.classifier : this.getDefaultClassifier()));
    }

    protected abstract String getDefaultClassifier();

    @Override
    public void setClassifier(@Nullable String classifier) {
        this.classifier = Strings.nullToEmpty((String)classifier);
    }

    @Override
    @Nullable
    public String getConf() {
        return Strings.emptyToNull((String)(this.conf != null ? this.conf : this.getDefaultConf()));
    }

    protected abstract String getDefaultConf();

    @Override
    public void setConf(@Nullable String conf) {
        this.conf = Strings.nullToEmpty((String)conf);
    }

    public void builtBy(Object ... tasks) {
        this.additionalBuildDependencies.add(tasks);
    }

    public TaskDependency getBuildDependencies() {
        return this.allBuildDependencies;
    }

    protected abstract TaskDependencyInternal getDefaultBuildDependencies();

    public String toString() {
        return String.format("%s %s:%s:%s:%s", this.getClass().getSimpleName(), this.getName(), this.getType(), this.getExtension(), this.getClassifier());
    }

    private class CompositeTaskDependency
    extends AbstractTaskDependency {
        private CompositeTaskDependency() {
        }

        public void visitDependencies(TaskDependencyResolveContext context) {
            AbstractIvyArtifact.this.getDefaultBuildDependencies().visitDependencies(context);
            AbstractIvyArtifact.this.additionalBuildDependencies.visitDependencies(context);
        }
    }
}

