/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations;

import com.google.common.collect.Lists;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Transformer;
import org.gradle.concurrent.ParallelismConfiguration;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.GradleThread;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.concurrent.ParallelismConfigurationListener;
import org.gradle.internal.concurrent.ParallelismConfigurationManager;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationIdFactory;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.BuildOperationQueueFactory;
import org.gradle.internal.operations.BuildOperationQueueFailure;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.operations.BuildOperationWorker;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.operations.DefaultBuildOperationRef;
import org.gradle.internal.operations.MultipleBuildOperationFailures;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.time.Clock;
import org.gradle.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBuildOperationExecutor
implements BuildOperationExecutor,
Stoppable,
ParallelismConfigurationListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultBuildOperationExecutor.class);
    private static final String LINE_SEPARATOR = SystemProperties.getInstance().getLineSeparator();
    private final BuildOperationListener listener;
    private final Clock clock;
    private final ProgressLoggerFactory progressLoggerFactory;
    private final BuildOperationQueueFactory buildOperationQueueFactory;
    private final ManagedExecutor fixedSizePool;
    private final ParallelismConfigurationManager parallelismConfigurationManager;
    private final BuildOperationIdFactory buildOperationIdFactory;
    private final CurrentBuildOperationRef currentBuildOperationRef = CurrentBuildOperationRef.instance();

    public DefaultBuildOperationExecutor(BuildOperationListener listener, Clock clock, ProgressLoggerFactory progressLoggerFactory, BuildOperationQueueFactory buildOperationQueueFactory, ExecutorFactory executorFactory, ParallelismConfigurationManager parallelismConfigurationManager, BuildOperationIdFactory buildOperationIdFactory) {
        this.listener = listener;
        this.clock = clock;
        this.progressLoggerFactory = progressLoggerFactory;
        this.buildOperationQueueFactory = buildOperationQueueFactory;
        this.fixedSizePool = executorFactory.create("Build operations", parallelismConfigurationManager.getParallelismConfiguration().getMaxWorkerCount());
        this.parallelismConfigurationManager = parallelismConfigurationManager;
        this.buildOperationIdFactory = buildOperationIdFactory;
        parallelismConfigurationManager.addListener((ParallelismConfigurationListener)this);
    }

    public void onParallelismConfigurationChange(ParallelismConfiguration parallelismConfiguration) {
        this.fixedSizePool.setFixedPoolSize(parallelismConfiguration.getMaxWorkerCount());
    }

    public BuildOperationRef getCurrentOperation() {
        BuildOperationState current = this.getCurrentBuildOperation();
        if (current == null) {
            throw new IllegalStateException("No operation is currently running.");
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunnableBuildOperation buildOperation) {
        try {
            this.execute(buildOperation, new RunnableBuildOperationWorker(), this.getCurrentBuildOperation());
        }
        finally {
            this.maybeStopUnmanagedThreadOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T call(CallableBuildOperation<T> buildOperation) {
        CallableBuildOperationWorker worker = new CallableBuildOperationWorker();
        try {
            this.execute((BuildOperation)buildOperation, worker, this.getCurrentBuildOperation());
        }
        finally {
            this.maybeStopUnmanagedThreadOperation();
        }
        return worker.getReturnValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <O extends RunnableBuildOperation> void runAll(Action<BuildOperationQueue<O>> schedulingAction) {
        try {
            this.executeInParallel(new ParentPreservingQueueWorker(new RunnableBuildOperationWorker()), schedulingAction);
        }
        finally {
            this.maybeStopUnmanagedThreadOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <O extends BuildOperation> void runAll(BuildOperationWorker<O> worker, Action<BuildOperationQueue<O>> schedulingAction) {
        try {
            this.executeInParallel(new ParentPreservingQueueWorker(worker), schedulingAction);
        }
        finally {
            this.maybeStopUnmanagedThreadOperation();
        }
    }

    private <O extends BuildOperation> void executeInParallel(BuildOperationQueue.QueueWorker<O> worker, Action<BuildOperationQueue<O>> queueAction) {
        BuildOperationQueue queue = this.buildOperationQueueFactory.create(this.fixedSizePool, worker);
        ArrayList failures = Lists.newArrayList();
        try {
            queueAction.execute((Object)queue);
        }
        catch (Exception e) {
            failures.add(new BuildOperationQueueFailure("There was a failure while populating the build operation queue: " + e.getMessage(), (Throwable)e));
            queue.cancel();
        }
        try {
            queue.waitForCompletion();
        }
        catch (MultipleBuildOperationFailures e) {
            failures.add(e);
        }
        if (failures.size() == 1) {
            throw (GradleException)((Object)failures.get(0));
        }
        if (failures.size() > 1) {
            throw new DefaultMultiCauseException(DefaultBuildOperationExecutor.formatMultipleFailureMessage(failures), (Iterable)failures);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <O extends BuildOperation> void execute(O buildOperation, BuildOperationWorker<O> worker, @Nullable BuildOperationState defaultParent) {
        BuildOperationDescriptor.Builder descriptorBuilder = buildOperation.description();
        BuildOperationState parent = (BuildOperationState)descriptorBuilder.getParentState();
        if (parent == null) {
            parent = defaultParent;
        }
        BuildOperationDescriptor descriptor = this.createDescriptor(descriptorBuilder, parent);
        BuildOperationState newOperation = new BuildOperationState(descriptor, this.clock.getCurrentTime());
        this.assertParentRunning("Cannot start operation (%s) as parent operation (%s) has already completed.", descriptor, parent);
        newOperation.setRunning(true);
        BuildOperationState parentOperation = this.getCurrentBuildOperation();
        this.setCurrentBuildOperation(newOperation);
        try {
            this.listener.started(descriptor, new OperationStartEvent(newOperation.getStartTime()));
            ProgressLogger progressLogger = this.createProgressLogger(newOperation);
            Throwable failure = null;
            DefaultBuildOperationContext context = new DefaultBuildOperationContext();
            LOGGER.debug("Build operation '{}' started", (Object)descriptor.getDisplayName());
            try {
                worker.execute(buildOperation, (BuildOperationContext)context);
            }
            catch (Throwable t) {
                context.thrown(t);
                failure = t;
            }
            LOGGER.debug("Completing Build operation '{}'", (Object)descriptor.getDisplayName());
            progressLogger.completed(context.status, context.failure != null);
            this.listener.finished(descriptor, new OperationFinishEvent(newOperation.getStartTime(), this.clock.getCurrentTime(), context.failure, context.result));
            this.assertParentRunning("Parent operation (%2$s) completed before this operation (%1$s).", descriptor, parent);
            if (failure != null) {
                throw UncheckedException.throwAsUncheckedException((Throwable)failure, (boolean)true);
            }
        }
        finally {
            this.setCurrentBuildOperation(parentOperation);
            newOperation.setRunning(false);
            LOGGER.debug("Build operation '{}' completed", (Object)descriptor.getDisplayName());
        }
    }

    private BuildOperationDescriptor createDescriptor(BuildOperationDescriptor.Builder descriptorBuilder, BuildOperationState parent) {
        OperationIdentifier id = new OperationIdentifier(this.buildOperationIdFactory.nextId());
        BuildOperationState current = this.maybeStartUnmanagedThreadOperation(parent);
        return descriptorBuilder.build(id, current == null ? null : current.getDescription().getId());
    }

    private void assertParentRunning(String message, BuildOperationDescriptor child, BuildOperationState parent) {
        if (parent != null && !parent.isRunning()) {
            String parentName = parent.getDescription().getDisplayName();
            throw new IllegalStateException(String.format(message, child.getDisplayName(), parentName));
        }
    }

    private ProgressLogger createProgressLogger(BuildOperationState currentOperation) {
        BuildOperationDescriptor descriptor = currentOperation.getDescription();
        ProgressLogger progressLogger = this.progressLoggerFactory.newOperation(DefaultBuildOperationExecutor.class, descriptor);
        return progressLogger.start(descriptor.getDisplayName(), descriptor.getProgressDisplayName());
    }

    private BuildOperationState maybeStartUnmanagedThreadOperation(BuildOperationState parentState) {
        if (!GradleThread.isManaged() && parentState == null) {
            parentState = UnmanagedThreadOperation.create(this.clock);
            parentState.setRunning(true);
            this.setCurrentBuildOperation(parentState);
            this.listener.started(parentState.getDescription(), new OperationStartEvent(parentState.getStartTime()));
        }
        return parentState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeStopUnmanagedThreadOperation() {
        BuildOperationState current = this.getCurrentBuildOperation();
        if (current instanceof UnmanagedThreadOperation) {
            try {
                this.listener.finished(current.getDescription(), new OperationFinishEvent(current.getStartTime(), this.clock.getCurrentTime(), null, null));
            }
            finally {
                this.setCurrentBuildOperation(null);
                current.setRunning(false);
            }
        }
    }

    protected void createRunningRootOperation(String displayName) {
        assert (this.getCurrentBuildOperation() == null);
        OperationIdentifier rootBuildOpId = new OperationIdentifier(1L);
        BuildOperationState operation = new BuildOperationState(BuildOperationDescriptor.displayName((String)displayName).build(rootBuildOpId, null), this.clock.getCurrentTime());
        operation.setRunning(true);
        this.setCurrentBuildOperation(operation);
    }

    private static String formatMultipleFailureMessage(List<GradleException> failures) {
        return StringUtils.join((Collection)CollectionUtils.collect(failures, (Transformer)new Transformer<String, GradleException>(){

            public String transform(GradleException e) {
                return e.getMessage();
            }
        }), (String)(LINE_SEPARATOR + "AND" + LINE_SEPARATOR));
    }

    public void stop() {
        this.parallelismConfigurationManager.removeListener((ParallelismConfigurationListener)this);
        this.fixedSizePool.stop();
    }

    private void setCurrentBuildOperation(BuildOperationState parentState) {
        this.currentBuildOperationRef.set((BuildOperationRef)parentState);
    }

    private BuildOperationState getCurrentBuildOperation() {
        return (BuildOperationState)this.currentBuildOperationRef.get();
    }

    private static class UnmanagedThreadOperation
    extends BuildOperationState {
        private static final AtomicLong UNMANAGED_THREAD_OPERATION_COUNTER = new AtomicLong(-1L);

        private static UnmanagedThreadOperation create(Clock clock) {
            LOGGER.debug("WARNING No operation is currently running in unmanaged thread: {}", (Object)Thread.currentThread().getName());
            OperationIdentifier id = new OperationIdentifier(UNMANAGED_THREAD_OPERATION_COUNTER.getAndDecrement());
            String displayName = "Unmanaged thread operation #" + id + " (" + Thread.currentThread().getName() + ')';
            return new UnmanagedThreadOperation(BuildOperationDescriptor.displayName((String)displayName).build(id, null), null, clock.getCurrentTime());
        }

        private UnmanagedThreadOperation(BuildOperationDescriptor descriptor, BuildOperationRef parent, long startTime) {
            super(descriptor, startTime);
        }
    }

    private static class BuildOperationState
    implements BuildOperationRef {
        private final BuildOperationDescriptor description;
        private final AtomicBoolean running = new AtomicBoolean();
        private final long startTime;

        private BuildOperationState(BuildOperationDescriptor descriptor, long startTime) {
            this.startTime = startTime;
            this.description = descriptor;
        }

        BuildOperationDescriptor getDescription() {
            return this.description;
        }

        boolean isRunning() {
            return this.running.get();
        }

        void setRunning(boolean running) {
            this.running.set(running);
        }

        long getStartTime() {
            return this.startTime;
        }

        public OperationIdentifier getId() {
            return this.description.getId();
        }

        public OperationIdentifier getParentId() {
            return this.description.getParentId();
        }

        private Object writeReplace() throws ObjectStreamException {
            return new DefaultBuildOperationRef(this.description.getId(), this.description.getParentId());
        }
    }

    private class ParentPreservingQueueWorker<O extends BuildOperation>
    implements BuildOperationQueue.QueueWorker<O> {
        private BuildOperationState parent;
        private BuildOperationWorker<O> worker;

        private ParentPreservingQueueWorker(BuildOperationWorker<O> worker) {
            this.parent = DefaultBuildOperationExecutor.this.maybeStartUnmanagedThreadOperation(DefaultBuildOperationExecutor.this.getCurrentBuildOperation());
            this.worker = worker;
        }

        public String getDisplayName() {
            return "runnable worker";
        }

        public void execute(O buildOperation) {
            DefaultBuildOperationExecutor.this.execute(buildOperation, this.worker, this.parent);
        }
    }

    private static class CallableBuildOperationWorker<T>
    implements BuildOperationWorker<CallableBuildOperation<T>> {
        private T returnValue;

        private CallableBuildOperationWorker() {
        }

        public String getDisplayName() {
            return "callable build operation";
        }

        public void execute(CallableBuildOperation<T> buildOperation, BuildOperationContext context) {
            this.returnValue = buildOperation.call(context);
        }

        public T getReturnValue() {
            return this.returnValue;
        }
    }

    private static class RunnableBuildOperationWorker<O extends RunnableBuildOperation>
    implements BuildOperationWorker<O> {
        private RunnableBuildOperationWorker() {
        }

        public String getDisplayName() {
            return "runnable build operation";
        }

        public void execute(O buildOperation, BuildOperationContext context) {
            buildOperation.run(context);
        }
    }

    private static class DefaultBuildOperationContext
    implements BuildOperationContext {
        Throwable failure;
        Object result;
        private String status;

        private DefaultBuildOperationContext() {
        }

        public void failed(Throwable t) {
            this.failure = t;
        }

        public void thrown(Throwable t) {
            if (this.failure == null) {
                this.failure = t;
            }
        }

        public void setResult(Object result) {
            this.result = result;
        }

        public void setStatus(String status) {
            this.status = status;
        }
    }
}

