Developer's introduction
========================

This page describes how to navigate the code in a way useful to those who wish
to modify it, link against, etc.


Layout of the sources
---------------------

<dl>

<dt>`.`</dt>
<dd>Root directory of the source tree.  Contains LICENSE.txt, the directories
listed below, etc.</dd>

<dt>`src/`</dt>
<dd>Source code.  Noteworthy files for beginning to learn the internals of
gr1c include:
<ul>
  <li>`common.h`, which defines the version number.</li>
  <li>`main.c`, main entry point for the program `gr1c`.</li>
  <li>`rg_main.c`, main entry point for the program `rg`.</li>
</ul></dd>

<dt>`exp/`</dt>
<dd>Consult `exp/README.txt`.  The main entry point for the program `grpatch` is
in `exp/grpatch.c`.</dd>

<dt>`aux/`</dt>
<dd>Consult `aux/README.txt`.  The main entry point for the program `autman` is
in `aux/autman.c`.</dd></dd>

<dt>`examples/`</dt>
<dd>Example specifications, edge change files, etc.  Some files are intended for
use with the program `gr1c`, others with `rg`, and still others with `grpatch`
and `grjit`, or some combination thereof.  Documentation for examples is
provided in `examples/README.md` or in comments at the top of the respective
file.</dd>

<dt>`tests/`</dt>
<dd>A test suite, which is usually invoked by ``make check`` from the root
directory.  Tests are built and run by `tests/Makefile`.  An environment
variable `VERBOSE` may be set to 1 to indicate that testing progress should be
reported as it happens.</dd>

<dt>`doc/`</dt>
<dd>Documentation source files and configuration.</dd>

<dt>`packaging/`</dt>
<dd>Consult `packaging/README.txt`.</dd>

</dl>


Design notes
------------

### Non-boolean domains

Internally, variables of non-Boolean domains are mapped into a set of Boolean
variables that use the original variable name as a prefix and then append the
corresponding bit index. E.g., `y` with domain of {0,1,2} would translate to 2
variables, `y0`, `y1` that are used to encode the bitvectors 00, 01, and 10. 11
(i.e., `y0` and `y1` both set to `True`) is unreachable.

A significant consequence is that the number of states generated internally
happens at boundaries of powers of two, e.g., so that an integer variable domain
of `[0,513]` incurs the same number of states as `[0,1023]`.


Code style
----------

Version numbers are of the form MAJOR.MINOR.MICRO; when a tag is made for a
release, it must be named as the version number preceded by "v", e.g., "v0.6.1"
for version 0.6.1.  The next commit following a release tag should use a version
number greater than that of the tag.  For example, the first commit after that
tagged "v0.6.1" has version 0.6.2.

For C, I mostly prefer the [Linux](https://www.kernel.org/) kernel style (as
expounded in Documentation/CodingStyle in the Linux source tree), except that
tab width should be 4 spaces.  Documentation in source code should usually be
line-wrapped at 70 characters (default in Emacs), but more importantly, lines of
code or comments should rarely exceed 80 characters in length.  README or other
plain text files describing nearby stuff are written in
[Markdown](http://daringfireball.net/projects/markdown/) and line-wrapped at 80
characters.  Many comments in the code (e.g., if beginning with `/**`) and `.md`
files under the `doc` directory are processed by [Doxygen]
(http://www.doxygen.org).  With [Emacs](http://www.gnu.org/software/emacs/) it
may be possible to achieve the correct line width and tab conventions by adding
the following to your `.emacs` configuration file.

    (add-hook 'rst-mode-hook
      '(lambda ()
	 (setq fill-column 80)))

    (add-hook 'c-mode-common-hook
	      '(lambda ()
		(c-add-style "scott-c-style" scott-c-style t)))

    (add-hook 'c++-mode-common-hook
      '(lambda ()
	(c-add-style "scott-c-style" scott-c-style t)))

    (setq scott-c-style
      '((tab-width . 4)
       (indent-tabs-mode . t)
       (c-basic-offset . 4)))
