#line 2 "../gotwebd/pages.tmpl"
/*
* Copyright (c) 2022 Omar Polo <op@openbsd.org>
* Copyright (c) 2016, 2019, 2020-2022 Tracey Emery <tracey@traceyemery.net>
*
* Permission to use, copy, modify, and distribute this software for any
* purpose with or without fee is hereby granted, provided that the above
* copyright notice and this permission notice appear in all copies.
*
* THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
* WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
* MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
* ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
* WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
* ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
* OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
*/
#line 19 "../gotwebd/pages.tmpl"
#include "got_compat.h"
#line 21 "../gotwebd/pages.tmpl"
#include <sys/types.h>
#include <sys/queue.h>
#include <sys/stat.h>
#line 25 "../gotwebd/pages.tmpl"
#include <ctype.h>
#include <event.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <imsg.h>
#line 33 "../gotwebd/pages.tmpl"
#include "got_error.h"
#include "got_object.h"
#include "got_reference.h"
#line 37 "../gotwebd/pages.tmpl"
#include "proc.h"
#line 39 "../gotwebd/pages.tmpl"
#include "gotwebd.h"
#include "tmpl.h"
#line 42 "../gotwebd/pages.tmpl"
static int gotweb_render_blob_line(struct template *, const char *, size_t);
static int gotweb_render_tree_item(struct template *, struct got_tree_entry *);
static int blame_line(struct template *, const char *, struct blame_line *,
int, int);
#line 47 "../gotwebd/pages.tmpl"
static inline int gotweb_render_more(struct template *, int);
#line 49 "../gotwebd/pages.tmpl"
static inline int diff_line(struct template *, char *);
static inline int tag_item(struct template *, struct repo_tag *);
static inline int branch(struct template *, struct got_reflist_entry *);
static inline int rss_tag_item(struct template *, struct repo_tag *);
static inline int rss_author(struct template *, char *);
#line 58 "../gotwebd/pages.tmpl"
int
gotweb_render_page(struct template *tp, int (*body)(struct template *))
{
int tp_ret = 0;
#line 60 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct server *srv = c->srv;
struct querystring *qs = c->t->qs;
struct gotweb_url u_path;
const char *prfx = c->document_uri;
const char *css = srv->custom_css;
#line 67 "../gotwebd/pages.tmpl"
memset(&u_path, 0, sizeof(u_path));
u_path.index_page = -1;
u_path.page = -1;
u_path.action = SUMMARY;
#line 76 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<!doctype html><html><head><meta charset=\"utf-8\" /><title>", 58)) == -1) goto err;
#line 76 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, srv->site_name)) == -1)
goto err;
#line 80 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</title><meta name=\"viewport\" content=\"initial-scale=1.0\" /><meta name=\"msapplication-TileColor\" content=\"#da532c\" /><meta name=\"theme-color\" content=\"#ffffff\"/><link rel=\"apple-touch-icon\" sizes=\"180x180\" href=\"", 212)) == -1) goto err;
#line 80 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, prfx)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "apple-touch-icon.png\" /><link rel=\"icon\" type=\"image/png\" sizes=\"32x32\" href=\"", 78)) == -1) goto err;
#line 81 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, prfx)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "favicon-32x32.png\" /><link rel=\"icon\" type=\"image/png\" sizes=\"16x16\" href=\"", 75)) == -1) goto err;
#line 82 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, prfx)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "favicon-16x16.png\" /><link rel=\"manifest\" href=\"", 48)) == -1) goto err;
#line 83 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, prfx)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "site.webmanifest\"/><link rel=\"mask-icon\" href=\"", 47)) == -1) goto err;
#line 84 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, prfx)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "safari-pinned-tab.svg\" /><link rel=\"stylesheet\" type=\"text/css\" href=\"", 70)) == -1) goto err;
#line 85 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, prfx)) == -1)
goto err;
#line 85 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, css)) == -1)
goto err;
#line 90 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\" /></head><body><header id=\"header\"><div id=\"got_link\"><a href=\"", 65)) == -1) goto err;
#line 90 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, srv->logo_url)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "\" target=\"_blank\"><img src=\"", 28)) == -1) goto err;
#line 91 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, prfx)) == -1)
goto err;
#line 91 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, srv->logo)) == -1)
goto err;
#line 97 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\" /></a></div></header><nav id=\"site_path\"><div id=\"site_link\"><a href=\"?index_page=", 84)) == -1) goto err;
#line 97 "../gotwebd/pages.tmpl"
if (asprintf(&tp->tp_tmp,  "%d", qs->index_page) == -1)
goto err;
if ((tp_ret = tp_htmlescape(tp, tp->tp_tmp)) == -1)
goto err;
free(tp->tp_tmp);
tp->tp_tmp = NULL;
if ((tp_ret = tp_write(tp, "\">", 2)) == -1) goto err;
#line 98 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, srv->site_link)) == -1)
goto err;
#line 100 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</a>", 4)) == -1) goto err;
#line 100 "../gotwebd/pages.tmpl"
if (qs->path) {
u_path.path = qs->path; 
if ((tp_ret = tp_htmlescape(tp, " / ")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 103 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(tp->tp_arg, &u_path)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">", 2)) == -1) goto err;
#line 104 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, qs->path)) == -1)
goto err;
#line 106 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</a>", 4)) == -1) goto err;
}
if (qs->action != INDEX) {
if ((tp_ret = tp_htmlescape(tp, " / ")) == -1)
goto err;
#line 108 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, gotweb_action_name(qs->action))) == -1)
goto err;
}
#line 113 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div></nav><main>", 18)) == -1) goto err;
#line 113 "../gotwebd/pages.tmpl"
if ((tp_ret = body(tp)) == -1) goto err;
#line 117 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</main><footer id=\"site_owner_wrapper\"><p id=\"site_owner\">", 58)) == -1) goto err;
#line 117 "../gotwebd/pages.tmpl"
if (srv->show_site_owner) {
if ((tp_ret = tp_htmlescape(tp, srv->site_owner)) == -1)
goto err;
}
#line 124 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</p></footer></body></html>", 27)) == -1) goto err;
err:
return tp_ret;
}
#line 126 "../gotwebd/pages.tmpl"
int
gotweb_render_error(struct template *tp)
{
int tp_ret = 0;
#line 128 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
#line 132 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div id=\"err_content\">", 22)) == -1) goto err;
#line 132 "../gotwebd/pages.tmpl"
if (t->error) {
if ((tp_ret = tp_htmlescape(tp, t->error->msg)) == -1)
goto err;
} else {
#line 136 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "See daemon logs for details", 27)) == -1) goto err;
}
#line 138 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div>", 6)) == -1) goto err;
err:
return tp_ret;
}
#line 140 "../gotwebd/pages.tmpl"
int
gotweb_render_repo_table_hdr(struct template *tp)
{
int tp_ret = 0;
#line 142 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct server *srv = c->srv;
#line 149 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div id=\"index_header\"><div class=\"index_project\">Project</div>", 63)) == -1) goto err;
#line 149 "../gotwebd/pages.tmpl"
if (srv->show_repo_description) {
#line 153 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div class=\"index_project_description\">Description</div>", 56)) == -1) goto err;
}
if (srv->show_repo_owner) {
#line 158 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div class=\"index_project_owner\">Owner</div>", 44)) == -1) goto err;
}
if (srv->show_repo_age) {
#line 163 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div class=\"index_project_age\">Last Change</div>", 48)) == -1) goto err;
}
#line 165 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div>", 6)) == -1) goto err;
err:
return tp_ret;
}
#line 167 "../gotwebd/pages.tmpl"
int
gotweb_render_repo_fragment(struct template *tp, struct repo_dir *repo_dir)
{
int tp_ret = 0;
#line 169 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct server *srv = c->srv;
struct gotweb_url summary = {
.action = SUMMARY,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
}, briefs = {
.action = BRIEFS,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
}, commits = {
.action = COMMITS,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
}, tags = {
.action = TAGS,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
}, tree = {
.action = TREE,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
}, rss = {
.action = RSS,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
};
#line 205 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div class=\"index_wrapper\"><div class=\"index_project\"><a href=\"", 63)) == -1) goto err;
#line 205 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(tp->tp_arg, &summary)) == -1) goto err;
#line 205 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">", 2)) == -1) goto err;
#line 205 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, repo_dir->name)) == -1)
goto err;
#line 207 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</a></div>", 10)) == -1) goto err;
#line 207 "../gotwebd/pages.tmpl"
if (srv->show_repo_description) {
#line 209 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div class=\"index_project_description\">", 39)) == -1) goto err;
#line 209 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, repo_dir->description)) == -1)
goto err;
#line 211 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div>", 6)) == -1) goto err;
}
if (srv->show_repo_owner) {
#line 214 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div class=\"index_project_owner\">", 33)) == -1) goto err;
#line 214 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, repo_dir->owner)) == -1)
goto err;
#line 216 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div>", 6)) == -1) goto err;
}
if (srv->show_repo_age) {
#line 219 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div class=\"index_project_age\">", 31)) == -1) goto err;
#line 219 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_age(tp, repo_dir->age, TM_DIFF)) == -1) goto err;
#line 221 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div>", 6)) == -1) goto err;
}
#line 224 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div class=\"navs_wrapper\"><div class=\"navs\"><a href=\"", 53)) == -1) goto err;
#line 224 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(tp->tp_arg, &summary)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">summary</a>", 13)) == -1) goto err;
#line 225 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 226 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(tp->tp_arg, &briefs)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">briefs</a>", 12)) == -1) goto err;
#line 227 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 228 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(tp->tp_arg, &commits)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">commits</a>", 13)) == -1) goto err;
#line 229 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 230 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(tp->tp_arg, &tags)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">tags</a>", 10)) == -1) goto err;
#line 231 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 232 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(tp->tp_arg, &tree)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">tree</a>", 10)) == -1) goto err;
#line 233 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 234 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(tp->tp_arg, &rss)) == -1) goto err;
#line 239 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">rss</a></div><hr /></div></div>", 33)) == -1) goto err;
err:
return tp_ret;
}
#line 241 "../gotwebd/pages.tmpl"
int
gotweb_render_briefs(struct template *tp)
{
int tp_ret = 0;
#line 243 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct querystring *qs = c->t->qs;
struct repo_commit *rc;
struct repo_dir *repo_dir = t->repo_dir;
struct gotweb_url diff_url, tree_url;
char *tmp;
#line 251 "../gotwebd/pages.tmpl"
diff_url = (struct gotweb_url){
.action = DIFF,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
.headref = qs->headref,
};
tree_url = (struct gotweb_url){
.action = TREE,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
.headref = qs->headref,
};
#line 270 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<header class='subtitle'><h2>Commit Briefs</h2></header><div id=\"briefs_content\">", 81)) == -1) goto err;
TAILQ_FOREACH(rc, &t->repo_commits, entry) {
#line 272 "../gotwebd/pages.tmpl"
diff_url.commit = rc->commit_id;
tree_url.commit = rc->commit_id;
#line 275 "../gotwebd/pages.tmpl"
tmp = strchr(rc->committer, '<');
if (tmp)
*tmp = '\0';
#line 279 "../gotwebd/pages.tmpl"
tmp = strchr(rc->commit_msg, '\n');
if (tmp)
*tmp = '\0';
#line 286 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div class='brief'><p class='brief_meta'><span class='briefs_age'>", 66)) == -1) goto err;
#line 286 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_age(tp, rc->committer_time, TM_DIFF)) == -1) goto err;
#line 288 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</span>", 7)) == -1) goto err;
#line 288 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " ")) == -1)
goto err;
#line 290 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<span class=\"briefs_author\">", 28)) == -1) goto err;
#line 290 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->committer)) == -1)
goto err;
#line 294 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</span></p><p class=\"briefs_log\"><a href=\"", 42)) == -1) goto err;
#line 294 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(tp->tp_arg, &diff_url)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">", 2)) == -1) goto err;
#line 295 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->commit_msg)) == -1)
goto err;
#line 297 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</a>", 4)) == -1) goto err;
#line 297 "../gotwebd/pages.tmpl"
if (rc->refs_str) {
if ((tp_ret = tp_htmlescape(tp, " ")) == -1)
goto err;
#line 298 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<span class=\"refs_str\">(", 24)) == -1) goto err;
#line 298 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->refs_str)) == -1)
goto err;
if ((tp_ret = tp_write(tp, ")</span>", 8)) == -1) goto err;
}
#line 305 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</a></p></div><div class=\"navs_wrapper\"><div class=\"navs\"><a href=\"", 67)) == -1) goto err;
#line 305 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(tp->tp_arg, &diff_url)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">diff</a>", 10)) == -1) goto err;
#line 306 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 307 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(tp->tp_arg, &tree_url)) == -1) goto err;
#line 311 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">tree</a></div></div><hr />", 28)) == -1) goto err;
}
if ((tp_ret = gotweb_render_more(tp, BRIEFS)) == -1) goto err;
#line 314 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div>", 6)) == -1) goto err;
err:
return tp_ret;
}
#line 316 "../gotwebd/pages.tmpl"
int
gotweb_render_more(struct template *tp, int action)
{
int tp_ret = 0;
#line 318 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct querystring *qs = t->qs;
struct gotweb_url more = {
.action = action,
.index_page = -1,
.path = qs->path,
.commit = t->more_id,
.headref = qs->headref,
.file = qs->file,
};
#line 330 "../gotwebd/pages.tmpl"
if (t->more_id) {
#line 333 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div id=\"np_wrapper\"><div id=\"nav_more\"><a href=\"", 49)) == -1) goto err;
#line 333 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &more)) == -1) goto err;
#line 338 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">More&nbsp;&darr;</a></div></div>", 34)) == -1) goto err;
}
err:
return tp_ret;
}
#line 341 "../gotwebd/pages.tmpl"
int
gotweb_render_navs(struct template *tp)
{
int tp_ret = 0;
#line 343 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct gotweb_url prev, next;
int have_prev, have_next;
#line 348 "../gotwebd/pages.tmpl"
gotweb_get_navs(c, &prev, &have_prev, &next, &have_next);
#line 352 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div id=\"np_wrapper\"><div id=\"nav_prev\">", 40)) == -1) goto err;
#line 352 "../gotwebd/pages.tmpl"
if (have_prev) {
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 353 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &prev)) == -1) goto err;
#line 356 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">Previous</a>", 14)) == -1) goto err;
}
#line 359 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div><div id=\"nav_next\">", 25)) == -1) goto err;
#line 359 "../gotwebd/pages.tmpl"
if (have_next) {
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 360 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &next)) == -1) goto err;
#line 363 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">Next</a>", 10)) == -1) goto err;
}
#line 366 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div></div>", 12)) == -1) goto err;
#line 366 "../gotwebd/pages.tmpl"
err:
#line 368 "../gotwebd/pages.tmpl"
free(t->next_id);
t->next_id = NULL;
free(t->prev_id);
t->prev_id = NULL;
return tp_ret;
}
#line 375 "../gotwebd/pages.tmpl"
int
gotweb_render_commits(struct template *tp)
{
int tp_ret = 0;
#line 377 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct repo_dir *repo_dir = t->repo_dir;
struct repo_commit *rc;
struct gotweb_url diff, tree;
#line 383 "../gotwebd/pages.tmpl"
diff = (struct gotweb_url){
.action = DIFF,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
};
tree = (struct gotweb_url){
.action = TREE,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
};
#line 400 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<header class=\"subtitle\"><h2>Commits</h2></header><div class=\"commits_content\">", 79)) == -1) goto err;
TAILQ_FOREACH(rc, &t->repo_commits, entry) {
#line 402 "../gotwebd/pages.tmpl"
diff.commit = rc->commit_id;
tree.commit = rc->commit_id;
#line 408 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div class=\"commits_header_wrapper\"><dl class=\"commits_header\"><dt>Commit:</dt><dd><code class=\"commit-id\">", 107)) == -1) goto err;
#line 408 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->commit_id)) == -1)
goto err;
#line 410 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</code></dd><dt>From:</dt><dd>", 30)) == -1) goto err;
#line 410 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->author)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "</dd>", 5)) == -1) goto err;
#line 411 "../gotwebd/pages.tmpl"
if (strcmp(rc->committer, rc->author) != 0) {
#line 413 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<dt>Via:</dt><dd>", 17)) == -1) goto err;
#line 413 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->committer)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "</dd>", 5)) == -1) goto err;
}
#line 417 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<dt>Date:</dt><dd>", 18)) == -1) goto err;
#line 417 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_age(tp, rc->committer_time, TM_LONG)) == -1) goto err;
#line 423 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dd></dl></div><hr /><div class=\"commit\">", 42)) == -1) goto err;
#line 423 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, "\n")) == -1)
goto err;
if ((tp_ret = tp_htmlescape(tp, rc->commit_msg)) == -1)
goto err;
#line 428 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div><div class=\"navs_wrapper\"><div class=\"navs\"><a href=\"", 59)) == -1) goto err;
#line 428 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &diff)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">diff</a>", 10)) == -1) goto err;
#line 429 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 430 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &tree)) == -1) goto err;
#line 434 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">tree</a></div></div><hr />", 28)) == -1) goto err;
}
if ((tp_ret = gotweb_render_more(tp, COMMITS)) == -1) goto err;
#line 437 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div>", 6)) == -1) goto err;
err:
return tp_ret;
}
#line 439 "../gotwebd/pages.tmpl"
int
gotweb_render_blob(struct template *tp)
{
int tp_ret = 0;
#line 441 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct got_blob_object *blob = t->blob;
struct repo_commit *rc = TAILQ_FIRST(&t->repo_commits);
#line 454 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<header class=\"subtitle\"><h2>Blob</h2></header><div id=\"blob_content\"><div id=\"blob_header_wrapper\"><dl id=\"blob_header\"><dt>Date:</dt><dd>", 139)) == -1) goto err;
#line 454 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_age(tp, rc->committer_time, TM_LONG)) == -1) goto err;
#line 457 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dd><dt>Message:</dt><dd class=\"commit-msg\">", 45)) == -1) goto err;
#line 457 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->commit_msg)) == -1)
goto err;
#line 463 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dd></dl></div><hr /><div id=\"blob\"><pre>", 42)) == -1) goto err;
#line 463 "../gotwebd/pages.tmpl"
if ((tp_ret = got_output_blob_by_lines(tp, blob, gotweb_render_blob_line)) == -1) goto err;
#line 467 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</pre></div></div>", 18)) == -1) goto err;
err:
return tp_ret;
}
#line 470 "../gotwebd/pages.tmpl"
int
gotweb_render_blob_line(struct template *tp, const char *line, size_t no)
{
int tp_ret = 0;
#line 472 "../gotwebd/pages.tmpl"
char lineno[16];
int r;
#line 475 "../gotwebd/pages.tmpl"
r = snprintf(lineno, sizeof(lineno), "%zu", no);
if (r < 0 || (size_t)r >= sizeof(lineno))
return -1;
#line 479 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div class=\"blob_line\" id=\"line", 31)) == -1) goto err;
#line 479 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, lineno)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "\"><a href=\"#line", 16)) == -1) goto err;
#line 480 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, lineno)) == -1)
goto err;
#line 480 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">", 2)) == -1) goto err;
#line 480 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, lineno)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "</a><span class=\"blob_code\">", 28)) == -1) goto err;
#line 481 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, line)) == -1)
goto err;
#line 483 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</span></div>", 13)) == -1) goto err;
err:
return tp_ret;
}
#line 485 "../gotwebd/pages.tmpl"
int
gotweb_render_tree(struct template *tp)
{
int tp_ret = 0;
#line 487 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct repo_commit *rc = TAILQ_FIRST(&t->repo_commits);
#line 498 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<header class='subtitle'><h2>Tree</h2></header><div id=\"tree_content\"><div id=\"tree_header_wrapper\"><dl id=\"tree_header\"><dt>Tree:</dt><dd><code class=\"commit-id\">", 163)) == -1) goto err;
#line 498 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->tree_id)) == -1)
goto err;
#line 501 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</code></dd><dt>Date:</dt><dd>", 30)) == -1) goto err;
#line 501 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_age(tp, rc->committer_time, TM_LONG)) == -1) goto err;
#line 504 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dd><dt>Message:</dt><dd class=\"commit-msg\">", 45)) == -1) goto err;
#line 504 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->commit_msg)) == -1)
goto err;
#line 509 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</d></dl></div><hr /><table id=\"tree\">", 38)) == -1) goto err;
#line 509 "../gotwebd/pages.tmpl"
if ((tp_ret = got_output_repo_tree(c, gotweb_render_tree_item)) == -1) goto err;
#line 512 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</table></div>", 14)) == -1) goto err;
err:
return tp_ret;
}
#line 515 "../gotwebd/pages.tmpl"
int
gotweb_render_tree_item(struct template *tp, struct got_tree_entry *te)
{
int tp_ret = 0;
#line 517 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct querystring *qs = t->qs;
struct repo_commit *rc = TAILQ_FIRST(&t->repo_commits);
const char *modestr = "";
const char *name;
const char *folder;
char *dir = NULL;
mode_t mode;
struct gotweb_url url = {
.index_page = -1,
.page = -1,
.commit = rc->commit_id,
.path = qs->path,
};
#line 533 "../gotwebd/pages.tmpl"
name = got_tree_entry_get_name(te);
mode = got_tree_entry_get_mode(te);
#line 536 "../gotwebd/pages.tmpl"
folder = qs->folder ? qs->folder : "";
if (S_ISDIR(mode)) {
if (asprintf(&dir, "%s/%s", folder, name) == -1)
return (-1);
#line 541 "../gotwebd/pages.tmpl"
url.action = TREE;
url.folder = dir;
} else {
url.action = BLOB;
url.folder = folder;
url.file = name;
}
#line 549 "../gotwebd/pages.tmpl"
if (got_object_tree_entry_is_submodule(te))
modestr = "$";
else if (S_ISLNK(mode))
modestr = "@";
else if (S_ISDIR(mode))
modestr = "/";
else if (mode & S_IXUSR)
modestr = "*";
#line 559 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<tr class=\"tree_wrapper\">", 25)) == -1) goto err;
#line 559 "../gotwebd/pages.tmpl"
if (S_ISDIR(mode)) {
#line 561 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<td class=\"tree_line\" colspan=2><a href=\"", 41)) == -1) goto err;
#line 561 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">", 2)) == -1) goto err;
#line 562 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, name)) == -1)
goto err;
#line 562 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, modestr)) == -1)
goto err;
#line 565 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</a></td>", 9)) == -1) goto err;
#line 565 "../gotwebd/pages.tmpl"
} else {
#line 567 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<td class=\"tree_line\"><a href=\"", 31)) == -1) goto err;
#line 567 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">", 2)) == -1) goto err;
#line 568 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, name)) == -1)
goto err;
#line 568 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, modestr)) == -1)
goto err;
#line 572 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</a></td><td class=\"tree_line_blank\">", 37)) == -1) goto err;
#line 572 "../gotwebd/pages.tmpl"
url.action = COMMITS; 
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 573 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
#line 576 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">commits</a>", 13)) == -1) goto err;
#line 576 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
url.action = BLAME; 
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 578 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
#line 582 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">blame</a></td>", 16)) == -1) goto err;
}
#line 584 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</tr>", 5)) == -1) goto err;
#line 584 "../gotwebd/pages.tmpl"
err:
#line 586 "../gotwebd/pages.tmpl"
free(dir);
return tp_ret;
}
#line 590 "../gotwebd/pages.tmpl"
int
gotweb_render_tags(struct template *tp)
{
int tp_ret = 0;
#line 592 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct querystring *qs = t->qs;
struct repo_tag *rt;
int commit_found;
#line 598 "../gotwebd/pages.tmpl"
commit_found = qs->commit == NULL;
#line 604 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<header class='subtitle'><h2>Tags</h2></header><div id=\"tags_content\">", 70)) == -1) goto err;
#line 604 "../gotwebd/pages.tmpl"
if (t->tag_count == 0) {
#line 608 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div id=\"err_content\">This repository contains no tags</div>", 60)) == -1) goto err;
#line 608 "../gotwebd/pages.tmpl"
} else {
TAILQ_FOREACH(rt, &t->repo_tags, entry) {
#line 610 "../gotwebd/pages.tmpl"
if (commit_found ||!strcmp(qs->commit, rt->commit_id)) {
commit_found = 1; 
if ((tp_ret = tag_item(tp, rt)) == -1) goto err;
}
}
#line 615 "../gotwebd/pages.tmpl"
if (t->next_id ||t->prev_id) {
qs->action = TAGS; 
if ((tp_ret = gotweb_render_navs(tp)) == -1) goto err;
}
}
#line 621 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div>", 6)) == -1) goto err;
err:
return tp_ret;
}
#line 623 "../gotwebd/pages.tmpl"
int
tag_item(struct template *tp, struct repo_tag *rt)
{
int tp_ret = 0;
#line 625 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct repo_dir *repo_dir = t->repo_dir;
char *tag_name = rt->tag_name;
char *msg = rt->tag_commit;
char *nl;
struct gotweb_url url = {
.action = TAG,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
.commit = rt->commit_id,
};
#line 639 "../gotwebd/pages.tmpl"
if (strncmp(tag_name, "refs/tags/", 10) == 0)
tag_name += 10;
#line 642 "../gotwebd/pages.tmpl"
if (msg) {
nl = strchr(msg, '\n');
if (nl)
*nl = '\0';
}
#line 649 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div class=\"tag_age\">", 21)) == -1) goto err;
#line 649 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_age(tp, rt->tagger_time, TM_DIFF)) == -1) goto err;
#line 651 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div><div class=\"tag_name\">", 28)) == -1) goto err;
#line 651 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, tag_name)) == -1)
goto err;
#line 653 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div><div class=\"tag_log\"><a href=\"", 36)) == -1) goto err;
#line 653 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">", 2)) == -1) goto err;
#line 654 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, msg)) == -1)
goto err;
#line 659 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</a></div><div class=\"navs_wrapper\"><div class=\"navs\"><a href=\"", 63)) == -1) goto err;
#line 659 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">tag</a>", 9)) == -1) goto err;
#line 660 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
url.action = BRIEFS; 
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 662 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">commit briefs</a>", 19)) == -1) goto err;
#line 663 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
url.action = COMMITS; 
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 665 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
#line 669 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">commits</a></div></div><hr />", 31)) == -1) goto err;
err:
return tp_ret;
}
#line 671 "../gotwebd/pages.tmpl"
int
gotweb_render_tag(struct template *tp)
{
int tp_ret = 0;
#line 673 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct repo_tag *rt;
const char *tag_name;
#line 678 "../gotwebd/pages.tmpl"
rt = TAILQ_LAST(&t->repo_tags, repo_tags_head);
tag_name = rt->tag_name;
#line 681 "../gotwebd/pages.tmpl"
if (strncmp(tag_name, "refs/", 5) == 0)
tag_name += 5;
#line 692 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<header class=\"subtitle\"><h2>Tag</h2></header><div id=\"tags_content\"><div id=\"tag_header_wrapper\"><dl id=\"tag_header\"><dt>Commit:</dt><dd><code class=\"commit-id\">", 162)) == -1) goto err;
#line 692 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rt->commit_id)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "</code>", 7)) == -1) goto err;
#line 693 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " ")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "<span class=\"refs_str\">(", 24)) == -1) goto err;
#line 694 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, tag_name)) == -1)
goto err;
#line 697 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, ")</span></dd><dt>Tagger:</dt><dd>", 33)) == -1) goto err;
#line 697 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rt->tagger)) == -1)
goto err;
#line 700 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dd><dt>Date:</dt><dd>", 23)) == -1) goto err;
#line 700 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_age(tp, rt->tagger_time, TM_LONG)) == -1) goto err;
#line 703 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dd><dt>Message:</dt><dd class=\"commit-msg\">", 45)) == -1) goto err;
#line 703 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rt->commit_msg)) == -1)
goto err;
#line 707 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dd></dl><hr /><pre id=\"tag_commit\">", 37)) == -1) goto err;
#line 707 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rt->tag_commit)) == -1)
goto err;
#line 711 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</pre></div></div>", 18)) == -1) goto err;
err:
return tp_ret;
}
#line 713 "../gotwebd/pages.tmpl"
int
gotweb_render_diff(struct template *tp)
{
int tp_ret = 0;
#line 715 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
FILE *fp = t->fp;
struct repo_commit *rc = TAILQ_FIRST(&t->repo_commits);
char *line = NULL;
size_t linesize = 0;
ssize_t linelen;
#line 730 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<header class=\"subtitle\"><h2>Commit Diff</h2></header><div id=\"diff_content\"><div id=\"diff_header_wrapper\"><dl id=\"diff_header\"><dt>Commit:</dt><dd><code class=\"commit-id\">", 172)) == -1) goto err;
#line 730 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->commit_id)) == -1)
goto err;
#line 732 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</code></dd><dt>From:</dt><dd>", 30)) == -1) goto err;
#line 732 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->author)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "</dd>", 5)) == -1) goto err;
#line 733 "../gotwebd/pages.tmpl"
if (strcmp(rc->committer, rc->author) != 0) {
#line 735 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<dt>Via:</dt><dd>", 17)) == -1) goto err;
#line 735 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->committer)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "</dd>", 5)) == -1) goto err;
}
#line 739 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<dt>Date:</dt><dd>", 18)) == -1) goto err;
#line 739 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_age(tp, rc->committer_time, TM_LONG)) == -1) goto err;
#line 742 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dd><dt>Message:</dt><dd class=\"commit-msg\">", 45)) == -1) goto err;
#line 742 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->commit_msg)) == -1)
goto err;
#line 747 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dd></dl></div><hr /><pre id=\"diff\">", 37)) == -1) goto err;
while ((linelen = getline(&line, &linesize, fp)) != -1) {
if ((tp_ret = diff_line(tp, line)) == -1) goto err;
}
#line 752 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</pre></div>", 12)) == -1) goto err;
#line 752 "../gotwebd/pages.tmpl"
err:
free(line); 
return tp_ret;
}
#line 756 "../gotwebd/pages.tmpl"
int
diff_line(struct template *tp, char *line )
{
int tp_ret = 0;
#line 758 "../gotwebd/pages.tmpl"
const char *color = NULL;
char *nl;
#line 761 "../gotwebd/pages.tmpl"
if (!strncmp(line, "-", 1))
color = "diff_minus";
else if (!strncmp(line, "+", 1))
color = "diff_plus";
else if (!strncmp(line, "@@", 2))
color = "diff_chunk_header";
else if (!strncmp(line, "commit +", 8) ||
!strncmp(line, "commit -", 8) ||
!strncmp(line, "blob +", 6) ||
!strncmp(line, "blob -", 6) ||
!strncmp(line, "file +", 6) ||
!strncmp(line, "file -", 6))
color = "diff_meta";
else if (!strncmp(line, "from:", 5) || !strncmp(line, "via:", 4))
color = "diff_author";
else if (!strncmp(line, "date:", 5))
color = "diff_date";
#line 779 "../gotwebd/pages.tmpl"
nl = strchr(line, '\n');
if (nl)
*nl = '\0';
#line 783 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<span class=\"diff_line ", 23)) == -1) goto err;
#line 783 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, color)) == -1)
goto err;
#line 783 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">", 2)) == -1) goto err;
#line 783 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, line)) == -1)
goto err;
#line 783 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</span>", 7)) == -1) goto err;
#line 783 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, "\n")) == -1)
goto err;
err:
return tp_ret;
}
#line 787 "../gotwebd/pages.tmpl"
int
gotweb_render_branches(struct template *tp, struct got_reflist_head *refs)
{
int tp_ret = 0;
#line 789 "../gotwebd/pages.tmpl"
struct got_reflist_entry *re;
#line 795 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<header class='subtitle'><h2>Branches</h2></header><div id=\"branches_content\">", 78)) == -1) goto err;
TAILQ_FOREACH(re, refs, entry) {
if (!got_ref_is_symbolic(re->ref)) {
if ((tp_ret = branch(tp, re)) == -1) goto err;
}
}
#line 801 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div>", 6)) == -1) goto err;
err:
return tp_ret;
}
#line 803 "../gotwebd/pages.tmpl"
int
branch(struct template *tp, struct got_reflist_entry *re)
{
int tp_ret = 0;
#line 805 "../gotwebd/pages.tmpl"
const struct got_error *err;
struct request *c = tp->tp_arg;
struct querystring *qs = c->t->qs;
const char *refname;
time_t age;
struct gotweb_url url = {
.action = SUMMARY,
.index_page = -1,
.page = -1,
.path = qs->path,
};
#line 817 "../gotwebd/pages.tmpl"
refname = got_ref_get_name(re->ref);
#line 819 "../gotwebd/pages.tmpl"
err = got_get_repo_age(&age, c, refname);
if (err) {
log_warnx("%s: %s", __func__, err->msg);
return -1;
}
#line 825 "../gotwebd/pages.tmpl"
if (strncmp(refname, "refs/heads/", 11) == 0)
refname += 11;
#line 828 "../gotwebd/pages.tmpl"
url.headref = refname;
#line 832 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<section class=\"branches_wrapper\"><div class=\"branches_age\">", 60)) == -1) goto err;
#line 832 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_age(tp, age, TM_DIFF)) == -1) goto err;
#line 835 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div><div class=\"branch\"><a href=\"", 35)) == -1) goto err;
#line 835 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
#line 835 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">", 2)) == -1) goto err;
#line 835 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, refname)) == -1)
goto err;
#line 839 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</a></div><div class=\"navs_wrapper\"><div class=\"navs\"><a href=\"", 63)) == -1) goto err;
#line 839 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">summary</a>", 13)) == -1) goto err;
#line 840 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
url.action = BRIEFS; 
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 842 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">commit briefs</a>", 19)) == -1) goto err;
#line 843 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
url.action = COMMITS; 
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 845 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
#line 850 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">commits</a></div></div><hr /></section>", 41)) == -1) goto err;
err:
return tp_ret;
}
#line 852 "../gotwebd/pages.tmpl"
int
gotweb_render_summary(struct template *tp)
{
int tp_ret = 0;
#line 854 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct server *srv = c->srv;
struct transport *t = c->t;
struct got_reflist_head *refs = &t->refs;
#line 860 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<dl id=\"summary_wrapper\">", 25)) == -1) goto err;
#line 860 "../gotwebd/pages.tmpl"
if (srv->show_repo_description) {
#line 862 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<dt>Description:</dt><dd>", 25)) == -1) goto err;
#line 862 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, t->repo_dir->description)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "</dd>", 5)) == -1) goto err;
}
if (srv->show_repo_owner) {
#line 866 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<dt>Owner:</dt><dd>", 19)) == -1) goto err;
#line 866 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, t->repo_dir->owner)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "</dd>", 5)) == -1) goto err;
}
if (srv->show_repo_age) {
#line 871 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<dt>Last Change:</dt><dd>", 25)) == -1) goto err;
#line 871 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_age(tp, t->repo_dir->age, TM_DIFF)) == -1) goto err;
#line 873 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dd>", 5)) == -1) goto err;
}
if (srv->show_repo_cloneurl) {
#line 876 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<dt>Clone URL:</dt><dd><pre class=\"clone-url\">", 46)) == -1) goto err;
#line 876 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, t->repo_dir->url)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "</pre></dd>", 11)) == -1) goto err;
}
#line 879 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dl>", 5)) == -1) goto err;
#line 879 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_briefs(tp)) == -1) goto err;
if ((tp_ret = gotweb_render_tags(tp)) == -1) goto err;
if ((tp_ret = gotweb_render_branches(tp, refs)) == -1) goto err;
err:
return tp_ret;
}
#line 884 "../gotwebd/pages.tmpl"
int
gotweb_render_blame(struct template *tp)
{
int tp_ret = 0;
#line 886 "../gotwebd/pages.tmpl"
const struct got_error *err;
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct repo_commit *rc = TAILQ_FIRST(&t->repo_commits);
#line 899 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<header class=\"subtitle\"><h2>Blame</h2></header><div id=\"blame_content\"><div id=\"blame_header_wrapper\"><dl id=\"blame_header\"><dt>Date:</dt><dd>", 143)) == -1) goto err;
#line 899 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_age(tp, rc->committer_time, TM_LONG)) == -1) goto err;
#line 902 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dd><dt>Message:</dt><dd class=\"commit-msg\">", 45)) == -1) goto err;
#line 902 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->commit_msg)) == -1)
goto err;
#line 907 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dd></dl></div><hr /><pre id=\"blame\">", 38)) == -1) goto err;
err = got_output_file_blame(c, &blame_line);
if (err && err->code != GOT_ERR_CANCELLED)
log_warnx("%s: got_output_file_blame: %s", __func__,
err->msg);
if (err)
return (-1);
#line 917 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</pre></div>", 12)) == -1) goto err;
err:
return tp_ret;
}
#line 920 "../gotwebd/pages.tmpl"
int
blame_line(struct template *tp, const char *line, struct blame_line *bline, int lprec, int lcur)
{
int tp_ret = 0;
#line 922 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct repo_dir *repo_dir = t->repo_dir;
char *committer, *s;
struct gotweb_url url = {
.action = DIFF,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
.commit = bline->id_str,
};
#line 934 "../gotwebd/pages.tmpl"
s = strchr(bline->committer, '<');
committer = s ? s + 1 : bline->committer;
#line 937 "../gotwebd/pages.tmpl"
s = strchr(committer, '@');
if (s)
*s = '\0';
#line 942 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div class=\"blame_wrapper\"><div class=\"blame_number\">", 53)) == -1) goto err;
#line 942 "../gotwebd/pages.tmpl"
if (asprintf(&tp->tp_tmp,  "%.*d", lprec, lcur) == -1)
goto err;
if ((tp_ret = tp_htmlescape(tp, tp->tp_tmp)) == -1)
goto err;
free(tp->tp_tmp);
tp->tp_tmp = NULL;
#line 944 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div><div class=\"blame_hash\"><a href=\"", 39)) == -1) goto err;
#line 944 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">", 2)) == -1) goto err;
#line 945 "../gotwebd/pages.tmpl"
if (asprintf(&tp->tp_tmp,  "%.8s", bline->id_str) == -1)
goto err;
if ((tp_ret = tp_htmlescape(tp, tp->tp_tmp)) == -1)
goto err;
free(tp->tp_tmp);
tp->tp_tmp = NULL;
#line 948 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</a></div><div class=\"blame_date\">", 34)) == -1) goto err;
#line 948 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, bline->datebuf)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "</div><div class=\"blame_author\">", 32)) == -1) goto err;
#line 949 "../gotwebd/pages.tmpl"
if (asprintf(&tp->tp_tmp,  "%.9s", committer) == -1)
goto err;
if ((tp_ret = tp_htmlescape(tp, tp->tp_tmp)) == -1)
goto err;
free(tp->tp_tmp);
tp->tp_tmp = NULL;
if ((tp_ret = tp_write(tp, "</div><div class=\"blame_code\">", 30)) == -1) goto err;
#line 950 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, line)) == -1)
goto err;
#line 952 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div></div>", 12)) == -1) goto err;
err:
return tp_ret;
}
#line 954 "../gotwebd/pages.tmpl"
int
gotweb_render_rss(struct template *tp)
{
int tp_ret = 0;
#line 956 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct server *srv = c->srv;
struct transport *t = c->t;
struct repo_dir *repo_dir = t->repo_dir;
struct repo_tag *rt;
struct gotweb_url summary = {
.action = SUMMARY,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
};
#line 971 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<?xml version=\"1.0\" encoding=\"UTF-8\"?><rss version=\"2.0\" xmlns:content=\"http://purl.org/rss/1.0/modules/content/\"><channel><title>Tags of ", 138)) == -1) goto err;
#line 971 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, repo_dir->name)) == -1)
goto err;
#line 974 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</title><link><![CDATA[", 23)) == -1) goto err;
#line 974 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_absolute_url(c, &summary)) == -1) goto err;
#line 977 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "]]></link>", 10)) == -1) goto err;
#line 977 "../gotwebd/pages.tmpl"
if (srv->show_repo_description) {
if ((tp_ret = tp_write(tp, "<description>", 13)) == -1) goto err;
#line 978 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, repo_dir->description)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "</description>", 14)) == -1) goto err;
}
TAILQ_FOREACH(rt, &t->repo_tags, entry) {
#line 981 "../gotwebd/pages.tmpl"
if ((tp_ret = rss_tag_item(tp, rt)) == -1) goto err;
}
#line 985 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</channel></rss>", 16)) == -1) goto err;
err:
return tp_ret;
}
#line 987 "../gotwebd/pages.tmpl"
int
rss_tag_item(struct template *tp, struct repo_tag *rt)
{
int tp_ret = 0;
#line 989 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct repo_dir *repo_dir = t->repo_dir;
char *tag_name = rt->tag_name;
struct gotweb_url tag = {
.action = TAG,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
.commit = rt->commit_id,
};
#line 1001 "../gotwebd/pages.tmpl"
if (strncmp(tag_name, "refs/tags/", 10) == 0)
tag_name += 10;
#line 1005 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<item><title>", 13)) == -1) goto err;
#line 1005 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, repo_dir->name)) == -1)
goto err;
#line 1005 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " ")) == -1)
goto err;
#line 1005 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, tag_name)) == -1)
goto err;
#line 1008 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</title><link><![CDATA[", 23)) == -1) goto err;
#line 1008 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_absolute_url(c, &tag)) == -1) goto err;
#line 1012 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "]]></link><description><![CDATA[<pre>", 37)) == -1) goto err;
#line 1012 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rt->tag_commit)) == -1)
goto err;
#line 1014 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</pre>]]></description>", 23)) == -1) goto err;
#line 1014 "../gotwebd/pages.tmpl"
if ((tp_ret = rss_author(tp, rt->tagger)) == -1) goto err;
if ((tp_ret = tp_write(tp, "<guid isPermaLink=\"false\">", 26)) == -1) goto err;
#line 1015 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rt->commit_id)) == -1)
goto err;
#line 1017 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</guid><pubDate>", 16)) == -1) goto err;
#line 1017 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_age(tp, rt->tagger_time, TM_RFC822)) == -1) goto err;
#line 1020 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</pubDate></item>", 17)) == -1) goto err;
err:
return tp_ret;
}
#line 1022 "../gotwebd/pages.tmpl"
int
rss_author(struct template *tp, char *author)
{
int tp_ret = 0;
#line 1024 "../gotwebd/pages.tmpl"
char *t, *mail;
#line 1026 "../gotwebd/pages.tmpl"
/* what to do if the author name contains a paren? */
if (strchr(author, '(') != NULL || strchr(author, ')') != NULL)
return 0;
#line 1030 "../gotwebd/pages.tmpl"
t = strchr(author, '<');
if (t == NULL)
return 0;
*t = '\0';
mail = t+1;
#line 1036 "../gotwebd/pages.tmpl"
while (isspace((unsigned char)*--t))
*t = '\0';
#line 1039 "../gotwebd/pages.tmpl"
t = strchr(mail, '>');
if (t == NULL)
return 0;
*t = '\0';
#line 1045 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<author>", 8)) == -1) goto err;
#line 1045 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, mail)) == -1)
goto err;
#line 1045 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " ")) == -1)
goto err;
#line 1045 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "(", 1)) == -1) goto err;
#line 1045 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, author)) == -1)
goto err;
#line 1047 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, ")</author>", 10)) == -1) goto err;
err:
return tp_ret;
}
