"""Generated message classes for oracledatabase version v1alpha.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'oracledatabase'


class AllConnectionStrings(_messages.Message):
  r"""Represents all connection strings that can be used to connect to the
  Autonomous Database.

  Fields:
    high: Output only. The database service provides the highest level of
      resources to each SQL statement.
    low: Output only. The Low database service provides the least level of
      resources to each SQL statement
    medium: Output only. The Medium database service provides a lower level of
      resources to each SQL statement
  """

  high = _messages.StringField(1)
  low = _messages.StringField(2)
  medium = _messages.StringField(3)


class AutonomousDatabase(_messages.Message):
  r"""Details of the Autonomous Database resource. https://docs.oracle.com/en-
  us/iaas/api/#/en/database/20160918/AutonomousDatabase/

  Messages:
    LabelsValue: Optional. labels or tags associated with the resource.

  Fields:
    adminPassword: Optional. Password for the default ADMIN user.
    database: Optional. The name of the Autonomous Database. The database name
      must be unique in the tenancy. The name must begin with an alphabetic
      character and can contain a maximum of 30 alphanumeric characters.
    displayName: Optional. User friendly name for the Autonomous Database. The
      name does not have to be unique.
    entitlementId: Output only. Entitlement ID of the private offer against
      which this autonomous database is provisioned.
    labels: Optional. labels or tags associated with the resource.
    name: Identifier. The name of the Autonomous Database resource with the
      format: projects/{project}/locations/{region}/autonomousDatabases/{auton
      omous_database} https://google.aip.dev/122
    properties: Optional. Various properties of the database.
    zone: Optional. Zone where the DB resides.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. labels or tags associated with the resource.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  adminPassword = _messages.StringField(1)
  database = _messages.StringField(2)
  displayName = _messages.StringField(3)
  entitlementId = _messages.StringField(4)
  labels = _messages.MessageField('LabelsValue', 5)
  name = _messages.StringField(6)
  properties = _messages.MessageField('AutonomousDatabaseProperties', 7)
  zone = _messages.StringField(8)


class AutonomousDatabaseApex(_messages.Message):
  r"""Oracle APEX Application Development. https://docs.oracle.com/en-
  us/iaas/api/#/en/database/20160918/datatypes/AutonomousDatabaseApex

  Fields:
    apexVersion: Output only. The Oracle APEX Application Development version.
    ordsVersion: Output only. The Oracle REST Data Services (ORDS) version.
  """

  apexVersion = _messages.StringField(1)
  ordsVersion = _messages.StringField(2)


class AutonomousDatabaseCharacterSet(_messages.Message):
  r"""Details of the Autonomous Database character set resource.
  https://docs.oracle.com/en-
  us/iaas/api/#/en/database/20160918/AutonomousDatabaseCharacterSets/

  Enums:
    CharacterSetTypeValueValuesEnum: Output only. An Oracle character set for
      Autonomous Database.

  Fields:
    characterSetType: Output only. An Oracle character set for Autonomous
      Database.
    name: Identifier. The name of the Autonomous Database Character Set
      resource with the format: projects/{project}/locations/{region}/autonomo
      usDatabaseCharacterSets/{autonomous_database_character_set}
      https://google.aip.dev/122
  """

  class CharacterSetTypeValueValuesEnum(_messages.Enum):
    r"""Output only. An Oracle character set for Autonomous Database.

    Values:
      CHARACTER_SET_TYPE_UNSPECIFIED: Character set type is not specified.
      DATABASE: Character set type as database.
      NATIONAL: Character set type as national.
    """
    CHARACTER_SET_TYPE_UNSPECIFIED = 0
    DATABASE = 1
    NATIONAL = 2

  characterSetType = _messages.EnumField('CharacterSetTypeValueValuesEnum', 1)
  name = _messages.StringField(2)


class AutonomousDatabaseConnectionStrings(_messages.Message):
  r"""The connection string used to connect to the Autonomous Database.
  https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/datatypes/Auto
  nomousDatabaseConnectionStrings

  Fields:
    allConnectionStrings: Output only. Returns all connection strings that can
      be used to connect to the Autonomous Database.
    dedicated: Output only. The database service provides the least level of
      resources to each SQL statement, but supports the most number of
      concurrent SQL statements.
    high: Output only. The database service provides the highest level of
      resources to each SQL statement.
    low: Output only. The Low database service provides the least level of
      resources to each SQL statement
    medium: Output only. The Medium database service provides a lower level of
      resources to each SQL statement
    profiles: Output only. A list of connection string profiles to allow
      clients to group, filter and select connection string values based on
      structured metadata.
  """

  allConnectionStrings = _messages.MessageField('AllConnectionStrings', 1)
  dedicated = _messages.StringField(2)
  high = _messages.StringField(3)
  low = _messages.StringField(4)
  medium = _messages.StringField(5)
  profiles = _messages.MessageField('DatabaseConnectionStringProfile', 6, repeated=True)


class AutonomousDatabaseConnectionUrls(_messages.Message):
  r"""The URLs for accessing Oracle Application Express (APEX) and SQL
  Developer Web with a browser from a Compute instance.
  https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/datatypes/Auto
  nomousDatabaseConnectionUrls

  Fields:
    apexUri: Output only. Oracle Application Express (APEX) URL.
    databaseTransformsUri: Output only. The URL of the Database Transforms for
      the Autonomous Database.
    graphStudioUri: Output only. The URL of the Graph Studio for the
      Autonomous Database.
    machineLearningNotebookUri: Output only. The URL of the Oracle Machine
      Learning (OML) Notebook for the Autonomous Database.
    machineLearningUserManagementUri: Output only. Oracle Machine Learning
      user management URL.
    mongoDbUri: Output only. The URL of the MongoDB API for the Autonomous
      Database.
    ordsUri: Output only. The Oracle REST Data Services (ORDS) URL of the Web
      Access for the Autonomous Database.
    sqlDevWebUri: Output only. Oracle SQL Developer Web URL.
  """

  apexUri = _messages.StringField(1)
  databaseTransformsUri = _messages.StringField(2)
  graphStudioUri = _messages.StringField(3)
  machineLearningNotebookUri = _messages.StringField(4)
  machineLearningUserManagementUri = _messages.StringField(5)
  mongoDbUri = _messages.StringField(6)
  ordsUri = _messages.StringField(7)
  sqlDevWebUri = _messages.StringField(8)


class AutonomousDatabaseProperties(_messages.Message):
  r"""Various properties of AutonomousDatabase.

  Enums:
    DataSafeStateValueValuesEnum: Output only. State of the Data Safe
      registration for this Autonomous Database.
    DatabaseManagementStateValueValuesEnum: Output only. State of Database
      Management for this Autonomous Database.
    DbEditionValueValuesEnum: Optional. The Oracle Database Edition that
      applies to the Autonomous databases.
    DbWorkloadValueValuesEnum: Required. The Autonomous Database workload
      type.
    LicenseTypeValueValuesEnum: Required. License type of the autonomous
      database
    LocalDisasterRecoveryTypeValueValuesEnum: Output only. Indicates the local
      disaster recovery (DR) type of the Autonomous Database Serverless
      instance.
    MaintenanceScheduleTypeValueValuesEnum: Optional. The maintenance schedule
      type of the Autonomous Database Serverless.
    OpenModeValueValuesEnum: Output only. Indicates the Autonomous Database
      mode.
    OperationsInsightsStateValueValuesEnum: Output only. State of Operations
      Insights for this Autonomous Database.
    PermissionLevelValueValuesEnum: Output only. The Autonomous Database
      permission level.
    RefreshableModeValueValuesEnum: Output only. The refresh mode of the
      clone.
    RefreshableStateValueValuesEnum: Output only. The refresh State of the
      clone.
    RoleValueValuesEnum: Output only. The Data Guard role of the ADB.
    StateValueValuesEnum: Output only. The current lifecycle state of the
      Autonomous Database.

  Fields:
    actualUsedDataStorageSizeTb: Output only. The current amount of storage in
      use for user and system data, in terabytes.
    allocatedStorageSizeTb: Output only. The amount of storage currently
      allocated for the database tables and billed for, rounded up.
    allowlistedIps: Optional. The client IP access control list (ACL).
    apexDetails: Output only. Information about Oracle APEX Application
      Development.
    arePrimaryWhitelistedIpsUsed: Output only. This field will be null if the
      Autonomous Database is not Data Guard enabled or Access Control is
      disabled. Its value would be TRUE if Autonomous Database is Data Guard
      enabled and Access Control is enabled and if the Autonomous Database
      uses primary IP access control list (ACL) for standby. Its value would
      be FALSE if Autonomous Database is Data Guard enabled and Access Control
      is enabled and if the Autonomous Database uses different IP access
      control list (ACL) for standby compared to primary.
    autonomousContainerDatabaseId: Output only. The Autonomous Container
      Database OCID.
    availableUpgradeVersions: Output only. List of Oracle Database versions
      available for a database upgrade.
    characterSet: Optional. The character set for the autonomous database. The
      default is AL32UTF8.
    computeCount: Optional. The number of compute servers for the autonomous
      database.
    connectionStrings: Output only. The connection strings used to connect to
      the Autonomous Database.
    connectionUrls: Output only. Oracle Connection URLS.
    cpuCoreCount: Optional. The number of CPU cores to be made available to
      the database.
    createTime: Output only. The date and time the Autonomous Database was
      created.
    customerContacts: Optional. The list of customer contacts.
    dataSafeState: Output only. State of the Data Safe registration for this
      Autonomous Database.
    dataStorageSizeTb: Optional. The quantity of data in the database, in
      terabytes.
    databaseManagementState: Output only. State of Database Management for
      this Autonomous Database.
    dbEdition: Optional. The Oracle Database Edition that applies to the
      Autonomous databases.
    dbVersion: Optional. A valid Oracle Database version for Autonomous
      Database.
    dbWorkload: Required. The Autonomous Database workload type.
    failedDataRecoveryDuration: Output only. Indicates the number of seconds
      of data loss for a Data Guard failover.
    isAccessControlEnabled: Optional. Indicates if the database-level access
      control is enabled.
    isAutoScalingEnabled: Optional. Indicates if auto scaling is enabled for
      the Autonomous Database CPU core count.
    isLocalDataGuardEnabled: Output only. Indicates whether the Autonomous
      Database has local (in-region) Data Guard enabled.
    isMtlsConnectionRequired: Output only. Specifies if the Autonomous
      Database requires mTLS connections.
    isStorageAutoScalingEnabled: Optional. Indicates if auto scaling is
      enabled for the Autonomous Database storage.
    licenseType: Required. License type of the autonomous database
    lifecycleDetails: Output only. Information about the current lifecycle
      state.
    localAdgAutoFailoverMaxDataLossLimit: Output only. Parameter represents an
      acceptable maximum data loss limit in seconds
    localDisasterRecoveryType: Output only. Indicates the local disaster
      recovery (DR) type of the Autonomous Database Serverless instance.
    localStandbyDb: Output only. Autonomous Data Guard standby database
      details.
    maintenanceScheduleType: Optional. The maintenance schedule type of the
      Autonomous Database Serverless.
    memoryPerOracleComputeUnitGbs: Output only. The amount of memory (in GBs)
      enabled per ECPU.
    memoryTableGbs: Output only. The area assigned to In-Memory tables in
      Autonomous Database.
    nCharacterSet: Optional. The national character set for the autonomous
      database. The default is AL16UTF16.
    ocid: Output only. OCID of the autonomous database.
      https://docs.oracle.com/en-
      us/iaas/Content/General/Concepts/identifiers.htm#Oracle
    openMode: Output only. Indicates the Autonomous Database mode.
    operationsInsightsState: Output only. State of Operations Insights for
      this Autonomous Database.
    peerDbIds: Output only. The list of OCIDs of standby databases located in
      Autonomous Data Guard remote regions that are associated with the source
      database.
    permissionLevel: Output only. The Autonomous Database permission level.
    privateEndpoint: Output only. The private endpoint for the resource.
    privateEndpointIp: Optional. The private endpoint IP address for the
      resource.
    privateEndpointLabel: Optional. The resource's private endpoint label.
    refreshableMode: Output only. The refresh mode of the clone.
    refreshableState: Output only. The refresh State of the clone.
    role: Output only. The Data Guard role of the ADB.
    scheduledOperations: Output only. The list of scheduled operations.
      Consists of values such as dayOfWeek, scheduledStartTime,
      scheduledStopTime.
    secretId: Optional. The OCI vault secret.
    sqlWebDeveloperUrl: Output only. The SQL Web Developer URL for the Oracle
      Autonomous Database.
    state: Output only. The current lifecycle state of the Autonomous
      Database.
    supportedCloneRegions: Output only. The list of regions that support the
      creation of an Autonomous Database clone.
    usedDataStorageSizeTbs: Output only. The storage space consumed by
      Autonomous Database in GBs.
    vaultId: Optional. The vault id of the Oracle Cloud Infrastructure.
  """

  class DataSafeStateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the Data Safe registration for this Autonomous
    Database.

    Values:
      DATA_SAFE_STATE_UNSPECIFIED: Default unspecified value.
      REGISTERING: Registering data safe state
      REGISTERED: Registered data safe state
      DEREGISTERING: Deregistering data safe state
      NOT_REGISTERED: Not registered data safe state
      FAILED: Failed data safe state
    """
    DATA_SAFE_STATE_UNSPECIFIED = 0
    REGISTERING = 1
    REGISTERED = 2
    DEREGISTERING = 3
    NOT_REGISTERED = 4
    FAILED = 5

  class DatabaseManagementStateValueValuesEnum(_messages.Enum):
    r"""Output only. State of Database Management for this Autonomous
    Database.

    Values:
      DATABASE_MANAGEMENT_STATE_UNSPECIFIED: Default unspecified value.
      ENABLING: Enabling Database Management state
      ENABLED: Enabled Database Management state
      DISABLING: Disabling Database Management state
      NOT_ENABLED: Not Enabled Database Management state
      FAILED_ENABLING: Failed enabling Database Management state
      FAILED_DISABLING: Failed disabling Database Management state
    """
    DATABASE_MANAGEMENT_STATE_UNSPECIFIED = 0
    ENABLING = 1
    ENABLED = 2
    DISABLING = 3
    NOT_ENABLED = 4
    FAILED_ENABLING = 5
    FAILED_DISABLING = 6

  class DbEditionValueValuesEnum(_messages.Enum):
    r"""Optional. The Oracle Database Edition that applies to the Autonomous
    databases.

    Values:
      DATABASE_EDITION_UNSPECIFIED: Default unspecified value.
      STANDARD_EDITION: Standard Database Edition
      ENTERPRISE_EDITION: Enterprise Database Edition
    """
    DATABASE_EDITION_UNSPECIFIED = 0
    STANDARD_EDITION = 1
    ENTERPRISE_EDITION = 2

  class DbWorkloadValueValuesEnum(_messages.Enum):
    r"""Required. The Autonomous Database workload type.

    Values:
      DB_WORKLOAD_UNSPECIFIED: Default unspecified value.
      OLTP: Autonomous Transaction Processing database
      DW: Autonomous Data Warehouse database
      AJD: Autonomous JSON Database
      APEX: Autonomous Database with the Oracle APEX Application Development
        workload type
    """
    DB_WORKLOAD_UNSPECIFIED = 0
    OLTP = 1
    DW = 2
    AJD = 3
    APEX = 4

  class LicenseTypeValueValuesEnum(_messages.Enum):
    r"""Required. License type of the autonomous database

    Values:
      LICENSE_TYPE_UNSPECIFIED: Unspecified
      LICENSE_INCLUDED: License included part of offer
      BRING_YOUR_OWN_LICENSE: Bring your own license
    """
    LICENSE_TYPE_UNSPECIFIED = 0
    LICENSE_INCLUDED = 1
    BRING_YOUR_OWN_LICENSE = 2

  class LocalDisasterRecoveryTypeValueValuesEnum(_messages.Enum):
    r"""Output only. Indicates the local disaster recovery (DR) type of the
    Autonomous Database Serverless instance.

    Values:
      LOCAL_DISASTER_RECOVERY_TYPE_UNSPECIFIED: Default unspecified value.
      ADG: Autonomous Data Guard recovery.
      BACKUP_BASED: Backup based recovery.
    """
    LOCAL_DISASTER_RECOVERY_TYPE_UNSPECIFIED = 0
    ADG = 1
    BACKUP_BASED = 2

  class MaintenanceScheduleTypeValueValuesEnum(_messages.Enum):
    r"""Optional. The maintenance schedule type of the Autonomous Database
    Serverless.

    Values:
      MAINTENANCE_SCHEDULE_TYPE_UNSPECIFIED: Default unspecified value.
      EARLY: An EARLY maintenance schedule follows a schedule applying patches
        prior to the REGULAR schedule.
      REGULAR: A REGULAR maintenance schedule follows the normal cycle
    """
    MAINTENANCE_SCHEDULE_TYPE_UNSPECIFIED = 0
    EARLY = 1
    REGULAR = 2

  class OpenModeValueValuesEnum(_messages.Enum):
    r"""Output only. Indicates the Autonomous Database mode.

    Values:
      OPEN_MODE_UNSPECIFIED: Default unspecified value.
      READ_ONLY: Read Only Mode
      READ_WRITE: Read Write Mode
    """
    OPEN_MODE_UNSPECIFIED = 0
    READ_ONLY = 1
    READ_WRITE = 2

  class OperationsInsightsStateValueValuesEnum(_messages.Enum):
    r"""Output only. State of Operations Insights for this Autonomous
    Database.

    Values:
      OPERATIONS_INSIGHTS_STATE_UNSPECIFIED: Default unspecified value.
      ENABLING: Enabling status for operation insights
      ENABLED: Enabled status for operation insights
      DISABLING: Disabling status for operation insights
      NOT_ENABLED: Not Enabled status for operation insights
      FAILED_ENABLING: Failed enabling status for operation insights
      FAILED_DISABLING: Failed disabling status for operation insights
    """
    OPERATIONS_INSIGHTS_STATE_UNSPECIFIED = 0
    ENABLING = 1
    ENABLED = 2
    DISABLING = 3
    NOT_ENABLED = 4
    FAILED_ENABLING = 5
    FAILED_DISABLING = 6

  class PermissionLevelValueValuesEnum(_messages.Enum):
    r"""Output only. The Autonomous Database permission level.

    Values:
      PERMISSION_LEVEL_UNSPECIFIED: Default unspecified value.
      RESTRICTED: Restricted mode allows access only by admin users.
      UNRESTRICTED: Normal access.
    """
    PERMISSION_LEVEL_UNSPECIFIED = 0
    RESTRICTED = 1
    UNRESTRICTED = 2

  class RefreshableModeValueValuesEnum(_messages.Enum):
    r"""Output only. The refresh mode of the clone.

    Values:
      REFRESHABLE_MODE_UNSPECIFIED: Default unspecified value.
      AUTOMATIC: AUTOMATIC indicates that the clone is automatically being
        refreshed with data from the source Autonomous Database.
      MANUAL: Manual refresh.
    """
    REFRESHABLE_MODE_UNSPECIFIED = 0
    AUTOMATIC = 1
    MANUAL = 2

  class RefreshableStateValueValuesEnum(_messages.Enum):
    r"""Output only. The refresh State of the clone.

    Values:
      REFRESHABLE_STATE_UNSPECIFIED: Default unspecified value.
      REFRESHING: Refreshing
      NOT_REFRESHING: Not refreshed
    """
    REFRESHABLE_STATE_UNSPECIFIED = 0
    REFRESHING = 1
    NOT_REFRESHING = 2

  class RoleValueValuesEnum(_messages.Enum):
    r"""Output only. The Data Guard role of the ADB.

    Values:
      ROLE_UNSPECIFIED: Default unspecified value.
      PRIMARY: Primary role
      STANDBY: Standby role
      DISABLED_STANDBY: Disabled standby role
      BACKUP_COPY: Backup copy role
      SNAPSHOT_STANDBY: Snapshot standby role
    """
    ROLE_UNSPECIFIED = 0
    PRIMARY = 1
    STANDBY = 2
    DISABLED_STANDBY = 3
    BACKUP_COPY = 4
    SNAPSHOT_STANDBY = 5

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current lifecycle state of the Autonomous Database.

    Values:
      STATE_UNSPECIFIED: Default unspecified value.
      PROVISIONING: Indicates that resource in Provisioning state
      AVAILABLE: Indicates that resource in Available state
      STOPPING: Indicates that resource in Stopping state
      STOPPED: Indicates that resource in Stopped state
      STARTING: Indicates that resource in Starting state
      TERMINATING: Indicates that resource in Terminating state
      TERMINATED: Indicates that resource in Terminated state
      UNAVAILABLE: Indicates that resource in Unavailable state
      RESTORE_IN_PROGRESS: Indicates that resource Restore is in progress
      RESTORE_FAILED: Indicates that resource failed to restore
      BACKUP_IN_PROGRESS: Indicates that resource backup is in progress
      SCALE_IN_PROGRESS: Indicates that resource scale is in progress
      AVAILABLE_NEEDS_ATTENTION: Indicates that resource in Available Needs
        Attention state
      UPDATING: Indicates that resource in Updating state
      MAINTENANCE_IN_PROGRESS: Indicates that resource in Maintenance In
        Progress state
      RESTARTING: Indicates that resource in Restarting state
      RECREATING: Indicates that resource in Recreating state
      ROLE_CHANGE_IN_PROGRESS: Indicates that resource Role Change is In
        Progress
      UPGRADING: Indicates that resource in Upgrading state
      INACCESSIBLE: Indicates that resource in Inaccessible state
      STANDBY: Indicates that resource in Standby state
    """
    STATE_UNSPECIFIED = 0
    PROVISIONING = 1
    AVAILABLE = 2
    STOPPING = 3
    STOPPED = 4
    STARTING = 5
    TERMINATING = 6
    TERMINATED = 7
    UNAVAILABLE = 8
    RESTORE_IN_PROGRESS = 9
    RESTORE_FAILED = 10
    BACKUP_IN_PROGRESS = 11
    SCALE_IN_PROGRESS = 12
    AVAILABLE_NEEDS_ATTENTION = 13
    UPDATING = 14
    MAINTENANCE_IN_PROGRESS = 15
    RESTARTING = 16
    RECREATING = 17
    ROLE_CHANGE_IN_PROGRESS = 18
    UPGRADING = 19
    INACCESSIBLE = 20
    STANDBY = 21

  actualUsedDataStorageSizeTb = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  allocatedStorageSizeTb = _messages.FloatField(2, variant=_messages.Variant.FLOAT)
  allowlistedIps = _messages.StringField(3, repeated=True)
  apexDetails = _messages.MessageField('AutonomousDatabaseApex', 4)
  arePrimaryWhitelistedIpsUsed = _messages.BooleanField(5)
  autonomousContainerDatabaseId = _messages.StringField(6)
  availableUpgradeVersions = _messages.StringField(7, repeated=True)
  characterSet = _messages.StringField(8)
  computeCount = _messages.FloatField(9, variant=_messages.Variant.FLOAT)
  connectionStrings = _messages.MessageField('AutonomousDatabaseConnectionStrings', 10)
  connectionUrls = _messages.MessageField('AutonomousDatabaseConnectionUrls', 11)
  cpuCoreCount = _messages.IntegerField(12, variant=_messages.Variant.INT32)
  createTime = _messages.StringField(13)
  customerContacts = _messages.MessageField('CustomerContact', 14, repeated=True)
  dataSafeState = _messages.EnumField('DataSafeStateValueValuesEnum', 15)
  dataStorageSizeTb = _messages.FloatField(16, variant=_messages.Variant.FLOAT)
  databaseManagementState = _messages.EnumField('DatabaseManagementStateValueValuesEnum', 17)
  dbEdition = _messages.EnumField('DbEditionValueValuesEnum', 18)
  dbVersion = _messages.StringField(19)
  dbWorkload = _messages.EnumField('DbWorkloadValueValuesEnum', 20)
  failedDataRecoveryDuration = _messages.StringField(21)
  isAccessControlEnabled = _messages.BooleanField(22)
  isAutoScalingEnabled = _messages.BooleanField(23)
  isLocalDataGuardEnabled = _messages.BooleanField(24)
  isMtlsConnectionRequired = _messages.BooleanField(25)
  isStorageAutoScalingEnabled = _messages.BooleanField(26)
  licenseType = _messages.EnumField('LicenseTypeValueValuesEnum', 27)
  lifecycleDetails = _messages.StringField(28)
  localAdgAutoFailoverMaxDataLossLimit = _messages.IntegerField(29, variant=_messages.Variant.INT32)
  localDisasterRecoveryType = _messages.EnumField('LocalDisasterRecoveryTypeValueValuesEnum', 30)
  localStandbyDb = _messages.MessageField('AutonomousDatabaseStandbySummary', 31)
  maintenanceScheduleType = _messages.EnumField('MaintenanceScheduleTypeValueValuesEnum', 32)
  memoryPerOracleComputeUnitGbs = _messages.IntegerField(33, variant=_messages.Variant.INT32)
  memoryTableGbs = _messages.IntegerField(34, variant=_messages.Variant.INT32)
  nCharacterSet = _messages.StringField(35)
  ocid = _messages.StringField(36)
  openMode = _messages.EnumField('OpenModeValueValuesEnum', 37)
  operationsInsightsState = _messages.EnumField('OperationsInsightsStateValueValuesEnum', 38)
  peerDbIds = _messages.StringField(39, repeated=True)
  permissionLevel = _messages.EnumField('PermissionLevelValueValuesEnum', 40)
  privateEndpoint = _messages.StringField(41)
  privateEndpointIp = _messages.StringField(42)
  privateEndpointLabel = _messages.StringField(43)
  refreshableMode = _messages.EnumField('RefreshableModeValueValuesEnum', 44)
  refreshableState = _messages.EnumField('RefreshableStateValueValuesEnum', 45)
  role = _messages.EnumField('RoleValueValuesEnum', 46)
  scheduledOperations = _messages.MessageField('ScheduledOperationDetails', 47)
  secretId = _messages.StringField(48)
  sqlWebDeveloperUrl = _messages.StringField(49)
  state = _messages.EnumField('StateValueValuesEnum', 50)
  supportedCloneRegions = _messages.StringField(51, repeated=True)
  usedDataStorageSizeTbs = _messages.IntegerField(52, variant=_messages.Variant.INT32)
  vaultId = _messages.StringField(53)


class AutonomousDatabaseStandbySummary(_messages.Message):
  r"""Autonomous Data Guard standby database details.
  https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/datatypes/Auto
  nomousDatabaseStandbySummary

  Enums:
    StateValueValuesEnum: Output only. The current lifecycle state of the
      Autonomous Database.

  Fields:
    dataGuardRoleChangedTime: Output only. The date and time the Autonomous
      Data Guard role was switched for the standby Autonomous Database.
    disasterRecoveryRoleChangedTime: Output only. The date and time the
      Disaster Recovery role was switched for the standby Autonomous Database.
    lagTimeDuration: Output only. The amount of time, in seconds, that the
      data of the standby database lags the data of the primary database.
    lifecycleDetails: Output only. Additional information about the current
      lifecycle state.
    state: Output only. The current lifecycle state of the Autonomous
      Database.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current lifecycle state of the Autonomous Database.

    Values:
      STATE_UNSPECIFIED: Default unspecified value.
      PROVISIONING: Indicates that resource in Provisioning state
      AVAILABLE: Indicates that resource in Available state
      STOPPING: Indicates that resource in Stopping state
      STOPPED: Indicates that resource in Stopped state
      STARTING: Indicates that resource in Starting state
      TERMINATING: Indicates that resource in Terminating state
      TERMINATED: Indicates that resource in Terminated state
      UNAVAILABLE: Indicates that resource in Unavailable state
      RESTORE_IN_PROGRESS: Indicates that resource Restore is in progress
      RESTORE_FAILED: Indicates that resource failed to restore
      BACKUP_IN_PROGRESS: Indicates that resource backup is in progress
      SCALE_IN_PROGRESS: Indicates that resource scale is in progress
      AVAILABLE_NEEDS_ATTENTION: Indicates that resource in Available Needs
        Attention state
      UPDATING: Indicates that resource in Updating state
      MAINTENANCE_IN_PROGRESS: Indicates that resource in Maintenance In
        Progress state
      RESTARTING: Indicates that resource in Restarting state
      RECREATING: Indicates that resource in Recreating state
      ROLE_CHANGE_IN_PROGRESS: Indicates that resource Role Change is In
        Progress
      UPGRADING: Indicates that resource in Upgrading state
      INACCESSIBLE: Indicates that resource in Inaccessible state
      STANDBY: Indicates that resource in Standby state
    """
    STATE_UNSPECIFIED = 0
    PROVISIONING = 1
    AVAILABLE = 2
    STOPPING = 3
    STOPPED = 4
    STARTING = 5
    TERMINATING = 6
    TERMINATED = 7
    UNAVAILABLE = 8
    RESTORE_IN_PROGRESS = 9
    RESTORE_FAILED = 10
    BACKUP_IN_PROGRESS = 11
    SCALE_IN_PROGRESS = 12
    AVAILABLE_NEEDS_ATTENTION = 13
    UPDATING = 14
    MAINTENANCE_IN_PROGRESS = 15
    RESTARTING = 16
    RECREATING = 17
    ROLE_CHANGE_IN_PROGRESS = 18
    UPGRADING = 19
    INACCESSIBLE = 20
    STANDBY = 21

  dataGuardRoleChangedTime = _messages.StringField(1)
  disasterRecoveryRoleChangedTime = _messages.StringField(2)
  lagTimeDuration = _messages.StringField(3)
  lifecycleDetails = _messages.StringField(4)
  state = _messages.EnumField('StateValueValuesEnum', 5)


class AutonomousDbVersion(_messages.Message):
  r"""Details of the Autonomous Database version. https://docs.oracle.com/en-
  us/iaas/api/#/en/database/20160918/AutonomousDbVersionSummary/

  Fields:
    name: Identifier. The name of the Autonomous Database Version resource
      with the format: projects/{project}/locations/{region}/autonomousDbVersi
      ons/{autonomous_db_version} https://google.aip.dev/122
    properties: Output only. Various properties of the autonomous database
      version.
    version: Output only. An Oracle Database version for Autonomous Database.
  """

  name = _messages.StringField(1)
  properties = _messages.MessageField('AutonomousDbVersionProperties', 2)
  version = _messages.StringField(3)


class AutonomousDbVersionProperties(_messages.Message):
  r"""Various properties of AutonomousDbVersion.

  Enums:
    DbWorkloadValueValuesEnum: The Autonomous Database workload type.

  Fields:
    dbWorkload: The Autonomous Database workload type.
    workloadUri: A URL that points to a detailed description of the Autonomous
      Database version.
  """

  class DbWorkloadValueValuesEnum(_messages.Enum):
    r"""The Autonomous Database workload type.

    Values:
      DB_WORKLOAD_UNSPECIFIED: Default unspecified value.
      OLTP: Autonomous Transaction Processing database
      DW: Autonomous Data Warehouse database
      AJD: Autonomous JSON Database
      APEX: Autonomous Database with the Oracle APEX Application Development
        workload type
    """
    DB_WORKLOAD_UNSPECIFIED = 0
    OLTP = 1
    DW = 2
    AJD = 3
    APEX = 4

  dbWorkload = _messages.EnumField('DbWorkloadValueValuesEnum', 1)
  workloadUri = _messages.StringField(2)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class CloudAccountDetails(_messages.Message):
  r"""Details of the OCI Cloud Account.

  Fields:
    accountCreationUri: Output only. URL to create a new account and link.
    cloudAccount: Output only. OCI account name.
    cloudAccountHomeRegion: Output only. OCI account home region.
    linkExistingAccountUri: Output only. URL to link an existing account.
  """

  accountCreationUri = _messages.StringField(1)
  cloudAccount = _messages.StringField(2)
  cloudAccountHomeRegion = _messages.StringField(3)
  linkExistingAccountUri = _messages.StringField(4)


class CloudExadataInfrastructure(_messages.Message):
  r"""Represents CloudExadataInfrastructure resource.
  https://docs.oracle.com/en-
  us/iaas/api/#/en/database/20160918/CloudExadataInfrastructure/

  Messages:
    LabelsValue: Optional. labels or tags associated with the resource.

  Fields:
    displayName: Optional. User friendly name for this resource.
    entitlementId: Output only. Entitlement ID of the private offer against
      which this infrastructure resource is provisioned.
    labels: Optional. labels or tags associated with the resource.
    name: Identifier. The name of the CloudExadataInfrastructure resource with
      the format: projects/{project}/locations/{region}/cloudExadataInfrastruc
      tures/{cloud_exadata_infrastructure} https://google.aip.dev/122
    properties: Optional. various properties of the infra.
    zone: Optional. zone where this infra resides.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. labels or tags associated with the resource.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  entitlementId = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  name = _messages.StringField(4)
  properties = _messages.MessageField('CloudExadataInfrastructureProperties', 5)
  zone = _messages.StringField(6)


class CloudExadataInfrastructureProperties(_messages.Message):
  r"""Various properties of CloudExadataInfrastrucutre.

  Enums:
    StateValueValuesEnum: Output only. The current lifecycle state of the
      CloudExadataInfrastructure.

  Fields:
    activatedStorageCount: Output only. The requested number of additional
      storage servers activated for the CloudExadataInfrastructure.
    additionalStorageCount: Output only. The requested number of additional
      storage servers for the CloudExadata infrastructure.
    availableStorageSizeGb: Output only. The available storage can be
      allocated to the cloud CloudExadata infrastructure resource, in
      gigabytes (GB).
    computeCount: Optional. The number of compute servers for the
      CloudExadatainfrastructure.
    cpuCount: Optional. The number of enabled CPU cores.
    customerContacts: Optional. The list of customer contacts.
    dataStorageSizeTb: Output only. Size, in terabytes, of the DATA disk
      group.
    dbNodeStorageSizeGb: Optional. The local node storage allocated in GBs.
    dbServerVersion: Output only. The software version of the database servers
      (dom0) in the CloudExadata infrastructure.
    maintenanceWindow: Optional. Maintenance window for repair.
    maxCpuCount: Output only. The total number of CPU cores available.
    maxDataStorageTb: Output only. The total available DATA disk group size.
    maxDbNodeStorageSizeGb: Output only. The total local node storage
      available in GBs.
    maxMemoryGb: Output only. The total memory available in GBs.
    memorySizeGb: Optional. The memory allocated in GBs.
    nextMaintenanceRunId: Output only. The OCID of the next maintenance run.
    nextMaintenanceRunTime: Output only. The time when the next maintenance
      run will occur.
    nextSecurityMaintenanceRunTime: Output only. The time when the next
      security maintenance run will occur.
    ociUrl: Output only. Deep link to the OCI console to view this resource.
    ocid: Output only. OCID of created infra. https://docs.oracle.com/en-
      us/iaas/Content/General/Concepts/identifiers.htm#Oracle
    shape: Required. The shape of the CloudExadataInfrastructure. The shape
      determines the amount of CPU, storage, and memory resources allocated to
      the instance.
    state: Output only. The current lifecycle state of the
      CloudExadataInfrastructure.
    storageCount: Optional. The number of Cloud Exadata storage servers for
      the CloudExadata infrastructure.
    storageServerVersion: Output only. The software version of the storage
      servers (cells) in the CloudExadata infrastructure.
    totalStorageSizeGb: Optional. The total storage allocated to the
      CloudExadataInfrastructure resource, in gigabytes (GB).
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current lifecycle state of the
    CloudExadataInfrastructure.

    Values:
      STATE_UNSPECIFIED: Default unspecified value.
      PROVISIONING: The infrastructure is being provisioned.
      AVAILABLE: The infrastructure is available for use.
      UPDATING: The infrastructure is being updated.
      TERMINATING: The infrastructure is being terminated.
      TERMINATED: The infrastructure is terminated.
      FAILED: The infrastructure is in failed state.
      MAINTENANCE_IN_PROGRESS: The infrastructure is in maintenance.
    """
    STATE_UNSPECIFIED = 0
    PROVISIONING = 1
    AVAILABLE = 2
    UPDATING = 3
    TERMINATING = 4
    TERMINATED = 5
    FAILED = 6
    MAINTENANCE_IN_PROGRESS = 7

  activatedStorageCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  additionalStorageCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  availableStorageSizeGb = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  computeCount = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  cpuCount = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  customerContacts = _messages.MessageField('CustomerContact', 6, repeated=True)
  dataStorageSizeTb = _messages.FloatField(7, variant=_messages.Variant.FLOAT)
  dbNodeStorageSizeGb = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  dbServerVersion = _messages.StringField(9)
  maintenanceWindow = _messages.MessageField('MaintenanceWindow', 10)
  maxCpuCount = _messages.IntegerField(11, variant=_messages.Variant.INT32)
  maxDataStorageTb = _messages.FloatField(12, variant=_messages.Variant.FLOAT)
  maxDbNodeStorageSizeGb = _messages.IntegerField(13, variant=_messages.Variant.INT32)
  maxMemoryGb = _messages.IntegerField(14, variant=_messages.Variant.INT32)
  memorySizeGb = _messages.IntegerField(15, variant=_messages.Variant.INT32)
  nextMaintenanceRunId = _messages.StringField(16)
  nextMaintenanceRunTime = _messages.StringField(17)
  nextSecurityMaintenanceRunTime = _messages.StringField(18)
  ociUrl = _messages.StringField(19)
  ocid = _messages.StringField(20)
  shape = _messages.StringField(21)
  state = _messages.EnumField('StateValueValuesEnum', 22)
  storageCount = _messages.IntegerField(23, variant=_messages.Variant.INT32)
  storageServerVersion = _messages.StringField(24)
  totalStorageSizeGb = _messages.IntegerField(25, variant=_messages.Variant.INT32)


class CloudVmCluster(_messages.Message):
  r"""Details of the Cloud VM Cluster resource. https://docs.oracle.com/en-
  us/iaas/api/#/en/database/20160918/CloudVmCluster/

  Messages:
    LabelsValue: Optional. labels or tags associated with the resource.

  Fields:
    createTime: Output only. The date and time that the VM cluster was
      created.
    displayName: Optional. User friendly name for this resource.
    exadataInfrastructure: Required. The name of the Exadata Infrastructure
      resource on which VM cluster resource is created. Format: projects/{proj
      ect}/locations/{region}/cloudExadataInfrastuctures/{cloud_extradata_infr
      astructure} https://google.aip.dev/122
    labels: Optional. labels or tags associated with the resource.
    name: Identifier. The name of the VM Cluster resource with the format:
      projects/{project}/locations/{region}/cloudVmClusters/{cloud_vm_cluster}
      https://google.aip.dev/122
    properties: Optional. various properties of the VM Cluster.
    region: Output only. region of resource. It is same as
      ExadataInfrastructure region.
    zone: Output only. zone - same as Exadata infrastructure.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. labels or tags associated with the resource.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  displayName = _messages.StringField(2)
  exadataInfrastructure = _messages.StringField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  properties = _messages.MessageField('CloudVmClusterProperties', 6)
  region = _messages.StringField(7)
  zone = _messages.StringField(8)


class CloudVmClusterProperties(_messages.Message):
  r"""Various properties and settings associated with Exadata VM cluster. Next
  Tag: 37

  Enums:
    DiskRedundancyValueValuesEnum: Optional. The type of redundancy
    LicenseTypeValueValuesEnum: Required. License type of VM Cluster
    StateValueValuesEnum: Output only. State of the cluster

  Fields:
    backupSubnetCidr: Required. CIDR range of the backup subnet.
    cidr: Required. Network settings. CIDR to use for cluster IP allocation.
    clusterName: Optional. OCI Cluster name.
    compartmentId: Output only. Compartment ID of cluster.
    cpuCoreCount: Required. Number of enabled CPU cores.
    dataStorageSizeTb: Optional. The data disk group size to be allocated in
      TBs.
    dbNodeStorageSizeGb: Optional. Local storage per VM
    dbServerOcids: Optional. OCID of database servers.
    diagnosticsDataCollectionOptions: Optional. Data collection options for
      diagnostics.
    diskRedundancy: Optional. The type of redundancy
    dnsListenerIp: Output only. DNS listener IP.
    domain: Output only. Parent DNS domain where SCAN DNS and hosts names are
      qualified. ex: ocispdelegated.ocisp10jvnet.oraclevcn.com
    giVersion: Optional. Grid Infrastructure Version
    hostname: Output only. host name without domain. format: "-" with some
      suffix. ex: sp2-yi0xq where "sp2" is the hostname_prefix.
    hostnamePrefix: Optional. Prefix for VM cluster host names.
    licenseType: Required. License type of VM Cluster
    localBackupEnabled: Optional. use local backup.
    memorySizeGb: Optional. Memory allocated in GBs.
    network: Required. The name of the VPC network. Format:
      projects/{project}/locations/global/networks/{network} or
      projects/{project}/global/networks/{network} https://google.aip.dev/122
    nodeCount: Optional. Number of database servers.
    ociUrl: Output only. Deep link to the OCI console to view this resource.
    ocid: Output only. OCID of VM Cluster
    ocpuCount: Optional. OCPU count per VM. Minimum is 0.1
    scanDns: Output only. SCAN DNS name. ex: sp2-yi0xq-
      scan.ocispdelegated.ocisp10jvnet.oraclevcn.com
    scanDnsRecordId: Output only. OCID of scan DNS record.
    scanIpIds: Output only. OCIDs of scan IPs.
    scanListenerPortTcp: Output only. SCAN listener port - TCP
    scanListenerPortTcpSsl: Output only. SCAN listener port - TLS
    shape: Output only. Shape of VM Cluster
    sparseDiskgroupEnabled: Optional. Use exadata sparse snapshots.
    sshPublicKeys: Optional. SSH public keys to be stored with cluster.
    state: Output only. State of the cluster
    storageSizeGb: Output only. The storage allocation for the disk group, in
      gigabytes (GB).
    systemVersion: Output only. Operating system version of the image.
    timeZone: Optional. Time zone of VM Cluster to set. Defaults to UTC if not
      specified.
  """

  class DiskRedundancyValueValuesEnum(_messages.Enum):
    r"""Optional. The type of redundancy

    Values:
      DISK_REDUNDANCY_UNSPECIFIED: unspecified.
      HIGH: High - 3 way mirror.
      NORMAL: Normal - 2 way mirror.
    """
    DISK_REDUNDANCY_UNSPECIFIED = 0
    HIGH = 1
    NORMAL = 2

  class LicenseTypeValueValuesEnum(_messages.Enum):
    r"""Required. License type of VM Cluster

    Values:
      LICENSE_TYPE_UNSPECIFIED: Unspecified
      LICENSE_INCLUDED: License included part of offer
      BRING_YOUR_OWN_LICENSE: Bring your own license
    """
    LICENSE_TYPE_UNSPECIFIED = 0
    LICENSE_INCLUDED = 1
    BRING_YOUR_OWN_LICENSE = 2

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the cluster

    Values:
      STATE_UNSPECIFIED: Unspecified
      PROVISIONING: Provisioning
      AVAILABLE: Available for use
      UPDATING: Updating
      TERMINATING: Terminating
      TERMINATED: Terminated
      FAILED: Failed
      MAINTENANCE_IN_PROGRESS: Maintenance in progress
    """
    STATE_UNSPECIFIED = 0
    PROVISIONING = 1
    AVAILABLE = 2
    UPDATING = 3
    TERMINATING = 4
    TERMINATED = 5
    FAILED = 6
    MAINTENANCE_IN_PROGRESS = 7

  backupSubnetCidr = _messages.StringField(1)
  cidr = _messages.StringField(2)
  clusterName = _messages.StringField(3)
  compartmentId = _messages.StringField(4)
  cpuCoreCount = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  dataStorageSizeTb = _messages.FloatField(6, variant=_messages.Variant.FLOAT)
  dbNodeStorageSizeGb = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  dbServerOcids = _messages.StringField(8, repeated=True)
  diagnosticsDataCollectionOptions = _messages.MessageField('DataCollectionOptions', 9)
  diskRedundancy = _messages.EnumField('DiskRedundancyValueValuesEnum', 10)
  dnsListenerIp = _messages.StringField(11)
  domain = _messages.StringField(12)
  giVersion = _messages.StringField(13)
  hostname = _messages.StringField(14)
  hostnamePrefix = _messages.StringField(15)
  licenseType = _messages.EnumField('LicenseTypeValueValuesEnum', 16)
  localBackupEnabled = _messages.BooleanField(17)
  memorySizeGb = _messages.IntegerField(18, variant=_messages.Variant.INT32)
  network = _messages.StringField(19)
  nodeCount = _messages.IntegerField(20, variant=_messages.Variant.INT32)
  ociUrl = _messages.StringField(21)
  ocid = _messages.StringField(22)
  ocpuCount = _messages.FloatField(23, variant=_messages.Variant.FLOAT)
  scanDns = _messages.StringField(24)
  scanDnsRecordId = _messages.StringField(25)
  scanIpIds = _messages.StringField(26, repeated=True)
  scanListenerPortTcp = _messages.IntegerField(27, variant=_messages.Variant.INT32)
  scanListenerPortTcpSsl = _messages.IntegerField(28, variant=_messages.Variant.INT32)
  shape = _messages.StringField(29)
  sparseDiskgroupEnabled = _messages.BooleanField(30)
  sshPublicKeys = _messages.StringField(31, repeated=True)
  state = _messages.EnumField('StateValueValuesEnum', 32)
  storageSizeGb = _messages.IntegerField(33, variant=_messages.Variant.INT32)
  systemVersion = _messages.StringField(34)
  timeZone = _messages.MessageField('TimeZone', 35)


class CustomerContact(_messages.Message):
  r"""The CustomerContact reference as defined by Oracle.
  https://docs.oracle.com/en-
  us/iaas/api/#/en/database/20160918/datatypes/CustomerContact

  Fields:
    email: Required. The email address used by Oracle to send notifications
      regarding databases and infrastructure.
  """

  email = _messages.StringField(1)


class DataCollectionOptions(_messages.Message):
  r"""Data collection options for diagnostics.

  Fields:
    diagnosticsEventsEnabled: Optional. Indicates whether diagnostic
      collection is enabled for the VM cluster
    healthMonitoringEnabled: Optional. Indicates whether health monitoring is
      enabled for the VM cluster
    incidentLogsEnabled: Optional. Indicates whether incident logs and trace
      collection are enabled for the VM cluster
  """

  diagnosticsEventsEnabled = _messages.BooleanField(1)
  healthMonitoringEnabled = _messages.BooleanField(2)
  incidentLogsEnabled = _messages.BooleanField(3)


class DatabaseConnectionStringProfile(_messages.Message):
  r"""The connection string profile to allow clients to group.
  https://docs.oracle.com/en-
  us/iaas/api/#/en/database/20160918/datatypes/DatabaseConnectionStringProfile

  Enums:
    ConsumerGroupValueValuesEnum: Output only. Consumer group used by the
      connection.
    HostFormatValueValuesEnum: Output only. Host format used in connection
      string.
    ProtocolValueValuesEnum: Output only. Protocol used by the connection.
    SessionModeValueValuesEnum: Output only. Specifies the session mode of the
      connection.
    SyntaxFormatValueValuesEnum: Output only. Specifies syntax of the
      connection string.
    TlsAuthenticationValueValuesEnum: Output only. Specifies TLS Hanshake

  Fields:
    consumerGroup: Output only. Consumer group used by the connection.
    displayName: Output only. Display name for the database connection.
    hostFormat: Output only. Host format used in connection string.
    isRegional: Output only. True for a regional connection string, applicable
      to cross-region DG only.
    protocol: Output only. Protocol used by the connection.
    sessionMode: Output only. Specifies the session mode of the connection.
    syntaxFormat: Output only. Specifies syntax of the connection string.
    tlsAuthentication: Output only. Specifies TLS Hanshake
    value: Output only. Connection string value.
  """

  class ConsumerGroupValueValuesEnum(_messages.Enum):
    r"""Output only. Consumer group used by the connection.

    Values:
      CONSUMER_GROUP_UNSPECIFIED: Default unspecified value.
      HIGH: High consumer group
      MEDIUM: Medium consumer group
      LOW: Low consumer group
      TP: TP consumer group
      TPURGENT: TPURGENT consumer group
    """
    CONSUMER_GROUP_UNSPECIFIED = 0
    HIGH = 1
    MEDIUM = 2
    LOW = 3
    TP = 4
    TPURGENT = 5

  class HostFormatValueValuesEnum(_messages.Enum):
    r"""Output only. Host format used in connection string.

    Values:
      HOST_FORMAT_UNSPECIFIED: Default unspecified value.
      FQDN: FQDN
      IP: IP
    """
    HOST_FORMAT_UNSPECIFIED = 0
    FQDN = 1
    IP = 2

  class ProtocolValueValuesEnum(_messages.Enum):
    r"""Output only. Protocol used by the connection.

    Values:
      PROTOCOL_UNSPECIFIED: Default unspecified value.
      TCP: Tcp
      TCPS: Tcps
    """
    PROTOCOL_UNSPECIFIED = 0
    TCP = 1
    TCPS = 2

  class SessionModeValueValuesEnum(_messages.Enum):
    r"""Output only. Specifies the session mode of the connection.

    Values:
      SESSION_MODE_UNSPECIFIED: Default unspecified value.
      DIRECT: Direct
      INDIRECT: Indirect
    """
    SESSION_MODE_UNSPECIFIED = 0
    DIRECT = 1
    INDIRECT = 2

  class SyntaxFormatValueValuesEnum(_messages.Enum):
    r"""Output only. Specifies syntax of the connection string.

    Values:
      SYNTAX_FORMAT_UNSPECIFIED: Default unspecified value.
      LONG: Long
      EZCONNECT: Ezconnect
      EZCONNECTPLUS: Ezconnectplus
    """
    SYNTAX_FORMAT_UNSPECIFIED = 0
    LONG = 1
    EZCONNECT = 2
    EZCONNECTPLUS = 3

  class TlsAuthenticationValueValuesEnum(_messages.Enum):
    r"""Output only. Specifies TLS Hanshake

    Values:
      TLS_AUTHENTICATION_UNSPECIFIED: Default unspecified value.
      SERVER: Server
      MUTUAL: Mutual
    """
    TLS_AUTHENTICATION_UNSPECIFIED = 0
    SERVER = 1
    MUTUAL = 2

  consumerGroup = _messages.EnumField('ConsumerGroupValueValuesEnum', 1)
  displayName = _messages.StringField(2)
  hostFormat = _messages.EnumField('HostFormatValueValuesEnum', 3)
  isRegional = _messages.BooleanField(4)
  protocol = _messages.EnumField('ProtocolValueValuesEnum', 5)
  sessionMode = _messages.EnumField('SessionModeValueValuesEnum', 6)
  syntaxFormat = _messages.EnumField('SyntaxFormatValueValuesEnum', 7)
  tlsAuthentication = _messages.EnumField('TlsAuthenticationValueValuesEnum', 8)
  value = _messages.StringField(9)


class DbNode(_messages.Message):
  r"""Details of the Db Node resource. https://docs.oracle.com/en-
  us/iaas/api/#/en/database/20160918/DbNode/

  Fields:
    name: Identifier. The name of the Db Node resource with the format: projec
      ts/{project}/locations/{location}/cloudVmClusters/{cloud_vm_cluster}/dbN
      odes/{db_node} https://google.aip.dev/122
    properties: Optional. various properties of the Db Node.
  """

  name = _messages.StringField(1)
  properties = _messages.MessageField('DbNodeProperties', 2)


class DbNodeProperties(_messages.Message):
  r"""Various properties and settings associated with Db node.

  Enums:
    StateValueValuesEnum: Output only. State of the db node

  Fields:
    dbNodeStorageSizeGb: Optional. Local storage per db node
    dbServerOcid: Optional. Db server OCID
    floatingIpAddress: Optional. Floating ip address
    hostname: Optional. DNS
    memorySizeGb: Memory allocated in GBs.
    ocid: Output only. OCID of Db Node
    ocpuCount: Optional. OCPU count per db node
    privateIpAddress: Optional. Private ip address
    state: Output only. State of the db node
    totalCpuCoreCount: Total CPU core count of the db node
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the db node

    Values:
      STATE_UNSPECIFIED: Unspecified
      PROVISIONING: Provisioning
      AVAILABLE: Available for use
      UPDATING: Updating
      STOPPING: Stopping
      STOPPED: Stopped
      STARTING: Starting
      TERMINATING: Terminating
      TERMINATED: Terminated
      FAILED: Failed
    """
    STATE_UNSPECIFIED = 0
    PROVISIONING = 1
    AVAILABLE = 2
    UPDATING = 3
    STOPPING = 4
    STOPPED = 5
    STARTING = 6
    TERMINATING = 7
    TERMINATED = 8
    FAILED = 9

  dbNodeStorageSizeGb = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  dbServerOcid = _messages.StringField(2)
  floatingIpAddress = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  hostname = _messages.StringField(4)
  memorySizeGb = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  ocid = _messages.StringField(6)
  ocpuCount = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  privateIpAddress = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  state = _messages.EnumField('StateValueValuesEnum', 9)
  totalCpuCoreCount = _messages.IntegerField(10, variant=_messages.Variant.INT32)


class DbServer(_messages.Message):
  r"""Details of the Db Server resource. https://docs.oracle.com/en-
  us/iaas/api/#/en/database/20160918/DbServer/

  Fields:
    displayName: Optional. User friendly name for this resource.
    name: Identifier. The name of the Db Server resource with the format: proj
      ects/{project}/locations/{location}/cloudExadataInfrastructures/{cloud_e
      xadata_infrastructure}/dbServers/{db_server} https://google.aip.dev/122
    properties: Optional. various properties of the Db Server.
  """

  displayName = _messages.StringField(1)
  name = _messages.StringField(2)
  properties = _messages.MessageField('DbServerProperties', 3)


class DbServerProperties(_messages.Message):
  r"""Various properties and settings associated with Exadata Db server.

  Enums:
    StateValueValuesEnum: Output only. State of the db server

  Fields:
    dbNodeStorageSizeGb: Optional. Local storage per VM
    maxDbNodeStorageSizeGb: Optional. Maximum local storage per VM
    maxMemorySizeGb: Optional. Maximum memory allocated in GBs.
    maxOcpuCount: Optional. Maximum OCPU count per db
    memorySizeGb: Optional. Memory allocated in GBs.
    ocid: Output only. OCID of Db Server
    ocpuCount: Optional. OCPU count per db
    state: Output only. State of the db server
    vmCount: Optional. Vm count per db
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. State of the db server

    Values:
      STATE_UNSPECIFIED: Unspecified
      CREATING: Creating
      AVAILABLE: Available for use
      UNAVAILABLE: Unavailable
      DELETING: Deleting
      DELETED: Deleted
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    AVAILABLE = 2
    UNAVAILABLE = 3
    DELETING = 4
    DELETED = 5

  dbNodeStorageSizeGb = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  maxDbNodeStorageSizeGb = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  maxMemorySizeGb = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  maxOcpuCount = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  memorySizeGb = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  ocid = _messages.StringField(6)
  ocpuCount = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  state = _messages.EnumField('StateValueValuesEnum', 8)
  vmCount = _messages.IntegerField(9, variant=_messages.Variant.INT32)


class DbSystemShape(_messages.Message):
  r"""Details of the Db System Shapes resource. https://docs.oracle.com/en-
  us/iaas/api/#/en/database/20160918/DbSystemShapeSummary/

  Fields:
    maxNodeCount: Optional. Maximum number of db servers
    maxStorageCount: Optional. Maximum number of storage servers
    memoryPerDbServerGb: Optional. Memory per db server node in GB
    minCoreCountPerNode: Optional. Minimum core count per node
    minMemoryPerDbServerGb: Optional. Minimum memory per db server in GB
    minNodeCount: Optional. Minimum number of db servers
    minNodeStoragePerServerGb: Optional. Minimum node storage per db server in
      GB
    minStorageCount: Optional. Minimum number of storage servers
    name: Identifier. The name of the Db System Shape resource with the
      format:
      projects/{project}/locations/{region}/dbSystemShapes/{db_system_shape}
      https://google.aip.dev/122
    ocpusPerDbServer: Optional. Number of cores per db server
    shape: Optional. shape
    storagePerStorageServerGb: Optional. Storage per storage server in GB
  """

  maxNodeCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  maxStorageCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  memoryPerDbServerGb = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  minCoreCountPerNode = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  minMemoryPerDbServerGb = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  minNodeCount = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  minNodeStoragePerServerGb = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  minStorageCount = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  name = _messages.StringField(9)
  ocpusPerDbServer = _messages.IntegerField(10, variant=_messages.Variant.INT32)
  shape = _messages.StringField(11)
  storagePerStorageServerGb = _messages.IntegerField(12, variant=_messages.Variant.INT32)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class Entitlement(_messages.Message):
  r"""Details of the Entitlement resource.

  Enums:
    StateValueValuesEnum: Output only. state

  Fields:
    cloudAccountDetails: Details of the OCI Cloud Account.
    entitlementId: Output only. GCP Marketplace order ID (aka entitlement ID)
    name: Identifier. The name of the Entitlement resource with the format:
      projects/{project}/locations/{region}/entitlements/{entitlement}
      https://google.aip.dev/122
    state: Output only. state
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. state

    Values:
      STATE_UNSPECIFIED: Unspecified
      ACCOUNT_NOT_LINKED: Account not linked
      ACCOUNT_NOT_ACTIVE: Cloud account not active (i.e linked but pending
        activation)
      ACTIVE: Entitlement and Account is active
    """
    STATE_UNSPECIFIED = 0
    ACCOUNT_NOT_LINKED = 1
    ACCOUNT_NOT_ACTIVE = 2
    ACTIVE = 3

  cloudAccountDetails = _messages.MessageField('CloudAccountDetails', 1)
  entitlementId = _messages.StringField(2)
  name = _messages.StringField(3)
  state = _messages.EnumField('StateValueValuesEnum', 4)


class GiVersion(_messages.Message):
  r"""Details of the Gi Version resource. https://docs.oracle.com/en-
  us/iaas/api/#/en/database/20160918/GiVersionSummary/

  Fields:
    name: Identifier. The name of the Gi Version resource with the format:
      projects/{project}/locations/{region}/giVersions/{gi_versions}
      https://google.aip.dev/122
    version: Optional. version
  """

  name = _messages.StringField(1)
  version = _messages.StringField(2)


class ListAutonomousDatabaseCharacterSetsResponse(_messages.Message):
  r"""Message for response to listing Autonomous Database Character Sets

  Fields:
    autonomousDatabaseCharacterSets: The list of Autonomous Database Character
      Sets
    nextPageToken: A token identifying a page of results the server should
      return.
  """

  autonomousDatabaseCharacterSets = _messages.MessageField('AutonomousDatabaseCharacterSet', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListAutonomousDatabasesResponse(_messages.Message):
  r"""Message for response to listing Autonomous Databases

  Fields:
    autonomousDatabases: The list of Autonomous Databases
    nextPageToken: A token identifying a page of results the server should
      return.
  """

  autonomousDatabases = _messages.MessageField('AutonomousDatabase', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListAutonomousDbVersionsResponse(_messages.Message):
  r"""Message for response to listing Autonomous DB Versions

  Fields:
    autonomousDbVersions: The list of Autonomous DB Versions
    nextPageToken: A token identifying a page of results the server should
      return.
  """

  autonomousDbVersions = _messages.MessageField('AutonomousDbVersion', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListCloudExadataInfrastructuresResponse(_messages.Message):
  r"""Message for response to listing Exadata Infrastructures

  Fields:
    cloudExadataInfrastructures: The list of Exadata Infrastructures
    nextPageToken: A token identifying a page of results the server should
      return.
  """

  cloudExadataInfrastructures = _messages.MessageField('CloudExadataInfrastructure', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListCloudVmClustersResponse(_messages.Message):
  r"""Message for response to listing VM Clusters

  Fields:
    cloudVmClusters: The list of VM Clusters
    nextPageToken: A token identifying a page of results the server should
      return.
  """

  cloudVmClusters = _messages.MessageField('CloudVmCluster', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListDbNodesResponse(_messages.Message):
  r"""Message for response to listing DB Nodes

  Fields:
    dbNodes: The list of DB Nodes
    nextPageToken: A token identifying a page of results the node should
      return.
  """

  dbNodes = _messages.MessageField('DbNode', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListDbServersResponse(_messages.Message):
  r"""Message for response to listing DB Servers

  Fields:
    dbServers: The list of DB Servers
    nextPageToken: A token identifying a page of results the server should
      return.
  """

  dbServers = _messages.MessageField('DbServer', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListDbSystemShapesResponse(_messages.Message):
  r"""Message for response to listing Db System Shapes

  Fields:
    dbSystemShapes: The list of Db System Shapes
    nextPageToken: A token identifying a page of results the server should
      return.
  """

  dbSystemShapes = _messages.MessageField('DbSystemShape', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListEntitlementsResponse(_messages.Message):
  r"""Message for response to listing Entitlements

  Fields:
    entitlements: The list of Entitlements
    nextPageToken: A token identifying a page of results the server should
      return.
  """

  entitlements = _messages.MessageField('Entitlement', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListGiVersionsResponse(_messages.Message):
  r"""Message for response to listing Gi Verions

  Fields:
    giVersions: The list of Gi Versions
    nextPageToken: A token identifying a page of results the server should
      return.
  """

  giVersions = _messages.MessageField('GiVersion', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents a Google Cloud location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class LocationMetadata(_messages.Message):
  r"""Metadata for a given Location.

  Fields:
    zones: Output only. zones in a location.
  """

  zones = _messages.StringField(1, repeated=True)


class MaintenanceWindow(_messages.Message):
  r"""Maintenance window as defined by Oracle. https://docs.oracle.com/en-
  us/iaas/api/#/en/database/20160918/datatypes/MaintenanceWindow

  Enums:
    DaysOfWeekValueListEntryValuesEnum:
    MonthsValueListEntryValuesEnum:
    PatchingModeValueValuesEnum: Optional. Cloud CloudExadataInfrastructure
      node patching method, either "ROLLING" or "NONROLLING". Default value is
      ROLLING.
    PreferenceValueValuesEnum: Optional. The maintenance window scheduling
      preference.

  Fields:
    customActionTimeoutMins: Optional. Determines the amount of time the
      system will wait before the start of each database server patching
      operation. Custom action timeout is in minutes and valid value is
      between 15 to 120 (inclusive).
    daysOfWeek: Optional. Days during the week when maintenance should be
      performed.
    hoursOfDay: Optional. The window of hours during the day when maintenance
      should be performed. The window is a 4 hour slot. Valid values are: 0 -
      represents time slot 0:00 - 3:59 UTC 4 - represents time slot 4:00 -
      7:59 UTC 8 - represents time slot 8:00 - 11:59 UTC 12 - represents time
      slot 12:00 - 15:59 UTC 16 - represents time slot 16:00 - 19:59 UTC 20 -
      represents time slot 20:00 - 23:59 UTC
    isCustomActionTimeoutEnabled: Optional. If true, enables the configuration
      of a custom action timeout (waiting period) between database server
      patching operations.
    leadTimeWeek: Optional. Lead time window allows user to set a lead time to
      prepare for a down time. The lead time is in weeks and valid value is
      between 1 to 4.
    months: Optional. Months during the year when maintenance should be
      performed.
    patchingMode: Optional. Cloud CloudExadataInfrastructure node patching
      method, either "ROLLING" or "NONROLLING". Default value is ROLLING.
    preference: Optional. The maintenance window scheduling preference.
    weeksOfMonth: Optional. Weeks during the month when maintenance should be
      performed. Weeks start on the 1st, 8th, 15th, and 22nd days of the
      month, and have a duration of 7 days. Weeks start and end based on
      calendar dates, not days of the week.
  """

  class DaysOfWeekValueListEntryValuesEnum(_messages.Enum):
    r"""DaysOfWeekValueListEntryValuesEnum enum type.

    Values:
      DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
      MONDAY: Monday
      TUESDAY: Tuesday
      WEDNESDAY: Wednesday
      THURSDAY: Thursday
      FRIDAY: Friday
      SATURDAY: Saturday
      SUNDAY: Sunday
    """
    DAY_OF_WEEK_UNSPECIFIED = 0
    MONDAY = 1
    TUESDAY = 2
    WEDNESDAY = 3
    THURSDAY = 4
    FRIDAY = 5
    SATURDAY = 6
    SUNDAY = 7

  class MonthsValueListEntryValuesEnum(_messages.Enum):
    r"""MonthsValueListEntryValuesEnum enum type.

    Values:
      MONTH_UNSPECIFIED: The unspecified month.
      JANUARY: The month of January.
      FEBRUARY: The month of February.
      MARCH: The month of March.
      APRIL: The month of April.
      MAY: The month of May.
      JUNE: The month of June.
      JULY: The month of July.
      AUGUST: The month of August.
      SEPTEMBER: The month of September.
      OCTOBER: The month of October.
      NOVEMBER: The month of November.
      DECEMBER: The month of December.
    """
    MONTH_UNSPECIFIED = 0
    JANUARY = 1
    FEBRUARY = 2
    MARCH = 3
    APRIL = 4
    MAY = 5
    JUNE = 6
    JULY = 7
    AUGUST = 8
    SEPTEMBER = 9
    OCTOBER = 10
    NOVEMBER = 11
    DECEMBER = 12

  class PatchingModeValueValuesEnum(_messages.Enum):
    r"""Optional. Cloud CloudExadataInfrastructure node patching method,
    either "ROLLING" or "NONROLLING". Default value is ROLLING.

    Values:
      PATCHING_MODE_UNSPECIFIED: Default unspecified value.
      ROLLING: Updates the Cloud Exadata database server hosts in a rolling
        fashion.
      NON_ROLLING: The non-rolling maintenance method first updates your
        storage servers at the same time, then your database servers at the
        same time.
    """
    PATCHING_MODE_UNSPECIFIED = 0
    ROLLING = 1
    NON_ROLLING = 2

  class PreferenceValueValuesEnum(_messages.Enum):
    r"""Optional. The maintenance window scheduling preference.

    Values:
      MAINTENANCE_WINDOW_PREFERENCE_UNSPECIFIED: Default unspecified value.
      CUSTOM_PREFERENCE: Custom preference.
      NO_PREFERENCE: No preference.
    """
    MAINTENANCE_WINDOW_PREFERENCE_UNSPECIFIED = 0
    CUSTOM_PREFERENCE = 1
    NO_PREFERENCE = 2

  customActionTimeoutMins = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  daysOfWeek = _messages.EnumField('DaysOfWeekValueListEntryValuesEnum', 2, repeated=True)
  hoursOfDay = _messages.IntegerField(3, repeated=True, variant=_messages.Variant.INT32)
  isCustomActionTimeoutEnabled = _messages.BooleanField(4)
  leadTimeWeek = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  months = _messages.EnumField('MonthsValueListEntryValuesEnum', 6, repeated=True)
  patchingMode = _messages.EnumField('PatchingModeValueValuesEnum', 7)
  preference = _messages.EnumField('PreferenceValueValuesEnum', 8)
  weeksOfMonth = _messages.IntegerField(9, repeated=True, variant=_messages.Variant.INT32)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as `Delete`, the response is
    `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    percentComplete: Output only. Percentage of the operation that has been
      completed, between 0 and 100. Note that this is not expected to be
      linear with time and is just an estimate.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have been
      cancelled successfully have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  percentComplete = _messages.FloatField(4)
  requestedCancellation = _messages.BooleanField(5)
  statusMessage = _messages.StringField(6)
  target = _messages.StringField(7)
  verb = _messages.StringField(8)


class OracledatabaseProjectsLocationsAutonomousDatabaseCharacterSetsGetRequest(_messages.Message):
  r"""A
  OracledatabaseProjectsLocationsAutonomousDatabaseCharacterSetsGetRequest
  object.

  Fields:
    name: Required. Name of the resource. Format projects/{project}/locations/
      {location}/autonomousDatabaseCharacterSets/{autonomous_database_characte
      r_set}
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsAutonomousDatabaseCharacterSetsListRequest(_messages.Message):
  r"""A
  OracledatabaseProjectsLocationsAutonomousDatabaseCharacterSetsListRequest
  object.

  Fields:
    filter: Optional. Filtering results based on character set. Format:
      character_set_type="{characterSetType}" Only character_set_type field is
      supported with literal equality operator. Accepted filter example:
      character_set_type="NATIONAL" or character_set_type="DATABASE" Wildcards
      are not supported in the filter currently.
    pageSize: Optional. The maximum number of items to return. If unspecified,
      at most 50 Autonomous DB Character Sets will be returned. The maximum
      value is 1000; values above 1000 will be coerced to 1000.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for
      ListAutonomousDatabaseCharacterSetsRequest Format:
      projects/{project}/locations/{location}
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class OracledatabaseProjectsLocationsAutonomousDatabasesCreateRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsAutonomousDatabasesCreateRequest
  object.

  Fields:
    autonomousDatabase: A AutonomousDatabase resource to be passed as the
      request body.
    autonomousDatabaseId: Required. The ID to use for the AutonomousDatabase,
      which will become the final component of the resource name. This value
      should be 4-63 characters, and valid characters are /a-z-/.
    parent: Required. Value for parent. Format:
      projects/{project}/locations/{location}
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  autonomousDatabase = _messages.MessageField('AutonomousDatabase', 1)
  autonomousDatabaseId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class OracledatabaseProjectsLocationsAutonomousDatabasesDeleteRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsAutonomousDatabasesDeleteRequest
  object.

  Fields:
    name: Required. Name of the resource Format: projects/{project}/locations/
      {location}/autonomousDatabases/{autonomous_database}
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class OracledatabaseProjectsLocationsAutonomousDatabasesGetRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsAutonomousDatabasesGetRequest object.

  Fields:
    name: Required. Name of the resource. Format projects/{project}/locations/
      {location}/autonomousDatabases/{autonomous_database}
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsAutonomousDatabasesListRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsAutonomousDatabasesListRequest object.

  Fields:
    filter: Optional. Filtering results
    orderBy: Optional. Hint for how to order the results
    pageSize: Optional. The maximum number of items to return. If unspecified,
      at most 50 Autonomous Database will be returned. The maximum value is
      1000; values above 1000 will be coerced to 1000.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListAutonomousDatabasesRequest Format:
      projects/{project}/locations/{location}
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class OracledatabaseProjectsLocationsAutonomousDbVersionsGetRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsAutonomousDbVersionsGetRequest object.

  Fields:
    name: Required. Name of the resource. Format projects/{project}/locations/
      {location}/autonomousDbVersions/{autonomous_db_version}
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsAutonomousDbVersionsListRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsAutonomousDbVersionsListRequest object.

  Fields:
    pageSize: Optional. The maximum number of items to return. If unspecified,
      at most 50 Autonomous DB Versions will be returned. The maximum value is
      1000; values above 1000 will be coerced to 1000.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListAutonomousDbVersionsRequest Format:
      projects/{project}/locations/{location}
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class OracledatabaseProjectsLocationsCloudExadataInfrastructuresCreateRequest(_messages.Message):
  r"""A
  OracledatabaseProjectsLocationsCloudExadataInfrastructuresCreateRequest
  object.

  Fields:
    cloudExadataInfrastructure: A CloudExadataInfrastructure resource to be
      passed as the request body.
    cloudExadataInfrastructureId: Required. The ID to use for the
      CloudExadataInfrastructure, which will become the final component of the
      resource name. This value should be 4-63 characters, and valid
      characters are /a-z-/.
    parent: Required. Value for parent. Format:
      projects/{project}/locations/{location}
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  cloudExadataInfrastructure = _messages.MessageField('CloudExadataInfrastructure', 1)
  cloudExadataInfrastructureId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class OracledatabaseProjectsLocationsCloudExadataInfrastructuresDbServersGetRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsCloudExadataInfrastructuresDbServersGet
  Request object.

  Fields:
    name: Required. Name of the resource. Format projects/{project}/locations/
      {location}/cloudExadataInfrastructures/{cloudExadataInfrastructure}/dbSe
      rvers/{db_server}
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsCloudExadataInfrastructuresDbServersListRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsCloudExadataInfrastructuresDbServersLis
  tRequest object.

  Fields:
    pageSize: Optional. The maximum number of items to return. If unspecified,
      at most 50 db servers will be returned. The maximum value is 1000;
      values above 1000 will be coerced to 1000.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListDbServersRequest Format: projects/{
      project}/locations/{location}/cloudExadataInfrastructures/{cloudExadataI
      nfrastructure}/dbServers
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class OracledatabaseProjectsLocationsCloudExadataInfrastructuresDeleteRequest(_messages.Message):
  r"""A
  OracledatabaseProjectsLocationsCloudExadataInfrastructuresDeleteRequest
  object.

  Fields:
    force: Optional. If set to true, child resource will be deleted. Request
      will only work there are not child resources.
    name: Required. Name of the resource Format: projects/{project}/locations/
      {location}/cloudExadataInfrastructures/{cloud_exadata_infrastructure}
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class OracledatabaseProjectsLocationsCloudExadataInfrastructuresGetRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsCloudExadataInfrastructuresGetRequest
  object.

  Fields:
    name: Required. Name of the resource. Format projects/{project}/locations/
      {location}/cloudExadataInfrastructures/{cloud_exadata_infrastructure}
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsCloudExadataInfrastructuresListRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsCloudExadataInfrastructuresListRequest
  object.

  Fields:
    pageSize: Optional. The maximum number of items to return. If unspecified,
      at most 50 Exadata infrastructures will be returned. The maximum value
      is 1000; values above 1000 will be coerced to 1000.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListCloudExadataInfrastructuresRequest
      Format: projects/{project}/locations/{location}
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class OracledatabaseProjectsLocationsCloudExadataInfrastructuresPatchRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsCloudExadataInfrastructuresPatchRequest
  object.

  Fields:
    cloudExadataInfrastructure: A CloudExadataInfrastructure resource to be
      passed as the request body.
    name: Identifier. The name of the CloudExadataInfrastructure resource with
      the format: projects/{project}/locations/{region}/cloudExadataInfrastruc
      tures/{cloud_exadata_infrastructure} https://google.aip.dev/122
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the Exadata resource by the update. The fields specified
      in the update_mask are relative to the resource, not the full request. A
      field will be overwritten if it is in the mask. If the user does not
      provide a mask then all fields will be overwritten.
  """

  cloudExadataInfrastructure = _messages.MessageField('CloudExadataInfrastructure', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class OracledatabaseProjectsLocationsCloudVmClustersCreateRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsCloudVmClustersCreateRequest object.

  Fields:
    cloudVmCluster: A CloudVmCluster resource to be passed as the request
      body.
    cloudVmClusterId: Required. The ID to use for the vmCluster, which will
      become the final component of the resource name. This value should be
      4-63 characters, and valid characters are /a-z-/.
    parent: Required. Value for parent. Format:
      projects/{project}/locations/{location}
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  cloudVmCluster = _messages.MessageField('CloudVmCluster', 1)
  cloudVmClusterId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class OracledatabaseProjectsLocationsCloudVmClustersDbNodesGetRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsCloudVmClustersDbNodesGetRequest
  object.

  Fields:
    name: Required. Name of the resource. Format projects/{project}/locations/
      {location}/cloudVmClusters/{cloud_vm_cluster}/dbNodes/{db_node}
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsCloudVmClustersDbNodesListRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsCloudVmClustersDbNodesListRequest
  object.

  Fields:
    pageSize: Optional. The maximum number of items to return. If unspecified,
      at most 50 db nodes will be returned. The maximum value is 1000; values
      above 1000 will be coerced to 1000.
    pageToken: Optional. A token identifying a page of results the node should
      return.
    parent: Required. Parent value for ListDbNodesRequest Format: projects/{pr
      oject}/locations/{location}/cloudVmClusters/{cloudVmCluster}/dbNodes
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class OracledatabaseProjectsLocationsCloudVmClustersDeleteRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsCloudVmClustersDeleteRequest object.

  Fields:
    force: Optional. If set to true, child resource will be deleted. Request
      will only work there are not child resources.
    name: Required. Name of the resource Format:
      projects/{project}/locations/{location}/cloudVmClusters/{cloud_vm_cluste
      r}
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class OracledatabaseProjectsLocationsCloudVmClustersGetRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsCloudVmClustersGetRequest object.

  Fields:
    name: Required. Name of the resource. Format
      projects/{project}/locations/{location}/cloudVmClusters/{cloud_vm_cluste
      r}
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsCloudVmClustersListRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsCloudVmClustersListRequest object.

  Fields:
    filter: Optional. Filtering results
    pageSize: Optional. The maximum number of items to return. If unspecified,
      at most 50 vm clusters will be returned. The maximum value is 1000;
      values above 1000 will be coerced to 1000.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListCloudVmClustersRequest Format:
      projects/{project}/locations/{location}
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class OracledatabaseProjectsLocationsCloudVmClustersPatchRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsCloudVmClustersPatchRequest object.

  Fields:
    cloudVmCluster: A CloudVmCluster resource to be passed as the request
      body.
    name: Identifier. The name of the VM Cluster resource with the format:
      projects/{project}/locations/{region}/cloudVmClusters/{cloud_vm_cluster}
      https://google.aip.dev/122
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the VmCluster resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields will be overwritten.
  """

  cloudVmCluster = _messages.MessageField('CloudVmCluster', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class OracledatabaseProjectsLocationsDbSystemShapesGetRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsDbSystemShapesGetRequest object.

  Fields:
    name: Required. Name of the resource. Format
      projects/{project}/locations/{location}/dbSystemShapes/{db_system_shape}
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsDbSystemShapesListRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsDbSystemShapesListRequest object.

  Fields:
    pageSize: Optional. The maximum number of items to return. If unspecified,
      at most 50 Db System Shapes will be returned. The maximum value is 1000;
      values above 1000 will be coerced to 1000.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListDbSystemShapesRequest Format:
      projects/{project}/locations/{location}
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class OracledatabaseProjectsLocationsEntitlementsGetRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsEntitlementsGetRequest object.

  Fields:
    name: Required. Name of the resource. Format
      projects/{project}/locations/{location}/entitlements/{entitlement}
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsEntitlementsListRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsEntitlementsListRequest object.

  Fields:
    pageSize: Optional. The maximum number of items to return. If unspecified,
      at most 50 entitlements will be returned. The maximum value is 1000;
      values above 1000 will be coerced to 1000.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListEntitlementsRequest Format:
      projects/{project}/locations/{location}/entitlements
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class OracledatabaseProjectsLocationsGetRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsGiVersionsGetRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsGiVersionsGetRequest object.

  Fields:
    name: Required. Name of the resource. Format
      projects/{project}/locations/{location}/giVersions/{gi_version}
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsGiVersionsListRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsGiVersionsListRequest object.

  Fields:
    pageSize: Optional. The maximum number of items to return. If unspecified,
      at most 50 gi versions will be returned. The maximum value is 1000;
      values above 1000 will be coerced to 1000.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListGiVersionsRequest Format:
      projects/{project}/locations/{location}
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class OracledatabaseProjectsLocationsListRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    includeUnrevealedLocations: If true, the returned list will include
      locations which are not yet revealed.
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  includeUnrevealedLocations = _messages.BooleanField(2)
  name = _messages.StringField(3, required=True)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)


class OracledatabaseProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class OracledatabaseProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class OracledatabaseProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A OracledatabaseProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class ScheduledOperationDetails(_messages.Message):
  r"""Details of scheduled operation. https://docs.oracle.com/en-
  us/iaas/api/#/en/database/20160918/datatypes/ScheduledOperationDetails

  Enums:
    DayOfWeekValueValuesEnum: Output only. Day of week.

  Fields:
    dayOfWeek: Output only. Day of week.
    scheduledStartTime: Output only. Auto start time.
    scheduledStopTime: Output only. Auto stop time.
  """

  class DayOfWeekValueValuesEnum(_messages.Enum):
    r"""Output only. Day of week.

    Values:
      DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
      MONDAY: Monday
      TUESDAY: Tuesday
      WEDNESDAY: Wednesday
      THURSDAY: Thursday
      FRIDAY: Friday
      SATURDAY: Saturday
      SUNDAY: Sunday
    """
    DAY_OF_WEEK_UNSPECIFIED = 0
    MONDAY = 1
    TUESDAY = 2
    WEDNESDAY = 3
    THURSDAY = 4
    FRIDAY = 5
    SATURDAY = 6
    SUNDAY = 7

  dayOfWeek = _messages.EnumField('DayOfWeekValueValuesEnum', 1)
  scheduledStartTime = _messages.StringField(2)
  scheduledStopTime = _messages.StringField(3)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class TimeZone(_messages.Message):
  r"""Represents a time zone from the [IANA Time Zone
  Database](https://www.iana.org/time-zones).

  Fields:
    id: IANA Time Zone Database time zone, e.g. "America/New_York".
    version: Optional. IANA Time Zone Database version number, e.g. "2019a".
  """

  id = _messages.StringField(1)
  version = _messages.StringField(2)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
