"""Generated message classes for networkconnectivity version v1beta.

This API enables connectivity with and between Google Cloud resources.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'networkconnectivity'


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class GoogleCloudLocationListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('GoogleCloudLocationLocation', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudLocationLocation(_messages.Message):
  r"""A resource that represents a Google Cloud location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class GoogleCloudNetworkconnectivityV1betaAcceptHubSpokeRequest(_messages.Message):
  r"""The request for HubService.AcceptHubSpoke.

  Fields:
    requestId: Optional. A request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server knows to
      ignore the request if it has already been completed. The server
      guarantees that a request doesn't result in creation of duplicate
      commitments for at least 60 minutes. For example, consider a situation
      where you make an initial request and the request times out. If you make
      the request again with the same request ID, the server can check to see
      whether the original operation was received. If it was, the server
      ignores the second request. This behavior prevents clients from
      mistakenly creating duplicate commitments. The request ID must be a
      valid UUID, with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    spokeUri: Required. The URI of the spoke to accept into the hub.
  """

  requestId = _messages.StringField(1)
  spokeUri = _messages.StringField(2)


class GoogleCloudNetworkconnectivityV1betaAcceptHubSpokeResponse(_messages.Message):
  r"""The response for HubService.AcceptHubSpoke.

  Fields:
    spoke: The spoke that was operated on.
  """

  spoke = _messages.MessageField('GoogleCloudNetworkconnectivityV1betaSpoke', 1)


class GoogleCloudNetworkconnectivityV1betaCustomHardwareInstance(_messages.Message):
  r"""Message describing CustomHardwareInstance object

  Messages:
    LabelsValue: Optional. User-defined labels.

  Fields:
    createTime: Output only. Time when the CustomHardwareInstance was created.
    labels: Optional. User-defined labels.
    name: Identifier. The name of a CustomHardwareInstance. Format: `projects/
      {project}/locations/{location}/customHardwareInstances/{custom_hardware_
      instance}`.
    region: Required. The region associated with the custom hardware instance.
      Example: us-central1
    updateTime: Output only. Time when the CustomHardwareInstance was updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. User-defined labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  name = _messages.StringField(3)
  region = _messages.StringField(4)
  updateTime = _messages.StringField(5)


class GoogleCloudNetworkconnectivityV1betaCustomHardwareLinkAttachment(_messages.Message):
  r"""Message describing CustomHardwareLinkAttachment object

  Enums:
    LinkTypeValueValuesEnum: Required. The type of custom hardware link
      attachment.

  Messages:
    LabelsValue: Optional. User-defined labels.

  Fields:
    createTime: Output only. Time when the CustomHardwareLinkAttachment was
      created.
    labels: Optional. User-defined labels.
    linkType: Required. The type of custom hardware link attachment.
    name: Identifier. The name of a CustomHardwareLinkAttachment. Format: `pro
      jects/{project}/locations/{location}/customHardwareLinkAttachments/{cust
      om_hardware_link_attachment}`.
    network: The name of the VPC network for this custom hardware link
      attachment. Format: `projects/{project}/global/networks/{network}`
    project: The consumer project where custom hardware instance are created.
      Format: `projects/{project}`
    updateTime: Output only. Time when the CustomHardwareLinkAttachment was
      updated.
  """

  class LinkTypeValueValuesEnum(_messages.Enum):
    r"""Required. The type of custom hardware link attachment.

    Values:
      LINK_TYPE_UNSPECIFIED: An invalid type as the default case.
      REGULAR: Regular traffic type.
      ULL: Ultra-low latency traffic type.
    """
    LINK_TYPE_UNSPECIFIED = 0
    REGULAR = 1
    ULL = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. User-defined labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  linkType = _messages.EnumField('LinkTypeValueValuesEnum', 3)
  name = _messages.StringField(4)
  network = _messages.StringField(5)
  project = _messages.StringField(6)
  updateTime = _messages.StringField(7)


class GoogleCloudNetworkconnectivityV1betaCustomHardwareLinkConnectPair(_messages.Message):
  r"""Message describing CustomHardwareLinkConnectPair object

  Messages:
    LabelsValue: Optional. User-defined labels.

  Fields:
    createTime: Output only. Time when the CustomHardwareLinkConnectPair was
      created.
    labels: Optional. User-defined labels.
    name: Identifier. The name of a CustomHardwareLinkConnectPair. The name is
      restricted to letters, numbers and with the first character being a
      letter, the last a letter or a number. Format: `projects/{project}/locat
      ions/{location}/customHardwareLinkConnectPairs/{custom_hardware_link_con
      nect_pair}` where custom_hardware_link_connect_pair must match the regex
      `^[a-zA-Z0-9-]*[a-zA-Z0-9]$`
    updateTime: Output only. Time when the CustomHardwareLinkConnectPair was
      updated.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. User-defined labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  name = _messages.StringField(3)
  updateTime = _messages.StringField(4)


class GoogleCloudNetworkconnectivityV1betaGroup(_messages.Message):
  r"""A group represents a subset of spokes attached to a hub.

  Enums:
    StateValueValuesEnum: Output only. The current lifecycle state of this
      group.

  Messages:
    LabelsValue: Optional. Labels in key-value pair format. For more
      information about labels, see [Requirements for
      labels](https://cloud.google.com/resource-manager/docs/creating-
      managing-labels#requirements).

  Fields:
    createTime: Output only. The time the group was created.
    description: Optional. The description of the group.
    labels: Optional. Labels in key-value pair format. For more information
      about labels, see [Requirements for
      labels](https://cloud.google.com/resource-manager/docs/creating-
      managing-labels#requirements).
    name: Immutable. The name of the group. Group names must be unique. They
      use the following form: `projects/{project_number}/locations/global/hubs
      /{hub}/groups/{group_id}`
    state: Output only. The current lifecycle state of this group.
    uid: Output only. The Google-generated UUID for the group. This value is
      unique across all group resources. If a group is deleted and another
      with the same name is created, the new route table is assigned a
      different unique_id.
    updateTime: Output only. The time the group was last updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current lifecycle state of this group.

    Values:
      STATE_UNSPECIFIED: No state information available
      CREATING: The resource's create operation is in progress.
      ACTIVE: The resource is active
      DELETING: The resource's delete operation is in progress.
      ACCEPTING: The resource's accept operation is in progress.
      REJECTING: The resource's reject operation is in progress.
      UPDATING: The resource's update operation is in progress.
      INACTIVE: The resource is inactive.
      OBSOLETE: The hub associated with this spoke resource has been deleted.
        This state applies to spoke resources only.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    ACTIVE = 2
    DELETING = 3
    ACCEPTING = 4
    REJECTING = 5
    UPDATING = 6
    INACTIVE = 7
    OBSOLETE = 8

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels in key-value pair format. For more information about
    labels, see [Requirements for labels](https://cloud.google.com/resource-
    manager/docs/creating-managing-labels#requirements).

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  name = _messages.StringField(4)
  state = _messages.EnumField('StateValueValuesEnum', 5)
  uid = _messages.StringField(6)
  updateTime = _messages.StringField(7)


class GoogleCloudNetworkconnectivityV1betaHub(_messages.Message):
  r"""A Network Connectivity Center hub is a global management resource to
  which you attach spokes. A single hub can contain spokes from multiple
  regions. However, if any of a hub's spokes use the site-to-site data
  transfer feature, the resources associated with those spokes must all be in
  the same VPC network. Spokes that do not use site-to-site data transfer can
  be associated with any VPC network in your project.

  Enums:
    StateValueValuesEnum: Output only. The current lifecycle state of this
      hub.

  Messages:
    LabelsValue: Optional labels in key-value pair format. For more
      information about labels, see [Requirements for
      labels](https://cloud.google.com/resource-manager/docs/creating-
      managing-labels#requirements).

  Fields:
    createTime: Output only. The time the hub was created.
    description: An optional description of the hub.
    labels: Optional labels in key-value pair format. For more information
      about labels, see [Requirements for
      labels](https://cloud.google.com/resource-manager/docs/creating-
      managing-labels#requirements).
    name: Immutable. The name of the hub. Hub names must be unique. They use
      the following form:
      `projects/{project_number}/locations/global/hubs/{hub_id}`
    routeTables: Output only. The route tables that belong to this hub. They
      use the following form: `projects/{project_number}/locations/global/hubs
      /{hub_id}/routeTables/{route_table_id}` This field is read-only. Network
      Connectivity Center automatically populates it based on the route tables
      nested under the hub.
    routingVpcs: The VPC networks associated with this hub's spokes. This
      field is read-only. Network Connectivity Center automatically populates
      it based on the set of spokes attached to the hub.
    spokeSummary: Output only. A summary of the spokes associated with a hub.
      The summary includes a count of spokes according to type and according
      to state. If any spokes are inactive, the summary also lists the reasons
      they are inactive, including a count for each reason.
    state: Output only. The current lifecycle state of this hub.
    uniqueId: Output only. The Google-generated UUID for the hub. This value
      is unique across all hub resources. If a hub is deleted and another with
      the same name is created, the new hub is assigned a different unique_id.
    updateTime: Output only. The time the hub was last updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current lifecycle state of this hub.

    Values:
      STATE_UNSPECIFIED: No state information available
      CREATING: The resource's create operation is in progress.
      ACTIVE: The resource is active
      DELETING: The resource's delete operation is in progress.
      ACCEPTING: The resource's accept operation is in progress.
      REJECTING: The resource's reject operation is in progress.
      UPDATING: The resource's update operation is in progress.
      INACTIVE: The resource is inactive.
      OBSOLETE: The hub associated with this spoke resource has been deleted.
        This state applies to spoke resources only.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    ACTIVE = 2
    DELETING = 3
    ACCEPTING = 4
    REJECTING = 5
    UPDATING = 6
    INACTIVE = 7
    OBSOLETE = 8

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional labels in key-value pair format. For more information about
    labels, see [Requirements for labels](https://cloud.google.com/resource-
    manager/docs/creating-managing-labels#requirements).

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  name = _messages.StringField(4)
  routeTables = _messages.StringField(5, repeated=True)
  routingVpcs = _messages.MessageField('GoogleCloudNetworkconnectivityV1betaRoutingVPC', 6, repeated=True)
  spokeSummary = _messages.MessageField('GoogleCloudNetworkconnectivityV1betaSpokeSummary', 7)
  state = _messages.EnumField('StateValueValuesEnum', 8)
  uniqueId = _messages.StringField(9)
  updateTime = _messages.StringField(10)


class GoogleCloudNetworkconnectivityV1betaLinkedInterconnectAttachments(_messages.Message):
  r"""A collection of VLAN attachment resources. These resources should be
  redundant attachments that all advertise the same prefixes to Google Cloud.
  Alternatively, in active/passive configurations, all attachments should be
  capable of advertising the same prefixes.

  Fields:
    siteToSiteDataTransfer: A value that controls whether site-to-site data
      transfer is enabled for these resources. Data transfer is available only
      in [supported locations](https://cloud.google.com/network-
      connectivity/docs/network-connectivity-center/concepts/locations).
    uris: The URIs of linked interconnect attachment resources
    vpcNetwork: Output only. The VPC network where these VLAN attachments are
      located.
  """

  siteToSiteDataTransfer = _messages.BooleanField(1)
  uris = _messages.StringField(2, repeated=True)
  vpcNetwork = _messages.StringField(3)


class GoogleCloudNetworkconnectivityV1betaLinkedRouterApplianceInstances(_messages.Message):
  r"""A collection of router appliance instances. If you configure multiple
  router appliance instances to receive data from the same set of sites
  outside of Google Cloud, we recommend that you associate those instances
  with the same spoke.

  Fields:
    instances: The list of router appliance instances.
    siteToSiteDataTransfer: A value that controls whether site-to-site data
      transfer is enabled for these resources. Data transfer is available only
      in [supported locations](https://cloud.google.com/network-
      connectivity/docs/network-connectivity-center/concepts/locations).
    vpcNetwork: Output only. The VPC network where these router appliance
      instances are located.
  """

  instances = _messages.MessageField('GoogleCloudNetworkconnectivityV1betaRouterApplianceInstance', 1, repeated=True)
  siteToSiteDataTransfer = _messages.BooleanField(2)
  vpcNetwork = _messages.StringField(3)


class GoogleCloudNetworkconnectivityV1betaLinkedVpcNetwork(_messages.Message):
  r"""An existing VPC network.

  Fields:
    excludeExportRanges: Optional. IP ranges encompassing the subnets to be
      excluded from peering.
    uri: Required. The URI of the VPC network resource.
  """

  excludeExportRanges = _messages.StringField(1, repeated=True)
  uri = _messages.StringField(2)


class GoogleCloudNetworkconnectivityV1betaLinkedVpnTunnels(_messages.Message):
  r"""A collection of Cloud VPN tunnel resources. These resources should be
  redundant HA VPN tunnels that all advertise the same prefixes to Google
  Cloud. Alternatively, in a passive/active configuration, all tunnels should
  be capable of advertising the same prefixes.

  Fields:
    siteToSiteDataTransfer: A value that controls whether site-to-site data
      transfer is enabled for these resources. Data transfer is available only
      in [supported locations](https://cloud.google.com/network-
      connectivity/docs/network-connectivity-center/concepts/locations).
    uris: The URIs of linked VPN tunnel resources.
    vpcNetwork: Output only. The VPC network where these VPN tunnels are
      located.
  """

  siteToSiteDataTransfer = _messages.BooleanField(1)
  uris = _messages.StringField(2, repeated=True)
  vpcNetwork = _messages.StringField(3)


class GoogleCloudNetworkconnectivityV1betaListCustomHardwareInstancesResponse(_messages.Message):
  r"""Response for ListCustomHardwareInstances.

  Fields:
    customHardwareInstances: The list of CustomHardwareInstance
    nextPageToken: The next pagination token in the List response. It should
      be used as page_token for the following request. An empty value means no
      more result.
    unreachable: Locations that could not be reached.
  """

  customHardwareInstances = _messages.MessageField('GoogleCloudNetworkconnectivityV1betaCustomHardwareInstance', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class GoogleCloudNetworkconnectivityV1betaListCustomHardwareLinkAttachmentsResponse(_messages.Message):
  r"""Response for ListCustomHardwareLinkAttachments.

  Fields:
    customHardwareLinkAttachments: The list of CustomHardwareLinkAttachment
    nextPageToken: The next pagination token in the List response. It should
      be used as page_token for the following request. An empty value means no
      more result.
    unreachable: Locations that could not be reached.
  """

  customHardwareLinkAttachments = _messages.MessageField('GoogleCloudNetworkconnectivityV1betaCustomHardwareLinkAttachment', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class GoogleCloudNetworkconnectivityV1betaListCustomHardwareLinkConnectPairsResponse(_messages.Message):
  r"""Response for ListCustomHardwareLinkConnectPairs.

  Fields:
    customHardwareLinkConnectPairs: The list of CustomHardwareLinkConnectPair
    nextPageToken: The next pagination token in the List response. It should
      be used as page_token for the following request. An empty value means no
      more result.
    unreachable: Locations that could not be reached.
  """

  customHardwareLinkConnectPairs = _messages.MessageField('GoogleCloudNetworkconnectivityV1betaCustomHardwareLinkConnectPair', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class GoogleCloudNetworkconnectivityV1betaListGroupsResponse(_messages.Message):
  r"""Response for HubService.ListGroups method.

  Fields:
    groups: The requested groups.
    nextPageToken: The token for the next page of the response. To see more
      results, use this value as the page_token for your next request. If this
      value is empty, there are no more results.
    unreachable: Hubs that could not be reached.
  """

  groups = _messages.MessageField('GoogleCloudNetworkconnectivityV1betaGroup', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class GoogleCloudNetworkconnectivityV1betaListHubSpokesResponse(_messages.Message):
  r"""The response for HubService.ListHubSpokes.

  Fields:
    nextPageToken: The token for the next page of the response. To see more
      results, use this value as the page_token for your next request. If this
      value is empty, there are no more results.
    spokes: The requested spokes. The spoke fields can be partially populated
      based on the `view` field in the request message.
    unreachable: Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  spokes = _messages.MessageField('GoogleCloudNetworkconnectivityV1betaSpoke', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class GoogleCloudNetworkconnectivityV1betaListHubsResponse(_messages.Message):
  r"""Response for HubService.ListHubs method.

  Fields:
    hubs: The requested hubs.
    nextPageToken: The token for the next page of the response. To see more
      results, use this value as the page_token for your next request. If this
      value is empty, there are no more results.
    unreachable: Locations that could not be reached.
  """

  hubs = _messages.MessageField('GoogleCloudNetworkconnectivityV1betaHub', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class GoogleCloudNetworkconnectivityV1betaListRegionalEndpointsResponse(_messages.Message):
  r"""Response for ListRegionalEndpoints.

  Fields:
    nextPageToken: The next pagination token in the List response. It should
      be used as page_token for the following request. An empty value means no
      more result.
    regionalEndpoints: Regional endpoints to be returned.
    unreachable: Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  regionalEndpoints = _messages.MessageField('GoogleCloudNetworkconnectivityV1betaRegionalEndpoint', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class GoogleCloudNetworkconnectivityV1betaListRouteTablesResponse(_messages.Message):
  r"""Response for HubService.ListRouteTables method.

  Fields:
    nextPageToken: The token for the next page of the response. To see more
      results, use this value as the page_token for your next request. If this
      value is empty, there are no more results.
    routeTables: The requested route tables.
    unreachable: Hubs that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  routeTables = _messages.MessageField('GoogleCloudNetworkconnectivityV1betaRouteTable', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class GoogleCloudNetworkconnectivityV1betaListRoutesResponse(_messages.Message):
  r"""Response for HubService.ListRoutes method.

  Fields:
    nextPageToken: The token for the next page of the response. To see more
      results, use this value as the page_token for your next request. If this
      value is empty, there are no more results.
    routes: The requested routes.
    unreachable: RouteTables that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  routes = _messages.MessageField('GoogleCloudNetworkconnectivityV1betaRoute', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class GoogleCloudNetworkconnectivityV1betaListSpokesResponse(_messages.Message):
  r"""The response for HubService.ListSpokes.

  Fields:
    nextPageToken: The token for the next page of the response. To see more
      results, use this value as the page_token for your next request. If this
      value is empty, there are no more results.
    spokes: The requested spokes.
    unreachable: Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  spokes = _messages.MessageField('GoogleCloudNetworkconnectivityV1betaSpoke', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class GoogleCloudNetworkconnectivityV1betaLocationMetadata(_messages.Message):
  r"""Metadata about locations

  Enums:
    LocationFeaturesValueListEntryValuesEnum:

  Fields:
    locationFeatures: List of supported features
  """

  class LocationFeaturesValueListEntryValuesEnum(_messages.Enum):
    r"""LocationFeaturesValueListEntryValuesEnum enum type.

    Values:
      LOCATION_FEATURE_UNSPECIFIED: No publicly supported feature in this
        location
      SITE_TO_CLOUD_SPOKES: Site-to-cloud spokes are supported in this
        location
      SITE_TO_SITE_SPOKES: Site-to-site spokes are supported in this location
    """
    LOCATION_FEATURE_UNSPECIFIED = 0
    SITE_TO_CLOUD_SPOKES = 1
    SITE_TO_SITE_SPOKES = 2

  locationFeatures = _messages.EnumField('LocationFeaturesValueListEntryValuesEnum', 1, repeated=True)


class GoogleCloudNetworkconnectivityV1betaNextHopVpcNetwork(_messages.Message):
  r"""A GoogleCloudNetworkconnectivityV1betaNextHopVpcNetwork object.

  Fields:
    uri: The URI of the VPC network resource
  """

  uri = _messages.StringField(1)


class GoogleCloudNetworkconnectivityV1betaOperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have been
      cancelled successfully have Operation.error value with a
      google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class GoogleCloudNetworkconnectivityV1betaRegionalEndpoint(_messages.Message):
  r"""The RegionalEndpoint resource.

  Enums:
    AccessTypeValueValuesEnum: Required. The access type of this regional
      endpoint. This field is reflected in the PSC Forwarding Rule
      configuration to enable global access.

  Messages:
    LabelsValue: User-defined labels.

  Fields:
    accessType: Required. The access type of this regional endpoint. This
      field is reflected in the PSC Forwarding Rule configuration to enable
      global access.
    address: Optional. The IP Address of the Regional Endpoint. When no
      address is provided, an IP from the subnetwork is allocated. Use one of
      the following formats: * IPv4 address as in `10.0.0.1` * Address
      resource URI as in
      `projects/{project}/regions/{region}/addresses/{address_name}`
    createTime: Output only. Time when the RegionalEndpoint was created.
    description: Optional. A description of this resource.
    ipAddress: Output only. The literal IP address of the PSC Forwarding Rule
      created on behalf of the customer. This field is deprecated. Use address
      instead.
    labels: User-defined labels.
    name: Output only. The name of a RegionalEndpoint. Format: `projects/{proj
      ect}/locations/{location}/regionalEndpoints/{regional_endpoint}`.
    network: The name of the VPC network for this private regional endpoint.
      Format: `projects/{project}/global/networks/{network}`
    pscForwardingRule: Output only. The resource reference of the PSC
      Forwarding Rule created on behalf of the customer. Format: `//compute.go
      ogleapis.com/projects/{project}/regions/{region}/forwardingRules/{forwar
      ding_rule_name}`
    subnetwork: The name of the subnetwork from which the IP address will be
      allocated. Format:
      `projects/{project}/regions/{region}/subnetworks/{subnetwork}`
    targetGoogleApi: Required. The service endpoint this private regional
      endpoint connects to. Format: `{apiname}.{region}.p.rep.googleapis.com`
      Example: "cloudkms.us-central1.p.rep.googleapis.com".
    updateTime: Output only. Time when the RegionalEndpoint was updated.
  """

  class AccessTypeValueValuesEnum(_messages.Enum):
    r"""Required. The access type of this regional endpoint. This field is
    reflected in the PSC Forwarding Rule configuration to enable global
    access.

    Values:
      ACCESS_TYPE_UNSPECIFIED: An invalid type as the default case.
      GLOBAL: This regional endpoint is accessible from all regions.
      REGIONAL: This regional endpoint is only accessible from the same region
        where it resides.
    """
    ACCESS_TYPE_UNSPECIFIED = 0
    GLOBAL = 1
    REGIONAL = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""User-defined labels.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  accessType = _messages.EnumField('AccessTypeValueValuesEnum', 1)
  address = _messages.StringField(2)
  createTime = _messages.StringField(3)
  description = _messages.StringField(4)
  ipAddress = _messages.StringField(5)
  labels = _messages.MessageField('LabelsValue', 6)
  name = _messages.StringField(7)
  network = _messages.StringField(8)
  pscForwardingRule = _messages.StringField(9)
  subnetwork = _messages.StringField(10)
  targetGoogleApi = _messages.StringField(11)
  updateTime = _messages.StringField(12)


class GoogleCloudNetworkconnectivityV1betaRejectHubSpokeRequest(_messages.Message):
  r"""The request for HubService.RejectHubSpoke.

  Fields:
    details: Optional. Additional information provided by the hub
      administrator.
    requestId: Optional. A request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server knows to
      ignore the request if it has already been completed. The server
      guarantees that a request doesn't result in creation of duplicate
      commitments for at least 60 minutes. For example, consider a situation
      where you make an initial request and the request times out. If you make
      the request again with the same request ID, the server can check to see
      whether the original operation was received. If it was, the server
      ignores the second request. This behavior prevents clients from
      mistakenly creating duplicate commitments. The request ID must be a
      valid UUID, with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    spokeUri: Required. The URI of the spoke to reject from the hub.
  """

  details = _messages.StringField(1)
  requestId = _messages.StringField(2)
  spokeUri = _messages.StringField(3)


class GoogleCloudNetworkconnectivityV1betaRejectHubSpokeResponse(_messages.Message):
  r"""The response for HubService.RejectHubSpoke.

  Fields:
    spoke: The spoke that was operated on.
  """

  spoke = _messages.MessageField('GoogleCloudNetworkconnectivityV1betaSpoke', 1)


class GoogleCloudNetworkconnectivityV1betaRoute(_messages.Message):
  r"""A route defines a path from VM instances within a spoke to a specific
  destination resource. Only VPC spokes have routes.

  Enums:
    StateValueValuesEnum: Output only. The current lifecycle state of the
      route.
    TypeValueValuesEnum: Output only. The route's type. Its type is determined
      by the properties of its IP address range.

  Messages:
    LabelsValue: Optional labels in key-value pair format. For more
      information about labels, see [Requirements for
      labels](https://cloud.google.com/resource-manager/docs/creating-
      managing-labels#requirements).

  Fields:
    createTime: Output only. The time the route was created.
    description: An optional description of the route.
    ipCidrRange: The destination IP address range.
    labels: Optional labels in key-value pair format. For more information
      about labels, see [Requirements for
      labels](https://cloud.google.com/resource-manager/docs/creating-
      managing-labels#requirements).
    location: Output only. The origin location of the route. Uses the
      following form: "projects/{project}/locations/{location}" Example:
      projects/1234/locations/us-central1
    name: Immutable. The name of the route. Route names must be unique. Route
      names use the following form: `projects/{project_number}/locations/globa
      l/hubs/{hub}/routeTables/{route_table_id}/routes/{route_id}`
    nextHopVpcNetwork: Immutable. The destination VPC network for packets on
      this route.
    spoke: Immutable. The spoke that this route leads to. Example:
      projects/12345/locations/global/spokes/SPOKE
    state: Output only. The current lifecycle state of the route.
    type: Output only. The route's type. Its type is determined by the
      properties of its IP address range.
    uid: Output only. The Google-generated UUID for the route. This value is
      unique across all Network Connectivity Center route resources. If a
      route is deleted and another with the same name is created, the new
      route is assigned a different `uid`.
    updateTime: Output only. The time the route was last updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current lifecycle state of the route.

    Values:
      STATE_UNSPECIFIED: No state information available
      CREATING: The resource's create operation is in progress.
      ACTIVE: The resource is active
      DELETING: The resource's delete operation is in progress.
      ACCEPTING: The resource's accept operation is in progress.
      REJECTING: The resource's reject operation is in progress.
      UPDATING: The resource's update operation is in progress.
      INACTIVE: The resource is inactive.
      OBSOLETE: The hub associated with this spoke resource has been deleted.
        This state applies to spoke resources only.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    ACTIVE = 2
    DELETING = 3
    ACCEPTING = 4
    REJECTING = 5
    UPDATING = 6
    INACTIVE = 7
    OBSOLETE = 8

  class TypeValueValuesEnum(_messages.Enum):
    r"""Output only. The route's type. Its type is determined by the
    properties of its IP address range.

    Values:
      ROUTE_TYPE_UNSPECIFIED: No route type information specified
      VPC_PRIMARY_SUBNET: The route leads to a destination within the primary
        address range of the VPC network's subnet.
      VPC_SECONDARY_SUBNET: The route leads to a destination within the
        secondary address range of the VPC network's subnet.
    """
    ROUTE_TYPE_UNSPECIFIED = 0
    VPC_PRIMARY_SUBNET = 1
    VPC_SECONDARY_SUBNET = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional labels in key-value pair format. For more information about
    labels, see [Requirements for labels](https://cloud.google.com/resource-
    manager/docs/creating-managing-labels#requirements).

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  ipCidrRange = _messages.StringField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  location = _messages.StringField(5)
  name = _messages.StringField(6)
  nextHopVpcNetwork = _messages.MessageField('GoogleCloudNetworkconnectivityV1betaNextHopVpcNetwork', 7)
  spoke = _messages.StringField(8)
  state = _messages.EnumField('StateValueValuesEnum', 9)
  type = _messages.EnumField('TypeValueValuesEnum', 10)
  uid = _messages.StringField(11)
  updateTime = _messages.StringField(12)


class GoogleCloudNetworkconnectivityV1betaRouteTable(_messages.Message):
  r"""A GoogleCloudNetworkconnectivityV1betaRouteTable object.

  Enums:
    StateValueValuesEnum: Output only. The current lifecycle state of this
      route table.

  Messages:
    LabelsValue: Optional labels in key-value pair format. For more
      information about labels, see [Requirements for
      labels](https://cloud.google.com/resource-manager/docs/creating-
      managing-labels#requirements).

  Fields:
    createTime: Output only. The time the route table was created.
    description: An optional description of the route table.
    labels: Optional labels in key-value pair format. For more information
      about labels, see [Requirements for
      labels](https://cloud.google.com/resource-manager/docs/creating-
      managing-labels#requirements).
    name: Immutable. The name of the route table. Route table names must be
      unique. They use the following form: `projects/{project_number}/location
      s/global/hubs/{hub}/routeTables/{route_table_id}`
    state: Output only. The current lifecycle state of this route table.
    uid: Output only. The Google-generated UUID for the route table. This
      value is unique across all route table resources. If a route table is
      deleted and another with the same name is created, the new route table
      is assigned a different `uid`.
    updateTime: Output only. The time the route table was last updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current lifecycle state of this route table.

    Values:
      STATE_UNSPECIFIED: No state information available
      CREATING: The resource's create operation is in progress.
      ACTIVE: The resource is active
      DELETING: The resource's delete operation is in progress.
      ACCEPTING: The resource's accept operation is in progress.
      REJECTING: The resource's reject operation is in progress.
      UPDATING: The resource's update operation is in progress.
      INACTIVE: The resource is inactive.
      OBSOLETE: The hub associated with this spoke resource has been deleted.
        This state applies to spoke resources only.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    ACTIVE = 2
    DELETING = 3
    ACCEPTING = 4
    REJECTING = 5
    UPDATING = 6
    INACTIVE = 7
    OBSOLETE = 8

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional labels in key-value pair format. For more information about
    labels, see [Requirements for labels](https://cloud.google.com/resource-
    manager/docs/creating-managing-labels#requirements).

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  name = _messages.StringField(4)
  state = _messages.EnumField('StateValueValuesEnum', 5)
  uid = _messages.StringField(6)
  updateTime = _messages.StringField(7)


class GoogleCloudNetworkconnectivityV1betaRouterApplianceInstance(_messages.Message):
  r"""A router appliance instance is a Compute Engine virtual machine (VM)
  instance that acts as a BGP speaker. A router appliance instance is
  specified by the URI of the VM and the internal IP address of one of the
  VM's network interfaces.

  Fields:
    ipAddress: The IP address on the VM to use for peering.
    virtualMachine: The URI of the VM.
  """

  ipAddress = _messages.StringField(1)
  virtualMachine = _messages.StringField(2)


class GoogleCloudNetworkconnectivityV1betaRoutingVPC(_messages.Message):
  r"""RoutingVPC contains information about the VPC networks associated with
  the spokes of a Network Connectivity Center hub.

  Fields:
    requiredForNewSiteToSiteDataTransferSpokes: Output only. If true,
      indicates that this VPC network is currently associated with spokes that
      use the data transfer feature (spokes where the
      site_to_site_data_transfer field is set to true). If you create new
      spokes that use data transfer, they must be associated with this VPC
      network. At most, one VPC network will have this field set to true.
    uri: The URI of the VPC network.
  """

  requiredForNewSiteToSiteDataTransferSpokes = _messages.BooleanField(1)
  uri = _messages.StringField(2)


class GoogleCloudNetworkconnectivityV1betaSpoke(_messages.Message):
  r"""A Network Connectivity Center spoke represents one or more network
  connectivity resources. When you create a spoke, you associate it with a
  hub. You must also identify a value for exactly one of the following fields:
  * linked_vpn_tunnels * linked_interconnect_attachments *
  linked_router_appliance_instances * linked_vpc_network

  Enums:
    SpokeTypeValueValuesEnum: Output only. The type of resource associated
      with the spoke.
    StateValueValuesEnum: Output only. The current lifecycle state of this
      spoke.

  Messages:
    LabelsValue: Optional labels in key-value pair format. For more
      information about labels, see [Requirements for
      labels](https://cloud.google.com/resource-manager/docs/creating-
      managing-labels#requirements).

  Fields:
    createTime: Output only. The time the spoke was created.
    description: An optional description of the spoke.
    group: Optional. The name of the group that this spoke is associated with.
    hub: Immutable. The name of the hub that this spoke is attached to.
    labels: Optional labels in key-value pair format. For more information
      about labels, see [Requirements for
      labels](https://cloud.google.com/resource-manager/docs/creating-
      managing-labels#requirements).
    linkedInterconnectAttachments: VLAN attachments that are associated with
      the spoke.
    linkedRouterApplianceInstances: Router appliance instances that are
      associated with the spoke.
    linkedVpcNetwork: Optional. VPC network that is associated with the spoke.
    linkedVpnTunnels: VPN tunnels that are associated with the spoke.
    name: Immutable. The name of the spoke. Spoke names must be unique. They
      use the following form:
      `projects/{project_number}/locations/{region}/spokes/{spoke_id}`
    reasons: Output only. The reasons for current state of the spoke. Only
      present when the spoke is in the `INACTIVE` state.
    spokeType: Output only. The type of resource associated with the spoke.
    state: Output only. The current lifecycle state of this spoke.
    uniqueId: Output only. The Google-generated UUID for the spoke. This value
      is unique across all spoke resources. If a spoke is deleted and another
      with the same name is created, the new spoke is assigned a different
      `unique_id`.
    updateTime: Output only. The time the spoke was last updated.
  """

  class SpokeTypeValueValuesEnum(_messages.Enum):
    r"""Output only. The type of resource associated with the spoke.

    Values:
      SPOKE_TYPE_UNSPECIFIED: Unspecified spoke type.
      VPN_TUNNEL: Spokes associated with VPN tunnels.
      INTERCONNECT_ATTACHMENT: Spokes associated with VLAN attachments.
      ROUTER_APPLIANCE: Spokes associated with router appliance instances.
      VPC_NETWORK: Spokes associated with VPC networks.
    """
    SPOKE_TYPE_UNSPECIFIED = 0
    VPN_TUNNEL = 1
    INTERCONNECT_ATTACHMENT = 2
    ROUTER_APPLIANCE = 3
    VPC_NETWORK = 4

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current lifecycle state of this spoke.

    Values:
      STATE_UNSPECIFIED: No state information available
      CREATING: The resource's create operation is in progress.
      ACTIVE: The resource is active
      DELETING: The resource's delete operation is in progress.
      ACCEPTING: The resource's accept operation is in progress.
      REJECTING: The resource's reject operation is in progress.
      UPDATING: The resource's update operation is in progress.
      INACTIVE: The resource is inactive.
      OBSOLETE: The hub associated with this spoke resource has been deleted.
        This state applies to spoke resources only.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    ACTIVE = 2
    DELETING = 3
    ACCEPTING = 4
    REJECTING = 5
    UPDATING = 6
    INACTIVE = 7
    OBSOLETE = 8

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional labels in key-value pair format. For more information about
    labels, see [Requirements for labels](https://cloud.google.com/resource-
    manager/docs/creating-managing-labels#requirements).

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  group = _messages.StringField(3)
  hub = _messages.StringField(4)
  labels = _messages.MessageField('LabelsValue', 5)
  linkedInterconnectAttachments = _messages.MessageField('GoogleCloudNetworkconnectivityV1betaLinkedInterconnectAttachments', 6)
  linkedRouterApplianceInstances = _messages.MessageField('GoogleCloudNetworkconnectivityV1betaLinkedRouterApplianceInstances', 7)
  linkedVpcNetwork = _messages.MessageField('GoogleCloudNetworkconnectivityV1betaLinkedVpcNetwork', 8)
  linkedVpnTunnels = _messages.MessageField('GoogleCloudNetworkconnectivityV1betaLinkedVpnTunnels', 9)
  name = _messages.StringField(10)
  reasons = _messages.MessageField('GoogleCloudNetworkconnectivityV1betaStateReason', 11, repeated=True)
  spokeType = _messages.EnumField('SpokeTypeValueValuesEnum', 12)
  state = _messages.EnumField('StateValueValuesEnum', 13)
  uniqueId = _messages.StringField(14)
  updateTime = _messages.StringField(15)


class GoogleCloudNetworkconnectivityV1betaSpokeStateCount(_messages.Message):
  r"""The number of spokes that are in a particular state and associated with
  a given hub.

  Enums:
    StateValueValuesEnum: Output only. The state of the spokes.

  Fields:
    count: Output only. The total number of spokes that are in this state and
      associated with a given hub.
    state: Output only. The state of the spokes.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The state of the spokes.

    Values:
      STATE_UNSPECIFIED: No state information available
      CREATING: The resource's create operation is in progress.
      ACTIVE: The resource is active
      DELETING: The resource's delete operation is in progress.
      ACCEPTING: The resource's accept operation is in progress.
      REJECTING: The resource's reject operation is in progress.
      UPDATING: The resource's update operation is in progress.
      INACTIVE: The resource is inactive.
      OBSOLETE: The hub associated with this spoke resource has been deleted.
        This state applies to spoke resources only.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    ACTIVE = 2
    DELETING = 3
    ACCEPTING = 4
    REJECTING = 5
    UPDATING = 6
    INACTIVE = 7
    OBSOLETE = 8

  count = _messages.IntegerField(1)
  state = _messages.EnumField('StateValueValuesEnum', 2)


class GoogleCloudNetworkconnectivityV1betaSpokeStateReasonCount(_messages.Message):
  r"""The number of spokes in the hub that are inactive for this reason.

  Enums:
    StateReasonCodeValueValuesEnum: Output only. The reason that a spoke is
      inactive.

  Fields:
    count: Output only. The total number of spokes that are inactive for a
      particular reason and associated with a given hub.
    stateReasonCode: Output only. The reason that a spoke is inactive.
  """

  class StateReasonCodeValueValuesEnum(_messages.Enum):
    r"""Output only. The reason that a spoke is inactive.

    Values:
      CODE_UNSPECIFIED: No information available.
      PENDING_REVIEW: The proposed spoke is pending review.
      REJECTED: The proposed spoke has been rejected by the hub administrator.
      PAUSED: The spoke has been deactivated internally.
      FAILED: Network Connectivity Center encountered errors while accepting
        the spoke.
    """
    CODE_UNSPECIFIED = 0
    PENDING_REVIEW = 1
    REJECTED = 2
    PAUSED = 3
    FAILED = 4

  count = _messages.IntegerField(1)
  stateReasonCode = _messages.EnumField('StateReasonCodeValueValuesEnum', 2)


class GoogleCloudNetworkconnectivityV1betaSpokeSummary(_messages.Message):
  r"""Summarizes information about the spokes associated with a hub. The
  summary includes a count of spokes according to type and according to state.
  If any spokes are inactive, the summary also lists the reasons they are
  inactive, including a count for each reason.

  Fields:
    spokeStateCounts: Output only. Counts the number of spokes that are in
      each state and associated with a given hub.
    spokeStateReasonCounts: Output only. Counts the number of spokes that are
      inactive for each possible reason and associated with a given hub.
    spokeTypeCounts: Output only. Counts the number of spokes of each type
      that are associated with a specific hub.
  """

  spokeStateCounts = _messages.MessageField('GoogleCloudNetworkconnectivityV1betaSpokeStateCount', 1, repeated=True)
  spokeStateReasonCounts = _messages.MessageField('GoogleCloudNetworkconnectivityV1betaSpokeStateReasonCount', 2, repeated=True)
  spokeTypeCounts = _messages.MessageField('GoogleCloudNetworkconnectivityV1betaSpokeTypeCount', 3, repeated=True)


class GoogleCloudNetworkconnectivityV1betaSpokeTypeCount(_messages.Message):
  r"""The number of spokes of a given type that are associated with a specific
  hub. The type indicates what kind of resource is associated with the spoke.

  Enums:
    SpokeTypeValueValuesEnum: Output only. The type of the spokes.

  Fields:
    count: Output only. The total number of spokes of this type that are
      associated with the hub.
    spokeType: Output only. The type of the spokes.
  """

  class SpokeTypeValueValuesEnum(_messages.Enum):
    r"""Output only. The type of the spokes.

    Values:
      SPOKE_TYPE_UNSPECIFIED: Unspecified spoke type.
      VPN_TUNNEL: Spokes associated with VPN tunnels.
      INTERCONNECT_ATTACHMENT: Spokes associated with VLAN attachments.
      ROUTER_APPLIANCE: Spokes associated with router appliance instances.
      VPC_NETWORK: Spokes associated with VPC networks.
    """
    SPOKE_TYPE_UNSPECIFIED = 0
    VPN_TUNNEL = 1
    INTERCONNECT_ATTACHMENT = 2
    ROUTER_APPLIANCE = 3
    VPC_NETWORK = 4

  count = _messages.IntegerField(1)
  spokeType = _messages.EnumField('SpokeTypeValueValuesEnum', 2)


class GoogleCloudNetworkconnectivityV1betaStateReason(_messages.Message):
  r"""The reason a spoke is inactive.

  Enums:
    CodeValueValuesEnum: The code associated with this reason.

  Fields:
    code: The code associated with this reason.
    message: Human-readable details about this reason.
    userDetails: Additional information provided by the user in the
      RejectSpoke call.
  """

  class CodeValueValuesEnum(_messages.Enum):
    r"""The code associated with this reason.

    Values:
      CODE_UNSPECIFIED: No information available.
      PENDING_REVIEW: The proposed spoke is pending review.
      REJECTED: The proposed spoke has been rejected by the hub administrator.
      PAUSED: The spoke has been deactivated internally.
      FAILED: Network Connectivity Center encountered errors while accepting
        the spoke.
    """
    CODE_UNSPECIFIED = 0
    PENDING_REVIEW = 1
    REJECTED = 2
    PAUSED = 3
    FAILED = 4

  code = _messages.EnumField('CodeValueValuesEnum', 1)
  message = _messages.StringField(2)
  userDetails = _messages.StringField(3)


class GoogleIamV1AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs. If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted. Example Policy with
  multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
  "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
  "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
  "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
  sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
  logging. It also exempts `jose@example.com` from DATA_READ logging, and
  `aliya@example.com` from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('GoogleIamV1AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class GoogleIamV1AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example: {
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables
  'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from
  DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class GoogleIamV1Binding(_messages.Message):
  r"""Associates `members`, or principals, with a `role`.

  Fields:
    condition: The condition that is associated with this binding. If the
      condition evaluates to `true`, then this binding applies to the current
      request. If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the principals in this
      binding. To learn which resources support conditions in their IAM
      policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the principals requesting access for a Google Cloud
      resource. `members` can have the following values: * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account. * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account. Does not include identities that come from
      external identity providers (IdPs) through identity federation. *
      `user:{emailid}`: An email address that represents a specific Google
      account. For example, `alice@example.com` . *
      `serviceAccount:{emailid}`: An email address that represents a Google
      service account. For example, `my-other-
      app@appspot.gserviceaccount.com`. *
      `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`:
      An identifier for a [Kubernetes service
      account](https://cloud.google.com/kubernetes-engine/docs/how-
      to/kubernetes-service-accounts). For example, `my-
      project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`. * `domain:{domain}`: The G Suite domain
      (primary) that represents all the users of that domain. For example,
      `google.com` or `example.com`. * `principal://iam.googleapis.com/locatio
      ns/global/workforcePools/{pool_id}/subject/{subject_attribute_value}`: A
      single identity in a workforce identity pool. * `principalSet://iam.goog
      leapis.com/locations/global/workforcePools/{pool_id}/group/{group_id}`:
      All workforce identities in a group. * `principalSet://iam.googleapis.co
      m/locations/global/workforcePools/{pool_id}/attribute.{attribute_name}/{
      attribute_value}`: All workforce identities with a specific attribute
      value. * `principalSet://iam.googleapis.com/locations/global/workforcePo
      ols/{pool_id}/*`: All identities in a workforce identity pool. * `princi
      pal://iam.googleapis.com/projects/{project_number}/locations/global/work
      loadIdentityPools/{pool_id}/subject/{subject_attribute_value}`: A single
      identity in a workload identity pool. * `principalSet://iam.googleapis.c
      om/projects/{project_number}/locations/global/workloadIdentityPools/{poo
      l_id}/group/{group_id}`: A workload identity pool group. * `principalSet
      ://iam.googleapis.com/projects/{project_number}/locations/global/workloa
      dIdentityPools/{pool_id}/attribute.{attribute_name}/{attribute_value}`:
      All identities in a workload identity pool with a certain attribute. * `
      principalSet://iam.googleapis.com/projects/{project_number}/locations/gl
      obal/workloadIdentityPools/{pool_id}/*`: All identities in a workload
      identity pool. * `deleted:user:{emailid}?uid={uniqueid}`: An email
      address (plus unique identifier) representing a user that has been
      recently deleted. For example,
      `alice@example.com?uid=123456789012345678901`. If the user is recovered,
      this value reverts to `user:{emailid}` and the recovered user retains
      the role in the binding. *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus unique identifier) representing a service account that has been
      recently deleted. For example, `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique identifier) representing a Google group that
      has been recently deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If the group is
      recovered, this value reverts to `group:{emailid}` and the recovered
      group retains the role in the binding. * `deleted:principal://iam.google
      apis.com/locations/global/workforcePools/{pool_id}/subject/{subject_attr
      ibute_value}`: Deleted single identity in a workforce identity pool. For
      example, `deleted:principal://iam.googleapis.com/locations/global/workfo
      rcePools/my-pool-id/subject/my-subject-attribute-value`.
    role: Role that is assigned to the list of `members`, or principals. For
      example, `roles/viewer`, `roles/editor`, or `roles/owner`. For an
      overview of the IAM roles and permissions, see the [IAM
      documentation](https://cloud.google.com/iam/docs/roles-overview). For a
      list of the available pre-defined roles, see
      [here](https://cloud.google.com/iam/docs/understanding-roles).
  """

  condition = _messages.MessageField('GoogleTypeExpr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class GoogleIamV1Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources. A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members`, or principals, to a
  single `role`. Principals can be user accounts, service accounts, Google
  groups, and domains (such as G Suite). A `role` is a named list of
  permissions; each `role` can be an IAM predefined role or a user-created
  custom role. For some types of Google Cloud resources, a `binding` can also
  specify a `condition`, which is a logical expression that allows access to a
  resource only if the expression evaluates to `true`. A condition can add
  constraints based on attributes of the request, the resource, or both. To
  learn which resources support conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies). **JSON example:** ``` { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } ``` **YAML example:** ``` bindings: -
  members: - user:mike@example.com - group:admins@example.com -
  domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com
  role: roles/resourcemanager.organizationAdmin - members: -
  user:eve@example.com role: roles/resourcemanager.organizationViewer
  condition: title: expirable access description: Does not grant access after
  Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z')
  etag: BwWWja0YfJA= version: 3 ``` For a description of IAM and its features,
  see the [IAM documentation](https://cloud.google.com/iam/docs/).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members`, or principals, with a `role`.
      Optionally, may specify a `condition` that determines how and when the
      `bindings` are applied. Each of the `bindings` must contain at least one
      principal. The `bindings` in a `Policy` can refer to up to 1,500
      principals; up to 250 of these principals can be Google groups. Each
      occurrence of a principal counts towards these limits. For example, if
      the `bindings` grant 50 different roles to `user:alice@example.com`, and
      not to any other principal, then you can add another 1,450 principals to
      the `bindings` in the `Policy`.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy. **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy. Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected. Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations: * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy that includes conditions **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost. If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset. To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  auditConfigs = _messages.MessageField('GoogleIamV1AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('GoogleIamV1Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class GoogleIamV1SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Google Cloud services (such as Projects) might
      reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: `paths: "bindings, etag"`
  """

  policy = _messages.MessageField('GoogleIamV1Policy', 1)
  updateMask = _messages.StringField(2)


class GoogleIamV1TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as `*` or `storage.*`) are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class GoogleIamV1TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class GoogleLongrunningCancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class GoogleLongrunningListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('GoogleLongrunningOperation', 2, repeated=True)


class GoogleLongrunningOperation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as `Delete`, the response is
    `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('GoogleRpcStatus', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class GoogleRpcStatus(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class GoogleTypeExpr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class NetworkconnectivityProjectsLocationsCustomHardwareInstancesCreateRequest(_messages.Message):
  r"""A
  NetworkconnectivityProjectsLocationsCustomHardwareInstancesCreateRequest
  object.

  Fields:
    customHardwareInstanceId: Required. Unique id of the
      CustomHardwareInstance. If auto-generating Id server-side, remove this
      field and custom_hardware_instance_id from the method_signature of
      Create RPC
    googleCloudNetworkconnectivityV1betaCustomHardwareInstance: A
      GoogleCloudNetworkconnectivityV1betaCustomHardwareInstance resource to
      be passed as the request body.
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  customHardwareInstanceId = _messages.StringField(1)
  googleCloudNetworkconnectivityV1betaCustomHardwareInstance = _messages.MessageField('GoogleCloudNetworkconnectivityV1betaCustomHardwareInstance', 2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class NetworkconnectivityProjectsLocationsCustomHardwareInstancesDeleteRequest(_messages.Message):
  r"""A
  NetworkconnectivityProjectsLocationsCustomHardwareInstancesDeleteRequest
  object.

  Fields:
    name: Required. The name of the CustomHardwareInstance to delete.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class NetworkconnectivityProjectsLocationsCustomHardwareInstancesGetRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsCustomHardwareInstancesGetRequest
  object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class NetworkconnectivityProjectsLocationsCustomHardwareInstancesListRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsCustomHardwareInstancesListRequest
  object.

  Fields:
    filter: Optional. A filter expression that filters the results listed in
      the response.
    orderBy: Optional. Sort the results by a certain order.
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. The parent resource's name of the
      CustomHardwareInstance.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class NetworkconnectivityProjectsLocationsCustomHardwareInstancesPatchRequest(_messages.Message):
  r"""A
  NetworkconnectivityProjectsLocationsCustomHardwareInstancesPatchRequest
  object.

  Fields:
    googleCloudNetworkconnectivityV1betaCustomHardwareInstance: A
      GoogleCloudNetworkconnectivityV1betaCustomHardwareInstance resource to
      be passed as the request body.
    name: Identifier. The name of a CustomHardwareInstance. Format: `projects/
      {project}/locations/{location}/customHardwareInstances/{custom_hardware_
      instance}`.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the CustomHardwareInstance resource by the update. The
      fields specified in the update_mask are relative to the resource, not
      the full request. A field will be overwritten if it is in the mask. If
      the user does not provide a mask then all fields will be overwritten.
  """

  googleCloudNetworkconnectivityV1betaCustomHardwareInstance = _messages.MessageField('GoogleCloudNetworkconnectivityV1betaCustomHardwareInstance', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class NetworkconnectivityProjectsLocationsCustomHardwareLinkAttachmentsCreateRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsCustomHardwareLinkAttachmentsCreat
  eRequest object.

  Fields:
    customHardwareLinkAttachmentId: Required. Unique id of the
      CustomHardwareLinkAttachment. If auto-generating Id server-side, remove
      this field and custom_hardware_link_attachment_id from the
      method_signature of Create RPC
    googleCloudNetworkconnectivityV1betaCustomHardwareLinkAttachment: A
      GoogleCloudNetworkconnectivityV1betaCustomHardwareLinkAttachment
      resource to be passed as the request body.
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  customHardwareLinkAttachmentId = _messages.StringField(1)
  googleCloudNetworkconnectivityV1betaCustomHardwareLinkAttachment = _messages.MessageField('GoogleCloudNetworkconnectivityV1betaCustomHardwareLinkAttachment', 2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class NetworkconnectivityProjectsLocationsCustomHardwareLinkAttachmentsDeleteRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsCustomHardwareLinkAttachmentsDelet
  eRequest object.

  Fields:
    name: Required. The name of the CustomHardwareLinkAttachment to delete.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class NetworkconnectivityProjectsLocationsCustomHardwareLinkAttachmentsGetRequest(_messages.Message):
  r"""A
  NetworkconnectivityProjectsLocationsCustomHardwareLinkAttachmentsGetRequest
  object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class NetworkconnectivityProjectsLocationsCustomHardwareLinkAttachmentsListRequest(_messages.Message):
  r"""A
  NetworkconnectivityProjectsLocationsCustomHardwareLinkAttachmentsListRequest
  object.

  Fields:
    filter: Optional. A filter expression that filters the results listed in
      the response.
    orderBy: Optional. Sort the results by a certain order.
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. The parent resource's name of the
      CustomHardwareLinkAttachment.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class NetworkconnectivityProjectsLocationsCustomHardwareLinkAttachmentsPatchRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsCustomHardwareLinkAttachmentsPatch
  Request object.

  Fields:
    googleCloudNetworkconnectivityV1betaCustomHardwareLinkAttachment: A
      GoogleCloudNetworkconnectivityV1betaCustomHardwareLinkAttachment
      resource to be passed as the request body.
    name: Identifier. The name of a CustomHardwareLinkAttachment. Format: `pro
      jects/{project}/locations/{location}/customHardwareLinkAttachments/{cust
      om_hardware_link_attachment}`.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the CustomHardwareLinkAttachment resource by the update.
      The fields specified in the update_mask are relative to the resource,
      not the full request. A field will be overwritten if it is in the mask.
      If the user does not provide a mask then all fields will be overwritten.
  """

  googleCloudNetworkconnectivityV1betaCustomHardwareLinkAttachment = _messages.MessageField('GoogleCloudNetworkconnectivityV1betaCustomHardwareLinkAttachment', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class NetworkconnectivityProjectsLocationsCustomHardwareLinkConnectPairsCreateRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsCustomHardwareLinkConnectPairsCrea
  teRequest object.

  Fields:
    customHardwareLinkConnectPairId: Required. Unique id of the
      CustomHardwareLinkConnectPair. (i.e. 'foo' in
      '[...]/projects/*/locations/*/customHardwareLinkConnectPairs/foo') See
      https://google.aip.dev/122#resource-id-segments
    googleCloudNetworkconnectivityV1betaCustomHardwareLinkConnectPair: A
      GoogleCloudNetworkconnectivityV1betaCustomHardwareLinkConnectPair
      resource to be passed as the request body.
    parent: Required. The parent resource's name of the
      CustomHardwareLinkConnectPair. Use the following format:
      `projects/{project}/locations/{location}`
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  customHardwareLinkConnectPairId = _messages.StringField(1)
  googleCloudNetworkconnectivityV1betaCustomHardwareLinkConnectPair = _messages.MessageField('GoogleCloudNetworkconnectivityV1betaCustomHardwareLinkConnectPair', 2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class NetworkconnectivityProjectsLocationsCustomHardwareLinkConnectPairsDeleteRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsCustomHardwareLinkConnectPairsDele
  teRequest object.

  Fields:
    name: Required. The name is restricted to letters, numbers and with the
      first character being a letter, the last a letter or a number. Format: `
      projects/{project}/locations/{location}/customHardwareLinkConnectPairs/{
      custom_hardware_link_connect_pair}` where
      custom_hardware_link_connect_pair must match the regex
      `^[a-zA-Z0-9-]*[a-zA-Z0-9]$`
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class NetworkconnectivityProjectsLocationsCustomHardwareLinkConnectPairsGetRequest(_messages.Message):
  r"""A
  NetworkconnectivityProjectsLocationsCustomHardwareLinkConnectPairsGetRequest
  object.

  Fields:
    name: Required. The name is restricted to letters, numbers and with the
      first character being a letter, the last a letter or a number. Format: `
      projects/{project}/locations/{location}/customHardwareLinkConnectPairs/{
      custom_hardware_link_connect_pair}` where
      custom_hardware_link_connect_pair must match the regex
      `^[a-zA-Z0-9-]*[a-zA-Z0-9]$`
  """

  name = _messages.StringField(1, required=True)


class NetworkconnectivityProjectsLocationsCustomHardwareLinkConnectPairsListRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsCustomHardwareLinkConnectPairsList
  Request object.

  Fields:
    filter: Optional. A filter expression that filters the results listed in
      the response.
    orderBy: Optional. Sort the results by a certain order.
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. The parent resource's name of the
      CustomHardwareLinkConnectPair. Use the following format:
      `projects/{project}/locations/{location}`
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class NetworkconnectivityProjectsLocationsCustomHardwareLinkConnectPairsPatchRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsCustomHardwareLinkConnectPairsPatc
  hRequest object.

  Fields:
    googleCloudNetworkconnectivityV1betaCustomHardwareLinkConnectPair: A
      GoogleCloudNetworkconnectivityV1betaCustomHardwareLinkConnectPair
      resource to be passed as the request body.
    name: Identifier. The name of a CustomHardwareLinkConnectPair. The name is
      restricted to letters, numbers and with the first character being a
      letter, the last a letter or a number. Format: `projects/{project}/locat
      ions/{location}/customHardwareLinkConnectPairs/{custom_hardware_link_con
      nect_pair}` where custom_hardware_link_connect_pair must match the regex
      `^[a-zA-Z0-9-]*[a-zA-Z0-9]$`
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the CustomHardwareLinkConnectPair resource by the update.
      The fields specified in the update_mask are relative to the resource,
      not the full request. A field will be overwritten if it is in the mask.
      If the user does not provide a mask then all fields will be overwritten.
  """

  googleCloudNetworkconnectivityV1betaCustomHardwareLinkConnectPair = _messages.MessageField('GoogleCloudNetworkconnectivityV1betaCustomHardwareLinkConnectPair', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class NetworkconnectivityProjectsLocationsGetRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class NetworkconnectivityProjectsLocationsGlobalHubsAcceptSpokeRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsGlobalHubsAcceptSpokeRequest
  object.

  Fields:
    googleCloudNetworkconnectivityV1betaAcceptHubSpokeRequest: A
      GoogleCloudNetworkconnectivityV1betaAcceptHubSpokeRequest resource to be
      passed as the request body.
    name: Required. The name of the hub into which to accept the spoke.
  """

  googleCloudNetworkconnectivityV1betaAcceptHubSpokeRequest = _messages.MessageField('GoogleCloudNetworkconnectivityV1betaAcceptHubSpokeRequest', 1)
  name = _messages.StringField(2, required=True)


class NetworkconnectivityProjectsLocationsGlobalHubsCreateRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsGlobalHubsCreateRequest object.

  Fields:
    googleCloudNetworkconnectivityV1betaHub: A
      GoogleCloudNetworkconnectivityV1betaHub resource to be passed as the
      request body.
    hubId: Required. A unique identifier for the hub.
    parent: Required. The parent resource.
    requestId: Optional. A request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server knows to
      ignore the request if it has already been completed. The server
      guarantees that a request doesn't result in creation of duplicate
      commitments for at least 60 minutes. For example, consider a situation
      where you make an initial request and the request times out. If you make
      the request again with the same request ID, the server can check to see
      whether the original operation was received. If it was, the server
      ignores the second request. This behavior prevents clients from
      mistakenly creating duplicate commitments. The request ID must be a
      valid UUID, with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  googleCloudNetworkconnectivityV1betaHub = _messages.MessageField('GoogleCloudNetworkconnectivityV1betaHub', 1)
  hubId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class NetworkconnectivityProjectsLocationsGlobalHubsDeleteRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsGlobalHubsDeleteRequest object.

  Fields:
    name: Required. The name of the hub to delete.
    requestId: Optional. A request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server knows to
      ignore the request if it has already been completed. The server
      guarantees that a request doesn't result in creation of duplicate
      commitments for at least 60 minutes. For example, consider a situation
      where you make an initial request and the request times out. If you make
      the request again with the same request ID, the server can check to see
      whether the original operation was received. If it was, the server
      ignores the second request. This behavior prevents clients from
      mistakenly creating duplicate commitments. The request ID must be a
      valid UUID, with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class NetworkconnectivityProjectsLocationsGlobalHubsGetIamPolicyRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsGlobalHubsGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class NetworkconnectivityProjectsLocationsGlobalHubsGetRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsGlobalHubsGetRequest object.

  Fields:
    name: Required. The name of the hub resource to get.
  """

  name = _messages.StringField(1, required=True)


class NetworkconnectivityProjectsLocationsGlobalHubsGroupsGetIamPolicyRequest(_messages.Message):
  r"""A
  NetworkconnectivityProjectsLocationsGlobalHubsGroupsGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class NetworkconnectivityProjectsLocationsGlobalHubsGroupsGetRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsGlobalHubsGroupsGetRequest object.

  Fields:
    name: Required. The name of the route table resource.
  """

  name = _messages.StringField(1, required=True)


class NetworkconnectivityProjectsLocationsGlobalHubsGroupsListRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsGlobalHubsGroupsListRequest
  object.

  Fields:
    filter: An expression that filters the list of results.
    orderBy: Sort the results by a certain order.
    pageSize: The maximum number of results to return per page.
    pageToken: The page token.
    parent: Required. The parent resource's name.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class NetworkconnectivityProjectsLocationsGlobalHubsGroupsSetIamPolicyRequest(_messages.Message):
  r"""A
  NetworkconnectivityProjectsLocationsGlobalHubsGroupsSetIamPolicyRequest
  object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class NetworkconnectivityProjectsLocationsGlobalHubsGroupsTestIamPermissionsRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsGlobalHubsGroupsTestIamPermissions
  Request object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class NetworkconnectivityProjectsLocationsGlobalHubsListRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsGlobalHubsListRequest object.

  Fields:
    filter: An expression that filters the list of results.
    orderBy: Sort the results by a certain order.
    pageSize: The maximum number of results per page to return.
    pageToken: The page token.
    parent: Required. The parent resource's name.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class NetworkconnectivityProjectsLocationsGlobalHubsListSpokesRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsGlobalHubsListSpokesRequest
  object.

  Enums:
    ViewValueValuesEnum: The view of the spoke to return. The view that you
      use determines which spoke fields are included in the response.

  Fields:
    filter: An expression that filters the list of results.
    name: Required. The name of the hub.
    orderBy: Sort the results by name or create_time.
    pageSize: The maximum number of results to return per page.
    pageToken: The page token.
    spokeLocations: A list of locations. Specify one of the following:
      `[global]`, a single region (for example, `[us-central1]`), or a
      combination of values (for example, `[global, us-central1, us-west1]`).
      If the spoke_locations field is populated, the list of results includes
      only spokes in the specified location. If the spoke_locations field is
      not populated, the list of results includes spokes in all locations.
    view: The view of the spoke to return. The view that you use determines
      which spoke fields are included in the response.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""The view of the spoke to return. The view that you use determines
    which spoke fields are included in the response.

    Values:
      SPOKE_VIEW_UNSPECIFIED: The spoke view is unspecified. When the spoke
        view is unspecified, the API returns the same fields as the `BASIC`
        view.
      BASIC: Includes `name`, `create_time`, `hub`, `unique_id`, `state`,
        `reasons`, and `spoke_type`. This is the default value.
      DETAILED: Includes all spoke fields except `labels`. You can use the
        `DETAILED` view only when you set the `spoke_locations` field to
        `[global]`.
    """
    SPOKE_VIEW_UNSPECIFIED = 0
    BASIC = 1
    DETAILED = 2

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  orderBy = _messages.StringField(3)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)
  spokeLocations = _messages.StringField(6, repeated=True)
  view = _messages.EnumField('ViewValueValuesEnum', 7)


class NetworkconnectivityProjectsLocationsGlobalHubsPatchRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsGlobalHubsPatchRequest object.

  Fields:
    googleCloudNetworkconnectivityV1betaHub: A
      GoogleCloudNetworkconnectivityV1betaHub resource to be passed as the
      request body.
    name: Immutable. The name of the hub. Hub names must be unique. They use
      the following form:
      `projects/{project_number}/locations/global/hubs/{hub_id}`
    requestId: Optional. A request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server knows to
      ignore the request if it has already been completed. The server
      guarantees that a request doesn't result in creation of duplicate
      commitments for at least 60 minutes. For example, consider a situation
      where you make an initial request and the request times out. If you make
      the request again with the same request ID, the server can check to see
      whether the original operation was received. If it was, the server
      ignores the second request. This behavior prevents clients from
      mistakenly creating duplicate commitments. The request ID must be a
      valid UUID, with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    updateMask: Optional. In the case of an update to an existing hub, field
      mask is used to specify the fields to be overwritten. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field is overwritten if it is in the mask. If the user does
      not provide a mask, then all fields are overwritten.
  """

  googleCloudNetworkconnectivityV1betaHub = _messages.MessageField('GoogleCloudNetworkconnectivityV1betaHub', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class NetworkconnectivityProjectsLocationsGlobalHubsRejectSpokeRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsGlobalHubsRejectSpokeRequest
  object.

  Fields:
    googleCloudNetworkconnectivityV1betaRejectHubSpokeRequest: A
      GoogleCloudNetworkconnectivityV1betaRejectHubSpokeRequest resource to be
      passed as the request body.
    name: Required. The name of the hub from which to reject the spoke.
  """

  googleCloudNetworkconnectivityV1betaRejectHubSpokeRequest = _messages.MessageField('GoogleCloudNetworkconnectivityV1betaRejectHubSpokeRequest', 1)
  name = _messages.StringField(2, required=True)


class NetworkconnectivityProjectsLocationsGlobalHubsRouteTablesGetRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsGlobalHubsRouteTablesGetRequest
  object.

  Fields:
    name: Required. The name of the route table resource.
  """

  name = _messages.StringField(1, required=True)


class NetworkconnectivityProjectsLocationsGlobalHubsRouteTablesListRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsGlobalHubsRouteTablesListRequest
  object.

  Fields:
    filter: An expression that filters the list of results.
    orderBy: Sort the results by a certain order.
    pageSize: The maximum number of results to return per page.
    pageToken: The page token.
    parent: Required. The parent resource's name.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class NetworkconnectivityProjectsLocationsGlobalHubsRouteTablesRoutesGetRequest(_messages.Message):
  r"""A
  NetworkconnectivityProjectsLocationsGlobalHubsRouteTablesRoutesGetRequest
  object.

  Fields:
    name: Required. The name of the route resource.
  """

  name = _messages.StringField(1, required=True)


class NetworkconnectivityProjectsLocationsGlobalHubsRouteTablesRoutesListRequest(_messages.Message):
  r"""A
  NetworkconnectivityProjectsLocationsGlobalHubsRouteTablesRoutesListRequest
  object.

  Fields:
    filter: An expression that filters the list of results.
    orderBy: Sort the results by a certain order.
    pageSize: The maximum number of results to return per page.
    pageToken: The page token.
    parent: Required. The parent resource's name.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class NetworkconnectivityProjectsLocationsGlobalHubsSetIamPolicyRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsGlobalHubsSetIamPolicyRequest
  object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class NetworkconnectivityProjectsLocationsGlobalHubsTestIamPermissionsRequest(_messages.Message):
  r"""A
  NetworkconnectivityProjectsLocationsGlobalHubsTestIamPermissionsRequest
  object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class NetworkconnectivityProjectsLocationsListRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class NetworkconnectivityProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsOperationsCancelRequest object.

  Fields:
    googleLongrunningCancelOperationRequest: A
      GoogleLongrunningCancelOperationRequest resource to be passed as the
      request body.
    name: The name of the operation resource to be cancelled.
  """

  googleLongrunningCancelOperationRequest = _messages.MessageField('GoogleLongrunningCancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class NetworkconnectivityProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class NetworkconnectivityProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class NetworkconnectivityProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class NetworkconnectivityProjectsLocationsRegionalEndpointsCreateRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsRegionalEndpointsCreateRequest
  object.

  Fields:
    googleCloudNetworkconnectivityV1betaRegionalEndpoint: A
      GoogleCloudNetworkconnectivityV1betaRegionalEndpoint resource to be
      passed as the request body.
    parent: Required. The parent resource's name of the RegionalEndpoint.
    regionalEndpointId: Required. Unique id of the Regional Endpoint to be
      created.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      knows to ignore the request if it has already been completed. The server
      guarantees that for at least 60 minutes since the first request. For
      example, consider a situation where you make an initial request and the
      request times out. If you make the request again with the same request
      ID, the server can check if the original operation with the same request
      ID was received, and if so, ignores the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  googleCloudNetworkconnectivityV1betaRegionalEndpoint = _messages.MessageField('GoogleCloudNetworkconnectivityV1betaRegionalEndpoint', 1)
  parent = _messages.StringField(2, required=True)
  regionalEndpointId = _messages.StringField(3)
  requestId = _messages.StringField(4)


class NetworkconnectivityProjectsLocationsRegionalEndpointsDeleteRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsRegionalEndpointsDeleteRequest
  object.

  Fields:
    name: Required. The name of the RegionalEndpoint to delete.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      knows to ignore the request if it has already been completed. The server
      guarantees that for at least 60 minutes since the first request. For
      example, consider a situation where you make an initial request and the
      request times out. If you make the request again with the same request
      ID, the server can check if the original operation with the same request
      ID was received, and if so, ignores the second request. This prevents
      clients from accidentally creating duplicate commitments. The request ID
      must be a valid UUID with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class NetworkconnectivityProjectsLocationsRegionalEndpointsGetRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsRegionalEndpointsGetRequest
  object.

  Fields:
    name: Required. Name of the RegionalEndpoint resource to get. Format: `pro
      jects/{project}/locations/{location}/regionalEndpoints/{regional_endpoin
      t}`
  """

  name = _messages.StringField(1, required=True)


class NetworkconnectivityProjectsLocationsRegionalEndpointsListRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsRegionalEndpointsListRequest
  object.

  Fields:
    filter: A filter expression that filters the results listed in the
      response.
    orderBy: Sort the results by a certain order.
    pageSize: Requested page size. Server may return fewer items than
      requested. If unspecified, server will pick an appropriate default.
    pageToken: A page token.
    parent: Required. The parent resource's name of the RegionalEndpoint.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class NetworkconnectivityProjectsLocationsSpokesCreateRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsSpokesCreateRequest object.

  Fields:
    googleCloudNetworkconnectivityV1betaSpoke: A
      GoogleCloudNetworkconnectivityV1betaSpoke resource to be passed as the
      request body.
    parent: Required. The parent resource.
    requestId: Optional. A request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server knows to
      ignore the request if it has already been completed. The server
      guarantees that a request doesn't result in creation of duplicate
      commitments for at least 60 minutes. For example, consider a situation
      where you make an initial request and the request times out. If you make
      the request again with the same request ID, the server can check to see
      whether the original operation was received. If it was, the server
      ignores the second request. This behavior prevents clients from
      mistakenly creating duplicate commitments. The request ID must be a
      valid UUID, with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    spokeId: Required. Unique id for the spoke to create.
  """

  googleCloudNetworkconnectivityV1betaSpoke = _messages.MessageField('GoogleCloudNetworkconnectivityV1betaSpoke', 1)
  parent = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  spokeId = _messages.StringField(4)


class NetworkconnectivityProjectsLocationsSpokesDeleteRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsSpokesDeleteRequest object.

  Fields:
    name: Required. The name of the spoke to delete.
    requestId: Optional. A request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server knows to
      ignore the request if it has already been completed. The server
      guarantees that a request doesn't result in creation of duplicate
      commitments for at least 60 minutes. For example, consider a situation
      where you make an initial request and the request times out. If you make
      the request again with the same request ID, the server can check to see
      whether the original operation was received. If it was, the server
      ignores the second request. This behavior prevents clients from
      mistakenly creating duplicate commitments. The request ID must be a
      valid UUID, with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class NetworkconnectivityProjectsLocationsSpokesGetIamPolicyRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsSpokesGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class NetworkconnectivityProjectsLocationsSpokesGetRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsSpokesGetRequest object.

  Fields:
    name: Required. The name of the spoke resource.
  """

  name = _messages.StringField(1, required=True)


class NetworkconnectivityProjectsLocationsSpokesListRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsSpokesListRequest object.

  Fields:
    filter: An expression that filters the list of results.
    orderBy: Sort the results by a certain order.
    pageSize: The maximum number of results to return per page.
    pageToken: The page token.
    parent: Required. The parent resource.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class NetworkconnectivityProjectsLocationsSpokesPatchRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsSpokesPatchRequest object.

  Fields:
    googleCloudNetworkconnectivityV1betaSpoke: A
      GoogleCloudNetworkconnectivityV1betaSpoke resource to be passed as the
      request body.
    name: Immutable. The name of the spoke. Spoke names must be unique. They
      use the following form:
      `projects/{project_number}/locations/{region}/spokes/{spoke_id}`
    requestId: Optional. A request ID to identify requests. Specify a unique
      request ID so that if you must retry your request, the server knows to
      ignore the request if it has already been completed. The server
      guarantees that a request doesn't result in creation of duplicate
      commitments for at least 60 minutes. For example, consider a situation
      where you make an initial request and the request times out. If you make
      the request again with the same request ID, the server can check to see
      whether the original operation was received. If it was, the server
      ignores the second request. This behavior prevents clients from
      mistakenly creating duplicate commitments. The request ID must be a
      valid UUID, with the exception that zero UUID is not supported
      (00000000-0000-0000-0000-000000000000).
    updateMask: Optional. In the case of an update to an existing spoke, field
      mask is used to specify the fields to be overwritten. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field is overwritten if it is in the mask. If the user does
      not provide a mask, then all fields are overwritten.
  """

  googleCloudNetworkconnectivityV1betaSpoke = _messages.MessageField('GoogleCloudNetworkconnectivityV1betaSpoke', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class NetworkconnectivityProjectsLocationsSpokesSetIamPolicyRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsSpokesSetIamPolicyRequest object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class NetworkconnectivityProjectsLocationsSpokesTestIamPermissionsRequest(_messages.Message):
  r"""A NetworkconnectivityProjectsLocationsSpokesTestIamPermissionsRequest
  object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
