"""Generated message classes for securitycentermanagement version v1.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'securitycentermanagement'


class Access(_messages.Message):
  r"""Represents an access event.

  Fields:
    callerIp: Caller's IP address, such as "1.1.1.1".
    callerIpGeo: The caller IP's geolocation, which identifies where the call
      came from.
    methodName: The method that the service account called, e.g.
      "SetIamPolicy".
    principalEmail: Associated email, such as "foo@google.com". The email
      address of the authenticated user or a service account acting on behalf
      of a third party principal making the request. For third party identity
      callers, the `principal_subject` field is populated instead of this
      field. For privacy reasons, the principal email address is sometimes
      redacted. For more information, see [Caller identities in audit
      logs](https://cloud.google.com/logging/docs/audit#user-id).
    principalSubject: A string that represents the principal_subject that is
      associated with the identity. Unlike `principal_email`,
      `principal_subject` supports principals that aren't associated with
      email addresses, such as third party principals. For most identities,
      the format is `principal://iam.googleapis.com/{identity pool
      name}/subject/{subject}`. Some GKE identities, such as GKE_WORKLOAD,
      FREEFORM, and GKE_HUB_WORKLOAD, still use the legacy format
      `serviceAccount:{identity pool name}[{subject}]`.
    serviceAccountDelegationInfo: The identity delegation history of an
      authenticated service account that made the request. The
      `serviceAccountDelegationInfo[]` object contains information about the
      real authorities that try to access Google Cloud resources by delegating
      on a service account. When multiple authorities are present, they are
      guaranteed to be sorted based on the original ordering of the identity
      delegation events.
    serviceAccountKeyName: The name of the service account key that was used
      to create or exchange credentials when authenticating the service
      account that made the request. This is a scheme-less URI full resource
      name. For example: "//iam.googleapis.com/projects/{PROJECT_ID}/serviceAc
      counts/{ACCOUNT}/keys/{key}".
    serviceName: This is the API service that the service account made a call
      to, e.g. "iam.googleapis.com"
    userAgent: The caller's user agent string associated with the finding.
    userAgentFamily: Type of user agent associated with the finding. For
      example, an operating system shell or an embedded or standalone
      application.
    userName: A string that represents a username. The username provided
      depends on the type of the finding and is likely not an IAM principal.
      For example, this can be a system username if the finding is related to
      a virtual machine, or it can be an application login username.
  """

  callerIp = _messages.StringField(1)
  callerIpGeo = _messages.MessageField('Geolocation', 2)
  methodName = _messages.StringField(3)
  principalEmail = _messages.StringField(4)
  principalSubject = _messages.StringField(5)
  serviceAccountDelegationInfo = _messages.MessageField('ServiceAccountDelegationInfo', 6, repeated=True)
  serviceAccountKeyName = _messages.StringField(7)
  serviceName = _messages.StringField(8)
  userAgent = _messages.StringField(9)
  userAgentFamily = _messages.StringField(10)
  userName = _messages.StringField(11)


class AccessReview(_messages.Message):
  r"""Conveys information about a Kubernetes access review (such as one
  returned by a [`kubectl auth
  can-i`](https://kubernetes.io/docs/reference/access-authn-
  authz/authorization/#checking-api-access) command) that was involved in a
  finding.

  Fields:
    group: The API group of the resource. "*" means all.
    name: The name of the resource being requested. Empty means all.
    ns: Namespace of the action being requested. Currently, there is no
      distinction between no namespace and all namespaces. Both are
      represented by "" (empty).
    resource: The optional resource type requested. "*" means all.
    subresource: The optional subresource type.
    verb: A Kubernetes resource API verb, like get, list, watch, create,
      update, delete, proxy. "*" means all.
    version: The API version of the resource. "*" means all.
  """

  group = _messages.StringField(1)
  name = _messages.StringField(2)
  ns = _messages.StringField(3)
  resource = _messages.StringField(4)
  subresource = _messages.StringField(5)
  verb = _messages.StringField(6)
  version = _messages.StringField(7)


class AttackExposure(_messages.Message):
  r"""An attack exposure contains the results of an attack path simulation
  run.

  Enums:
    StateValueValuesEnum: What state this AttackExposure is in. This captures
      whether or not an attack exposure has been calculated or not.

  Fields:
    attackExposureResult: The resource name of the attack path simulation
      result that contains the details regarding this attack exposure score.
      Example: organizations/123/attackExposureResults/456
    exposedHighValueResourcesCount: The number of high value resources that
      are exposed as a result of this finding.
    exposedLowValueResourcesCount: The number of high value resources that are
      exposed as a result of this finding.
    exposedMediumValueResourcesCount: The number of medium value resources
      that are exposed as a result of this finding.
    latestCalculationTime: The most recent time the attack exposure was
      updated on this finding.
    score: A number between 0 (inclusive) and infinity that represents how
      important this finding is to remediate. The higher the score, the more
      important it is to remediate.
    state: What state this AttackExposure is in. This captures whether or not
      an attack exposure has been calculated or not.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""What state this AttackExposure is in. This captures whether or not an
    attack exposure has been calculated or not.

    Values:
      STATE_UNSPECIFIED: The state is not specified.
      CALCULATED: The attack exposure has been calculated.
      NOT_CALCULATED: The attack exposure has not been calculated.
    """
    STATE_UNSPECIFIED = 0
    CALCULATED = 1
    NOT_CALCULATED = 2

  attackExposureResult = _messages.StringField(1)
  exposedHighValueResourcesCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  exposedLowValueResourcesCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  exposedMediumValueResourcesCount = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  latestCalculationTime = _messages.StringField(5)
  score = _messages.FloatField(6)
  state = _messages.EnumField('StateValueValuesEnum', 7)


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs. If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted. Example Policy with
  multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
  "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
  "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
  "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
  sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
  logging. It also exempts `jose@example.com` from DATA_READ logging, and
  `aliya@example.com` from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example: {
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables
  'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from
  DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class CloudDlpDataProfile(_messages.Message):
  r"""The [data profile](https://cloud.google.com/dlp/docs/data-profiles)
  associated with the finding.

  Enums:
    ParentTypeValueValuesEnum: The resource hierarchy level at which the data
      profile was generated.

  Fields:
    dataProfile: Name of the data profile, for example,
      `projects/123/locations/europe/tableProfiles/8383929`.
    parentType: The resource hierarchy level at which the data profile was
      generated.
  """

  class ParentTypeValueValuesEnum(_messages.Enum):
    r"""The resource hierarchy level at which the data profile was generated.

    Values:
      PARENT_TYPE_UNSPECIFIED: Unspecified parent type.
      ORGANIZATION: Organization-level configurations.
      PROJECT: Project-level configurations.
    """
    PARENT_TYPE_UNSPECIFIED = 0
    ORGANIZATION = 1
    PROJECT = 2

  dataProfile = _messages.StringField(1)
  parentType = _messages.EnumField('ParentTypeValueValuesEnum', 2)


class CloudDlpInspection(_messages.Message):
  r"""Details about the Cloud Data Loss Prevention (Cloud DLP) [inspection
  job](https://cloud.google.com/dlp/docs/concepts-job-triggers) that produced
  the finding.

  Fields:
    fullScan: Whether Cloud DLP scanned the complete resource or a sampled
      subset.
    infoType: The type of information (or
      *[infoType](https://cloud.google.com/dlp/docs/infotypes-reference)*)
      found, for example, `EMAIL_ADDRESS` or `STREET_ADDRESS`.
    infoTypeCount: The number of times Cloud DLP found this infoType within
      this job and resource.
    inspectJob: Name of the inspection job, for example,
      `projects/123/locations/europe/dlpJobs/i-8383929`.
  """

  fullScan = _messages.BooleanField(1)
  infoType = _messages.StringField(2)
  infoTypeCount = _messages.IntegerField(3)
  inspectJob = _messages.StringField(4)


class Compliance(_messages.Message):
  r"""Contains compliance information about a security standard indicating
  unmet recommendations.

  Fields:
    ids: Policies within the standard or benchmark, for example, A.12.4.1
    standard: Industry-wide compliance standards or benchmarks, such as CIS,
      PCI, and OWASP.
    version: Version of the standard or benchmark, for example, 1.1
  """

  ids = _messages.StringField(1, repeated=True)
  standard = _messages.StringField(2)
  version = _messages.StringField(3)


class Connection(_messages.Message):
  r"""Contains information about the IP connection associated with the
  finding.

  Enums:
    ProtocolValueValuesEnum: IANA Internet Protocol Number such as TCP(6) and
      UDP(17).

  Fields:
    destinationIp: Destination IP address. Not present for sockets that are
      listening and not connected.
    destinationPort: Destination port. Not present for sockets that are
      listening and not connected.
    protocol: IANA Internet Protocol Number such as TCP(6) and UDP(17).
    sourceIp: Source IP address.
    sourcePort: Source port.
  """

  class ProtocolValueValuesEnum(_messages.Enum):
    r"""IANA Internet Protocol Number such as TCP(6) and UDP(17).

    Values:
      PROTOCOL_UNSPECIFIED: Unspecified protocol (not HOPOPT).
      ICMP: Internet Control Message Protocol.
      TCP: Transmission Control Protocol.
      UDP: User Datagram Protocol.
      GRE: Generic Routing Encapsulation.
      ESP: Encap Security Payload.
    """
    PROTOCOL_UNSPECIFIED = 0
    ICMP = 1
    TCP = 2
    UDP = 3
    GRE = 4
    ESP = 5

  destinationIp = _messages.StringField(1)
  destinationPort = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  protocol = _messages.EnumField('ProtocolValueValuesEnum', 3)
  sourceIp = _messages.StringField(4)
  sourcePort = _messages.IntegerField(5, variant=_messages.Variant.INT32)


class Contact(_messages.Message):
  r"""The email address of a contact.

  Fields:
    email: An email address. For example, "`person123@company.com`".
  """

  email = _messages.StringField(1)


class ContactDetails(_messages.Message):
  r"""Details about specific contacts

  Fields:
    contacts: A list of contacts
  """

  contacts = _messages.MessageField('Contact', 1, repeated=True)


class Container(_messages.Message):
  r"""Container associated with the finding.

  Fields:
    createTime: The time that the container was created.
    imageId: Optional container image ID, if provided by the container
      runtime. Uniquely identifies the container image launched using a
      container image digest.
    labels: Container labels, as provided by the container runtime.
    name: Name of the container.
    uri: Container image URI provided when configuring a pod or container.
      This string can identify a container image version using mutable tags.
  """

  createTime = _messages.StringField(1)
  imageId = _messages.StringField(2)
  labels = _messages.MessageField('Label', 3, repeated=True)
  name = _messages.StringField(4)
  uri = _messages.StringField(5)


class CustomConfig(_messages.Message):
  r"""Defines the properties in a custom module configuration for Security
  Health Analytics. Use the custom module configuration to create custom
  detectors that generate custom findings for resources that you specify.

  Enums:
    SeverityValueValuesEnum: Optional. The severity to assign to findings
      generated by the module.

  Fields:
    customOutput: Optional. Custom output properties.
    description: Optional. Text that describes the vulnerability or
      misconfiguration that the custom module detects. This explanation is
      returned with each finding instance to help investigators understand the
      detected issue. The text must be enclosed in quotation marks.
    predicate: Optional. The CEL expression to evaluate to produce findings.
      When the expression evaluates to true against a resource, a finding is
      generated.
    recommendation: Optional. An explanation of the recommended steps that
      security teams can take to resolve the detected issue. This explanation
      is returned with each finding generated by this module in the
      `nextSteps` property of the finding JSON.
    resourceSelector: Optional. The CAI resource types that the custom module
      operates on (see go/gcp-cai-doc/supported-asset-types). Each custom
      module can specify up to 5 resource types.
    severity: Optional. The severity to assign to findings generated by the
      module.
  """

  class SeverityValueValuesEnum(_messages.Enum):
    r"""Optional. The severity to assign to findings generated by the module.

    Values:
      SEVERITY_UNSPECIFIED: Unspecified severity.
      CRITICAL: Critical severity.
      HIGH: High severity.
      MEDIUM: Medium severity.
      LOW: Low severity.
    """
    SEVERITY_UNSPECIFIED = 0
    CRITICAL = 1
    HIGH = 2
    MEDIUM = 3
    LOW = 4

  customOutput = _messages.MessageField('CustomOutputSpec', 1)
  description = _messages.StringField(2)
  predicate = _messages.MessageField('Expr', 3)
  recommendation = _messages.StringField(4)
  resourceSelector = _messages.MessageField('ResourceSelector', 5)
  severity = _messages.EnumField('SeverityValueValuesEnum', 6)


class CustomModuleValidationError(_messages.Message):
  r"""An error encountered while validating the uploaded configuration of an
  Event Threat Detection Custom Module.

  Fields:
    description: A description of the error, suitable for human consumption.
      Required.
    end: The end position of the error in the uploaded text version of the
      module. This field may be omitted if no specific position applies, or if
      one could not be computed..
    fieldPath: The path, in RFC 8901 JSON Pointer format, to the field that
      failed validation. This may be left empty if no specific field is
      affected.
    start: The initial position of the error in the uploaded text version of
      the module. This field may be omitted if no specific position applies,
      or if one could not be computed.
  """

  description = _messages.StringField(1)
  end = _messages.MessageField('Position', 2)
  fieldPath = _messages.StringField(3)
  start = _messages.MessageField('Position', 4)


class CustomOutputSpec(_messages.Message):
  r"""A set of optional name-value pairs that define custom source properties
  to return with each finding that is generated by the custom module. The
  custom source properties that are defined here are included in the finding
  JSON under `sourceProperties`.

  Fields:
    properties: Optional. A list of custom output properties to add to the
      finding.
  """

  properties = _messages.MessageField('Property', 1, repeated=True)


class Cve(_messages.Message):
  r"""CVE stands for Common Vulnerabilities and Exposures. More information:
  https://cve.mitre.org

  Fields:
    cvssv3: Describe Common Vulnerability Scoring System specified at
      https://www.first.org/cvss/v3.1/specification-document
    id: The unique identifier for the vulnerability. e.g. CVE-2021-34527
    references: Additional information about the CVE. e.g.
      https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-34527
    upstreamFixAvailable: Whether upstream fix is available for the CVE.
  """

  cvssv3 = _messages.MessageField('Cvssv3', 1)
  id = _messages.StringField(2)
  references = _messages.MessageField('Reference', 3, repeated=True)
  upstreamFixAvailable = _messages.BooleanField(4)


class Cvssv3(_messages.Message):
  r"""Common Vulnerability Scoring System version 3.

  Enums:
    AttackComplexityValueValuesEnum: This metric describes the conditions
      beyond the attacker's control that must exist in order to exploit the
      vulnerability.
    AttackVectorValueValuesEnum: Base Metrics Represents the intrinsic
      characteristics of a vulnerability that are constant over time and
      across user environments. This metric reflects the context by which
      vulnerability exploitation is possible.
    AvailabilityImpactValueValuesEnum: This metric measures the impact to the
      availability of the impacted component resulting from a successfully
      exploited vulnerability.
    ConfidentialityImpactValueValuesEnum: This metric measures the impact to
      the confidentiality of the information resources managed by a software
      component due to a successfully exploited vulnerability.
    IntegrityImpactValueValuesEnum: This metric measures the impact to
      integrity of a successfully exploited vulnerability.
    PrivilegesRequiredValueValuesEnum: This metric describes the level of
      privileges an attacker must possess before successfully exploiting the
      vulnerability.
    ScopeValueValuesEnum: The Scope metric captures whether a vulnerability in
      one vulnerable component impacts resources in components beyond its
      security scope.
    UserInteractionValueValuesEnum: This metric captures the requirement for a
      human user, other than the attacker, to participate in the successful
      compromise of the vulnerable component.

  Fields:
    attackComplexity: This metric describes the conditions beyond the
      attacker's control that must exist in order to exploit the
      vulnerability.
    attackVector: Base Metrics Represents the intrinsic characteristics of a
      vulnerability that are constant over time and across user environments.
      This metric reflects the context by which vulnerability exploitation is
      possible.
    availabilityImpact: This metric measures the impact to the availability of
      the impacted component resulting from a successfully exploited
      vulnerability.
    baseScore: The base score is a function of the base metric scores.
    confidentialityImpact: This metric measures the impact to the
      confidentiality of the information resources managed by a software
      component due to a successfully exploited vulnerability.
    integrityImpact: This metric measures the impact to integrity of a
      successfully exploited vulnerability.
    privilegesRequired: This metric describes the level of privileges an
      attacker must possess before successfully exploiting the vulnerability.
    scope: The Scope metric captures whether a vulnerability in one vulnerable
      component impacts resources in components beyond its security scope.
    userInteraction: This metric captures the requirement for a human user,
      other than the attacker, to participate in the successful compromise of
      the vulnerable component.
  """

  class AttackComplexityValueValuesEnum(_messages.Enum):
    r"""This metric describes the conditions beyond the attacker's control
    that must exist in order to exploit the vulnerability.

    Values:
      ATTACK_COMPLEXITY_UNSPECIFIED: Invalid value.
      ATTACK_COMPLEXITY_LOW: Specialized access conditions or extenuating
        circumstances do not exist. An attacker can expect repeatable success
        when attacking the vulnerable component.
      ATTACK_COMPLEXITY_HIGH: A successful attack depends on conditions beyond
        the attacker's control. That is, a successful attack cannot be
        accomplished at will, but requires the attacker to invest in some
        measurable amount of effort in preparation or execution against the
        vulnerable component before a successful attack can be expected.
    """
    ATTACK_COMPLEXITY_UNSPECIFIED = 0
    ATTACK_COMPLEXITY_LOW = 1
    ATTACK_COMPLEXITY_HIGH = 2

  class AttackVectorValueValuesEnum(_messages.Enum):
    r"""Base Metrics Represents the intrinsic characteristics of a
    vulnerability that are constant over time and across user environments.
    This metric reflects the context by which vulnerability exploitation is
    possible.

    Values:
      ATTACK_VECTOR_UNSPECIFIED: Invalid value.
      ATTACK_VECTOR_NETWORK: The vulnerable component is bound to the network
        stack and the set of possible attackers extends beyond the other
        options listed below, up to and including the entire Internet.
      ATTACK_VECTOR_ADJACENT: The vulnerable component is bound to the network
        stack, but the attack is limited at the protocol level to a logically
        adjacent topology.
      ATTACK_VECTOR_LOCAL: The vulnerable component is not bound to the
        network stack and the attacker's path is via read/write/execute
        capabilities.
      ATTACK_VECTOR_PHYSICAL: The attack requires the attacker to physically
        touch or manipulate the vulnerable component.
    """
    ATTACK_VECTOR_UNSPECIFIED = 0
    ATTACK_VECTOR_NETWORK = 1
    ATTACK_VECTOR_ADJACENT = 2
    ATTACK_VECTOR_LOCAL = 3
    ATTACK_VECTOR_PHYSICAL = 4

  class AvailabilityImpactValueValuesEnum(_messages.Enum):
    r"""This metric measures the impact to the availability of the impacted
    component resulting from a successfully exploited vulnerability.

    Values:
      IMPACT_UNSPECIFIED: Invalid value.
      IMPACT_HIGH: High impact.
      IMPACT_LOW: Low impact.
      IMPACT_NONE: No impact.
    """
    IMPACT_UNSPECIFIED = 0
    IMPACT_HIGH = 1
    IMPACT_LOW = 2
    IMPACT_NONE = 3

  class ConfidentialityImpactValueValuesEnum(_messages.Enum):
    r"""This metric measures the impact to the confidentiality of the
    information resources managed by a software component due to a
    successfully exploited vulnerability.

    Values:
      IMPACT_UNSPECIFIED: Invalid value.
      IMPACT_HIGH: High impact.
      IMPACT_LOW: Low impact.
      IMPACT_NONE: No impact.
    """
    IMPACT_UNSPECIFIED = 0
    IMPACT_HIGH = 1
    IMPACT_LOW = 2
    IMPACT_NONE = 3

  class IntegrityImpactValueValuesEnum(_messages.Enum):
    r"""This metric measures the impact to integrity of a successfully
    exploited vulnerability.

    Values:
      IMPACT_UNSPECIFIED: Invalid value.
      IMPACT_HIGH: High impact.
      IMPACT_LOW: Low impact.
      IMPACT_NONE: No impact.
    """
    IMPACT_UNSPECIFIED = 0
    IMPACT_HIGH = 1
    IMPACT_LOW = 2
    IMPACT_NONE = 3

  class PrivilegesRequiredValueValuesEnum(_messages.Enum):
    r"""This metric describes the level of privileges an attacker must possess
    before successfully exploiting the vulnerability.

    Values:
      PRIVILEGES_REQUIRED_UNSPECIFIED: Invalid value.
      PRIVILEGES_REQUIRED_NONE: The attacker is unauthorized prior to attack,
        and therefore does not require any access to settings or files of the
        vulnerable system to carry out an attack.
      PRIVILEGES_REQUIRED_LOW: The attacker requires privileges that provide
        basic user capabilities that could normally affect only settings and
        files owned by a user. Alternatively, an attacker with Low privileges
        has the ability to access only non-sensitive resources.
      PRIVILEGES_REQUIRED_HIGH: The attacker requires privileges that provide
        significant (e.g., administrative) control over the vulnerable
        component allowing access to component-wide settings and files.
    """
    PRIVILEGES_REQUIRED_UNSPECIFIED = 0
    PRIVILEGES_REQUIRED_NONE = 1
    PRIVILEGES_REQUIRED_LOW = 2
    PRIVILEGES_REQUIRED_HIGH = 3

  class ScopeValueValuesEnum(_messages.Enum):
    r"""The Scope metric captures whether a vulnerability in one vulnerable
    component impacts resources in components beyond its security scope.

    Values:
      SCOPE_UNSPECIFIED: Invalid value.
      SCOPE_UNCHANGED: An exploited vulnerability can only affect resources
        managed by the same security authority.
      SCOPE_CHANGED: An exploited vulnerability can affect resources beyond
        the security scope managed by the security authority of the vulnerable
        component.
    """
    SCOPE_UNSPECIFIED = 0
    SCOPE_UNCHANGED = 1
    SCOPE_CHANGED = 2

  class UserInteractionValueValuesEnum(_messages.Enum):
    r"""This metric captures the requirement for a human user, other than the
    attacker, to participate in the successful compromise of the vulnerable
    component.

    Values:
      USER_INTERACTION_UNSPECIFIED: Invalid value.
      USER_INTERACTION_NONE: The vulnerable system can be exploited without
        interaction from any user.
      USER_INTERACTION_REQUIRED: Successful exploitation of this vulnerability
        requires a user to take some action before the vulnerability can be
        exploited.
    """
    USER_INTERACTION_UNSPECIFIED = 0
    USER_INTERACTION_NONE = 1
    USER_INTERACTION_REQUIRED = 2

  attackComplexity = _messages.EnumField('AttackComplexityValueValuesEnum', 1)
  attackVector = _messages.EnumField('AttackVectorValueValuesEnum', 2)
  availabilityImpact = _messages.EnumField('AvailabilityImpactValueValuesEnum', 3)
  baseScore = _messages.FloatField(4)
  confidentialityImpact = _messages.EnumField('ConfidentialityImpactValueValuesEnum', 5)
  integrityImpact = _messages.EnumField('IntegrityImpactValueValuesEnum', 6)
  privilegesRequired = _messages.EnumField('PrivilegesRequiredValueValuesEnum', 7)
  scope = _messages.EnumField('ScopeValueValuesEnum', 8)
  userInteraction = _messages.EnumField('UserInteractionValueValuesEnum', 9)


class Database(_messages.Message):
  r"""Represents database access information, such as queries. A database may
  be a sub-resource of an instance (as in the case of Cloud SQL instances or
  Cloud Spanner instances), or the database instance itself. Some database
  resources might not have the [full resource
  name](https://google.aip.dev/122#full-resource-names) populated because
  these resource types, such as Cloud SQL databases, are not yet supported by
  Cloud Asset Inventory. In these cases only the display name is provided.

  Fields:
    displayName: The human-readable name of the database that the user
      connected to.
    grantees: The target usernames, roles, or groups of an SQL privilege
      grant, which is not an IAM policy change.
    name: Some database resources may not have the [full resource
      name](https://google.aip.dev/122#full-resource-names) populated because
      these resource types are not yet supported by Cloud Asset Inventory
      (e.g. Cloud SQL databases). In these cases only the display name will be
      provided. The [full resource name](https://google.aip.dev/122#full-
      resource-names) of the database that the user connected to, if it is
      supported by Cloud Asset Inventory.
    query: The SQL statement that is associated with the database access.
    userName: The username used to connect to the database. The username might
      not be an IAM principal and does not have a set format.
    version: The version of the database, for example, POSTGRES_14. See [the
      complete list](https://cloud.google.com/sql/docs/mysql/admin-
      api/rest/v1/SqlDatabaseVersion).
  """

  displayName = _messages.StringField(1)
  grantees = _messages.StringField(2, repeated=True)
  name = _messages.StringField(3)
  query = _messages.StringField(4)
  userName = _messages.StringField(5)
  version = _messages.StringField(6)


class Detection(_messages.Message):
  r"""Memory hash detection contributing to the binary family match.

  Fields:
    binary: The name of the binary associated with the memory hash signature
      detection.
    percentPagesMatched: The percentage of memory page hashes in the signature
      that were matched.
  """

  binary = _messages.StringField(1)
  percentPagesMatched = _messages.FloatField(2)


class EffectiveEventThreatDetectionCustomModule(_messages.Message):
  r"""An EffectiveEventThreatDetectionCustomModule is the representation of
  EventThreatDetectionCustomModule at a given level taking hierarchy into
  account and resolving various fields accordingly. e.g. if the module is
  enabled at the ancestor level, effective modules at all descendant levels
  will have enablement_state set to ENABLED. Similarly, if module.inherited is
  set, then effective module's config will contain the ancestor's config
  details. EffectiveEventThreatDetectionCustomModule is read-only.

  Enums:
    EnablementStateValueValuesEnum: Output only. The effective state of
      enablement for the module at the given level of the hierarchy.

  Messages:
    ConfigValue: Output only. Config for the effective module.

  Fields:
    config: Output only. Config for the effective module.
    description: Output only. The description for the module.
    displayName: Output only. The human readable name to be displayed for the
      module.
    enablementState: Output only. The effective state of enablement for the
      module at the given level of the hierarchy.
    name: Immutable. The resource name of the ETD custom module. Its format
      is: * "organizations/{organization}/locations/{location}/effectiveEventT
      hreatDetectionCustomModules/{effective_event_threat_detection_custom_mod
      ule}". * "folders/{folder}/locations/{location}/effectiveEventThreatDete
      ctionCustomModules/{effective_event_threat_detection_custom_module}". *
      "projects/{project}/locations/{location}/effectiveEventThreatDetectionCu
      stomModules/{effective_event_threat_detection_custom_module}".
    type: Output only. Type for the module. e.g. CONFIGURABLE_BAD_IP.
  """

  class EnablementStateValueValuesEnum(_messages.Enum):
    r"""Output only. The effective state of enablement for the module at the
    given level of the hierarchy.

    Values:
      ENABLEMENT_STATE_UNSPECIFIED: Unspecified enablement state.
      ENABLED: The module is enabled at the given level.
      DISABLED: The module is disabled at the given level.
    """
    ENABLEMENT_STATE_UNSPECIFIED = 0
    ENABLED = 1
    DISABLED = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ConfigValue(_messages.Message):
    r"""Output only. Config for the effective module.

    Messages:
      AdditionalProperty: An additional property for a ConfigValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ConfigValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  config = _messages.MessageField('ConfigValue', 1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  enablementState = _messages.EnumField('EnablementStateValueValuesEnum', 4)
  name = _messages.StringField(5)
  type = _messages.StringField(6)


class EffectiveSecurityHealthAnalyticsCustomModule(_messages.Message):
  r"""An EffectiveSecurityHealthAnalyticsCustomModule is the representation of
  a Security Health Analytics custom module at a specified level of the
  resource hierarchy: organization, folder, or project. If a custom module is
  inherited from a parent organization or folder, the value of the
  `enablementState` property in EffectiveSecurityHealthAnalyticsCustomModule
  is set to the value that is effective in the parent, instead of `INHERITED`.
  For example, if the module is enabled in a parent organization or folder,
  the effective enablement_state for the module in all child folders or
  projects is also `enabled`. EffectiveSecurityHealthAnalyticsCustomModule is
  read-only.

  Enums:
    EnablementStateValueValuesEnum: Output only. The effective state of
      enablement for the module at the given level of the hierarchy.

  Fields:
    customConfig: Output only. The user-specified configuration for the
      module.
    displayName: Output only. The display name for the custom module. The name
      must be between 1 and 128 characters, start with a lowercase letter, and
      contain alphanumeric characters or underscores only.
    enablementState: Output only. The effective state of enablement for the
      module at the given level of the hierarchy.
    name: Output only. The resource name of the custom module. Its format is "
      organizations/{organization}/locations/{location}/effectiveSecurityHealt
      hAnalyticsCustomModules/{effective_security_health_analytics_custom_modu
      le}", or "folders/{folder}/locations/{location}/effectiveSecurityHealthA
      nalyticsCustomModules/{effective_security_health_analytics_custom_module
      }", or "projects/{project}/locations/{location}/effectiveSecurityHealthA
      nalyticsCustomModules/{effective_security_health_analytics_custom_module
      }"
  """

  class EnablementStateValueValuesEnum(_messages.Enum):
    r"""Output only. The effective state of enablement for the module at the
    given level of the hierarchy.

    Values:
      ENABLEMENT_STATE_UNSPECIFIED: Unspecified enablement state.
      ENABLED: The module is enabled at the given level.
      DISABLED: The module is disabled at the given level.
    """
    ENABLEMENT_STATE_UNSPECIFIED = 0
    ENABLED = 1
    DISABLED = 2

  customConfig = _messages.MessageField('CustomConfig', 1)
  displayName = _messages.StringField(2)
  enablementState = _messages.EnumField('EnablementStateValueValuesEnum', 3)
  name = _messages.StringField(4)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class EnvironmentVariable(_messages.Message):
  r"""A name-value pair representing an environment variable used in an
  operating system process.

  Fields:
    name: Environment variable name as a JSON encoded string.
    val: Environment variable value as a JSON encoded string.
  """

  name = _messages.StringField(1)
  val = _messages.StringField(2)


class EventThreatDetectionCustomModule(_messages.Message):
  r"""An event threat detection custom module is a Cloud SCC resource that
  contains the configuration and enablement state of a custom module, which
  enables ETD to write certain findings to Cloud SCC.

  Enums:
    EnablementStateValueValuesEnum: Optional. The state of enablement for the
      module at the given level of the hierarchy.

  Messages:
    ConfigValue: Optional. Config for the module. For the resident module, its
      config value is defined at this level. For the inherited module, its
      config value is inherited from the ancestor module.

  Fields:
    ancestorModule: Output only. The closest ancestor module that this module
      inherits the enablement state from. If empty, indicates that the custom
      module was created in the requesting parent organization, folder, or
      project. The format is the same as the EventThreatDetectionCustomModule
      resource name.
    config: Optional. Config for the module. For the resident module, its
      config value is defined at this level. For the inherited module, its
      config value is inherited from the ancestor module.
    description: Optional. The description for the module.
    displayName: Optional. The human readable name to be displayed for the
      module.
    enablementState: Optional. The state of enablement for the module at the
      given level of the hierarchy.
    lastEditor: Output only. The editor the module was last updated by.
    name: Immutable. The resource name of the ETD custom module. Its format
      is: * "organizations/{organization}/locations/{location}/eventThreatDete
      ctionCustomModules/{event_threat_detection_custom_module}". * "folders/{
      folder}/locations/{location}/eventThreatDetectionCustomModules/{event_th
      reat_detection_custom_module}". * "projects/{project}/locations/{locatio
      n}/eventThreatDetectionCustomModules/{event_threat_detection_custom_modu
      le}".
    type: Optional. Type for the module. e.g. CONFIGURABLE_BAD_IP.
    updateTime: Output only. The time the module was last updated.
  """

  class EnablementStateValueValuesEnum(_messages.Enum):
    r"""Optional. The state of enablement for the module at the given level of
    the hierarchy.

    Values:
      ENABLEMENT_STATE_UNSPECIFIED: Unspecified enablement state.
      ENABLED: The module is enabled at the given level.
      DISABLED: The module is disabled at the given level.
      INHERITED: State is inherited from an ancestor module. The module will
        either be effectively ENABLED or DISABLED based on its closest non-
        inherited ancestor module in the CRM hierarchy. Attempting to set a
        top level module (module with no parent) to the INHERITED state will
        result in an error.
    """
    ENABLEMENT_STATE_UNSPECIFIED = 0
    ENABLED = 1
    DISABLED = 2
    INHERITED = 3

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ConfigValue(_messages.Message):
    r"""Optional. Config for the module. For the resident module, its config
    value is defined at this level. For the inherited module, its config value
    is inherited from the ancestor module.

    Messages:
      AdditionalProperty: An additional property for a ConfigValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ConfigValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  ancestorModule = _messages.StringField(1)
  config = _messages.MessageField('ConfigValue', 2)
  description = _messages.StringField(3)
  displayName = _messages.StringField(4)
  enablementState = _messages.EnumField('EnablementStateValueValuesEnum', 5)
  lastEditor = _messages.StringField(6)
  name = _messages.StringField(7)
  type = _messages.StringField(8)
  updateTime = _messages.StringField(9)


class ExfilResource(_messages.Message):
  r"""Resource where data was exfiltrated from or exfiltrated to.

  Fields:
    components: Subcomponents of the asset that was exfiltrated, like URIs
      used during exfiltration, table names, databases, and filenames. For
      example, multiple tables might have been exfiltrated from the same Cloud
      SQL instance, or multiple files might have been exfiltrated from the
      same Cloud Storage bucket.
    name: The resource's [full resource name](https://cloud.google.com/apis/de
      sign/resource_names#full_resource_name).
  """

  components = _messages.StringField(1, repeated=True)
  name = _messages.StringField(2)


class Exfiltration(_messages.Message):
  r"""Exfiltration represents a data exfiltration attempt from one or more
  sources to one or more targets. The `sources` attribute lists the sources of
  the exfiltrated data. The `targets` attribute lists the destinations the
  data was copied to.

  Fields:
    sources: If there are multiple sources, then the data is considered
      "joined" between them. For instance, BigQuery can join multiple tables,
      and each table would be considered a source.
    targets: If there are multiple targets, each target would get a complete
      copy of the "joined" source data.
    totalExfiltratedBytes: Total exfiltrated bytes processed for the entire
      job.
  """

  sources = _messages.MessageField('ExfilResource', 1, repeated=True)
  targets = _messages.MessageField('ExfilResource', 2, repeated=True)
  totalExfiltratedBytes = _messages.IntegerField(3)


class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class ExternalSystem(_messages.Message):
  r"""Representation of third party SIEM/SOAR fields within SCC.

  Fields:
    assignees: References primary/secondary etc assignees in the external
      system.
    externalSystemUpdateTime: The time when the case was last updated, as
      reported by the external system.
    externalUid: The identifier that's used to track the finding's
      corresponding case in the external system.
    name: Full resource name of the external system, for example:
      "organizations/1234/sources/5678/findings/123456/externalSystems/jira",
      "folders/1234/sources/5678/findings/123456/externalSystems/jira",
      "projects/1234/sources/5678/findings/123456/externalSystems/jira"
    status: The most recent status of the finding's corresponding case, as
      reported by the external system.
  """

  assignees = _messages.StringField(1, repeated=True)
  externalSystemUpdateTime = _messages.StringField(2)
  externalUid = _messages.StringField(3)
  name = _messages.StringField(4)
  status = _messages.StringField(5)


class File(_messages.Message):
  r"""File information about the related binary/library used by an executable,
  or the script used by a script interpreter

  Fields:
    contents: Prefix of the file contents as a JSON-encoded string.
    hashedSize: The length in bytes of the file prefix that was hashed. If
      hashed_size == size, any hashes reported represent the entire file.
    partiallyHashed: True when the hash covers only a prefix of the file.
    path: Absolute path of the file as a JSON encoded string.
    sha256: SHA256 hash of the first hashed_size bytes of the file encoded as
      a hex string. If hashed_size == size, sha256 represents the SHA256 hash
      of the entire file.
    size: Size of the file in bytes.
  """

  contents = _messages.StringField(1)
  hashedSize = _messages.IntegerField(2)
  partiallyHashed = _messages.BooleanField(3)
  path = _messages.StringField(4)
  sha256 = _messages.StringField(5)
  size = _messages.IntegerField(6)


class Finding(_messages.Message):
  r"""Security Command Center finding. A finding is a record of assessment
  data like security, risk, health, or privacy, that is ingested into Security
  Command Center for presentation, notification, analysis, policy testing, and
  enforcement. For example, a cross-site scripting (XSS) vulnerability in an
  App Engine application is a finding.

  Enums:
    FindingClassValueValuesEnum: The class of the finding.
    MuteValueValuesEnum: Indicates the mute state of a finding (either muted,
      unmuted or undefined). Unlike other attributes of a finding, a finding
      provider shouldn't set the value of mute.
    SeverityValueValuesEnum: The severity of the finding. This field is
      managed by the source that writes the finding.
    StateValueValuesEnum: The state of the finding.

  Messages:
    ContactsValue: Output only. Map containing the points of contact for the
      given finding. The key represents the type of contact, while the value
      contains a list of all the contacts that pertain. Please refer to:
      https://cloud.google.com/resource-manager/docs/managing-notification-
      contacts#notification-categories { "security": { "contacts": [ {
      "email": "person1@company.com" }, { "email": "person2@company.com" } ] }
      }
    ExternalSystemsValue: Output only. Third party SIEM/SOAR fields within
      SCC, contains external system information and external system finding
      fields.
    SourcePropertiesValue: Source specific properties. These properties are
      managed by the source that writes the finding. The key names in the
      source_properties map must be between 1 and 255 characters, and must
      start with a letter and contain alphanumeric characters or underscores
      only.

  Fields:
    access: Access details associated with the finding, such as more
      information on the caller, which method was accessed, and from where.
    attackExposure: The results of an attack path simulation relevant to this
      finding.
    canonicalName: The canonical name of the finding. It's either "organizatio
      ns/{organization_id}/sources/{source_id}/findings/{finding_id}",
      "folders/{folder_id}/sources/{source_id}/findings/{finding_id}" or
      "projects/{project_number}/sources/{source_id}/findings/{finding_id}",
      depending on the closest CRM ancestor of the resource associated with
      the finding.
    category: The additional taxonomy group within findings from a given
      source. This field is immutable after creation time. Example:
      "XSS_FLASH_INJECTION"
    cloudDlpDataProfile: Cloud DLP data profile that is associated with the
      finding.
    cloudDlpInspection: Cloud Data Loss Prevention (Cloud DLP) inspection
      results that are associated with the finding.
    compliances: Contains compliance information for security standards
      associated to the finding.
    connections: Contains information about the IP connection associated with
      the finding.
    contacts: Output only. Map containing the points of contact for the given
      finding. The key represents the type of contact, while the value
      contains a list of all the contacts that pertain. Please refer to:
      https://cloud.google.com/resource-manager/docs/managing-notification-
      contacts#notification-categories { "security": { "contacts": [ {
      "email": "person1@company.com" }, { "email": "person2@company.com" } ] }
      }
    containers: Containers associated with the finding. This field provides
      information for both Kubernetes and non-Kubernetes containers.
    createTime: The time at which the finding was created in Security Command
      Center.
    database: Database associated with the finding.
    description: Contains more details about the finding.
    eventTime: The time the finding was first detected. If an existing finding
      is updated, then this is the time the update occurred. For example, if
      the finding represents an open firewall, this property captures the time
      the detector believes the firewall became open. The accuracy is
      determined by the detector. If the finding is later resolved, then this
      time reflects when the finding was resolved. This must not be set to a
      value greater than the current timestamp.
    exfiltration: Represents exfiltrations associated with the finding.
    externalSystems: Output only. Third party SIEM/SOAR fields within SCC,
      contains external system information and external system finding fields.
    externalUri: The URI that, if available, points to a web page outside of
      Security Command Center where additional information about the finding
      can be found. This field is guaranteed to be either empty or a well
      formed URL.
    files: File associated with the finding.
    findingClass: The class of the finding.
    iamBindings: Represents IAM bindings associated with the finding.
    indicator: Represents what's commonly known as an *indicator of
      compromise* (IoC) in computer forensics. This is an artifact observed on
      a network or in an operating system that, with high confidence,
      indicates a computer intrusion. For more information, see [Indicator of
      compromise](https://en.wikipedia.org/wiki/Indicator_of_compromise).
    kernelRootkit: Signature of the kernel rootkit.
    kubernetes: Kubernetes resources associated with the finding.
    loadBalancers: The load balancers associated with the finding.
    mitreAttack: MITRE ATT&CK tactics and techniques related to this finding.
      See: https://attack.mitre.org
    moduleName: Unique identifier of the module which generated the finding.
      Example: folders/598186756061/securityHealthAnalyticsSettings/customModu
      les/56799441161885
    mute: Indicates the mute state of a finding (either muted, unmuted or
      undefined). Unlike other attributes of a finding, a finding provider
      shouldn't set the value of mute.
    muteInitiator: Records additional information about the mute operation,
      for example, the [mute configuration](/security-command-center/docs/how-
      to-mute-findings) that muted the finding and the user who muted the
      finding.
    muteUpdateTime: Output only. The most recent time this finding was muted
      or unmuted.
    name: The [relative resource name](https://cloud.google.com/apis/design/re
      source_names#relative_resource_name) of the finding. Example: "organizat
      ions/{organization_id}/sources/{source_id}/findings/{finding_id}",
      "folders/{folder_id}/sources/{source_id}/findings/{finding_id}",
      "projects/{project_id}/sources/{source_id}/findings/{finding_id}".
    nextSteps: Steps to address the finding.
    parent: The relative resource name of the source the finding belongs to.
      See: https://cloud.google.com/apis/design/resource_names#relative_resour
      ce_name This field is immutable after creation time. For example:
      "organizations/{organization_id}/sources/{source_id}"
    parentDisplayName: Output only. The human readable display name of the
      finding source such as "Event Threat Detection" or "Security Health
      Analytics".
    processes: Represents operating system processes associated with the
      Finding.
    resourceName: For findings on Google Cloud resources, the full resource
      name of the Google Cloud resource this finding is for. See:
      https://cloud.google.com/apis/design/resource_names#full_resource_name
      When the finding is for a non-Google Cloud resource, the resourceName
      can be a customer or partner defined string. This field is immutable
      after creation time.
    securityMarks: Output only. User specified security marks. These marks are
      entirely managed by the user and come from the SecurityMarks resource
      that belongs to the finding.
    securityPosture: The security posture associated with the finding.
    severity: The severity of the finding. This field is managed by the source
      that writes the finding.
    sourceProperties: Source specific properties. These properties are managed
      by the source that writes the finding. The key names in the
      source_properties map must be between 1 and 255 characters, and must
      start with a letter and contain alphanumeric characters or underscores
      only.
    state: The state of the finding.
    vulnerability: Represents vulnerability-specific fields like CVE and CVSS
      scores. CVE stands for Common Vulnerabilities and Exposures
      (https://cve.mitre.org/about/)
  """

  class FindingClassValueValuesEnum(_messages.Enum):
    r"""The class of the finding.

    Values:
      FINDING_CLASS_UNSPECIFIED: Unspecified finding class.
      THREAT: Describes unwanted or malicious activity.
      VULNERABILITY: Describes a potential weakness in software that increases
        risk to Confidentiality & Integrity & Availability.
      MISCONFIGURATION: Describes a potential weakness in cloud resource/asset
        configuration that increases risk.
      OBSERVATION: Describes a security observation that is for informational
        purposes.
      SCC_ERROR: Describes an error that prevents some SCC functionality.
      POSTURE_VIOLATION: Describes a potential security risk due to a change
        in the security posture.
    """
    FINDING_CLASS_UNSPECIFIED = 0
    THREAT = 1
    VULNERABILITY = 2
    MISCONFIGURATION = 3
    OBSERVATION = 4
    SCC_ERROR = 5
    POSTURE_VIOLATION = 6

  class MuteValueValuesEnum(_messages.Enum):
    r"""Indicates the mute state of a finding (either muted, unmuted or
    undefined). Unlike other attributes of a finding, a finding provider
    shouldn't set the value of mute.

    Values:
      MUTE_UNSPECIFIED: Unspecified.
      MUTED: Finding has been muted.
      UNMUTED: Finding has been unmuted.
      UNDEFINED: Finding has never been muted/unmuted.
    """
    MUTE_UNSPECIFIED = 0
    MUTED = 1
    UNMUTED = 2
    UNDEFINED = 3

  class SeverityValueValuesEnum(_messages.Enum):
    r"""The severity of the finding. This field is managed by the source that
    writes the finding.

    Values:
      SEVERITY_UNSPECIFIED: This value is used for findings when a source
        doesn't write a severity value.
      CRITICAL: Vulnerability: A critical vulnerability is easily discoverable
        by an external actor, exploitable, and results in the direct ability
        to execute arbitrary code, exfiltrate data, and otherwise gain
        additional access and privileges to cloud resources and workloads.
        Examples include publicly accessible unprotected user data and public
        SSH access with weak or no passwords. Threat: Indicates a threat that
        is able to access, modify, or delete data or execute unauthorized code
        within existing resources.
      HIGH: Vulnerability: A high risk vulnerability can be easily discovered
        and exploited in combination with other vulnerabilities in order to
        gain direct access and the ability to execute arbitrary code,
        exfiltrate data, and otherwise gain additional access and privileges
        to cloud resources and workloads. An example is a database with weak
        or no passwords that is only accessible internally. This database
        could easily be compromised by an actor that had access to the
        internal network. Threat: Indicates a threat that is able to create
        new computational resources in an environment but not able to access
        data or execute code in existing resources.
      MEDIUM: Vulnerability: A medium risk vulnerability could be used by an
        actor to gain access to resources or privileges that enable them to
        eventually (through multiple steps or a complex exploit) gain access
        and the ability to execute arbitrary code or exfiltrate data. An
        example is a service account with access to more projects than it
        should have. If an actor gains access to the service account, they
        could potentially use that access to manipulate a project the service
        account was not intended to. Threat: Indicates a threat that is able
        to cause operational impact but may not access data or execute
        unauthorized code.
      LOW: Vulnerability: A low risk vulnerability hampers a security
        organization's ability to detect vulnerabilities or active threats in
        their deployment, or prevents the root cause investigation of security
        issues. An example is monitoring and logs being disabled for resource
        configurations and access. Threat: Indicates a threat that has
        obtained minimal access to an environment but is not able to access
        data, execute code, or create resources.
    """
    SEVERITY_UNSPECIFIED = 0
    CRITICAL = 1
    HIGH = 2
    MEDIUM = 3
    LOW = 4

  class StateValueValuesEnum(_messages.Enum):
    r"""The state of the finding.

    Values:
      STATE_UNSPECIFIED: Unspecified state.
      ACTIVE: The finding requires attention and has not been addressed yet.
      INACTIVE: The finding has been fixed, triaged as a non-issue or
        otherwise addressed and is no longer active.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    INACTIVE = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ContactsValue(_messages.Message):
    r"""Output only. Map containing the points of contact for the given
    finding. The key represents the type of contact, while the value contains
    a list of all the contacts that pertain. Please refer to:
    https://cloud.google.com/resource-manager/docs/managing-notification-
    contacts#notification-categories { "security": { "contacts": [ { "email":
    "person1@company.com" }, { "email": "person2@company.com" } ] } }

    Messages:
      AdditionalProperty: An additional property for a ContactsValue object.

    Fields:
      additionalProperties: Additional properties of type ContactsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ContactsValue object.

      Fields:
        key: Name of the additional property.
        value: A ContactDetails attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('ContactDetails', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ExternalSystemsValue(_messages.Message):
    r"""Output only. Third party SIEM/SOAR fields within SCC, contains
    external system information and external system finding fields.

    Messages:
      AdditionalProperty: An additional property for a ExternalSystemsValue
        object.

    Fields:
      additionalProperties: Additional properties of type ExternalSystemsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ExternalSystemsValue object.

      Fields:
        key: Name of the additional property.
        value: A ExternalSystem attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('ExternalSystem', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class SourcePropertiesValue(_messages.Message):
    r"""Source specific properties. These properties are managed by the source
    that writes the finding. The key names in the source_properties map must
    be between 1 and 255 characters, and must start with a letter and contain
    alphanumeric characters or underscores only.

    Messages:
      AdditionalProperty: An additional property for a SourcePropertiesValue
        object.

    Fields:
      additionalProperties: Additional properties of type
        SourcePropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a SourcePropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  access = _messages.MessageField('Access', 1)
  attackExposure = _messages.MessageField('AttackExposure', 2)
  canonicalName = _messages.StringField(3)
  category = _messages.StringField(4)
  cloudDlpDataProfile = _messages.MessageField('CloudDlpDataProfile', 5)
  cloudDlpInspection = _messages.MessageField('CloudDlpInspection', 6)
  compliances = _messages.MessageField('Compliance', 7, repeated=True)
  connections = _messages.MessageField('Connection', 8, repeated=True)
  contacts = _messages.MessageField('ContactsValue', 9)
  containers = _messages.MessageField('Container', 10, repeated=True)
  createTime = _messages.StringField(11)
  database = _messages.MessageField('Database', 12)
  description = _messages.StringField(13)
  eventTime = _messages.StringField(14)
  exfiltration = _messages.MessageField('Exfiltration', 15)
  externalSystems = _messages.MessageField('ExternalSystemsValue', 16)
  externalUri = _messages.StringField(17)
  files = _messages.MessageField('File', 18, repeated=True)
  findingClass = _messages.EnumField('FindingClassValueValuesEnum', 19)
  iamBindings = _messages.MessageField('IamBinding', 20, repeated=True)
  indicator = _messages.MessageField('Indicator', 21)
  kernelRootkit = _messages.MessageField('KernelRootkit', 22)
  kubernetes = _messages.MessageField('Kubernetes', 23)
  loadBalancers = _messages.MessageField('LoadBalancer', 24, repeated=True)
  mitreAttack = _messages.MessageField('MitreAttack', 25)
  moduleName = _messages.StringField(26)
  mute = _messages.EnumField('MuteValueValuesEnum', 27)
  muteInitiator = _messages.StringField(28)
  muteUpdateTime = _messages.StringField(29)
  name = _messages.StringField(30)
  nextSteps = _messages.StringField(31)
  parent = _messages.StringField(32)
  parentDisplayName = _messages.StringField(33)
  processes = _messages.MessageField('Process', 34, repeated=True)
  resourceName = _messages.StringField(35)
  securityMarks = _messages.MessageField('SecurityMarks', 36)
  securityPosture = _messages.MessageField('SecurityPosture', 37)
  severity = _messages.EnumField('SeverityValueValuesEnum', 38)
  sourceProperties = _messages.MessageField('SourcePropertiesValue', 39)
  state = _messages.EnumField('StateValueValuesEnum', 40)
  vulnerability = _messages.MessageField('Vulnerability', 41)


class Geolocation(_messages.Message):
  r"""Represents a geographical location for a given access.

  Fields:
    regionCode: A CLDR.
  """

  regionCode = _messages.StringField(1)


class GoogleCloudLocationLocation(_messages.Message):
  r"""A resource that represents a Google Cloud location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class GoogleCloudSecuritycenterV1Binding(_messages.Message):
  r"""Represents a Kubernetes RoleBinding or ClusterRoleBinding.

  Fields:
    name: Name for the binding.
    ns: Namespace for the binding.
    role: The Role or ClusterRole referenced by the binding.
    subjects: Represents one or more subjects that are bound to the role. Not
      always available for PATCH requests.
  """

  name = _messages.StringField(1)
  ns = _messages.StringField(2)
  role = _messages.MessageField('Role', 3)
  subjects = _messages.MessageField('Subject', 4, repeated=True)


class GoogleIamV1Binding(_messages.Message):
  r"""Associates `members`, or principals, with a `role`.

  Fields:
    condition: The condition that is associated with this binding. If the
      condition evaluates to `true`, then this binding applies to the current
      request. If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the principals in this
      binding. To learn which resources support conditions in their IAM
      policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the principals requesting access for a Google Cloud
      resource. `members` can have the following values: * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account. * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account. Does not include identities that come from
      external identity providers (IdPs) through identity federation. *
      `user:{emailid}`: An email address that represents a specific Google
      account. For example, `alice@example.com` . *
      `serviceAccount:{emailid}`: An email address that represents a Google
      service account. For example, `my-other-
      app@appspot.gserviceaccount.com`. *
      `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`:
      An identifier for a [Kubernetes service
      account](https://cloud.google.com/kubernetes-engine/docs/how-
      to/kubernetes-service-accounts). For example, `my-
      project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`. * `domain:{domain}`: The G Suite domain
      (primary) that represents all the users of that domain. For example,
      `google.com` or `example.com`. *
      `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique
      identifier) representing a user that has been recently deleted. For
      example, `alice@example.com?uid=123456789012345678901`. If the user is
      recovered, this value reverts to `user:{emailid}` and the recovered user
      retains the role in the binding. *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus unique identifier) representing a service account that has been
      recently deleted. For example, `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique identifier) representing a Google group that
      has been recently deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If the group is
      recovered, this value reverts to `group:{emailid}` and the recovered
      group retains the role in the binding.
    role: Role that is assigned to the list of `members`, or principals. For
      example, `roles/viewer`, `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class IamBinding(_messages.Message):
  r"""Represents a particular IAM binding, which captures a member's role
  addition, removal, or state.

  Enums:
    ActionValueValuesEnum: The action that was performed on a Binding.

  Fields:
    action: The action that was performed on a Binding.
    member: A single identity requesting access for a Cloud Platform resource,
      for example, "foo@google.com".
    role: Role that is assigned to "members". For example, "roles/viewer",
      "roles/editor", or "roles/owner".
  """

  class ActionValueValuesEnum(_messages.Enum):
    r"""The action that was performed on a Binding.

    Values:
      ACTION_UNSPECIFIED: Unspecified.
      ADD: Addition of a Binding.
      REMOVE: Removal of a Binding.
    """
    ACTION_UNSPECIFIED = 0
    ADD = 1
    REMOVE = 2

  action = _messages.EnumField('ActionValueValuesEnum', 1)
  member = _messages.StringField(2)
  role = _messages.StringField(3)


class Indicator(_messages.Message):
  r"""Represents what's commonly known as an _indicator of compromise_ (IoC)
  in computer forensics. This is an artifact observed on a network or in an
  operating system that, with high confidence, indicates a computer intrusion.
  For more information, see [Indicator of
  compromise](https://en.wikipedia.org/wiki/Indicator_of_compromise).

  Fields:
    domains: List of domains associated to the Finding.
    ipAddresses: The list of IP addresses that are associated with the
      finding.
    signatures: The list of matched signatures indicating that the given
      process is present in the environment.
    uris: The list of URIs associated to the Findings.
  """

  domains = _messages.StringField(1, repeated=True)
  ipAddresses = _messages.StringField(2, repeated=True)
  signatures = _messages.MessageField('ProcessSignature', 3, repeated=True)
  uris = _messages.StringField(4, repeated=True)


class KernelRootkit(_messages.Message):
  r"""Kernel mode rootkit signatures.

  Fields:
    name: Rootkit name, when available.
    unexpectedCodeModification: True if unexpected modifications of kernel
      code memory are present.
    unexpectedFtraceHandler: True if `ftrace` points are present with
      callbacks pointing to regions that are not in the expected kernel or
      module code range.
    unexpectedInterruptHandler: True if interrupt handlers that are are not in
      the expected kernel or module code regions are present.
    unexpectedKernelCodePages: True if kernel code pages that are not in the
      expected kernel or module code regions are present.
    unexpectedKprobeHandler: True if `kprobe` points are present with
      callbacks pointing to regions that are not in the expected kernel or
      module code range.
    unexpectedProcessesInRunqueue: True if unexpected processes in the
      scheduler run queue are present. Such processes are in the run queue,
      but not in the process task list.
    unexpectedReadOnlyDataModification: True if unexpected modifications of
      kernel read-only data memory are present.
    unexpectedSystemCallHandler: True if system call handlers that are are not
      in the expected kernel or module code regions are present.
  """

  name = _messages.StringField(1)
  unexpectedCodeModification = _messages.BooleanField(2)
  unexpectedFtraceHandler = _messages.BooleanField(3)
  unexpectedInterruptHandler = _messages.BooleanField(4)
  unexpectedKernelCodePages = _messages.BooleanField(5)
  unexpectedKprobeHandler = _messages.BooleanField(6)
  unexpectedProcessesInRunqueue = _messages.BooleanField(7)
  unexpectedReadOnlyDataModification = _messages.BooleanField(8)
  unexpectedSystemCallHandler = _messages.BooleanField(9)


class Kubernetes(_messages.Message):
  r"""Kubernetes-related attributes.

  Fields:
    accessReviews: Provides information on any Kubernetes access reviews
      (privilege checks) relevant to the finding.
    bindings: Provides Kubernetes role binding information for findings that
      involve [RoleBindings or
      ClusterRoleBindings](https://cloud.google.com/kubernetes-
      engine/docs/how-to/role-based-access-control).
    nodePools: GKE [node pools](https://cloud.google.com/kubernetes-
      engine/docs/concepts/node-pools) associated with the finding. This field
      contains node pool information for each node, when it is available.
    nodes: Provides Kubernetes [node](https://cloud.google.com/kubernetes-
      engine/docs/concepts/cluster-architecture#nodes) information.
    objects: Kubernetes objects related to the finding.
    pods: Kubernetes [Pods](https://cloud.google.com/kubernetes-
      engine/docs/concepts/pod) associated with the finding. This field
      contains Pod records for each container that is owned by a Pod.
    roles: Provides Kubernetes role information for findings that involve
      [Roles or ClusterRoles](https://cloud.google.com/kubernetes-
      engine/docs/how-to/role-based-access-control).
  """

  accessReviews = _messages.MessageField('AccessReview', 1, repeated=True)
  bindings = _messages.MessageField('GoogleCloudSecuritycenterV1Binding', 2, repeated=True)
  nodePools = _messages.MessageField('NodePool', 3, repeated=True)
  nodes = _messages.MessageField('Node', 4, repeated=True)
  objects = _messages.MessageField('Object', 5, repeated=True)
  pods = _messages.MessageField('Pod', 6, repeated=True)
  roles = _messages.MessageField('Role', 7, repeated=True)


class Label(_messages.Message):
  r"""Represents a generic name-value label. A label has separate name and
  value fields to support filtering with the `contains()` function. For more
  information, see [Filtering on array-type
  fields](https://cloud.google.com/security-command-center/docs/how-to-api-
  list-findings#array-contains-filtering).

  Fields:
    name: Name of the label.
    value: Value that corresponds to the label's name.
  """

  name = _messages.StringField(1)
  value = _messages.StringField(2)


class ListDescendantEventThreatDetectionCustomModulesResponse(_messages.Message):
  r"""Response message for listing descendant Event Threat Detection custom
  modules.

  Fields:
    eventThreatDetectionCustomModules: The list of
      EventThreatDetectionCustomModules
    nextPageToken: A token identifying a page of results the server should
      return.
  """

  eventThreatDetectionCustomModules = _messages.MessageField('EventThreatDetectionCustomModule', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListDescendantSecurityHealthAnalyticsCustomModulesResponse(_messages.Message):
  r"""Response message for listing descendant Security Health Analytics custom
  modules.

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    securityHealthAnalyticsCustomModules: The list of
      SecurityHealthAnalyticsCustomModules
  """

  nextPageToken = _messages.StringField(1)
  securityHealthAnalyticsCustomModules = _messages.MessageField('SecurityHealthAnalyticsCustomModule', 2, repeated=True)


class ListEffectiveEventThreatDetectionCustomModulesResponse(_messages.Message):
  r"""Response message for listing effective Event Threat Detection custom
  modules.

  Fields:
    effectiveEventThreatDetectionCustomModules: The list of
      EffectiveEventThreatDetectionCustomModules
    nextPageToken: A token identifying a page of results the server should
      return.
  """

  effectiveEventThreatDetectionCustomModules = _messages.MessageField('EffectiveEventThreatDetectionCustomModule', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListEffectiveSecurityHealthAnalyticsCustomModulesResponse(_messages.Message):
  r"""Response message for listing effective Security Health Analytics custom
  modules.

  Fields:
    effectiveSecurityHealthAnalyticsCustomModules: The list of
      EffectiveSecurityHealthAnalyticsCustomModule
    nextPageToken: A token identifying a page of results the server should
      return.
  """

  effectiveSecurityHealthAnalyticsCustomModules = _messages.MessageField('EffectiveSecurityHealthAnalyticsCustomModule', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListEventThreatDetectionCustomModulesResponse(_messages.Message):
  r"""Response message for listing Event Threat Detection custom modules.

  Fields:
    eventThreatDetectionCustomModules: The list of
      EventThreatDetectionCustomModules
    nextPageToken: A token identifying a page of results the server should
      return.
  """

  eventThreatDetectionCustomModules = _messages.MessageField('EventThreatDetectionCustomModule', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('GoogleCloudLocationLocation', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListSecurityHealthAnalyticsCustomModulesResponse(_messages.Message):
  r"""Response message for listing Security Health Analytics custom modules.

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    securityHealthAnalyticsCustomModules: The list of
      SecurityHealthAnalyticsCustomModules
  """

  nextPageToken = _messages.StringField(1)
  securityHealthAnalyticsCustomModules = _messages.MessageField('SecurityHealthAnalyticsCustomModule', 2, repeated=True)


class LoadBalancer(_messages.Message):
  r"""Contains information related to the load balancer associated with the
  finding.

  Fields:
    name: The name of the load balancer associated with the finding.
  """

  name = _messages.StringField(1)


class MemoryHashSignature(_messages.Message):
  r"""A signature corresponding to memory page hashes.

  Fields:
    binaryFamily: The binary family.
    detections: The list of memory hash detections contributing to the binary
      family match.
  """

  binaryFamily = _messages.StringField(1)
  detections = _messages.MessageField('Detection', 2, repeated=True)


class MitreAttack(_messages.Message):
  r"""MITRE ATT&CK tactics and techniques related to this finding. See:
  https://attack.mitre.org

  Enums:
    AdditionalTacticsValueListEntryValuesEnum:
    AdditionalTechniquesValueListEntryValuesEnum:
    PrimaryTacticValueValuesEnum: The MITRE ATT&CK tactic most closely
      represented by this finding, if any.
    PrimaryTechniquesValueListEntryValuesEnum:

  Fields:
    additionalTactics: Additional MITRE ATT&CK tactics related to this
      finding, if any.
    additionalTechniques: Additional MITRE ATT&CK techniques related to this
      finding, if any, along with any of their respective parent techniques.
    primaryTactic: The MITRE ATT&CK tactic most closely represented by this
      finding, if any.
    primaryTechniques: The MITRE ATT&CK technique most closely represented by
      this finding, if any. primary_techniques is a repeated field because
      there are multiple levels of MITRE ATT&CK techniques. If the technique
      most closely represented by this finding is a sub-technique (e.g.
      `SCANNING_IP_BLOCKS`), both the sub-technique and its parent
      technique(s) will be listed (e.g. `SCANNING_IP_BLOCKS`,
      `ACTIVE_SCANNING`).
    version: The MITRE ATT&CK version referenced by the above fields. E.g.
      "8".
  """

  class AdditionalTacticsValueListEntryValuesEnum(_messages.Enum):
    r"""AdditionalTacticsValueListEntryValuesEnum enum type.

    Values:
      TACTIC_UNSPECIFIED: Unspecified value.
      RECONNAISSANCE: TA0043
      RESOURCE_DEVELOPMENT: TA0042
      INITIAL_ACCESS: TA0001
      EXECUTION: TA0002
      PERSISTENCE: TA0003
      PRIVILEGE_ESCALATION: TA0004
      DEFENSE_EVASION: TA0005
      CREDENTIAL_ACCESS: TA0006
      DISCOVERY: TA0007
      LATERAL_MOVEMENT: TA0008
      COLLECTION: TA0009
      COMMAND_AND_CONTROL: TA0011
      EXFILTRATION: TA0010
      IMPACT: TA0040
    """
    TACTIC_UNSPECIFIED = 0
    RECONNAISSANCE = 1
    RESOURCE_DEVELOPMENT = 2
    INITIAL_ACCESS = 3
    EXECUTION = 4
    PERSISTENCE = 5
    PRIVILEGE_ESCALATION = 6
    DEFENSE_EVASION = 7
    CREDENTIAL_ACCESS = 8
    DISCOVERY = 9
    LATERAL_MOVEMENT = 10
    COLLECTION = 11
    COMMAND_AND_CONTROL = 12
    EXFILTRATION = 13
    IMPACT = 14

  class AdditionalTechniquesValueListEntryValuesEnum(_messages.Enum):
    r"""AdditionalTechniquesValueListEntryValuesEnum enum type.

    Values:
      TECHNIQUE_UNSPECIFIED: Unspecified value.
      ACTIVE_SCANNING: T1595
      SCANNING_IP_BLOCKS: T1595.001
      INGRESS_TOOL_TRANSFER: T1105
      NATIVE_API: T1106
      SHARED_MODULES: T1129
      COMMAND_AND_SCRIPTING_INTERPRETER: T1059
      UNIX_SHELL: T1059.004
      RESOURCE_HIJACKING: T1496
      PROXY: T1090
      EXTERNAL_PROXY: T1090.002
      MULTI_HOP_PROXY: T1090.003
      DYNAMIC_RESOLUTION: T1568
      UNSECURED_CREDENTIALS: T1552
      VALID_ACCOUNTS: T1078
      LOCAL_ACCOUNTS: T1078.003
      CLOUD_ACCOUNTS: T1078.004
      NETWORK_DENIAL_OF_SERVICE: T1498
      PERMISSION_GROUPS_DISCOVERY: T1069
      CLOUD_GROUPS: T1069.003
      EXFILTRATION_OVER_WEB_SERVICE: T1567
      EXFILTRATION_TO_CLOUD_STORAGE: T1567.002
      ACCOUNT_MANIPULATION: T1098
      SSH_AUTHORIZED_KEYS: T1098.004
      CREATE_OR_MODIFY_SYSTEM_PROCESS: T1543
      STEAL_WEB_SESSION_COOKIE: T1539
      MODIFY_CLOUD_COMPUTE_INFRASTRUCTURE: T1578
      EXPLOIT_PUBLIC_FACING_APPLICATION: T1190
      MODIFY_AUTHENTICATION_PROCESS: T1556
      DATA_DESTRUCTION: T1485
      DOMAIN_POLICY_MODIFICATION: T1484
      IMPAIR_DEFENSES: T1562
      NETWORK_SERVICE_DISCOVERY: T1046
      ACCESS_TOKEN_MANIPULATION: T1134
      ABUSE_ELEVATION_CONTROL_MECHANISM: T1548
      DEFAULT_ACCOUNTS: T1078.001
      INHIBIT_SYSTEM_RECOVERY: T1490
    """
    TECHNIQUE_UNSPECIFIED = 0
    ACTIVE_SCANNING = 1
    SCANNING_IP_BLOCKS = 2
    INGRESS_TOOL_TRANSFER = 3
    NATIVE_API = 4
    SHARED_MODULES = 5
    COMMAND_AND_SCRIPTING_INTERPRETER = 6
    UNIX_SHELL = 7
    RESOURCE_HIJACKING = 8
    PROXY = 9
    EXTERNAL_PROXY = 10
    MULTI_HOP_PROXY = 11
    DYNAMIC_RESOLUTION = 12
    UNSECURED_CREDENTIALS = 13
    VALID_ACCOUNTS = 14
    LOCAL_ACCOUNTS = 15
    CLOUD_ACCOUNTS = 16
    NETWORK_DENIAL_OF_SERVICE = 17
    PERMISSION_GROUPS_DISCOVERY = 18
    CLOUD_GROUPS = 19
    EXFILTRATION_OVER_WEB_SERVICE = 20
    EXFILTRATION_TO_CLOUD_STORAGE = 21
    ACCOUNT_MANIPULATION = 22
    SSH_AUTHORIZED_KEYS = 23
    CREATE_OR_MODIFY_SYSTEM_PROCESS = 24
    STEAL_WEB_SESSION_COOKIE = 25
    MODIFY_CLOUD_COMPUTE_INFRASTRUCTURE = 26
    EXPLOIT_PUBLIC_FACING_APPLICATION = 27
    MODIFY_AUTHENTICATION_PROCESS = 28
    DATA_DESTRUCTION = 29
    DOMAIN_POLICY_MODIFICATION = 30
    IMPAIR_DEFENSES = 31
    NETWORK_SERVICE_DISCOVERY = 32
    ACCESS_TOKEN_MANIPULATION = 33
    ABUSE_ELEVATION_CONTROL_MECHANISM = 34
    DEFAULT_ACCOUNTS = 35
    INHIBIT_SYSTEM_RECOVERY = 36

  class PrimaryTacticValueValuesEnum(_messages.Enum):
    r"""The MITRE ATT&CK tactic most closely represented by this finding, if
    any.

    Values:
      TACTIC_UNSPECIFIED: Unspecified value.
      RECONNAISSANCE: TA0043
      RESOURCE_DEVELOPMENT: TA0042
      INITIAL_ACCESS: TA0001
      EXECUTION: TA0002
      PERSISTENCE: TA0003
      PRIVILEGE_ESCALATION: TA0004
      DEFENSE_EVASION: TA0005
      CREDENTIAL_ACCESS: TA0006
      DISCOVERY: TA0007
      LATERAL_MOVEMENT: TA0008
      COLLECTION: TA0009
      COMMAND_AND_CONTROL: TA0011
      EXFILTRATION: TA0010
      IMPACT: TA0040
    """
    TACTIC_UNSPECIFIED = 0
    RECONNAISSANCE = 1
    RESOURCE_DEVELOPMENT = 2
    INITIAL_ACCESS = 3
    EXECUTION = 4
    PERSISTENCE = 5
    PRIVILEGE_ESCALATION = 6
    DEFENSE_EVASION = 7
    CREDENTIAL_ACCESS = 8
    DISCOVERY = 9
    LATERAL_MOVEMENT = 10
    COLLECTION = 11
    COMMAND_AND_CONTROL = 12
    EXFILTRATION = 13
    IMPACT = 14

  class PrimaryTechniquesValueListEntryValuesEnum(_messages.Enum):
    r"""PrimaryTechniquesValueListEntryValuesEnum enum type.

    Values:
      TECHNIQUE_UNSPECIFIED: Unspecified value.
      ACTIVE_SCANNING: T1595
      SCANNING_IP_BLOCKS: T1595.001
      INGRESS_TOOL_TRANSFER: T1105
      NATIVE_API: T1106
      SHARED_MODULES: T1129
      COMMAND_AND_SCRIPTING_INTERPRETER: T1059
      UNIX_SHELL: T1059.004
      RESOURCE_HIJACKING: T1496
      PROXY: T1090
      EXTERNAL_PROXY: T1090.002
      MULTI_HOP_PROXY: T1090.003
      DYNAMIC_RESOLUTION: T1568
      UNSECURED_CREDENTIALS: T1552
      VALID_ACCOUNTS: T1078
      LOCAL_ACCOUNTS: T1078.003
      CLOUD_ACCOUNTS: T1078.004
      NETWORK_DENIAL_OF_SERVICE: T1498
      PERMISSION_GROUPS_DISCOVERY: T1069
      CLOUD_GROUPS: T1069.003
      EXFILTRATION_OVER_WEB_SERVICE: T1567
      EXFILTRATION_TO_CLOUD_STORAGE: T1567.002
      ACCOUNT_MANIPULATION: T1098
      SSH_AUTHORIZED_KEYS: T1098.004
      CREATE_OR_MODIFY_SYSTEM_PROCESS: T1543
      STEAL_WEB_SESSION_COOKIE: T1539
      MODIFY_CLOUD_COMPUTE_INFRASTRUCTURE: T1578
      EXPLOIT_PUBLIC_FACING_APPLICATION: T1190
      MODIFY_AUTHENTICATION_PROCESS: T1556
      DATA_DESTRUCTION: T1485
      DOMAIN_POLICY_MODIFICATION: T1484
      IMPAIR_DEFENSES: T1562
      NETWORK_SERVICE_DISCOVERY: T1046
      ACCESS_TOKEN_MANIPULATION: T1134
      ABUSE_ELEVATION_CONTROL_MECHANISM: T1548
      DEFAULT_ACCOUNTS: T1078.001
      INHIBIT_SYSTEM_RECOVERY: T1490
    """
    TECHNIQUE_UNSPECIFIED = 0
    ACTIVE_SCANNING = 1
    SCANNING_IP_BLOCKS = 2
    INGRESS_TOOL_TRANSFER = 3
    NATIVE_API = 4
    SHARED_MODULES = 5
    COMMAND_AND_SCRIPTING_INTERPRETER = 6
    UNIX_SHELL = 7
    RESOURCE_HIJACKING = 8
    PROXY = 9
    EXTERNAL_PROXY = 10
    MULTI_HOP_PROXY = 11
    DYNAMIC_RESOLUTION = 12
    UNSECURED_CREDENTIALS = 13
    VALID_ACCOUNTS = 14
    LOCAL_ACCOUNTS = 15
    CLOUD_ACCOUNTS = 16
    NETWORK_DENIAL_OF_SERVICE = 17
    PERMISSION_GROUPS_DISCOVERY = 18
    CLOUD_GROUPS = 19
    EXFILTRATION_OVER_WEB_SERVICE = 20
    EXFILTRATION_TO_CLOUD_STORAGE = 21
    ACCOUNT_MANIPULATION = 22
    SSH_AUTHORIZED_KEYS = 23
    CREATE_OR_MODIFY_SYSTEM_PROCESS = 24
    STEAL_WEB_SESSION_COOKIE = 25
    MODIFY_CLOUD_COMPUTE_INFRASTRUCTURE = 26
    EXPLOIT_PUBLIC_FACING_APPLICATION = 27
    MODIFY_AUTHENTICATION_PROCESS = 28
    DATA_DESTRUCTION = 29
    DOMAIN_POLICY_MODIFICATION = 30
    IMPAIR_DEFENSES = 31
    NETWORK_SERVICE_DISCOVERY = 32
    ACCESS_TOKEN_MANIPULATION = 33
    ABUSE_ELEVATION_CONTROL_MECHANISM = 34
    DEFAULT_ACCOUNTS = 35
    INHIBIT_SYSTEM_RECOVERY = 36

  additionalTactics = _messages.EnumField('AdditionalTacticsValueListEntryValuesEnum', 1, repeated=True)
  additionalTechniques = _messages.EnumField('AdditionalTechniquesValueListEntryValuesEnum', 2, repeated=True)
  primaryTactic = _messages.EnumField('PrimaryTacticValueValuesEnum', 3)
  primaryTechniques = _messages.EnumField('PrimaryTechniquesValueListEntryValuesEnum', 4, repeated=True)
  version = _messages.StringField(5)


class Node(_messages.Message):
  r"""Kubernetes nodes associated with the finding.

  Fields:
    name: [Full resource name](https://google.aip.dev/122#full-resource-names)
      of the Compute Engine VM running the cluster node.
  """

  name = _messages.StringField(1)


class NodePool(_messages.Message):
  r"""Provides GKE node pool information.

  Fields:
    name: Kubernetes node pool name.
    nodes: Nodes associated with the finding.
  """

  name = _messages.StringField(1)
  nodes = _messages.MessageField('Node', 2, repeated=True)


class Object(_messages.Message):
  r"""Kubernetes object related to the finding, uniquely identified by GKNN.
  Used if the object Kind is not one of Pod, Node, NodePool, Binding, or
  AccessReview.

  Fields:
    group: Kubernetes object group, such as "policy.k8s.io/v1".
    kind: Kubernetes object kind, such as "Namespace".
    name: Kubernetes object name. For details see
      https://kubernetes.io/docs/concepts/overview/working-with-
      objects/names/.
    ns: Kubernetes object namespace. Must be a valid DNS label. Named "ns" to
      avoid collision with C++ namespace keyword. For details see
      https://kubernetes.io/docs/tasks/administer-cluster/namespaces/.
  """

  group = _messages.StringField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3)
  ns = _messages.StringField(4)


class Pod(_messages.Message):
  r"""A Kubernetes Pod.

  Fields:
    containers: Pod containers associated with this finding, if any.
    labels: Pod labels. For Kubernetes containers, these are applied to the
      container.
    name: Kubernetes Pod name.
    ns: Kubernetes Pod namespace.
  """

  containers = _messages.MessageField('Container', 1, repeated=True)
  labels = _messages.MessageField('Label', 2, repeated=True)
  name = _messages.StringField(3)
  ns = _messages.StringField(4)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources. A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members`, or principals, to a
  single `role`. Principals can be user accounts, service accounts, Google
  groups, and domains (such as G Suite). A `role` is a named list of
  permissions; each `role` can be an IAM predefined role or a user-created
  custom role. For some types of Google Cloud resources, a `binding` can also
  specify a `condition`, which is a logical expression that allows access to a
  resource only if the expression evaluates to `true`. A condition can add
  constraints based on attributes of the request, the resource, or both. To
  learn which resources support conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies). **JSON example:** ``` { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } ``` **YAML example:** ``` bindings: -
  members: - user:mike@example.com - group:admins@example.com -
  domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com
  role: roles/resourcemanager.organizationAdmin - members: -
  user:eve@example.com role: roles/resourcemanager.organizationViewer
  condition: title: expirable access description: Does not grant access after
  Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z')
  etag: BwWWja0YfJA= version: 3 ``` For a description of IAM and its features,
  see the [IAM documentation](https://cloud.google.com/iam/docs/).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members`, or principals, with a `role`.
      Optionally, may specify a `condition` that determines how and when the
      `bindings` are applied. Each of the `bindings` must contain at least one
      principal. The `bindings` in a `Policy` can refer to up to 1,500
      principals; up to 250 of these principals can be Google groups. Each
      occurrence of a principal counts towards these limits. For example, if
      the `bindings` grant 50 different roles to `user:alice@example.com`, and
      not to any other principal, then you can add another 1,450 principals to
      the `bindings` in the `Policy`.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy. **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy. Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected. Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations: * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy that includes conditions **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost. If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset. To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('GoogleIamV1Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class Position(_messages.Message):
  r"""A position in the uploaded text version of a module.

  Fields:
    columnNumber: The column position in the line
    lineNumber: The line position in the text
  """

  columnNumber = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  lineNumber = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class Process(_messages.Message):
  r"""Represents an operating system process.

  Fields:
    args: Process arguments as JSON encoded strings.
    argumentsTruncated: True if `args` is incomplete.
    binary: File information for the process executable.
    envVariables: Process environment variables.
    envVariablesTruncated: True if `env_variables` is incomplete.
    libraries: File information for libraries loaded by the process.
    name: The process name, as displayed in utilities like `top` and `ps`.
      This name can be accessed through `/proc/[pid]/comm` and changed with
      `prctl(PR_SET_NAME)`.
    parentPid: The parent process ID.
    pid: The process ID.
    script: When the process represents the invocation of a script, `binary`
      provides information about the interpreter, while `script` provides
      information about the script file provided to the interpreter.
  """

  args = _messages.StringField(1, repeated=True)
  argumentsTruncated = _messages.BooleanField(2)
  binary = _messages.MessageField('File', 3)
  envVariables = _messages.MessageField('EnvironmentVariable', 4, repeated=True)
  envVariablesTruncated = _messages.BooleanField(5)
  libraries = _messages.MessageField('File', 6, repeated=True)
  name = _messages.StringField(7)
  parentPid = _messages.IntegerField(8)
  pid = _messages.IntegerField(9)
  script = _messages.MessageField('File', 10)


class ProcessSignature(_messages.Message):
  r"""Indicates what signature matched this process.

  Fields:
    memoryHashSignature: Signature indicating that a binary family was
      matched.
    yaraRuleSignature: Signature indicating that a YARA rule was matched.
  """

  memoryHashSignature = _messages.MessageField('MemoryHashSignature', 1)
  yaraRuleSignature = _messages.MessageField('YaraRuleSignature', 2)


class Property(_messages.Message):
  r"""An individual name-value pair that defines a custom source property.

  Fields:
    name: Optional. Name of the property for the custom output.
    valueExpression: Optional. The CEL expression for the custom output. A
      resource property can be specified to return the value of the property
      or a text string enclosed in quotation marks.
  """

  name = _messages.StringField(1)
  valueExpression = _messages.MessageField('Expr', 2)


class Reference(_messages.Message):
  r"""Additional Links

  Fields:
    source: Source of the reference e.g. NVD
    uri: Uri for the mentioned source e.g. https://cve.mitre.org/cgi-
      bin/cvename.cgi?name=CVE-2021-34527.
  """

  source = _messages.StringField(1)
  uri = _messages.StringField(2)


class ResourceSelector(_messages.Message):
  r"""Resource for selecting resource type.

  Fields:
    resourceTypes: Optional. The resource types to run the detector on.
  """

  resourceTypes = _messages.StringField(1, repeated=True)


class Role(_messages.Message):
  r"""Kubernetes Role or ClusterRole.

  Enums:
    KindValueValuesEnum: Role type.

  Fields:
    kind: Role type.
    name: Role name.
    ns: Role namespace.
  """

  class KindValueValuesEnum(_messages.Enum):
    r"""Role type.

    Values:
      KIND_UNSPECIFIED: Role type is not specified.
      ROLE: Kubernetes Role.
      CLUSTER_ROLE: Kubernetes ClusterRole.
    """
    KIND_UNSPECIFIED = 0
    ROLE = 1
    CLUSTER_ROLE = 2

  kind = _messages.EnumField('KindValueValuesEnum', 1)
  name = _messages.StringField(2)
  ns = _messages.StringField(3)


class SecurityHealthAnalyticsCustomModule(_messages.Message):
  r"""Represents an instance of a Security Health Analytics custom module,
  including its full module name, display name, enablement state, and last
  updated time. You can create a custom module at the organization, folder, or
  project level. Custom modules that you create at the organization or folder
  level are inherited by the child folders and projects.

  Enums:
    EnablementStateValueValuesEnum: Optional. The enablement state of the
      custom module.

  Fields:
    ancestorModule: Output only. Specifies the organization or folder from
      which the custom module is inherited. If empty, indicates that the
      custom module was created in the organization, folder, or project in
      which you are viewing the custom module.
    customConfig: Optional. The user specified custom configuration for the
      module.
    displayName: Optional. The display name of the Security Health Analytics
      custom module. This display name becomes the finding category for all
      findings that are returned by this custom module. The display name must
      be between 1 and 128 characters, start with a lowercase letter, and
      contain alphanumeric characters or underscores only.
    enablementState: Optional. The enablement state of the custom module.
    lastEditor: Output only. The editor that last updated the custom module.
    name: Immutable. The resource name of the custom module. Its format is "or
      ganizations/{organization}/locations/{location}/securityHealthAnalyticsC
      ustomModules/{security_health_analytics_custom_module}", or "folders/{fo
      lder}/locations/{location}/securityHealthAnalyticsCustomModules/{securit
      y_health_analytics_custom_module}", or "projects/{project}/locations/{lo
      cation}/securityHealthAnalyticsCustomModules/{security_health_analytics_
      custom_module}" The id {customModule} is server-generated and is not
      user settable. It will be a numeric id containing 1-20 digits.
    updateTime: Output only. The time at which the custom module was last
      updated.
  """

  class EnablementStateValueValuesEnum(_messages.Enum):
    r"""Optional. The enablement state of the custom module.

    Values:
      ENABLEMENT_STATE_UNSPECIFIED: Unspecified enablement state.
      ENABLED: The module is enabled at the given CRM resource.
      DISABLED: The module is disabled at the given CRM resource.
      INHERITED: State is inherited from an ancestor module. The module will
        either be effectively ENABLED or DISABLED based on its closest non-
        inherited ancestor module in the CRM hierarchy. Attempting to set a
        top level module (module with no parent) to the INHERITED state will
        result in an INVALID_ARGUMENT error.
    """
    ENABLEMENT_STATE_UNSPECIFIED = 0
    ENABLED = 1
    DISABLED = 2
    INHERITED = 3

  ancestorModule = _messages.StringField(1)
  customConfig = _messages.MessageField('CustomConfig', 2)
  displayName = _messages.StringField(3)
  enablementState = _messages.EnumField('EnablementStateValueValuesEnum', 4)
  lastEditor = _messages.StringField(5)
  name = _messages.StringField(6)
  updateTime = _messages.StringField(7)


class SecurityMarks(_messages.Message):
  r"""User specified security marks that are attached to the parent Security
  Command Center resource. Security marks are scoped within a Security Command
  Center organization -- they can be modified and viewed by all users who have
  proper permissions on the organization.

  Messages:
    MarksValue: Mutable user specified security marks belonging to the parent
      resource. Constraints are as follows: * Keys and values are treated as
      case insensitive * Keys must be between 1 - 256 characters (inclusive) *
      Keys must be letters, numbers, underscores, or dashes * Values have
      leading and trailing whitespace trimmed, remaining characters must be
      between 1 - 4096 characters (inclusive)

  Fields:
    canonicalName: The canonical name of the marks. Examples:
      "organizations/{organization_id}/assets/{asset_id}/securityMarks"
      "folders/{folder_id}/assets/{asset_id}/securityMarks"
      "projects/{project_number}/assets/{asset_id}/securityMarks" "organizatio
      ns/{organization_id}/sources/{source_id}/findings/{finding_id}/securityM
      arks" "folders/{folder_id}/sources/{source_id}/findings/{finding_id}/sec
      urityMarks" "projects/{project_number}/sources/{source_id}/findings/{fin
      ding_id}/securityMarks"
    marks: Mutable user specified security marks belonging to the parent
      resource. Constraints are as follows: * Keys and values are treated as
      case insensitive * Keys must be between 1 - 256 characters (inclusive) *
      Keys must be letters, numbers, underscores, or dashes * Values have
      leading and trailing whitespace trimmed, remaining characters must be
      between 1 - 4096 characters (inclusive)
    name: The relative resource name of the SecurityMarks. See:
      https://cloud.google.com/apis/design/resource_names#relative_resource_na
      me Examples:
      "organizations/{organization_id}/assets/{asset_id}/securityMarks" "organ
      izations/{organization_id}/sources/{source_id}/findings/{finding_id}/sec
      urityMarks".
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MarksValue(_messages.Message):
    r"""Mutable user specified security marks belonging to the parent
    resource. Constraints are as follows: * Keys and values are treated as
    case insensitive * Keys must be between 1 - 256 characters (inclusive) *
    Keys must be letters, numbers, underscores, or dashes * Values have
    leading and trailing whitespace trimmed, remaining characters must be
    between 1 - 4096 characters (inclusive)

    Messages:
      AdditionalProperty: An additional property for a MarksValue object.

    Fields:
      additionalProperties: Additional properties of type MarksValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MarksValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  canonicalName = _messages.StringField(1)
  marks = _messages.MessageField('MarksValue', 2)
  name = _messages.StringField(3)


class SecurityPosture(_messages.Message):
  r"""Represents a posture that is deployed on Google Cloud by the Security
  Command Center Posture Management service. A posture contains one or more
  policy sets. A policy set is a group of policies that enforce a set of
  security rules on Google Cloud.

  Fields:
    changedPolicy: The name of the policy that has been updated, for example,
      `projects/{project_id}/policies/{constraint_name}`.
    name: Name of the posture, for example,
      `organizations/{org_id}/locations/{location}/postures/{posture_name}`.
    postureDeployment: The name of the posture deployment, for example,
      `projects/{project_id}/posturedeployments/{posture_deployment_id}`.
    postureDeploymentResource: The project, folder, or organization on which
      the posture is deployed, for example, `projects/{project_id}`.
    revisionId: The version of the posture, for example, `c7cfa2a8`.
  """

  changedPolicy = _messages.StringField(1)
  name = _messages.StringField(2)
  postureDeployment = _messages.StringField(3)
  postureDeploymentResource = _messages.StringField(4)
  revisionId = _messages.StringField(5)


class SecuritycentermanagementFoldersLocationsEffectiveEventThreatDetectionCustomModulesGetRequest(_messages.Message):
  r"""A SecuritycentermanagementFoldersLocationsEffectiveEventThreatDetectionC
  ustomModulesGetRequest object.

  Fields:
    name: Required. The resource name of the ETD custom module. Its format is:
      * "organizations/{organization}/locations/{location}/effectiveEventThrea
      tDetectionCustomModules/{effective_event_threat_detection_custom_module}
      ". * "folders/{folder}/locations/{location}/effectiveEventThreatDetectio
      nCustomModules/{effective_event_threat_detection_custom_module}". * "pro
      jects/{project}/locations/{location}/effectiveEventThreatDetectionCustom
      Modules/{effective_event_threat_detection_custom_module}".
  """

  name = _messages.StringField(1, required=True)


class SecuritycentermanagementFoldersLocationsEffectiveEventThreatDetectionCustomModulesListRequest(_messages.Message):
  r"""A SecuritycentermanagementFoldersLocationsEffectiveEventThreatDetectionC
  ustomModulesListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return in a single
      response. Default is 10, minimum is 1, maximum is 1000.
    pageToken: Optional. The value returned by the last call indicating a
      continuation
    parent: Required. Name of parent to list effective custom modules. Its
      format is "organizations/{organization}/locations/{location}/eventThreat
      DetectionCustomModules", "folders/{folder}/locations/{location}/eventThr
      eatDetectionCustomModules", or "projects/{project}/locations/{location}/
      eventThreatDetectionCustomModules"
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class SecuritycentermanagementFoldersLocationsEffectiveSecurityHealthAnalyticsCustomModulesGetRequest(_messages.Message):
  r"""A SecuritycentermanagementFoldersLocationsEffectiveSecurityHealthAnalyti
  csCustomModulesGetRequest object.

  Fields:
    name: Required. The resource name of the SHA custom module. Its format is:
      * "organizations/{organization}/locations/{location}/effectiveSecurityHe
      althAnalyticsCustomModules/{module_id}". * "folders/{folder}/locations/{
      location}/effectiveSecurityHealthAnalyticsCustomModules/{module_id}". *
      "projects/{project}/locations/{location}/effectiveSecurityHealthAnalytic
      sCustomModules/{module_id}".
  """

  name = _messages.StringField(1, required=True)


class SecuritycentermanagementFoldersLocationsEffectiveSecurityHealthAnalyticsCustomModulesListRequest(_messages.Message):
  r"""A SecuritycentermanagementFoldersLocationsEffectiveSecurityHealthAnalyti
  csCustomModulesListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return in a single
      response. Default is 10, minimum is 1, maximum is 1000.
    pageToken: Optional. The value returned by the last call indicating a
      continuation
    parent: Required. Name of parent to list effective custom modules. Its
      format is "organizations/{organization}/locations/{location}/effectiveSe
      curityHealthAnalyticsCustomModules", "folders/{folder}/locations/{locati
      on}/effectiveSecurityHealthAnalyticsCustomModules", or "projects/{projec
      t}/locations/{location}/effectiveSecurityHealthAnalyticsCustomModules"
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class SecuritycentermanagementFoldersLocationsEventThreatDetectionCustomModulesCreateRequest(_messages.Message):
  r"""A SecuritycentermanagementFoldersLocationsEventThreatDetectionCustomModu
  lesCreateRequest object.

  Fields:
    eventThreatDetectionCustomModule: A EventThreatDetectionCustomModule
      resource to be passed as the request body.
    parent: Required. Name of parent for the module. Its format is "organizati
      ons/{organization}/locations/{location}/eventThreatDetectionCustomModule
      s", "folders/{folder}/locations/{location}/eventThreatDetectionCustomMod
      ules", or "projects/{project}/locations/{location}/eventThreatDetectionC
      ustomModules"
    validateOnly: Optional. When set to true, only validations (including IAM
      checks) will done for the request (no module will be created). An OK
      response indicates the request is valid while an error response
      indicates the request is invalid. Note that a subsequent request to
      actually create the module could still fail because 1. the state could
      have changed (e.g. IAM permission lost) or 2. A failure occurred during
      creation of the module.
  """

  eventThreatDetectionCustomModule = _messages.MessageField('EventThreatDetectionCustomModule', 1)
  parent = _messages.StringField(2, required=True)
  validateOnly = _messages.BooleanField(3)


class SecuritycentermanagementFoldersLocationsEventThreatDetectionCustomModulesDeleteRequest(_messages.Message):
  r"""A SecuritycentermanagementFoldersLocationsEventThreatDetectionCustomModu
  lesDeleteRequest object.

  Fields:
    name: Required. The resource name of the ETD custom module. Its format is:
      * "organizations/{organization}/locations/{location}/eventThreatDetectio
      nCustomModules/{event_threat_detection_custom_module}". * "folders/{fold
      er}/locations/{location}/eventThreatDetectionCustomModules/{event_threat
      _detection_custom_module}". * "projects/{project}/locations/{location}/e
      ventThreatDetectionCustomModules/{event_threat_detection_custom_module}"
      .
    validateOnly: Optional. When set to true, only validations (including IAM
      checks) will done for the request (module will not be deleted). An OK
      response indicates the request is valid while an error response
      indicates the request is invalid. Note that a subsequent request to
      actually delete the module could still fail because 1. the state could
      have changed (e.g. IAM permission lost) or 2. A failure occurred while
      trying to delete the module.
  """

  name = _messages.StringField(1, required=True)
  validateOnly = _messages.BooleanField(2)


class SecuritycentermanagementFoldersLocationsEventThreatDetectionCustomModulesGetRequest(_messages.Message):
  r"""A SecuritycentermanagementFoldersLocationsEventThreatDetectionCustomModu
  lesGetRequest object.

  Fields:
    name: Required. The resource name of the ETD custom module. Its format is:
      * "organizations/{organization}/locations/{location}/eventThreatDetectio
      nCustomModules/{event_threat_detection_custom_module}". * "folders/{fold
      er}/locations/{location}/eventThreatDetectionCustomModules/{event_threat
      _detection_custom_module}". * "projects/{project}/locations/{location}/e
      ventThreatDetectionCustomModules/{event_threat_detection_custom_module}"
      .
  """

  name = _messages.StringField(1, required=True)


class SecuritycentermanagementFoldersLocationsEventThreatDetectionCustomModulesListDescendantRequest(_messages.Message):
  r"""A SecuritycentermanagementFoldersLocationsEventThreatDetectionCustomModu
  lesListDescendantRequest object.

  Fields:
    pageSize: Optional. The maximum number of modules to return. The service
      may return fewer than this value. If unspecified, at most 10 configs
      will be returned. The maximum value is 1000; values above 1000 will be
      coerced to 1000.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Name of parent to list custom modules. Its format is "or
      ganizations/{organization}/locations/{location}/eventThreatDetectionCust
      omModules", "folders/{folder}/locations/{location}/eventThreatDetectionC
      ustomModules", or "projects/{project}/locations/{location}/eventThreatDe
      tectionCustomModules"
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class SecuritycentermanagementFoldersLocationsEventThreatDetectionCustomModulesListRequest(_messages.Message):
  r"""A SecuritycentermanagementFoldersLocationsEventThreatDetectionCustomModu
  lesListRequest object.

  Fields:
    pageSize: Optional. The maximum number of modules to return. The service
      may return fewer than this value. If unspecified, at most 10 configs
      will be returned. The maximum value is 1000; values above 1000 will be
      coerced to 1000.
    pageToken: Optional. A page token, received from a previous
      `ListEventThreatDetectionCustomModules` call. Provide this to retrieve
      the subsequent page. When paginating, all other parameters provided to
      `ListEventThreatDetectionCustomModules` must match the call that
      provided the page token.
    parent: Required. Name of parent to list custom modules. Its format is "or
      ganizations/{organization}/locations/{location}/eventThreatDetectionCust
      omModules", "folders/{folder}/locations/{location}/eventThreatDetectionC
      ustomModules", or "projects/{project}/locations/{location}/eventThreatDe
      tectionCustomModules"
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class SecuritycentermanagementFoldersLocationsEventThreatDetectionCustomModulesPatchRequest(_messages.Message):
  r"""A SecuritycentermanagementFoldersLocationsEventThreatDetectionCustomModu
  lesPatchRequest object.

  Fields:
    eventThreatDetectionCustomModule: A EventThreatDetectionCustomModule
      resource to be passed as the request body.
    name: Immutable. The resource name of the ETD custom module. Its format
      is: * "organizations/{organization}/locations/{location}/eventThreatDete
      ctionCustomModules/{event_threat_detection_custom_module}". * "folders/{
      folder}/locations/{location}/eventThreatDetectionCustomModules/{event_th
      reat_detection_custom_module}". * "projects/{project}/locations/{locatio
      n}/eventThreatDetectionCustomModules/{event_threat_detection_custom_modu
      le}".
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the EventThreatDetectionCustomModule resource by the
      update. The fields specified in the update_mask are relative to the
      resource, not the full request. A field will be overwritten if it is in
      the mask. If the user does not provide a mask then all fields will be
      overwritten.
    validateOnly: Optional. When set to true, only validations (including IAM
      checks) will done for the request (module will not be updated). An OK
      response indicates the request is valid while an error response
      indicates the request is invalid. Note that a subsequent request to
      actually update the module could still fail because 1. the state could
      have changed (e.g. IAM permission lost) or 2. A failure occurred while
      trying to update the module.
  """

  eventThreatDetectionCustomModule = _messages.MessageField('EventThreatDetectionCustomModule', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class SecuritycentermanagementFoldersLocationsSecurityHealthAnalyticsCustomModulesCreateRequest(_messages.Message):
  r"""A SecuritycentermanagementFoldersLocationsSecurityHealthAnalyticsCustomM
  odulesCreateRequest object.

  Fields:
    parent: Required. Name of the parent for the module. Its format is "organi
      zations/{organization}/locations/{location}/securityHealthAnalyticsCusto
      mModules", "folders/{folder}/locations/{location}/securityHealthAnalytic
      sCustomModules", or "projects/{project}/locations/{location}/securityHea
      lthAnalyticsCustomModules"
    securityHealthAnalyticsCustomModule: A SecurityHealthAnalyticsCustomModule
      resource to be passed as the request body.
    validateOnly: Optional. When set to true, only validations (including IAM
      checks) will done for the request (no module will be created). An OK
      response indicates the request is valid while an error response
      indicates the request is invalid. Note that a subsequent request to
      actually create the module could still fail because: 1. the state could
      have changed (e.g. IAM permission lost) or 2. A failure occurred during
      creation of the module. Defaults to false.
  """

  parent = _messages.StringField(1, required=True)
  securityHealthAnalyticsCustomModule = _messages.MessageField('SecurityHealthAnalyticsCustomModule', 2)
  validateOnly = _messages.BooleanField(3)


class SecuritycentermanagementFoldersLocationsSecurityHealthAnalyticsCustomModulesDeleteRequest(_messages.Message):
  r"""A SecuritycentermanagementFoldersLocationsSecurityHealthAnalyticsCustomM
  odulesDeleteRequest object.

  Fields:
    name: Required. The resource name of the SHA custom module. Its format is:
      * "organizations/{organization}/locations/{location}/securityHealthAnaly
      ticsCustomModules/{security_health_analytics_custom_module}". * "folders
      /{folder}/locations/{location}/securityHealthAnalyticsCustomModules/{sec
      urity_health_analytics_custom_module}". * "projects/{project}/locations/
      {location}/securityHealthAnalyticsCustomModules/{security_health_analyti
      cs_custom_module}".
    validateOnly: Optional. When set to true, only validations (including IAM
      checks) will done for the request (module will not be deleted). An OK
      response indicates the request is valid while an error response
      indicates the request is invalid. Note that a subsequent request to
      actually delete the module could still fail because 1. the state could
      have changed (e.g. IAM permission lost) or 2. A failure occurred while
      trying to delete the module.
  """

  name = _messages.StringField(1, required=True)
  validateOnly = _messages.BooleanField(2)


class SecuritycentermanagementFoldersLocationsSecurityHealthAnalyticsCustomModulesGetRequest(_messages.Message):
  r"""A SecuritycentermanagementFoldersLocationsSecurityHealthAnalyticsCustomM
  odulesGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class SecuritycentermanagementFoldersLocationsSecurityHealthAnalyticsCustomModulesListDescendantRequest(_messages.Message):
  r"""A SecuritycentermanagementFoldersLocationsSecurityHealthAnalyticsCustomM
  odulesListDescendantRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return in a single
      response. Default is 10, minimum is 1, maximum is 1000.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Name of parent to list custom modules. Its format is "or
      ganizations/{organization}/locations/{location}/securityHealthAnalyticsC
      ustomModules", "folders/{folder}/locations/{location}/securityHealthAnal
      yticsCustomModules", or "projects/{project}/locations/{location}/securit
      yHealthAnalyticsCustomModules"
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class SecuritycentermanagementFoldersLocationsSecurityHealthAnalyticsCustomModulesListRequest(_messages.Message):
  r"""A SecuritycentermanagementFoldersLocationsSecurityHealthAnalyticsCustomM
  odulesListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return in a single
      response. Default is 10, minimum is 1, maximum is 1000.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Name of parent to list custom modules. Its format is "or
      ganizations/{organization}/locations/{location}/securityHealthAnalyticsC
      ustomModules", "folders/{folder}/locations/{location}/securityHealthAnal
      yticsCustomModules", or "projects/{project}/locations/{location}/securit
      yHealthAnalyticsCustomModules"
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class SecuritycentermanagementFoldersLocationsSecurityHealthAnalyticsCustomModulesPatchRequest(_messages.Message):
  r"""A SecuritycentermanagementFoldersLocationsSecurityHealthAnalyticsCustomM
  odulesPatchRequest object.

  Fields:
    name: Immutable. The resource name of the custom module. Its format is "or
      ganizations/{organization}/locations/{location}/securityHealthAnalyticsC
      ustomModules/{security_health_analytics_custom_module}", or "folders/{fo
      lder}/locations/{location}/securityHealthAnalyticsCustomModules/{securit
      y_health_analytics_custom_module}", or "projects/{project}/locations/{lo
      cation}/securityHealthAnalyticsCustomModules/{security_health_analytics_
      custom_module}" The id {customModule} is server-generated and is not
      user settable. It will be a numeric id containing 1-20 digits.
    securityHealthAnalyticsCustomModule: A SecurityHealthAnalyticsCustomModule
      resource to be passed as the request body.
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the SecurityHealthAnalyticsCustomModule resource by the
      update. The fields specified in the update_mask are relative to the
      resource, not the full request. A field will be overwritten if it is in
      the mask. If the user does not provide a mask then all fields will be
      overwritten.
    validateOnly: Optional. When set to true, only validations (including IAM
      checks) will done for the request (module will not be updated). An OK
      response indicates the request is valid while an error response
      indicates the request is invalid. Note that a subsequent request to
      actually update the module could still fail because 1. the state could
      have changed (e.g. IAM permission lost) or 2. A failure occurred while
      trying to update the module.
  """

  name = _messages.StringField(1, required=True)
  securityHealthAnalyticsCustomModule = _messages.MessageField('SecurityHealthAnalyticsCustomModule', 2)
  updateMask = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class SecuritycentermanagementFoldersLocationsSecurityHealthAnalyticsCustomModulesSimulateRequest(_messages.Message):
  r"""A SecuritycentermanagementFoldersLocationsSecurityHealthAnalyticsCustomM
  odulesSimulateRequest object.

  Fields:
    parent: Required. The relative resource name of the organization, project,
      or folder. See: https://cloud.google.com/apis/design/resource_names#rela
      tive_resource_name An example is: "organizations/{organization_id}".
    simulateSecurityHealthAnalyticsCustomModuleRequest: A
      SimulateSecurityHealthAnalyticsCustomModuleRequest resource to be passed
      as the request body.
  """

  parent = _messages.StringField(1, required=True)
  simulateSecurityHealthAnalyticsCustomModuleRequest = _messages.MessageField('SimulateSecurityHealthAnalyticsCustomModuleRequest', 2)


class SecuritycentermanagementOrganizationsLocationsEffectiveEventThreatDetectionCustomModulesGetRequest(_messages.Message):
  r"""A SecuritycentermanagementOrganizationsLocationsEffectiveEventThreatDete
  ctionCustomModulesGetRequest object.

  Fields:
    name: Required. The resource name of the ETD custom module. Its format is:
      * "organizations/{organization}/locations/{location}/effectiveEventThrea
      tDetectionCustomModules/{effective_event_threat_detection_custom_module}
      ". * "folders/{folder}/locations/{location}/effectiveEventThreatDetectio
      nCustomModules/{effective_event_threat_detection_custom_module}". * "pro
      jects/{project}/locations/{location}/effectiveEventThreatDetectionCustom
      Modules/{effective_event_threat_detection_custom_module}".
  """

  name = _messages.StringField(1, required=True)


class SecuritycentermanagementOrganizationsLocationsEffectiveEventThreatDetectionCustomModulesListRequest(_messages.Message):
  r"""A SecuritycentermanagementOrganizationsLocationsEffectiveEventThreatDete
  ctionCustomModulesListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return in a single
      response. Default is 10, minimum is 1, maximum is 1000.
    pageToken: Optional. The value returned by the last call indicating a
      continuation
    parent: Required. Name of parent to list effective custom modules. Its
      format is "organizations/{organization}/locations/{location}/eventThreat
      DetectionCustomModules", "folders/{folder}/locations/{location}/eventThr
      eatDetectionCustomModules", or "projects/{project}/locations/{location}/
      eventThreatDetectionCustomModules"
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class SecuritycentermanagementOrganizationsLocationsEffectiveSecurityHealthAnalyticsCustomModulesGetRequest(_messages.Message):
  r"""A SecuritycentermanagementOrganizationsLocationsEffectiveSecurityHealthA
  nalyticsCustomModulesGetRequest object.

  Fields:
    name: Required. The resource name of the SHA custom module. Its format is:
      * "organizations/{organization}/locations/{location}/effectiveSecurityHe
      althAnalyticsCustomModules/{module_id}". * "folders/{folder}/locations/{
      location}/effectiveSecurityHealthAnalyticsCustomModules/{module_id}". *
      "projects/{project}/locations/{location}/effectiveSecurityHealthAnalytic
      sCustomModules/{module_id}".
  """

  name = _messages.StringField(1, required=True)


class SecuritycentermanagementOrganizationsLocationsEffectiveSecurityHealthAnalyticsCustomModulesListRequest(_messages.Message):
  r"""A SecuritycentermanagementOrganizationsLocationsEffectiveSecurityHealthA
  nalyticsCustomModulesListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return in a single
      response. Default is 10, minimum is 1, maximum is 1000.
    pageToken: Optional. The value returned by the last call indicating a
      continuation
    parent: Required. Name of parent to list effective custom modules. Its
      format is "organizations/{organization}/locations/{location}/effectiveSe
      curityHealthAnalyticsCustomModules", "folders/{folder}/locations/{locati
      on}/effectiveSecurityHealthAnalyticsCustomModules", or "projects/{projec
      t}/locations/{location}/effectiveSecurityHealthAnalyticsCustomModules"
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class SecuritycentermanagementOrganizationsLocationsEventThreatDetectionCustomModulesCreateRequest(_messages.Message):
  r"""A SecuritycentermanagementOrganizationsLocationsEventThreatDetectionCust
  omModulesCreateRequest object.

  Fields:
    eventThreatDetectionCustomModule: A EventThreatDetectionCustomModule
      resource to be passed as the request body.
    parent: Required. Name of parent for the module. Its format is "organizati
      ons/{organization}/locations/{location}/eventThreatDetectionCustomModule
      s", "folders/{folder}/locations/{location}/eventThreatDetectionCustomMod
      ules", or "projects/{project}/locations/{location}/eventThreatDetectionC
      ustomModules"
    validateOnly: Optional. When set to true, only validations (including IAM
      checks) will done for the request (no module will be created). An OK
      response indicates the request is valid while an error response
      indicates the request is invalid. Note that a subsequent request to
      actually create the module could still fail because 1. the state could
      have changed (e.g. IAM permission lost) or 2. A failure occurred during
      creation of the module.
  """

  eventThreatDetectionCustomModule = _messages.MessageField('EventThreatDetectionCustomModule', 1)
  parent = _messages.StringField(2, required=True)
  validateOnly = _messages.BooleanField(3)


class SecuritycentermanagementOrganizationsLocationsEventThreatDetectionCustomModulesDeleteRequest(_messages.Message):
  r"""A SecuritycentermanagementOrganizationsLocationsEventThreatDetectionCust
  omModulesDeleteRequest object.

  Fields:
    name: Required. The resource name of the ETD custom module. Its format is:
      * "organizations/{organization}/locations/{location}/eventThreatDetectio
      nCustomModules/{event_threat_detection_custom_module}". * "folders/{fold
      er}/locations/{location}/eventThreatDetectionCustomModules/{event_threat
      _detection_custom_module}". * "projects/{project}/locations/{location}/e
      ventThreatDetectionCustomModules/{event_threat_detection_custom_module}"
      .
    validateOnly: Optional. When set to true, only validations (including IAM
      checks) will done for the request (module will not be deleted). An OK
      response indicates the request is valid while an error response
      indicates the request is invalid. Note that a subsequent request to
      actually delete the module could still fail because 1. the state could
      have changed (e.g. IAM permission lost) or 2. A failure occurred while
      trying to delete the module.
  """

  name = _messages.StringField(1, required=True)
  validateOnly = _messages.BooleanField(2)


class SecuritycentermanagementOrganizationsLocationsEventThreatDetectionCustomModulesGetRequest(_messages.Message):
  r"""A SecuritycentermanagementOrganizationsLocationsEventThreatDetectionCust
  omModulesGetRequest object.

  Fields:
    name: Required. The resource name of the ETD custom module. Its format is:
      * "organizations/{organization}/locations/{location}/eventThreatDetectio
      nCustomModules/{event_threat_detection_custom_module}". * "folders/{fold
      er}/locations/{location}/eventThreatDetectionCustomModules/{event_threat
      _detection_custom_module}". * "projects/{project}/locations/{location}/e
      ventThreatDetectionCustomModules/{event_threat_detection_custom_module}"
      .
  """

  name = _messages.StringField(1, required=True)


class SecuritycentermanagementOrganizationsLocationsEventThreatDetectionCustomModulesListDescendantRequest(_messages.Message):
  r"""A SecuritycentermanagementOrganizationsLocationsEventThreatDetectionCust
  omModulesListDescendantRequest object.

  Fields:
    pageSize: Optional. The maximum number of modules to return. The service
      may return fewer than this value. If unspecified, at most 10 configs
      will be returned. The maximum value is 1000; values above 1000 will be
      coerced to 1000.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Name of parent to list custom modules. Its format is "or
      ganizations/{organization}/locations/{location}/eventThreatDetectionCust
      omModules", "folders/{folder}/locations/{location}/eventThreatDetectionC
      ustomModules", or "projects/{project}/locations/{location}/eventThreatDe
      tectionCustomModules"
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class SecuritycentermanagementOrganizationsLocationsEventThreatDetectionCustomModulesListRequest(_messages.Message):
  r"""A SecuritycentermanagementOrganizationsLocationsEventThreatDetectionCust
  omModulesListRequest object.

  Fields:
    pageSize: Optional. The maximum number of modules to return. The service
      may return fewer than this value. If unspecified, at most 10 configs
      will be returned. The maximum value is 1000; values above 1000 will be
      coerced to 1000.
    pageToken: Optional. A page token, received from a previous
      `ListEventThreatDetectionCustomModules` call. Provide this to retrieve
      the subsequent page. When paginating, all other parameters provided to
      `ListEventThreatDetectionCustomModules` must match the call that
      provided the page token.
    parent: Required. Name of parent to list custom modules. Its format is "or
      ganizations/{organization}/locations/{location}/eventThreatDetectionCust
      omModules", "folders/{folder}/locations/{location}/eventThreatDetectionC
      ustomModules", or "projects/{project}/locations/{location}/eventThreatDe
      tectionCustomModules"
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class SecuritycentermanagementOrganizationsLocationsEventThreatDetectionCustomModulesPatchRequest(_messages.Message):
  r"""A SecuritycentermanagementOrganizationsLocationsEventThreatDetectionCust
  omModulesPatchRequest object.

  Fields:
    eventThreatDetectionCustomModule: A EventThreatDetectionCustomModule
      resource to be passed as the request body.
    name: Immutable. The resource name of the ETD custom module. Its format
      is: * "organizations/{organization}/locations/{location}/eventThreatDete
      ctionCustomModules/{event_threat_detection_custom_module}". * "folders/{
      folder}/locations/{location}/eventThreatDetectionCustomModules/{event_th
      reat_detection_custom_module}". * "projects/{project}/locations/{locatio
      n}/eventThreatDetectionCustomModules/{event_threat_detection_custom_modu
      le}".
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the EventThreatDetectionCustomModule resource by the
      update. The fields specified in the update_mask are relative to the
      resource, not the full request. A field will be overwritten if it is in
      the mask. If the user does not provide a mask then all fields will be
      overwritten.
    validateOnly: Optional. When set to true, only validations (including IAM
      checks) will done for the request (module will not be updated). An OK
      response indicates the request is valid while an error response
      indicates the request is invalid. Note that a subsequent request to
      actually update the module could still fail because 1. the state could
      have changed (e.g. IAM permission lost) or 2. A failure occurred while
      trying to update the module.
  """

  eventThreatDetectionCustomModule = _messages.MessageField('EventThreatDetectionCustomModule', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class SecuritycentermanagementOrganizationsLocationsEventThreatDetectionCustomModulesValidateRequest(_messages.Message):
  r"""A SecuritycentermanagementOrganizationsLocationsEventThreatDetectionCust
  omModulesValidateRequest object.

  Fields:
    parent: Required. Resource name of the parent to validate the Custom
      Module under. Its format is: * "organizations/{organization}/locations/{
      location}/eventThreatDetectionCustomModules".
    validateEventThreatDetectionCustomModuleRequest: A
      ValidateEventThreatDetectionCustomModuleRequest resource to be passed as
      the request body.
  """

  parent = _messages.StringField(1, required=True)
  validateEventThreatDetectionCustomModuleRequest = _messages.MessageField('ValidateEventThreatDetectionCustomModuleRequest', 2)


class SecuritycentermanagementOrganizationsLocationsSecurityHealthAnalyticsCustomModulesCreateRequest(_messages.Message):
  r"""A SecuritycentermanagementOrganizationsLocationsSecurityHealthAnalyticsC
  ustomModulesCreateRequest object.

  Fields:
    parent: Required. Name of the parent for the module. Its format is "organi
      zations/{organization}/locations/{location}/securityHealthAnalyticsCusto
      mModules", "folders/{folder}/locations/{location}/securityHealthAnalytic
      sCustomModules", or "projects/{project}/locations/{location}/securityHea
      lthAnalyticsCustomModules"
    securityHealthAnalyticsCustomModule: A SecurityHealthAnalyticsCustomModule
      resource to be passed as the request body.
    validateOnly: Optional. When set to true, only validations (including IAM
      checks) will done for the request (no module will be created). An OK
      response indicates the request is valid while an error response
      indicates the request is invalid. Note that a subsequent request to
      actually create the module could still fail because: 1. the state could
      have changed (e.g. IAM permission lost) or 2. A failure occurred during
      creation of the module. Defaults to false.
  """

  parent = _messages.StringField(1, required=True)
  securityHealthAnalyticsCustomModule = _messages.MessageField('SecurityHealthAnalyticsCustomModule', 2)
  validateOnly = _messages.BooleanField(3)


class SecuritycentermanagementOrganizationsLocationsSecurityHealthAnalyticsCustomModulesDeleteRequest(_messages.Message):
  r"""A SecuritycentermanagementOrganizationsLocationsSecurityHealthAnalyticsC
  ustomModulesDeleteRequest object.

  Fields:
    name: Required. The resource name of the SHA custom module. Its format is:
      * "organizations/{organization}/locations/{location}/securityHealthAnaly
      ticsCustomModules/{security_health_analytics_custom_module}". * "folders
      /{folder}/locations/{location}/securityHealthAnalyticsCustomModules/{sec
      urity_health_analytics_custom_module}". * "projects/{project}/locations/
      {location}/securityHealthAnalyticsCustomModules/{security_health_analyti
      cs_custom_module}".
    validateOnly: Optional. When set to true, only validations (including IAM
      checks) will done for the request (module will not be deleted). An OK
      response indicates the request is valid while an error response
      indicates the request is invalid. Note that a subsequent request to
      actually delete the module could still fail because 1. the state could
      have changed (e.g. IAM permission lost) or 2. A failure occurred while
      trying to delete the module.
  """

  name = _messages.StringField(1, required=True)
  validateOnly = _messages.BooleanField(2)


class SecuritycentermanagementOrganizationsLocationsSecurityHealthAnalyticsCustomModulesGetRequest(_messages.Message):
  r"""A SecuritycentermanagementOrganizationsLocationsSecurityHealthAnalyticsC
  ustomModulesGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class SecuritycentermanagementOrganizationsLocationsSecurityHealthAnalyticsCustomModulesListDescendantRequest(_messages.Message):
  r"""A SecuritycentermanagementOrganizationsLocationsSecurityHealthAnalyticsC
  ustomModulesListDescendantRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return in a single
      response. Default is 10, minimum is 1, maximum is 1000.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Name of parent to list custom modules. Its format is "or
      ganizations/{organization}/locations/{location}/securityHealthAnalyticsC
      ustomModules", "folders/{folder}/locations/{location}/securityHealthAnal
      yticsCustomModules", or "projects/{project}/locations/{location}/securit
      yHealthAnalyticsCustomModules"
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class SecuritycentermanagementOrganizationsLocationsSecurityHealthAnalyticsCustomModulesListRequest(_messages.Message):
  r"""A SecuritycentermanagementOrganizationsLocationsSecurityHealthAnalyticsC
  ustomModulesListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return in a single
      response. Default is 10, minimum is 1, maximum is 1000.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Name of parent to list custom modules. Its format is "or
      ganizations/{organization}/locations/{location}/securityHealthAnalyticsC
      ustomModules", "folders/{folder}/locations/{location}/securityHealthAnal
      yticsCustomModules", or "projects/{project}/locations/{location}/securit
      yHealthAnalyticsCustomModules"
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class SecuritycentermanagementOrganizationsLocationsSecurityHealthAnalyticsCustomModulesPatchRequest(_messages.Message):
  r"""A SecuritycentermanagementOrganizationsLocationsSecurityHealthAnalyticsC
  ustomModulesPatchRequest object.

  Fields:
    name: Immutable. The resource name of the custom module. Its format is "or
      ganizations/{organization}/locations/{location}/securityHealthAnalyticsC
      ustomModules/{security_health_analytics_custom_module}", or "folders/{fo
      lder}/locations/{location}/securityHealthAnalyticsCustomModules/{securit
      y_health_analytics_custom_module}", or "projects/{project}/locations/{lo
      cation}/securityHealthAnalyticsCustomModules/{security_health_analytics_
      custom_module}" The id {customModule} is server-generated and is not
      user settable. It will be a numeric id containing 1-20 digits.
    securityHealthAnalyticsCustomModule: A SecurityHealthAnalyticsCustomModule
      resource to be passed as the request body.
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the SecurityHealthAnalyticsCustomModule resource by the
      update. The fields specified in the update_mask are relative to the
      resource, not the full request. A field will be overwritten if it is in
      the mask. If the user does not provide a mask then all fields will be
      overwritten.
    validateOnly: Optional. When set to true, only validations (including IAM
      checks) will done for the request (module will not be updated). An OK
      response indicates the request is valid while an error response
      indicates the request is invalid. Note that a subsequent request to
      actually update the module could still fail because 1. the state could
      have changed (e.g. IAM permission lost) or 2. A failure occurred while
      trying to update the module.
  """

  name = _messages.StringField(1, required=True)
  securityHealthAnalyticsCustomModule = _messages.MessageField('SecurityHealthAnalyticsCustomModule', 2)
  updateMask = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class SecuritycentermanagementOrganizationsLocationsSecurityHealthAnalyticsCustomModulesSimulateRequest(_messages.Message):
  r"""A SecuritycentermanagementOrganizationsLocationsSecurityHealthAnalyticsC
  ustomModulesSimulateRequest object.

  Fields:
    parent: Required. The relative resource name of the organization, project,
      or folder. See: https://cloud.google.com/apis/design/resource_names#rela
      tive_resource_name An example is: "organizations/{organization_id}".
    simulateSecurityHealthAnalyticsCustomModuleRequest: A
      SimulateSecurityHealthAnalyticsCustomModuleRequest resource to be passed
      as the request body.
  """

  parent = _messages.StringField(1, required=True)
  simulateSecurityHealthAnalyticsCustomModuleRequest = _messages.MessageField('SimulateSecurityHealthAnalyticsCustomModuleRequest', 2)


class SecuritycentermanagementProjectsLocationsEffectiveEventThreatDetectionCustomModulesGetRequest(_messages.Message):
  r"""A SecuritycentermanagementProjectsLocationsEffectiveEventThreatDetection
  CustomModulesGetRequest object.

  Fields:
    name: Required. The resource name of the ETD custom module. Its format is:
      * "organizations/{organization}/locations/{location}/effectiveEventThrea
      tDetectionCustomModules/{effective_event_threat_detection_custom_module}
      ". * "folders/{folder}/locations/{location}/effectiveEventThreatDetectio
      nCustomModules/{effective_event_threat_detection_custom_module}". * "pro
      jects/{project}/locations/{location}/effectiveEventThreatDetectionCustom
      Modules/{effective_event_threat_detection_custom_module}".
  """

  name = _messages.StringField(1, required=True)


class SecuritycentermanagementProjectsLocationsEffectiveEventThreatDetectionCustomModulesListRequest(_messages.Message):
  r"""A SecuritycentermanagementProjectsLocationsEffectiveEventThreatDetection
  CustomModulesListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return in a single
      response. Default is 10, minimum is 1, maximum is 1000.
    pageToken: Optional. The value returned by the last call indicating a
      continuation
    parent: Required. Name of parent to list effective custom modules. Its
      format is "organizations/{organization}/locations/{location}/eventThreat
      DetectionCustomModules", "folders/{folder}/locations/{location}/eventThr
      eatDetectionCustomModules", or "projects/{project}/locations/{location}/
      eventThreatDetectionCustomModules"
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class SecuritycentermanagementProjectsLocationsEffectiveSecurityHealthAnalyticsCustomModulesGetRequest(_messages.Message):
  r"""A SecuritycentermanagementProjectsLocationsEffectiveSecurityHealthAnalyt
  icsCustomModulesGetRequest object.

  Fields:
    name: Required. The resource name of the SHA custom module. Its format is:
      * "organizations/{organization}/locations/{location}/effectiveSecurityHe
      althAnalyticsCustomModules/{module_id}". * "folders/{folder}/locations/{
      location}/effectiveSecurityHealthAnalyticsCustomModules/{module_id}". *
      "projects/{project}/locations/{location}/effectiveSecurityHealthAnalytic
      sCustomModules/{module_id}".
  """

  name = _messages.StringField(1, required=True)


class SecuritycentermanagementProjectsLocationsEffectiveSecurityHealthAnalyticsCustomModulesListRequest(_messages.Message):
  r"""A SecuritycentermanagementProjectsLocationsEffectiveSecurityHealthAnalyt
  icsCustomModulesListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return in a single
      response. Default is 10, minimum is 1, maximum is 1000.
    pageToken: Optional. The value returned by the last call indicating a
      continuation
    parent: Required. Name of parent to list effective custom modules. Its
      format is "organizations/{organization}/locations/{location}/effectiveSe
      curityHealthAnalyticsCustomModules", "folders/{folder}/locations/{locati
      on}/effectiveSecurityHealthAnalyticsCustomModules", or "projects/{projec
      t}/locations/{location}/effectiveSecurityHealthAnalyticsCustomModules"
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class SecuritycentermanagementProjectsLocationsEventThreatDetectionCustomModulesCreateRequest(_messages.Message):
  r"""A SecuritycentermanagementProjectsLocationsEventThreatDetectionCustomMod
  ulesCreateRequest object.

  Fields:
    eventThreatDetectionCustomModule: A EventThreatDetectionCustomModule
      resource to be passed as the request body.
    parent: Required. Name of parent for the module. Its format is "organizati
      ons/{organization}/locations/{location}/eventThreatDetectionCustomModule
      s", "folders/{folder}/locations/{location}/eventThreatDetectionCustomMod
      ules", or "projects/{project}/locations/{location}/eventThreatDetectionC
      ustomModules"
    validateOnly: Optional. When set to true, only validations (including IAM
      checks) will done for the request (no module will be created). An OK
      response indicates the request is valid while an error response
      indicates the request is invalid. Note that a subsequent request to
      actually create the module could still fail because 1. the state could
      have changed (e.g. IAM permission lost) or 2. A failure occurred during
      creation of the module.
  """

  eventThreatDetectionCustomModule = _messages.MessageField('EventThreatDetectionCustomModule', 1)
  parent = _messages.StringField(2, required=True)
  validateOnly = _messages.BooleanField(3)


class SecuritycentermanagementProjectsLocationsEventThreatDetectionCustomModulesDeleteRequest(_messages.Message):
  r"""A SecuritycentermanagementProjectsLocationsEventThreatDetectionCustomMod
  ulesDeleteRequest object.

  Fields:
    name: Required. The resource name of the ETD custom module. Its format is:
      * "organizations/{organization}/locations/{location}/eventThreatDetectio
      nCustomModules/{event_threat_detection_custom_module}". * "folders/{fold
      er}/locations/{location}/eventThreatDetectionCustomModules/{event_threat
      _detection_custom_module}". * "projects/{project}/locations/{location}/e
      ventThreatDetectionCustomModules/{event_threat_detection_custom_module}"
      .
    validateOnly: Optional. When set to true, only validations (including IAM
      checks) will done for the request (module will not be deleted). An OK
      response indicates the request is valid while an error response
      indicates the request is invalid. Note that a subsequent request to
      actually delete the module could still fail because 1. the state could
      have changed (e.g. IAM permission lost) or 2. A failure occurred while
      trying to delete the module.
  """

  name = _messages.StringField(1, required=True)
  validateOnly = _messages.BooleanField(2)


class SecuritycentermanagementProjectsLocationsEventThreatDetectionCustomModulesGetRequest(_messages.Message):
  r"""A SecuritycentermanagementProjectsLocationsEventThreatDetectionCustomMod
  ulesGetRequest object.

  Fields:
    name: Required. The resource name of the ETD custom module. Its format is:
      * "organizations/{organization}/locations/{location}/eventThreatDetectio
      nCustomModules/{event_threat_detection_custom_module}". * "folders/{fold
      er}/locations/{location}/eventThreatDetectionCustomModules/{event_threat
      _detection_custom_module}". * "projects/{project}/locations/{location}/e
      ventThreatDetectionCustomModules/{event_threat_detection_custom_module}"
      .
  """

  name = _messages.StringField(1, required=True)


class SecuritycentermanagementProjectsLocationsEventThreatDetectionCustomModulesListDescendantRequest(_messages.Message):
  r"""A SecuritycentermanagementProjectsLocationsEventThreatDetectionCustomMod
  ulesListDescendantRequest object.

  Fields:
    pageSize: Optional. The maximum number of modules to return. The service
      may return fewer than this value. If unspecified, at most 10 configs
      will be returned. The maximum value is 1000; values above 1000 will be
      coerced to 1000.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Name of parent to list custom modules. Its format is "or
      ganizations/{organization}/locations/{location}/eventThreatDetectionCust
      omModules", "folders/{folder}/locations/{location}/eventThreatDetectionC
      ustomModules", or "projects/{project}/locations/{location}/eventThreatDe
      tectionCustomModules"
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class SecuritycentermanagementProjectsLocationsEventThreatDetectionCustomModulesListRequest(_messages.Message):
  r"""A SecuritycentermanagementProjectsLocationsEventThreatDetectionCustomMod
  ulesListRequest object.

  Fields:
    pageSize: Optional. The maximum number of modules to return. The service
      may return fewer than this value. If unspecified, at most 10 configs
      will be returned. The maximum value is 1000; values above 1000 will be
      coerced to 1000.
    pageToken: Optional. A page token, received from a previous
      `ListEventThreatDetectionCustomModules` call. Provide this to retrieve
      the subsequent page. When paginating, all other parameters provided to
      `ListEventThreatDetectionCustomModules` must match the call that
      provided the page token.
    parent: Required. Name of parent to list custom modules. Its format is "or
      ganizations/{organization}/locations/{location}/eventThreatDetectionCust
      omModules", "folders/{folder}/locations/{location}/eventThreatDetectionC
      ustomModules", or "projects/{project}/locations/{location}/eventThreatDe
      tectionCustomModules"
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class SecuritycentermanagementProjectsLocationsEventThreatDetectionCustomModulesPatchRequest(_messages.Message):
  r"""A SecuritycentermanagementProjectsLocationsEventThreatDetectionCustomMod
  ulesPatchRequest object.

  Fields:
    eventThreatDetectionCustomModule: A EventThreatDetectionCustomModule
      resource to be passed as the request body.
    name: Immutable. The resource name of the ETD custom module. Its format
      is: * "organizations/{organization}/locations/{location}/eventThreatDete
      ctionCustomModules/{event_threat_detection_custom_module}". * "folders/{
      folder}/locations/{location}/eventThreatDetectionCustomModules/{event_th
      reat_detection_custom_module}". * "projects/{project}/locations/{locatio
      n}/eventThreatDetectionCustomModules/{event_threat_detection_custom_modu
      le}".
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the EventThreatDetectionCustomModule resource by the
      update. The fields specified in the update_mask are relative to the
      resource, not the full request. A field will be overwritten if it is in
      the mask. If the user does not provide a mask then all fields will be
      overwritten.
    validateOnly: Optional. When set to true, only validations (including IAM
      checks) will done for the request (module will not be updated). An OK
      response indicates the request is valid while an error response
      indicates the request is invalid. Note that a subsequent request to
      actually update the module could still fail because 1. the state could
      have changed (e.g. IAM permission lost) or 2. A failure occurred while
      trying to update the module.
  """

  eventThreatDetectionCustomModule = _messages.MessageField('EventThreatDetectionCustomModule', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class SecuritycentermanagementProjectsLocationsGetRequest(_messages.Message):
  r"""A SecuritycentermanagementProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class SecuritycentermanagementProjectsLocationsListRequest(_messages.Message):
  r"""A SecuritycentermanagementProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class SecuritycentermanagementProjectsLocationsSecurityHealthAnalyticsCustomModulesCreateRequest(_messages.Message):
  r"""A SecuritycentermanagementProjectsLocationsSecurityHealthAnalyticsCustom
  ModulesCreateRequest object.

  Fields:
    parent: Required. Name of the parent for the module. Its format is "organi
      zations/{organization}/locations/{location}/securityHealthAnalyticsCusto
      mModules", "folders/{folder}/locations/{location}/securityHealthAnalytic
      sCustomModules", or "projects/{project}/locations/{location}/securityHea
      lthAnalyticsCustomModules"
    securityHealthAnalyticsCustomModule: A SecurityHealthAnalyticsCustomModule
      resource to be passed as the request body.
    validateOnly: Optional. When set to true, only validations (including IAM
      checks) will done for the request (no module will be created). An OK
      response indicates the request is valid while an error response
      indicates the request is invalid. Note that a subsequent request to
      actually create the module could still fail because: 1. the state could
      have changed (e.g. IAM permission lost) or 2. A failure occurred during
      creation of the module. Defaults to false.
  """

  parent = _messages.StringField(1, required=True)
  securityHealthAnalyticsCustomModule = _messages.MessageField('SecurityHealthAnalyticsCustomModule', 2)
  validateOnly = _messages.BooleanField(3)


class SecuritycentermanagementProjectsLocationsSecurityHealthAnalyticsCustomModulesDeleteRequest(_messages.Message):
  r"""A SecuritycentermanagementProjectsLocationsSecurityHealthAnalyticsCustom
  ModulesDeleteRequest object.

  Fields:
    name: Required. The resource name of the SHA custom module. Its format is:
      * "organizations/{organization}/locations/{location}/securityHealthAnaly
      ticsCustomModules/{security_health_analytics_custom_module}". * "folders
      /{folder}/locations/{location}/securityHealthAnalyticsCustomModules/{sec
      urity_health_analytics_custom_module}". * "projects/{project}/locations/
      {location}/securityHealthAnalyticsCustomModules/{security_health_analyti
      cs_custom_module}".
    validateOnly: Optional. When set to true, only validations (including IAM
      checks) will done for the request (module will not be deleted). An OK
      response indicates the request is valid while an error response
      indicates the request is invalid. Note that a subsequent request to
      actually delete the module could still fail because 1. the state could
      have changed (e.g. IAM permission lost) or 2. A failure occurred while
      trying to delete the module.
  """

  name = _messages.StringField(1, required=True)
  validateOnly = _messages.BooleanField(2)


class SecuritycentermanagementProjectsLocationsSecurityHealthAnalyticsCustomModulesGetRequest(_messages.Message):
  r"""A SecuritycentermanagementProjectsLocationsSecurityHealthAnalyticsCustom
  ModulesGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class SecuritycentermanagementProjectsLocationsSecurityHealthAnalyticsCustomModulesListDescendantRequest(_messages.Message):
  r"""A SecuritycentermanagementProjectsLocationsSecurityHealthAnalyticsCustom
  ModulesListDescendantRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return in a single
      response. Default is 10, minimum is 1, maximum is 1000.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Name of parent to list custom modules. Its format is "or
      ganizations/{organization}/locations/{location}/securityHealthAnalyticsC
      ustomModules", "folders/{folder}/locations/{location}/securityHealthAnal
      yticsCustomModules", or "projects/{project}/locations/{location}/securit
      yHealthAnalyticsCustomModules"
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class SecuritycentermanagementProjectsLocationsSecurityHealthAnalyticsCustomModulesListRequest(_messages.Message):
  r"""A SecuritycentermanagementProjectsLocationsSecurityHealthAnalyticsCustom
  ModulesListRequest object.

  Fields:
    pageSize: Optional. The maximum number of results to return in a single
      response. Default is 10, minimum is 1, maximum is 1000.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Name of parent to list custom modules. Its format is "or
      ganizations/{organization}/locations/{location}/securityHealthAnalyticsC
      ustomModules", "folders/{folder}/locations/{location}/securityHealthAnal
      yticsCustomModules", or "projects/{project}/locations/{location}/securit
      yHealthAnalyticsCustomModules"
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class SecuritycentermanagementProjectsLocationsSecurityHealthAnalyticsCustomModulesPatchRequest(_messages.Message):
  r"""A SecuritycentermanagementProjectsLocationsSecurityHealthAnalyticsCustom
  ModulesPatchRequest object.

  Fields:
    name: Immutable. The resource name of the custom module. Its format is "or
      ganizations/{organization}/locations/{location}/securityHealthAnalyticsC
      ustomModules/{security_health_analytics_custom_module}", or "folders/{fo
      lder}/locations/{location}/securityHealthAnalyticsCustomModules/{securit
      y_health_analytics_custom_module}", or "projects/{project}/locations/{lo
      cation}/securityHealthAnalyticsCustomModules/{security_health_analytics_
      custom_module}" The id {customModule} is server-generated and is not
      user settable. It will be a numeric id containing 1-20 digits.
    securityHealthAnalyticsCustomModule: A SecurityHealthAnalyticsCustomModule
      resource to be passed as the request body.
    updateMask: Required. Field mask is used to specify the fields to be
      overwritten in the SecurityHealthAnalyticsCustomModule resource by the
      update. The fields specified in the update_mask are relative to the
      resource, not the full request. A field will be overwritten if it is in
      the mask. If the user does not provide a mask then all fields will be
      overwritten.
    validateOnly: Optional. When set to true, only validations (including IAM
      checks) will done for the request (module will not be updated). An OK
      response indicates the request is valid while an error response
      indicates the request is invalid. Note that a subsequent request to
      actually update the module could still fail because 1. the state could
      have changed (e.g. IAM permission lost) or 2. A failure occurred while
      trying to update the module.
  """

  name = _messages.StringField(1, required=True)
  securityHealthAnalyticsCustomModule = _messages.MessageField('SecurityHealthAnalyticsCustomModule', 2)
  updateMask = _messages.StringField(3)
  validateOnly = _messages.BooleanField(4)


class SecuritycentermanagementProjectsLocationsSecurityHealthAnalyticsCustomModulesSimulateRequest(_messages.Message):
  r"""A SecuritycentermanagementProjectsLocationsSecurityHealthAnalyticsCustom
  ModulesSimulateRequest object.

  Fields:
    parent: Required. The relative resource name of the organization, project,
      or folder. See: https://cloud.google.com/apis/design/resource_names#rela
      tive_resource_name An example is: "organizations/{organization_id}".
    simulateSecurityHealthAnalyticsCustomModuleRequest: A
      SimulateSecurityHealthAnalyticsCustomModuleRequest resource to be passed
      as the request body.
  """

  parent = _messages.StringField(1, required=True)
  simulateSecurityHealthAnalyticsCustomModuleRequest = _messages.MessageField('SimulateSecurityHealthAnalyticsCustomModuleRequest', 2)


class ServiceAccountDelegationInfo(_messages.Message):
  r"""Identity delegation history of an authenticated service account.

  Fields:
    principalEmail: The email address of a Google account.
    principalSubject: A string representing the principal_subject associated
      with the identity. As compared to `principal_email`, supports principals
      that aren't associated with email addresses, such as third party
      principals. For most identities, the format will be
      `principal://iam.googleapis.com/{identity pool name}/subjects/{subject}`
      except for some GKE identities (GKE_WORKLOAD, FREEFORM,
      GKE_HUB_WORKLOAD) that are still in the legacy format
      `serviceAccount:{identity pool name}[{subject}]`
  """

  principalEmail = _messages.StringField(1)
  principalSubject = _messages.StringField(2)


class SimulateSecurityHealthAnalyticsCustomModuleRequest(_messages.Message):
  r"""Request message to simulate a CustomConfig against a given test
  resource. Maximum size of the request is 4 MB by default.

  Fields:
    customConfig: Required. The user specified custom configuration to test.
    resource: Required. Resource data to simulate custom module against.
  """

  customConfig = _messages.MessageField('CustomConfig', 1)
  resource = _messages.MessageField('SimulatedResource', 2)


class SimulateSecurityHealthAnalyticsCustomModuleResponse(_messages.Message):
  r"""Response message for simulating a SecurityHealthAnalyticsCustomModule
  against a given resource.

  Fields:
    result: Result for test case in the corresponding request.
  """

  result = _messages.MessageField('SimulatedResult', 1)


class SimulatedResource(_messages.Message):
  r"""Manually constructed resource. If the custom module only evaluates
  against the resource data, the iam_policy_data field can be omitted, and
  vice versa.

  Messages:
    ResourceDataValue: Optional. A representation of the GCP resource. Should
      match the GCP resource JSON format.

  Fields:
    iamPolicyData: Optional. A representation of the IAM policy.
    resourceData: Optional. A representation of the GCP resource. Should match
      the GCP resource JSON format.
    resourceType: Required. The type of the resource, e.g.
      `compute.googleapis.com/Disk`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResourceDataValue(_messages.Message):
    r"""Optional. A representation of the GCP resource. Should match the GCP
    resource JSON format.

    Messages:
      AdditionalProperty: An additional property for a ResourceDataValue
        object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResourceDataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  iamPolicyData = _messages.MessageField('Policy', 1)
  resourceData = _messages.MessageField('ResourceDataValue', 2)
  resourceType = _messages.StringField(3)


class SimulatedResult(_messages.Message):
  r"""Possible test result.

  Fields:
    error: Error encountered during the test.
    finding: Finding that would be published for the test case, if a violation
      is detected.
    noViolation: Indicates that the test case does not trigger any violation.
  """

  error = _messages.MessageField('Status', 1)
  finding = _messages.MessageField('Finding', 2)
  noViolation = _messages.MessageField('Empty', 3)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class Subject(_messages.Message):
  r"""Represents a Kubernetes subject.

  Enums:
    KindValueValuesEnum: Authentication type for the subject.

  Fields:
    kind: Authentication type for the subject.
    name: Name for the subject.
    ns: Namespace for the subject.
  """

  class KindValueValuesEnum(_messages.Enum):
    r"""Authentication type for the subject.

    Values:
      AUTH_TYPE_UNSPECIFIED: Authentication is not specified.
      USER: User with valid certificate.
      SERVICEACCOUNT: Users managed by Kubernetes API with credentials stored
        as secrets.
      GROUP: Collection of users.
    """
    AUTH_TYPE_UNSPECIFIED = 0
    USER = 1
    SERVICEACCOUNT = 2
    GROUP = 3

  kind = _messages.EnumField('KindValueValuesEnum', 1)
  name = _messages.StringField(2)
  ns = _messages.StringField(3)


class ValidateEventThreatDetectionCustomModuleRequest(_messages.Message):
  r"""Request to validate an Event Threat Detection custom module.

  Fields:
    rawText: Required. The raw text of the module's contents. Used to generate
      error messages.
    type: Required. The type of the module (e.g. CONFIGURABLE_BAD_IP).
  """

  rawText = _messages.StringField(1)
  type = _messages.StringField(2)


class ValidateEventThreatDetectionCustomModuleResponse(_messages.Message):
  r"""Response to validating an Event Threat Detection custom module.

  Fields:
    errors: A list of errors returned by the validator. If the list is empty,
      there were no errors.
  """

  errors = _messages.MessageField('CustomModuleValidationError', 1, repeated=True)


class Vulnerability(_messages.Message):
  r"""Refers to common vulnerability fields e.g. cve, cvss, cwe etc.

  Fields:
    cve: CVE stands for Common Vulnerabilities and Exposures
      (https://cve.mitre.org/about/)
  """

  cve = _messages.MessageField('Cve', 1)


class YaraRuleSignature(_messages.Message):
  r"""A signature corresponding to a YARA rule.

  Fields:
    yaraRule: The name of the YARA rule.
  """

  yaraRule = _messages.StringField(1)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
