# -*- coding: utf-8 -*- #
# Copyright 2023 Google LLC. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""Useful commands for interacting with the Cloud SCC API."""

from googlecloudsdk.api_lib.util import apis
from googlecloudsdk.generated_clients.apis.securitycentermanagement.v1 import securitycentermanagement_v1_messages as messages


class ETDCustomModuleClient(object):
  """Client for ETD custom module interaction with the Security Center Management API."""

  def __init__(self):
    # Although this client looks specific to projects, this is a codegen
    # artifact. It can be used for any parent types.
    self._client = apis.GetClientInstance(
        'securitycentermanagement', 'v1'
    ).projects_locations_eventThreatDetectionCustomModules

  def Get(self, name: str) -> messages.EventThreatDetectionCustomModule:
    """Get a ETD custom module."""

    req = messages.SecuritycentermanagementProjectsLocationsEventThreatDetectionCustomModulesGetRequest(
        name=name
    )
    return self._client.Get(req)


class EffectiveETDCustomModuleClient(object):
  """Client for effective ETD custom module interaction with the Security Center Management API."""

  def __init__(self):
    self._client = apis.GetClientInstance(
        'securitycentermanagement', 'v1'
    ).projects_locations_effectiveEventThreatDetectionCustomModules

  def Get(
      self, name: str) -> messages.EffectiveEventThreatDetectionCustomModule:
    """Get a ETD effective custom module."""

    req = messages.SecuritycentermanagementProjectsLocationsEffectiveEventThreatDetectionCustomModulesGetRequest(
        name=name
    )
    return self._client.Get(req)
