"""Generated message classes for cloudkms version v1alpha1.

Manages keys and performs cryptographic operations in a central cloud service,
for direct use by other cloud resources and applications.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding


package = 'cloudkms'


class CloudkmsProjectsGetProjectOptOutStateRequest(_messages.Message):
  r"""A CloudkmsProjectsGetProjectOptOutStateRequest object.

  Fields:
    name: Required. Project number or id for which to get the opt-out
      preference, in the format `projects/123456789` (or `projects/my-
      project`).
  """

  name = _messages.StringField(1, required=True)


class CloudkmsProjectsSetProjectOptOutStateRequest(_messages.Message):
  r"""A CloudkmsProjectsSetProjectOptOutStateRequest object.

  Fields:
    name: Required. Project number or id for which to set the opt-out
      preference, in the format `projects/123456789` (or `projects/my-
      project`).
    setProjectOptOutStateRequest: A SetProjectOptOutStateRequest resource to
      be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  setProjectOptOutStateRequest = _messages.MessageField('SetProjectOptOutStateRequest', 2)


class GetProjectOptOutStateResponse(_messages.Message):
  r"""Response message for KmsOptOutService.GetProjectOptOutState.

  Fields:
    value: The current opt-out preference (true == opt out, and vice versa).
  """

  value = _messages.BooleanField(1)


class LocationMetadata(_messages.Message):
  r"""Cloud KMS metadata for the given google.cloud.location.Location.

  Fields:
    ekmAvailable: Indicates whether CryptoKeys with protection_level EXTERNAL
      can be created in this location.
    hsmAvailable: Indicates whether CryptoKeys with protection_level HSM can
      be created in this location.
  """

  ekmAvailable = _messages.BooleanField(1)
  hsmAvailable = _messages.BooleanField(2)


class SetProjectOptOutStateRequest(_messages.Message):
  r"""Request message for KmsOptOutService.SetProjectOptOutState.

  Fields:
    value: Required. New opt out preference value (true == opt out, and vice
      versa).
  """

  value = _messages.BooleanField(1)


class SetProjectOptOutStateResponse(_messages.Message):
  r"""Response message for KmsOptOutService.SetProjectOptOutState.

  Fields:
    value: The updated opt-out preference (true == opt out, and vice versa).
  """

  value = _messages.BooleanField(1)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
